/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.data.Vector3;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class VectorI
implements Cloneable {
    public int x;
    public int y;
    public int z;

    public VectorI() {
        this(0, 0, 0);
    }

    public VectorI(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public VectorI(Entity entity) {
        this.x = (int)Math.floor(entity.field_70165_t);
        this.y = (int)Math.floor(entity.field_70163_u);
        this.z = (int)Math.floor(entity.field_70161_v);
    }

    public VectorI(TileEntity tileEntity) {
        this.x = tileEntity.func_174877_v().func_177958_n();
        this.y = tileEntity.func_174877_v().func_177956_o();
        this.z = tileEntity.func_174877_v().func_177952_p();
    }

    public VectorI(RayTraceResult movingObject) {
        this.x = movingObject.func_178782_a().func_177958_n();
        this.y = movingObject.func_178782_a().func_177956_o();
        this.z = movingObject.func_178782_a().func_177952_p();
    }

    public VectorI(BlockPos blockPos) {
        this.x = blockPos.func_177958_n();
        this.y = blockPos.func_177956_o();
        this.z = blockPos.func_177952_p();
    }

    public VectorI(EnumFacing direction) {
        this.x = direction.func_82601_c();
        this.y = direction.func_96559_d();
        this.z = direction.func_82599_e();
    }

    public Vector3 getBlockCenter() {
        return new Vector3((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5);
    }

    public VectorI clone() {
        return new VectorI(this.x, this.y, this.z);
    }

    public VectorI invertedClone() {
        return new VectorI(-this.x, -this.y, -this.z);
    }

    public VectorI clone(EnumFacing side) {
        return new VectorI(this.x + side.func_82601_c(), this.y + side.func_96559_d(), this.z + side.func_82599_e());
    }

    public Block getBlock(IBlockAccess blockAccess) {
        return blockAccess.func_180495_p(new BlockPos(this.x, this.y, this.z)).func_177230_c();
    }

    public IBlockState getBlockState(IBlockAccess blockAccess) {
        return blockAccess.func_180495_p(new BlockPos(this.x, this.y, this.z));
    }

    public TileEntity getTileEntity(IBlockAccess blockAccess) {
        return blockAccess.func_175625_s(new BlockPos(this.x, this.y, this.z));
    }

    public void setBlockState(World world, IBlockState blockState) {
        world.func_180501_a(this.getBlockPos(), blockState, 3);
    }

    public VectorI translate(VectorI vector) {
        this.x += vector.x;
        this.y += vector.y;
        this.z += vector.z;
        return this;
    }

    public VectorI translateBack(VectorI vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        this.z -= vector.z;
        return this;
    }

    public VectorI translate(EnumFacing side, int amount) {
        switch (side) {
            case DOWN: {
                this.y -= amount;
                break;
            }
            case UP: {
                this.y += amount;
                break;
            }
            case NORTH: {
                this.z -= amount;
                break;
            }
            case SOUTH: {
                this.z += amount;
                break;
            }
            case WEST: {
                this.x -= amount;
                break;
            }
            case EAST: {
                this.x += amount;
                break;
            }
        }
        return this;
    }

    public VectorI translate(EnumFacing side) {
        this.x += side.func_82601_c();
        this.y += side.func_96559_d();
        this.z += side.func_82599_e();
        return this;
    }

    public static VectorI add(VectorI vector1, VectorI vector2) {
        return new VectorI(vector1.x + vector2.x, vector1.y + vector2.y, vector1.z + vector2.z);
    }

    public VectorI add(VectorI vector) {
        return new VectorI(this.x + vector.x, this.y + vector.y, this.z + vector.z);
    }

    @Deprecated
    public VectorI add(Vector3 vector) {
        this.x = (int)((long)this.x + Math.round(vector.x));
        this.y = (int)((long)this.y + Math.round(vector.y));
        this.z = (int)((long)this.z + Math.round(vector.z));
        return this;
    }

    public static VectorI subtract(VectorI vector1, VectorI vector2) {
        return new VectorI(vector1.x - vector2.x, vector1.y - vector2.y, vector1.z - vector2.z);
    }

    public VectorI subtract(VectorI vector) {
        return new VectorI(this.x - vector.x, this.y - vector.y, this.z - vector.z);
    }

    @Deprecated
    public static VectorI set(Vector3 vector) {
        return new VectorI((int)Math.round(vector.x), (int)Math.round(vector.y), (int)Math.round(vector.z));
    }

    public int hashCode() {
        return (this.x + "X" + this.y + "Y" + this.z + "lem").hashCode();
    }

    public boolean equals(TileEntity tileEntity) {
        return this.x == tileEntity.func_174877_v().func_177958_n() && this.y == tileEntity.func_174877_v().func_177956_o() && this.z == tileEntity.func_174877_v().func_177952_p();
    }

    public boolean equals(Object object) {
        if (object instanceof VectorI) {
            VectorI vector = (VectorI)object;
            return this.x == vector.x && this.y == vector.y && this.z == vector.z;
        }
        if (object instanceof TileEntity) {
            TileEntity tileEntity = (TileEntity)object;
            return this.x == tileEntity.func_174877_v().func_177958_n() && this.y == tileEntity.func_174877_v().func_177956_o() && this.z == tileEntity.func_174877_v().func_177952_p();
        }
        return false;
    }

    public String toString() {
        return "VectorI [" + this.x + " " + this.y + " " + this.z + "]";
    }

    public static VectorI createFromNBT(NBTTagCompound tagCompound) {
        VectorI vector = new VectorI();
        vector.readFromNBT(tagCompound);
        return vector;
    }

    public void readFromNBT(@Nonnull NBTTagCompound tagCompound) {
        this.x = tagCompound.func_74762_e("x");
        this.y = tagCompound.func_74762_e("y");
        this.z = tagCompound.func_74762_e("z");
    }

    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("x", this.x);
        tagCompound.func_74768_a("y", this.y);
        tagCompound.func_74768_a("z", this.z);
        return tagCompound;
    }

    @Deprecated
    public double distanceTo(VectorI vector) {
        int newX = vector.x - this.x;
        int newY = vector.y - this.y;
        int newZ = vector.z - this.z;
        return Math.sqrt(newX * newX + newY * newY + newZ * newZ);
    }

    public int distance2To(BlockPos blockPos) {
        int newX = blockPos.func_177958_n() - this.x;
        int newY = blockPos.func_177956_o() - this.y;
        int newZ = blockPos.func_177952_p() - this.z;
        return newX * newX + newY * newY + newZ * newZ;
    }

    public int distance2To(VectorI vector) {
        int newX = vector.x - this.x;
        int newY = vector.y - this.y;
        int newZ = vector.z - this.z;
        return newX * newX + newY * newY + newZ * newZ;
    }

    public double distance2To(Entity entity) {
        double newX = entity.field_70165_t - (double)this.x;
        double newY = entity.field_70163_u - (double)this.y;
        double newZ = entity.field_70161_v - (double)this.z;
        return newX * newX + newY * newY + newZ * newZ;
    }

    public int distance2To(TileEntity tileEntity) {
        int newX = tileEntity.func_174877_v().func_177958_n() - this.x;
        int newY = tileEntity.func_174877_v().func_177956_o() - this.y;
        int newZ = tileEntity.func_174877_v().func_177952_p() - this.z;
        return newX * newX + newY * newY + newZ * newZ;
    }

    public static int distance2To(VectorI vector1, VectorI vector2) {
        int newX = vector1.x - vector2.x;
        int newY = vector1.y - vector2.y;
        int newZ = vector1.z - vector2.z;
        return newX * newX + newY * newY + newZ * newZ;
    }

    @Deprecated
    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public int getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public VectorI scale(float amount) {
        this.x = Math.round((float)this.x * amount);
        this.y = Math.round((float)this.y * amount);
        this.z = Math.round((float)this.z * amount);
        return this;
    }

    public void rotateByAngle(double yaw, double pitch) {
        this.rotateByAngle(yaw, pitch, 0.0);
    }

    public void rotateByAngle(double yaw, double pitch, double roll) {
        double yawRadians = Math.toRadians(yaw);
        double yawCosinus = Math.cos(yawRadians);
        double yawSinus = Math.sin(yawRadians);
        double pitchRadians = Math.toRadians(pitch);
        double pitchCosinus = Math.cos(pitchRadians);
        double pitchSinus = Math.sin(pitchRadians);
        double rollRadians = Math.toRadians(roll);
        double rollCosinus = Math.cos(rollRadians);
        double rollSinus = Math.sin(rollRadians);
        double oldX = this.x;
        double oldY = this.y;
        double oldZ = this.z;
        this.x = (int)Math.round(oldX * yawCosinus * pitchCosinus + oldZ * (yawCosinus * pitchSinus * rollSinus - yawSinus * rollCosinus) + oldY * (yawCosinus * pitchSinus * rollCosinus + yawSinus * rollSinus));
        this.z = (int)Math.round(oldX * yawSinus * pitchCosinus + oldZ * (yawSinus * pitchSinus * rollSinus + yawCosinus * rollCosinus) + oldY * (yawSinus * pitchSinus * rollCosinus - yawCosinus * rollSinus));
        this.y = (int)Math.round(-oldX * pitchSinus + oldZ * pitchCosinus * rollSinus + oldY * pitchCosinus * rollCosinus);
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }
}

