/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.entity;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Vector3;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityParticleBunch
extends Entity {
    private static final int ACCELERATION_SOUND_UPDATE_TICKS = 10;
    private static final double[] PARTICLE_BUNCH_ENERGY_TO_X = new double[]{0.1, 1.0, 10.0, 100.0};
    private static final double[] PARTICLE_BUNCH_ENERGY_TO_SOUND_Y = new double[]{0.0, 1.0, 2.0, 3.0};
    private static final SoundEvent[] PARTICLE_BUNCH_SOUNDS = new SoundEvent[]{SoundEvents.ACCELERATING_LOW, SoundEvents.ACCELERATING_MEDIUM, SoundEvents.ACCELERATING_HIGH};
    private static final DataParameter<Float> DATA_PARAMETER_ENERGY = EntityDataManager.func_187226_a(EntityParticleBunch.class, (DataSerializer)DataSerializers.field_187193_c);
    public Vector3 vectorNextPosition = new Vector3(0.0, 0.0, 0.0);
    public Vector3 vectorTurningPoint = null;
    private int lastUpdateTicks = 0;
    private static final int UPDATE_TICKS_TIMEOUT = 20;
    private int soundTicks;

    public EntityParticleBunch(World world) {
        super(world);
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info(String.format("%s created in dimension %s", new Object[]{this, Commons.format(world)}));
        }
    }

    public EntityParticleBunch(World world, double x, double y, double z) {
        super(world);
        this.field_70165_t = x + 0.5;
        this.field_70163_u = y + 0.5;
        this.field_70161_v = z + 0.5;
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info((Object)((Object)this) + " created");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        boolean lightFromSky = false;
        int lightFromBlock = 15;
        return 240;
    }

    public boolean func_180431_b(@Nonnull DamageSource source) {
        return true;
    }

    public void onRefreshFromSimulation(double newEnergy, Vector3 vectorNewPosition, Vector3 vectorNewTurningPoint) {
        this.func_70107_b(this.vectorNextPosition.x, this.vectorNextPosition.y, this.vectorNextPosition.z);
        this.setEnergy((float)newEnergy);
        this.vectorNextPosition = vectorNewPosition;
        this.vectorTurningPoint = vectorNewTurningPoint;
        this.lastUpdateTicks = 0;
    }

    public float getEnergy() {
        return ((Float)this.field_70180_af.func_187225_a(DATA_PARAMETER_ENERGY)).floatValue();
    }

    public void setEnergy(float energy) {
        this.field_70180_af.func_187227_b(DATA_PARAMETER_ENERGY, (Object)Float.valueOf(energy));
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ++this.lastUpdateTicks;
        if (this.lastUpdateTicks > 20) {
            this.func_70106_y();
        }
        --this.soundTicks;
        if (this.soundTicks < 0) {
            double factor = Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_X, PARTICLE_BUNCH_ENERGY_TO_SOUND_Y, this.getEnergy());
            int indexSound = (int)Math.floor(factor);
            SoundEvent soundEvent = PARTICLE_BUNCH_SOUNDS[Commons.clamp(0, PARTICLE_BUNCH_SOUNDS.length - 1, indexSound)];
            float pitch = 0.6f + 0.4f * (float)(factor - (double)indexSound);
            this.soundTicks = (int)Math.floor(10.0f * pitch);
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundEvent, SoundCategory.HOSTILE, 1.0f, pitch);
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA_PARAMETER_ENERGY, (Object)Float.valueOf(0.0f));
        this.func_70105_a(2.0f, 2.0f);
        this.field_70145_X = true;
        this.soundTicks = 0;
    }

    public float func_70047_e() {
        return 2.0f;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info((Object)((Object)this) + " dead");
        }
    }

    protected void func_70037_a(@Nonnull NBTTagCompound tagCompound) {
        this.vectorNextPosition = Vector3.createFromNBT(tagCompound.func_74775_l("nextPosition"));
        if (tagCompound.func_74764_b("turningPoint")) {
            this.vectorTurningPoint = Vector3.createFromNBT(tagCompound.func_74775_l("turningPoint"));
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound.func_74782_a("nextPosition", (NBTBase)this.vectorNextPosition.writeToNBT(new NBTTagCompound()));
        if (this.vectorTurningPoint != null) {
            tagCompound.func_74782_a("turningPoint", (NBTBase)this.vectorTurningPoint.writeToNBT(new NBTTagCompound()));
        }
    }

    @Nonnull
    public NBTTagCompound func_189511_e(@Nonnull NBTTagCompound tagCompound) {
        return super.func_189511_e(tagCompound);
    }

    public boolean func_184198_c(@Nonnull NBTTagCompound tagCompound) {
        return false;
    }

    public boolean func_70039_c(@Nonnull NBTTagCompound tagCompound) {
        return false;
    }

    @Nonnull
    public String toString() {
        return String.format("%s/%d %s", ((Object)((Object)this)).getClass().getSimpleName(), this.func_145782_y(), Commons.format(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v));
    }
}

