/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.data.GlobalRegion;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;

public abstract class AbstractSequencer {
    private static final AtomicBoolean isUpdating = new AtomicBoolean(false);
    private static final ConcurrentHashMap<AbstractSequencer, Boolean> sequencers = new ConcurrentHashMap(10);
    private static final CopyOnWriteArraySet<GlobalRegion> globalRegionLocks = new CopyOnWriteArraySet();

    public static void updateTick() {
        if (sequencers.isEmpty()) {
            return;
        }
        while (!isUpdating.compareAndSet(false, true)) {
            Thread.yield();
        }
        Iterator<Map.Entry<AbstractSequencer, Boolean>> iterator = sequencers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<AbstractSequencer, Boolean> entry = iterator.next();
            boolean doContinue = entry.getKey().onUpdate();
            if (doContinue) continue;
            iterator.remove();
        }
        isUpdating.set(false);
    }

    @Nonnull
    protected static GlobalRegion addLock(@Nonnull IGlobalRegionProvider globalRegionProvider) {
        GlobalRegion globalRegion = new GlobalRegion(globalRegionProvider);
        globalRegionLocks.add(globalRegion);
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        assert (server != null);
        for (EntityPlayerMP entityPlayerMP : server.func_184103_al().func_181057_v()) {
            if (!globalRegion.contains(entityPlayerMP.func_180425_c())) continue;
            entityPlayerMP.func_71053_j();
            entityPlayerMP.func_71128_l();
        }
        return globalRegion;
    }

    protected static void removeLock(@Nonnull GlobalRegion globalRegion) {
        globalRegionLocks.remove(globalRegion);
    }

    protected static boolean isLocked(@Nonnull BlockPos blockPos) {
        for (GlobalRegion globalRegion : globalRegionLocks) {
            if (!globalRegion.contains(blockPos)) continue;
            return true;
        }
        return false;
    }

    protected void register() {
        while (!isUpdating.compareAndSet(false, true)) {
            Thread.yield();
        }
        sequencers.put(this, true);
        isUpdating.set(false);
    }

    protected void unregister() {
        sequencers.put(this, false);
    }

    public abstract boolean onUpdate();

    protected abstract void readFromNBT(@Nonnull NBTTagCompound var1);

    protected abstract NBTTagCompound writeToNBT(@Nonnull NBTTagCompound var1);
}

