/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import com.google.common.collect.ImmutableSet;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.TileEntityAbstractChunkLoading;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoadingHandler
implements ForgeChunkManager.LoadingCallback {
    public static final ChunkLoadingHandler INSTANCE = new ChunkLoadingHandler();

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            int z;
            int y;
            NBTTagCompound tagCompound = ticket.getModData();
            if (!(tagCompound.func_74764_b("posX") && tagCompound.func_74764_b("posY") && tagCompound.func_74764_b("posZ"))) {
                WarpDrive.logger.error(String.format("Unable to resume chunkloading: incomplete or corrupted NBT data %s", tagCompound));
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                continue;
            }
            int x = tagCompound.func_74762_e("posX");
            TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y = tagCompound.func_74762_e("posY"), z = tagCompound.func_74762_e("posZ")));
            if (!(tileEntity instanceof TileEntityAbstractChunkLoading)) {
                WarpDrive.logger.error(String.format("Unable to resume chunkloading %s: invalid tile entity %s", Commons.format(world, x, y, z), tileEntity == null ? "-null-" : tileEntity));
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                continue;
            }
            TileEntityAbstractChunkLoading tileEntityAbstractChunkLoading = (TileEntityAbstractChunkLoading)tileEntity;
            boolean shouldChunkLoad = tileEntityAbstractChunkLoading.shouldChunkLoad();
            if (!shouldChunkLoad) {
                WarpDrive.logger.warn(String.format("Unable to resume chunkloading %s: chunk loader is disabled or out of power %s", Commons.format(world, x, y, z), tileEntity));
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                continue;
            }
            WarpDrive.logger.info(String.format("Resuming chunkloading of %s", tileEntity));
            tileEntityAbstractChunkLoading.chunkloading_giveTicket(ticket);
            tileEntityAbstractChunkLoading.refreshChunkLoading();
        }
    }

    public static ForgeChunkManager.Ticket forgeTicket_requestNormal(World world, TileEntity tileEntity) {
        if (ForgeChunkManager.ticketCountAvailableFor((Object)WarpDrive.instance, (World)world) <= 0) {
            WarpDrive.logger.error(String.format("No ChunkLoader tickets available for %s", Commons.format(world)));
            return null;
        }
        ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestTicket((Object)WarpDrive.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            WarpDrive.logger.error(String.format("Failed to register ChunkLoader Ticket for %s", Commons.format(world)));
            return null;
        }
        if (WarpDriveConfig.LOGGING_CHUNK_LOADING) {
            WarpDrive.logger.info(String.format("Forcing chunk loading %s", Commons.format(ticket.world, tileEntity.func_174877_v())));
        }
        NBTTagCompound tagCompound = ticket.getModData();
        tagCompound.func_74778_a("id", tileEntity.getClass().getSimpleName());
        tagCompound.func_74768_a("posX", tileEntity.func_174877_v().func_177958_n());
        tagCompound.func_74768_a("posY", tileEntity.func_174877_v().func_177956_o());
        tagCompound.func_74768_a("posZ", tileEntity.func_174877_v().func_177952_p());
        return ticket;
    }

    public static void forgeTicket_release(ForgeChunkManager.Ticket ticket) {
        if (ticket == null) {
            return;
        }
        ChunkLoadingHandler.forgeTicket_clearChunks(ticket);
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
    }

    public static void forgeTicket_addChunks(ForgeChunkManager.Ticket ticket, ChunkPos chunk) {
        if (WarpDrive.isDev) {
            WarpDrive.logger.info(String.format("Forcing chunk loading @ %s %s", Commons.format(ticket.world), chunk));
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
    }

    public static void forgeTicket_clearChunks(ForgeChunkManager.Ticket ticket) {
        if (ticket == null) {
            return;
        }
        if (WarpDriveConfig.LOGGING_CHUNK_LOADING) {
            NBTTagCompound tagCompound = ticket.getModData();
            int x = tagCompound.func_74762_e("posX");
            int y = tagCompound.func_74762_e("posY");
            int z = tagCompound.func_74762_e("posZ");
            WarpDrive.logger.info(String.format("Releasing chunk loading %s", Commons.format(ticket.world, x, y, z)));
        }
        ImmutableSet chunks = ticket.getChunkList();
        for (ChunkPos chunk : chunks) {
            if (WarpDrive.isDev) {
                WarpDrive.logger.info(String.format("Releasing chunk loading @ %s %s", Commons.format(ticket.world), chunk));
            }
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
        }
    }
}

