/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.BreathingManager;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.forcefield.BlockForceField;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.OfflineAvatarManager;
import cr0s.warpdrive.data.StateAir;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.item.ItemWarpArmor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class LivingHandler {
    private static final HashMap<UUID, Integer> player_cloakTicks = new HashMap();
    private static final HashMap<UUID, Integer> player_borderBypassTicks = new HashMap();
    private static final HashMap<Long, Double> entity_yMotion = new HashMap();
    private static final int CLOAK_CHECK_TIMEOUT_TICKS = 100;
    private static final int BORDER_WARNING_RANGE_BLOCKS_SQUARED = 400;
    private static final int BORDER_BYPASS_RANGE_BLOCKS_SQUARED = 1024;
    private static final int BORDER_BYPASS_PULL_BACK_BLOCKS = 16;
    private static final int BORDER_BYPASS_DAMAGES_PER_TICK = 9000;
    private static final int BORDER_BYPASS_DELAY_TICK = 200;
    private static final int PURGE_PERIOD_TICKS = 6000;
    private static int tickUpdate = 6000;

    public static void updateTick() {
        if (--tickUpdate < 0) {
            tickUpdate = 6000;
            LocalProfiler.start("LivingHandler cleanup");
            Iterator<Long> iterator = entity_yMotion.keySet().iterator();
            while (iterator.hasNext()) {
                Long key = iterator.next();
                int dimensionId = (int)(key >> 32);
                WorldServer worldServer = DimensionManager.getWorld((int)dimensionId);
                if (worldServer == null) {
                    iterator.remove();
                    continue;
                }
                Entity entity = worldServer.func_73045_a((int)(key & 0xFFFFFFFFL));
                if (entity != null) continue;
                iterator.remove();
            }
            LocalProfiler.stop(1000L);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(@Nonnull LivingEvent.LivingUpdateEvent event) {
        CelestialObject celestialObject;
        if (event.getEntityLiving() == null || event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        int x = MathHelper.func_76128_c((double)entityLivingBase.field_70165_t);
        int y = MathHelper.func_76128_c((double)entityLivingBase.field_70163_u);
        int z = MathHelper.func_76128_c((double)entityLivingBase.field_70161_v);
        if (!entityLivingBase.field_70122_E) {
            entity_yMotion.put((long)entityLivingBase.field_71093_bK << 32 | (long)entityLivingBase.func_145782_y(), entityLivingBase.field_70181_x);
        }
        if ((celestialObject = CelestialObjectManager.get(entityLivingBase.field_70170_p, x, z)) == null) {
            return;
        }
        double distanceSquared = celestialObject.getSquareDistanceOutsideBorder(x, z);
        if (distanceSquared <= 0.0) {
            if (entityLivingBase instanceof EntityPlayer) {
                if (Math.abs(distanceSquared) <= 400.0 && entityLivingBase.field_70173_aa % 40 == 0) {
                    ((EntityPlayer)entityLivingBase).func_146105_b((ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.world_border.in_range", (int)Math.sqrt(Math.abs(distanceSquared))), true);
                }
                player_borderBypassTicks.remove(entityLivingBase.func_110124_au());
            }
        } else {
            if (entityLivingBase instanceof EntityPlayer && ((EntityPlayer)entityLivingBase).field_71075_bZ.field_75102_a) {
                if (entityLivingBase.field_70173_aa % 100 == 0) {
                    ((EntityPlayer)entityLivingBase).func_146105_b((ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.world_border.outside", (int)Math.sqrt(Math.abs(distanceSquared))), true);
                }
                return;
            }
            double relativeX = entityLivingBase.field_70165_t - (double)celestialObject.dimensionCenterX;
            double relativeZ = entityLivingBase.field_70161_v - (double)celestialObject.dimensionCenterZ;
            double newAbsoluteX = Math.min(Math.abs(relativeX), Math.max(0.0, (double)(celestialObject.borderRadiusX - 16)));
            double newAbsoluteZ = Math.min(Math.abs(relativeZ), Math.max(0.0, (double)(celestialObject.borderRadiusZ - 16)));
            double newEntityX = (double)celestialObject.dimensionCenterX + Math.signum(relativeX) * newAbsoluteX;
            double newEntityY = entityLivingBase.field_70163_u + 0.1;
            double newEntityZ = (double)celestialObject.dimensionCenterX + Math.signum(relativeZ) * newAbsoluteZ;
            Commons.moveEntity((Entity)entityLivingBase, entityLivingBase.field_70170_p, new Vector3(newEntityX, newEntityY, newEntityZ));
            boolean isDelayed = false;
            if (entityLivingBase instanceof EntityPlayer && !entityLivingBase.field_70128_L && entityLivingBase.field_70725_aQ <= 0) {
                Commons.addChatMessage((ICommandSender)entityLivingBase, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.world_border.reached", new Object[0]));
                int borderBypassTicks = player_borderBypassTicks.getOrDefault(entityLivingBase.func_110124_au(), 0);
                player_borderBypassTicks.put(entityLivingBase.func_110124_au(), borderBypassTicks + 1);
                boolean bl = isDelayed = borderBypassTicks < 200;
            }
            if (distanceSquared < 1024.0 || isDelayed) {
                entityLivingBase.func_70015_d(1);
            } else {
                entityLivingBase.func_70097_a(DamageSource.field_76380_i, 9000.0f);
                return;
            }
        }
        if (entityLivingBase instanceof EntityPlayerMP) {
            this.updatePlayerCloakState(entityLivingBase);
            if (WarpDriveConfig.BREATHING_AIR_AT_ENTITY_DEBUG && entityLivingBase.field_70170_p.func_72820_D() % 20L == 0L) {
                StateAir.dumpAroundEntity((EntityPlayer)entityLivingBase);
            }
            if (WarpDriveConfig.OFFLINE_AVATAR_ENABLE) {
                OfflineAvatarManager.onTick((EntityPlayer)entityLivingBase);
            }
            if (!entityLivingBase.field_70122_E && !celestialObject.hasAtmosphere() && entityLivingBase.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == Items.field_185160_cR && entityLivingBase.func_184613_cA()) {
                ((EntityPlayerMP)entityLivingBase).func_189103_N();
            }
        }
        if (entityLivingBase.field_70128_L || entityLivingBase.func_180431_b((DamageSource)WarpDrive.damageAsphyxia)) {
            return;
        }
        if (!(celestialObject.hasAtmosphere() || entityLivingBase instanceof EntityPlayerMP && ((EntityPlayerMP)entityLivingBase).field_71075_bZ.field_75102_a)) {
            BreathingManager.onLivingUpdateEvent(entityLivingBase, x, y, z);
        }
        if (entityLivingBase.field_70163_u < -10.0) {
            if (Dictionary.isLeftBehind((Entity)entityLivingBase) || Dictionary.isAnchor((Entity)entityLivingBase)) {
                return;
            }
            CelestialObject celestialObjectChild = CelestialObjectManager.getClosestChild(entityLivingBase.field_70170_p, x, z);
            if (celestialObjectChild != null && !celestialObjectChild.isVirtual() && !celestialObject.isHyperspace() && celestialObjectChild.isInOrbit(entityLivingBase.field_70170_p.field_73011_w.getDimension(), x, z)) {
                WorldServer worldTarget = Commons.getOrCreateWorldServer(celestialObjectChild.dimensionId);
                if (worldTarget == null) {
                    WarpDrive.logger.error(String.format("Unable to initialize dimension %d for %s", celestialObjectChild.dimensionId, entityLivingBase));
                    Commons.addChatMessage((ICommandSender)entityLivingBase, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.exception_loading_dimension", celestialObjectChild.dimensionId));
                    entityLivingBase.func_70634_a(entityLivingBase.field_70165_t, 260.0, entityLivingBase.field_70161_v);
                } else {
                    VectorI vEntry = celestialObjectChild.getEntryOffset();
                    double xTarget = entityLivingBase.field_70165_t + (double)vEntry.x;
                    double yTarget = celestialObject.isSpace() ? 1500.0 : (double)(worldTarget.func_72940_L() + 5);
                    double zTarget = entityLivingBase.field_70161_v + (double)vEntry.z;
                    entityLivingBase.field_70143_R = -5.0f;
                    Commons.moveEntity((Entity)entityLivingBase, (World)worldTarget, new Vector3(xTarget, yTarget, zTarget));
                    if (!celestialObject.hasAtmosphere() && celestialObjectChild.hasAtmosphere()) {
                        this.applyAtmosphericEntryEffect(entityLivingBase);
                    }
                }
            } else if (celestialObject.isHyperspace() || celestialObject.isSpace()) {
                entityLivingBase.func_70634_a(entityLivingBase.field_70165_t, 260.0, entityLivingBase.field_70161_v);
            }
        }
    }

    private void applyAtmosphericEntryEffect(@Nonnull EntityLivingBase entityLivingBase) {
        Iterable inventoryArmor = entityLivingBase.func_184193_aE();
        int countReentryArmor = 0;
        for (ItemStack itemStack : inventoryArmor) {
            if (!(itemStack.func_77973_b() instanceof ItemWarpArmor) || ((ItemWarpArmor)itemStack.func_77973_b()).getTier(itemStack).getIndex() <= EnumTier.BASIC.getIndex()) continue;
            ++countReentryArmor;
        }
        if (countReentryArmor == 4 || !(entityLivingBase instanceof EntityPlayer) && countReentryArmor >= 1) {
            return;
        }
        entityLivingBase.func_70015_d(30);
    }

    private void updatePlayerCloakState(EntityLivingBase entity) {
        try {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            Integer cloakTicks = player_cloakTicks.get(player.func_110124_au());
            if (cloakTicks == null) {
                player_cloakTicks.put(player.func_110124_au(), 0);
                return;
            }
            if (cloakTicks >= 100) {
                player_cloakTicks.put(player.func_110124_au(), 0);
                WarpDrive.cloaks.updatePlayer(player);
            } else {
                player_cloakTicks.put(player.func_110124_au(), cloakTicks + 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
        }
    }

    @SubscribeEvent
    public void onLivingFall(@Nonnull LivingFallEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        Double motionY = entity_yMotion.get((long)entityLivingBase.field_71093_bK << 32 | (long)entityLivingBase.func_145782_y());
        if (motionY == null) {
            motionY = entityLivingBase.field_70181_x;
        }
        if (motionY > -0.6517) {
            event.setCanceled(true);
            if (WarpDriveConfig.LOGGING_GRAVITY && entityLivingBase instanceof EntityPlayerMP) {
                WarpDrive.logger.warn(String.format("(low speed     ) Entity fall damage at motionY %.3f from distance %.3f of %s, isCancelled %s", motionY, Float.valueOf(event.getDistance()), entityLivingBase, event.isCanceled()));
            }
            return;
        }
        float distance = event.getDistance();
        int check = MathHelper.func_76123_f((float)(distance - 3.0f));
        if (check <= 0) {
            event.setCanceled(true);
            if (WarpDriveConfig.LOGGING_GRAVITY && entityLivingBase instanceof EntityPlayerMP) {
                WarpDrive.logger.warn(String.format("(short distance) Entity fall damage at motionY %.3f from distance %.3f of %s, isCancelled %s", motionY, Float.valueOf(event.getDistance()), entityLivingBase, event.isCanceled()));
            }
            return;
        }
        if (WarpDriveConfig.LOGGING_GRAVITY) {
            WarpDrive.logger.warn(String.format("Entity fall damage at motionY %.3f from distance %.3f of %s, isCancelled %s", motionY, Float.valueOf(event.getDistance()), entityLivingBase, event.isCanceled()));
        }
        for (EntityEquipmentSlot entityEquipmentSlot : EntityEquipmentSlot.values()) {
            ItemStack itemStackInSlot = entityLivingBase.func_184582_a(entityEquipmentSlot);
            if (itemStackInSlot.func_190926_b() || !Dictionary.ITEMS_NOFALLDAMAGE.contains(itemStackInSlot.func_77973_b())) continue;
            event.setCanceled(true);
            if (!WarpDrive.isDev || !WarpDriveConfig.LOGGING_GRAVITY || !(entityLivingBase instanceof EntityPlayerMP)) continue;
            WarpDrive.logger.warn(String.format("(boots absorbed) Entity fall damage at motionY %.3f from distance %.3f of %s, isCancelled %s", motionY, Float.valueOf(event.getDistance()), entityLivingBase, event.isCanceled()));
        }
        event.setDistance((float)(-6.582 + 4.148 * Math.exp(1.2 * Math.abs(motionY))));
        if (WarpDriveConfig.LOGGING_GRAVITY && entityLivingBase instanceof EntityPlayerMP) {
            WarpDrive.logger.warn(String.format("(full damage   ) Entity fall damage at motionY %.3f from distance %.3f of %s, isCancelled %s", motionY, Float.valueOf(event.getDistance()), entityLivingBase, event.isCanceled()));
        }
    }

    @SubscribeEvent
    public void onEnderTeleport(@Nonnull EnderTeleportEvent event) {
        if (event.getEntityLiving() == null || event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        World world = event.getEntityLiving().field_70170_p;
        int x = MathHelper.func_76128_c((double)event.getTargetX());
        int y = MathHelper.func_76128_c((double)event.getTargetY());
        int z = MathHelper.func_76128_c((double)event.getTargetZ());
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        for (int xLoop = x - 1; xLoop <= x + 1; ++xLoop) {
            for (int zLoop = z - 1; zLoop <= z + 1; ++zLoop) {
                for (int yLoop = y - 1; yLoop <= y + 1; ++yLoop) {
                    if (yLoop <= 0 || yLoop > 255) continue;
                    mutableBlockPos.func_181079_c(xLoop, yLoop, zLoop);
                    Block block = world.func_180495_p((BlockPos)mutableBlockPos).func_177230_c();
                    if (!(block instanceof BlockForceField)) continue;
                    event.setCanceled(true);
                    return;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    void onLivingDeath(@Nonnull LivingDeathEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityLivingBase != null) {
            BreathingManager.onEntityLivingDeath(entityLivingBase);
        }
    }
}

