/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IMyBakedModel;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModelBakeEventHandler {
    public static final ModelBakeEventHandler INSTANCE = new ModelBakeEventHandler();
    private static final Map<ModelResourceLocation, Class<? extends IMyBakedModel>> modelResourceLocationToBakedModel = new HashMap<ModelResourceLocation, Class<? extends IMyBakedModel>>(64);

    private ModelBakeEventHandler() {
    }

    public static void registerBakedModel(ModelResourceLocation modelResourceLocation, Class<? extends IMyBakedModel> classBakedModel) {
        modelResourceLocationToBakedModel.put(modelResourceLocation, classBakedModel);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        for (Map.Entry<ModelResourceLocation, Class<? extends IMyBakedModel>> entry : modelResourceLocationToBakedModel.entrySet()) {
            IMyBakedModel bakedModelNew;
            IBakedModel bakedModelExisting = (IBakedModel)event.getModelRegistry().func_82594_a((Object)entry.getKey());
            if (bakedModelExisting == null) {
                WarpDrive.logger.warn(String.format("Unable to update baked model for missing %s", entry.getKey()));
                continue;
            }
            try {
                bakedModelNew = entry.getValue().newInstance();
                bakedModelNew.setModelResourceLocation(entry.getKey());
                bakedModelNew.setOriginalBakedModel(bakedModelExisting);
            }
            catch (Exception exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.error(String.format("Failed to update baked model through %s of %s", entry.getKey(), entry.getValue()));
                continue;
            }
            event.getModelRegistry().func_82595_a((Object)entry.getKey(), (Object)bakedModelNew);
        }
    }
}

