/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.forcefield.BlockForceField;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.GlobalRegion;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.data.OfflineAvatarManager;
import cr0s.warpdrive.event.AbstractSequencer;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerHandler {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerLoadFromFile(@Nonnull PlayerEvent.LoadFromFile event) {
        OfflineAvatarManager.onPlayerLoggedIn(event.getEntityPlayer());
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(@Nonnull PlayerEvent.PlayerLoggedOutEvent event) {
        if (WarpDriveConfig.OFFLINE_AVATAR_ENABLE) {
            OfflineAvatarManager.onPlayerLoggedOut(event.player);
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(@Nonnull PlayerEvent.BreakSpeed event) {
        BlockPos blockPos = event.getPos();
        this.doCancelEventDuringJump((PlayerEvent)event, blockPos);
        if (event.isCanceled()) {
            return;
        }
        IBlockState blockState = event.getState();
        this.doCancelEventForNonMembers((PlayerEvent)event, blockPos, blockState);
    }

    @SubscribeEvent
    public void onEntityItemPickup(@Nonnull EntityItemPickupEvent event) {
        this.doCancelEventDuringJump((PlayerEvent)event, event.getItem().func_180425_c());
    }

    @SubscribeEvent
    public void onLeftClickBlock(@Nonnull PlayerInteractEvent.LeftClickBlock event) {
        BlockPos blockPos = event.getPos();
        this.doCancelEventDuringJump((PlayerEvent)event, blockPos);
        IBlockState blockState = event.getWorld().func_180495_p(blockPos);
        this.doCancelEventForNonMembers((PlayerEvent)event, blockPos, blockState);
    }

    @SubscribeEvent
    public void onRightClickBlock(@Nonnull PlayerInteractEvent.RightClickBlock event) {
        ArrayList<GlobalRegion> globalRegions;
        BlockPos blockPos = event.getPos();
        this.doCancelEventDuringJump((PlayerEvent)event, blockPos);
        IBlockState blockState = event.getWorld().func_180495_p(blockPos);
        this.doCancelEventForNonMembers((PlayerEvent)event, blockPos, blockState);
        if (!(event.getEntityPlayer() == null || event.getEntityPlayer().field_71071_by == null || !blockState.func_177230_c().equals(Blocks.field_150324_C) || event.getWorld().field_72995_K || blockPos.func_177958_n() == 0 && blockPos.func_177956_o() == 0 && blockPos.func_177952_p() == 0 || (globalRegions = GlobalRegionManager.getContainers(EnumGlobalRegionType.SHIP, event.getWorld(), blockPos)).isEmpty())) {
            BlockPos blockPosBed = blockPos;
            if (blockState.func_177229_b((IProperty)BlockBed.field_176472_a) != BlockBed.EnumPartType.HEAD) {
                blockPosBed = blockPos.func_177972_a((EnumFacing)blockState.func_177229_b((IProperty)BlockHorizontal.field_185512_D));
                IBlockState blockStateHead = event.getWorld().func_180495_p(blockPosBed);
                if (blockState.func_177230_c() != blockStateHead.func_177230_c()) {
                    blockPosBed = blockPos;
                }
            }
            BlockPos blockPosBedOriginal = event.getEntityPlayer().getBedLocation(event.getWorld().field_73011_w.getDimension());
            event.getEntityPlayer().setSpawnChunk(blockPosBed.func_185334_h(), false, event.getWorld().field_73011_w.getDimension());
            BlockPos blockPosBedUpdated = event.getEntityPlayer().getBedLocation(event.getWorld().field_73011_w.getDimension());
            if (blockPosBedOriginal == null || blockPosBedUpdated != null && !blockPosBedUpdated.equals((Object)blockPosBedOriginal)) {
                Commons.addChatMessage((ICommandSender)event.getEntityPlayer(), (ITextComponent)new TextComponentTranslation("commands.spawnpoint.success", new Object[]{event.getEntityPlayer().func_145748_c_(), blockPosBedUpdated.func_177958_n(), blockPosBedUpdated.func_177956_o(), blockPosBedUpdated.func_177952_p()}));
            }
            if (event.getWorld().field_73011_w.getDimension() != 0) {
                event.setCanceled(true);
            }
        }
    }

    private void doCancelEventForNonMembers(@Nonnull PlayerEvent event, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        EntityPlayer entityPlayer = event.getEntityPlayer();
        boolean isCrewMember = PlayerHandler.checkMaintenanceAndCrew((Event)event, entityPlayer, blockPos, blockState);
        if (!isCrewMember && !entityPlayer.func_184812_l_()) {
            if (Commons.throttleMe("cancelingEventForNonMember")) {
                WarpDrive.logger.info(String.format("Cancelling event for non-member %s", entityPlayer));
            }
            event.setCanceled(true);
        }
    }

    public static boolean checkMaintenanceAndCrew(@Nonnull Event event, @Nonnull EntityPlayer entityPlayer, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        Block block = blockState.func_177230_c();
        float hardness = blockState.func_185887_b(entityPlayer.func_130014_f_(), blockPos);
        if (block instanceof BlockForceField || hardness < WarpDriveConfig.HULL_HARDNESS[1] || Dictionary.BLOCKS_ANCHOR.contains(block)) {
            return true;
        }
        ArrayList<GlobalRegion> globalRegions = GlobalRegionManager.getContainers(EnumGlobalRegionType.SHIP, entityPlayer.field_70170_p, blockPos);
        if (globalRegions.isEmpty()) {
            return true;
        }
        boolean isUnderMaintenance = true;
        boolean isCrewMember = true;
        for (GlobalRegion globalRegion : globalRegions) {
            TileEntity tileEntity = entityPlayer.field_70170_p.func_175625_s(globalRegion.getBlockPos());
            if (!(tileEntity instanceof TileEntityShipCore)) {
                if (Commons.throttleMe("onBreakSpeed-InvalidInstance")) {
                    WarpDrive.logger.error(String.format("Unable to adjust harvest speed due to invalid tile entity for global region, expecting TileEntityShipCore, got %s %s. size is %d.", tileEntity, Commons.format(entityPlayer.field_70170_p, globalRegion.getBlockPos()), globalRegions.size()));
                }
                return false;
            }
            TileEntityShipCore tileEntityShipCore = (TileEntityShipCore)tileEntity;
            if (!tileEntityShipCore.isAssemblyValid()) {
                if (!Commons.throttleMe("onBreakSpeed-InvalidAssembly")) continue;
                WarpDrive.logger.debug(String.format("Skipping maintenance & crew members for invalid ship assembly %s", tileEntity));
                continue;
            }
            isUnderMaintenance &= tileEntityShipCore.isUnderMaintenance();
            isCrewMember &= tileEntityShipCore.isCrewMember(entityPlayer);
        }
        if (isUnderMaintenance) {
            if (event instanceof PlayerEvent.BreakSpeed) {
                ((PlayerEvent.BreakSpeed)event).setNewSpeed(5.0f * hardness);
            }
            return true;
        }
        return isCrewMember || entityPlayer.func_184812_l_();
    }

    private void doCancelEventDuringJump(@Nonnull PlayerEvent event, @Nonnull BlockPos blockPos) {
        assert (event.isCancelable());
        if (event.isCanceled()) {
            return;
        }
        if (AbstractSequencer.isLocked(blockPos)) {
            event.setCanceled(true);
        }
    }
}

