/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.event;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.world.FakeWorld;
import gregtech.api.items.IToolItem;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TooltipHandler {
    private static final BlockPos blockPosDummy = new BlockPos(0, -1, 0);

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTooltipEvent_first(@Nonnull ItemTooltipEvent event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        if (event.getItemStack().func_190926_b()) {
            return;
        }
        if (Dictionary.ITEMS_BREATHING_HELMET.contains(event.getItemStack().func_77973_b())) {
            Commons.addTooltip(event.getToolTip(), new TextComponentTranslation("warpdrive.tooltip.item_tag.breathing_helmet", new Object[0]).func_150254_d());
        }
        if (Dictionary.ITEMS_FLYINSPACE.contains(event.getItemStack().func_77973_b())) {
            Commons.addTooltip(event.getToolTip(), new TextComponentTranslation("warpdrive.tooltip.item_tag.fly_in_space", new Object[0]).func_150254_d());
        }
        if (Dictionary.ITEMS_NOFALLDAMAGE.contains(event.getItemStack().func_77973_b())) {
            Commons.addTooltip(event.getToolTip(), new TextComponentTranslation("warpdrive.tooltip.item_tag.no_fall_damage", new Object[0]).func_150254_d());
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTooltipEvent_last(@Nonnull ItemTooltipEvent event) {
        int[] idOres;
        if (event.getEntityPlayer() == null) {
            return;
        }
        if (event.getItemStack().func_190926_b()) {
            return;
        }
        KeyBinding keyBindingSneak = Minecraft.func_71410_x().field_71474_y.field_74311_E;
        boolean isSneaking = Commons.isKeyPressed(keyBindingSneak);
        boolean isCreativeMode = event.getEntityPlayer().field_71075_bZ.field_75098_d;
        TooltipHandler.cleanupTooltip(event.getToolTip(), isSneaking, isCreativeMode);
        Block block = Block.func_149634_a((Item)event.getItemStack().func_77973_b());
        if (block != Blocks.field_150350_a) {
            TooltipHandler.addBlockDetails(event, isSneaking, isCreativeMode, block);
        } else {
            TooltipHandler.addItemDetails(event, isSneaking, isCreativeMode, event.getItemStack());
        }
        if (WarpDriveConfig.TOOLTIP_ADD_BURN_TIME.isEnabled(isSneaking, isCreativeMode)) {
            try {
                int fuelValue;
                int fuelEvent = ForgeEventFactory.getItemBurnTime((ItemStack)event.getItemStack());
                int fuelFurnace = Math.round(TileEntityFurnace.func_145952_a((ItemStack)event.getItemStack()));
                int n = fuelValue = fuelEvent >= 0 ? 0 : fuelFurnace;
                if (fuelValue > 0) {
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78Fuel to burn %.1f ores", Float.valueOf((float)fuelValue / 200.0f)));
                }
            }
            catch (Exception fuelEvent) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.TOOLTIP_ADD_ORE_DICTIONARY_NAME.isEnabled(isSneaking, isCreativeMode) && (idOres = OreDictionary.getOreIDs((ItemStack)event.getItemStack())).length != 0) {
            Commons.addTooltip(event.getToolTip(), "Ore dictionary names:");
            for (int idOre : idOres) {
                String nameOre = OreDictionary.getOreName((int)idOre);
                Commons.addTooltip(event.getToolTip(), "- " + nameOre);
            }
        }
    }

    private static void cleanupTooltip(@Nonnull List<String> list, boolean isSneaking, boolean isCreativeMode) {
        if (list.isEmpty()) {
            return;
        }
        if (!WarpDriveConfig.TOOLTIP_ENABLE_DEDUPLICATION.isEnabled(isSneaking, isCreativeMode)) {
            return;
        }
        HashSet<String> setClean = new HashSet<String>(list.size());
        Iterator<String> iterator = list.iterator();
        while (iterator.hasNext()) {
            String original = iterator.next();
            String clean = Commons.removeFormatting(original).trim().toLowerCase();
            if (clean.isEmpty()) continue;
            boolean doRemove = setClean.contains(clean);
            for (String key : WarpDriveConfig.TOOLTIP_CLEANUP_LIST) {
                if (!clean.contains(key)) continue;
                doRemove = true;
                break;
            }
            if (doRemove) {
                iterator.remove();
                continue;
            }
            setClean.add(clean);
        }
        boolean wasEmpty = false;
        iterator = list.iterator();
        while (iterator.hasNext()) {
            String original = iterator.next();
            String clean = Commons.removeFormatting(original).trim();
            if (!clean.isEmpty() || original.length() > 4) {
                wasEmpty = false;
                continue;
            }
            if (wasEmpty || !iterator.hasNext()) {
                iterator.remove();
            }
            wasEmpty = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void addBlockDetails(@Nonnull ItemTooltipEvent event, boolean isSneaking, boolean isCreativeMode, Block block) {
        ResourceLocation registryNameItem = event.getItemStack().func_77973_b().getRegistryName();
        if (registryNameItem == null) {
            Commons.addTooltip(event.getToolTip(), "\u00c2\u00a74Invalid item with no registry name!");
            return;
        }
        if (WarpDriveConfig.TOOLTIP_ADD_REGISTRY_NAME.isEnabled(isSneaking, isCreativeMode)) {
            try {
                ResourceLocation registryNameBlock = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
                if (registryNameBlock != null) {
                    Commons.addTooltip(event.getToolTip(), "\u00c2\u00a78" + registryNameBlock);
                }
            }
            catch (Exception registryNameBlock) {
                // empty catch block
            }
        }
        IBlockState blockState = TooltipHandler.getStateForPlacement(block, null, null, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f, event.getItemStack().func_77960_j(), null, EnumHand.MAIN_HAND);
        if (WarpDriveConfig.TOOLTIP_ADD_BLOCK_MATERIAL.isEnabled(isSneaking, isCreativeMode)) {
            try {
                Material material = blockState.func_185904_a();
                String name = Commons.format(material);
                Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78Material is %s", name));
            }
            catch (Exception material) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.TOOLTIP_ADD_HARVESTING.isEnabled(isSneaking, isCreativeMode)) {
            try {
                String harvestTool = block.getHarvestTool(blockState);
                if (harvestTool != null) {
                    Commons.addTooltip(event.getToolTip(), String.format("Harvest with %s (%d)", harvestTool, block.getHarvestLevel(blockState)));
                }
            }
            catch (Exception harvestTool) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.TOOLTIP_ADD_OPACITY.isEnabled(isSneaking, isCreativeMode) && blockState != null) {
            try {
                Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78Light opacity is %s", block.func_149717_k(blockState)));
                if (WarpDrive.isDev) {
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78isFullBlock is %s", block.func_149730_j(blockState)));
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78isFullCube is %s", block.func_149686_d(blockState)));
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78isTopSolid is %s", block.func_185481_k(blockState)));
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78isBlockNormalCube is %s", block.func_149637_q(blockState)));
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78isNormalCube is %s", block.func_149721_r(blockState)));
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78causesSuffocation is %s", block.func_176214_u(blockState)));
                }
            }
            catch (Exception harvestTool) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.TOOLTIP_ADD_HARDNESS.isEnabled(isSneaking, isCreativeMode)) {
            FakeWorld fakeWorld = new FakeWorld(blockState, true);
            try {
                float hardness1 = blockState.func_185887_b((World)fakeWorld, BlockPos.field_177992_a);
                float hardness2 = block.field_149782_v;
                if (hardness2 == 0.0f || hardness1 == hardness2) {
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78Hardness is %.1f", Float.valueOf(hardness1)));
                } else {
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78Hardness is %.1f (%.1f)", Float.valueOf(hardness1), Float.valueOf(hardness2)));
                }
            }
            catch (Exception hardness1) {
                // empty catch block
            }
            try {
                float resistance1 = block.getExplosionResistance((World)fakeWorld, BlockPos.field_177992_a, null, null);
                float resistance2 = block.func_149638_a(null);
                if (resistance2 == 0.0f || resistance1 == resistance2) {
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78Explosion resistance is %.1f", Float.valueOf(resistance1)));
                } else {
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78Explosion resistance is %.1f (%.1f)", Float.valueOf(resistance1), Float.valueOf(resistance2)));
                }
            }
            catch (Exception resistance1) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.TOOLTIP_ADD_FLAMMABILITY.isEnabled(isSneaking, isCreativeMode)) {
            try {
                int flammability = Blocks.field_150480_ab.func_176532_c(block);
                int fireSpread = Blocks.field_150480_ab.func_176534_d(block);
                if (flammability > 0) {
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78Flammability is %d, spread %d", flammability, fireSpread));
                }
            }
            catch (Exception flammability) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.TOOLTIP_ADD_FLUID.isEnabled(isSneaking, isCreativeMode)) {
            try {
                Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
                if (fluid != null) {
                    if (fluid.isGaseous()) {
                        Commons.addTooltip(event.getToolTip(), String.format("Gas viscosity is %d", fluid.getViscosity()));
                        Commons.addTooltip(event.getToolTip(), String.format("Gas density is %d", fluid.getDensity()));
                    } else {
                        Commons.addTooltip(event.getToolTip(), String.format("Liquid viscosity is %d", fluid.getViscosity()));
                        Commons.addTooltip(event.getToolTip(), String.format("Liquid density is %d", fluid.getDensity()));
                    }
                    Commons.addTooltip(event.getToolTip(), String.format("Temperature is %d K", fluid.getTemperature()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static IBlockState getStateForPlacement(Block block, World world, BlockPos blockPos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int metadata, EntityLivingBase entityLivingBase, @Nonnull EnumHand enumHand) {
        BlockPos blockPosToUse = blockPos != null ? blockPos : blockPosDummy;
        IBlockState blockState = world != null && world.field_72995_K || Thread.currentThread().getName().equals("Client thread") ? TooltipHandler.getStateForPlacement_client(block, world, blockPosToUse, facing, hitX, hitY, hitZ, metadata, entityLivingBase, enumHand) : TooltipHandler.getStateForPlacement_safely(block, world, blockPosToUse, facing, hitX, hitY, hitZ, metadata, entityLivingBase, enumHand);
        return blockState;
    }

    @SideOnly(value=Side.CLIENT)
    private static IBlockState getStateForPlacement_client(Block block, World world, BlockPos blockPos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int metadata, EntityLivingBase entityLivingBase, @Nonnull EnumHand enumHand) {
        EntityLivingBase entityLivingBaseToUse;
        Object object = entityLivingBaseToUse = entityLivingBase != null ? entityLivingBase : Minecraft.func_71410_x().field_71439_g;
        World worldToUse = world != null ? world : (entityLivingBase != null ? entityLivingBaseToUse.func_130014_f_() : null);
        return TooltipHandler.getStateForPlacement_safely(block, worldToUse, blockPos, facing, hitX, hitY, hitZ, metadata, entityLivingBaseToUse, enumHand);
    }

    private static IBlockState getStateForPlacement_safely(Block block, World world, BlockPos blockPos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int metadata, EntityLivingBase entityLivingBase, @Nonnull EnumHand enumHand) {
        IBlockState blockState;
        try {
            blockState = block.getStateForPlacement(world, blockPos, facing, hitX, hitY, hitZ, metadata, entityLivingBase, enumHand);
        }
        catch (AssertionError | Exception throwable1) {
            try {
                blockState = block.func_176203_a(metadata);
                if (WarpDrive.isDev && (world == null || entityLivingBase == null)) {
                    WarpDrive.logger.debug(String.format("Exception getting block state from block %s (%s %d): %s", block, block.getRegistryName(), metadata, throwable1));
                }
            }
            catch (AssertionError | Exception throwable2) {
                WarpDrive.logger.error(String.format("Exception getting block state from item stack %s (%s %d): %s", block, block.getRegistryName(), metadata, throwable1));
                ((Throwable)throwable1).printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.error(String.format("followed by %s", throwable2));
                ((Throwable)throwable2).printStackTrace(WarpDrive.printStreamError);
                blockState = block.func_176223_P();
            }
        }
        return blockState;
    }

    @SideOnly(value=Side.CLIENT)
    private static void addItemDetails(ItemTooltipEvent event, boolean isSneaking, boolean isCreativeMode, @Nonnull ItemStack itemStack) {
        int enchantability;
        Item item = itemStack.func_77973_b();
        if (WarpDriveConfig.TOOLTIP_ADD_REGISTRY_NAME.isEnabled(isSneaking, isCreativeMode)) {
            try {
                ResourceLocation registryNameItem = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)itemStack.func_77973_b());
                if (registryNameItem == null) {
                    Commons.addTooltip(event.getToolTip(), "\u00c2\u00a74Invalid item with no registry name!");
                    return;
                }
                Commons.addTooltip(event.getToolTip(), "\u00c2\u00a78" + registryNameItem);
            }
            catch (Exception registryNameItem) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.TOOLTIP_ADD_DURABILITY.isEnabled(isSneaking, isCreativeMode)) {
            try {
                if (WarpDriveConfig.isGregtechLoaded && itemStack.func_77973_b() instanceof IToolItem) {
                    IToolItem toolItem = (IToolItem)itemStack.func_77973_b();
                    int itemDamage = toolItem.getItemDamage(itemStack);
                    int maxDamage = toolItem.getMaxItemDamage(itemStack);
                    Commons.addTooltip(event.getToolTip(), String.format("Durability: %d / %d", maxDamage - itemDamage, maxDamage));
                }
                if (itemStack.func_77984_f()) {
                    Commons.addTooltip(event.getToolTip(), String.format("Durability: %d / %d", itemStack.func_77958_k() - itemStack.func_77952_i(), itemStack.func_77958_k()));
                }
            }
            catch (Exception toolItem) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.TOOLTIP_ADD_ARMOR_POINTS.isEnabled(isSneaking, isCreativeMode)) {
            try {
                if (item instanceof ItemArmor) {
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78Armor points is %d", ((ItemArmor)item).field_77879_b));
                }
            }
            catch (Exception toolItem) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.TOOLTIP_ADD_HARVESTING.isEnabled(isSneaking, isCreativeMode)) {
            try {
                Set toolClasses = item.getToolClasses(itemStack);
                for (String toolClass : toolClasses) {
                    int harvestLevel = item.getHarvestLevel(itemStack, toolClass, event.getEntityPlayer(), null);
                    if (harvestLevel == -1) continue;
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78Tool class is %s (%d)", toolClass, harvestLevel));
                }
            }
            catch (Exception toolClasses) {
                // empty catch block
            }
        }
        if (WarpDriveConfig.TOOLTIP_ADD_ENCHANTABILITY.isEnabled(isSneaking, isCreativeMode) && (enchantability = item.func_77619_b()) > 0) {
            Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78Enchantability is %d", enchantability));
        }
        if (WarpDriveConfig.TOOLTIP_ADD_REPAIR_WITH.isEnabled(isSneaking, isCreativeMode)) {
            try {
                ItemStack itemStackRepair;
                if (item instanceof ItemArmor) {
                    ItemArmor.ArmorMaterial armorMaterial = ((ItemArmor)item).func_82812_d();
                    itemStackRepair = armorMaterial.getRepairItemStack();
                } else if (item instanceof ItemTool) {
                    String nameMaterial = ((ItemTool)item).func_77861_e();
                    Item.ToolMaterial toolMaterial = Item.ToolMaterial.valueOf((String)nameMaterial);
                    itemStackRepair = toolMaterial.getRepairItemStack();
                } else if (item instanceof ItemSword) {
                    String nameMaterial = ((ItemSword)item).func_150932_j();
                    Item.ToolMaterial toolMaterial = Item.ToolMaterial.valueOf((String)nameMaterial);
                    itemStackRepair = toolMaterial.getRepairItemStack();
                } else {
                    itemStackRepair = ItemStack.field_190927_a;
                }
                if (!itemStackRepair.func_190926_b()) {
                    Commons.addTooltip(event.getToolTip(), String.format("\u00c2\u00a78Repairable with %s", new TextComponentTranslation(itemStackRepair.func_77977_a() + ".name", new Object[0]).func_150254_d()));
                }
            }
            catch (Exception itemStackRepair) {
                // empty catch block
            }
        }
        if (item instanceof ItemMonsterPlacer && WarpDriveConfig.TOOLTIP_ADD_ENTITY_ID.isEnabled(isSneaking, isCreativeMode)) {
            ResourceLocation entityId = ItemMonsterPlacer.func_190908_h((ItemStack)itemStack);
            if (entityId != null) {
                Commons.addTooltip(event.getToolTip(), String.format("Entity is %s", entityId));
            } else {
                Commons.addTooltip(event.getToolTip(), "Entity is \u00c2\u00a74-undefined");
            }
        }
    }
}

