/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.item;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.IBeamFrequency;
import cr0s.warpdrive.api.IControlChannel;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.api.IWarpTool;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.energy.BlockCapacitor;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.item.ItemAbstractBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTuningFork
extends ItemAbstractBase
implements IWarpTool {
    public ItemTuningFork(String registryName, EnumTier enumTier) {
        super(registryName, enumTier);
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77655_b("warpdrive.tool.tuning_fork");
        this.func_77664_n();
        this.func_77627_a(true);
    }

    public void func_150895_a(@Nonnull CreativeTabs creativeTab, @Nonnull NonNullList<ItemStack> list) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (int dyeColor = 0; dyeColor < 16; ++dyeColor) {
            list.add((Object)new ItemStack((Item)this, 1, dyeColor));
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getModelResourceLocation(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        ResourceLocation resourceLocation = this.getRegistryName();
        assert (resourceLocation != null);
        if (damage >= 0 && damage < 16) {
            resourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a() + "-" + EnumDyeColor.func_176766_a((int)damage).func_176610_l());
        }
        return new ModelResourceLocation(resourceLocation, "inventory");
    }

    @Nonnull
    public String func_77667_c(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        if (damage >= 0 && damage < 16) {
            return this.func_77658_a() + "." + EnumDyeColor.func_176766_a((int)damage).func_176762_d();
        }
        return this.func_77658_a();
    }

    public static int getVideoChannel(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningFork)) {
            return -1;
        }
        return itemStack.func_77952_i() % 16 + 100;
    }

    public static int getBeamFrequency(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningFork)) {
            return -1;
        }
        return (itemStack.func_77952_i() % 16 + 1) * 10;
    }

    public static int getControlChannel(ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemTuningFork)) {
            return -1;
        }
        return itemStack.func_77952_i() % 16 + 2;
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer entityPlayer, @Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumHand hand, @Nonnull EnumFacing enumFacing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        ItemStack itemStackHeld = entityPlayer.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity == null) {
            return EnumActionResult.FAIL;
        }
        boolean hasVideoChannel = tileEntity instanceof IVideoChannel;
        boolean hasBeamFrequency = tileEntity instanceof IBeamFrequency;
        boolean hasControlChannel = tileEntity instanceof IControlChannel;
        if (!(hasVideoChannel || hasBeamFrequency || hasControlChannel)) {
            return EnumActionResult.FAIL;
        }
        if (!(!hasVideoChannel || entityPlayer.func_70093_af() && hasBeamFrequency)) {
            ((IVideoChannel)tileEntity).setVideoChannel(ItemTuningFork.getVideoChannel(itemStackHeld));
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new TextComponentTranslation("warpdrive.video_channel.set", new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemTuningFork.getVideoChannel(itemStackHeld)}));
            world.func_184134_a(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, SoundEvents.DING, SoundCategory.PLAYERS, 0.1f, 1.0f, false);
        } else if (!(!hasControlChannel || entityPlayer.func_70093_af() && hasBeamFrequency)) {
            ((IControlChannel)tileEntity).setControlChannel(ItemTuningFork.getControlChannel(itemStackHeld));
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new TextComponentTranslation("warpdrive.control_channel.set", new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemTuningFork.getControlChannel(itemStackHeld)}));
            world.func_184134_a(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, SoundEvents.DING, SoundCategory.PLAYERS, 0.1f, 1.0f, false);
        } else {
            ((IBeamFrequency)tileEntity).setBeamFrequency(ItemTuningFork.getBeamFrequency(itemStackHeld));
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new TextComponentTranslation("warpdrive.beam_frequency.set", new Object[]{tileEntity.func_145838_q().func_149732_F(), ItemTuningFork.getBeamFrequency(itemStackHeld)}));
            world.func_184134_a(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, SoundEvents.DING, SoundCategory.PLAYERS, 0.1f, 1.0f, false);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean doesSneakBypassUse(@Nonnull ItemStack itemStack, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos blockPos, @Nonnull EntityPlayer player) {
        Block block = blockAccess.func_180495_p(blockPos).func_177230_c();
        return block instanceof BlockCapacitor || super.doesSneakBypassUse(itemStack, blockAccess, blockPos, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemStack, @Nullable World world, @Nonnull List<String> list, @Nonnull ITooltipFlag advancedItemTooltips) {
        super.func_77624_a(itemStack, world, list, advancedItemTooltips);
        WarpDriveText textTooltip = new WarpDriveText();
        textTooltip.append(null, "warpdrive.video_channel.tooltip", new Object[]{new WarpDriveText(Commons.getStyleValue(), ItemTuningFork.getVideoChannel(itemStack))});
        textTooltip.append(null, "warpdrive.beam_frequency.tooltip", new Object[]{new WarpDriveText(Commons.getStyleValue(), ItemTuningFork.getBeamFrequency(itemStack))});
        textTooltip.append(null, "warpdrive.control_channel.tooltip", new Object[]{new WarpDriveText(Commons.getStyleValue(), ItemTuningFork.getControlChannel(itemStack))});
        textTooltip.appendLineBreak();
        textTooltip.append(null, "item.warpdrive.tool.tuning_fork.tooltip.usage", new Object[0]);
        Commons.addTooltip(list, textTooltip.func_150254_d());
    }
}

