/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CloakedArea;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageCloak
implements IMessage,
IMessageHandler<MessageCloak, IMessage> {
    private int coreX;
    private int coreY;
    private int coreZ;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private boolean isFullyTransparent;
    private boolean isUncloaking;

    public MessageCloak() {
    }

    public MessageCloak(CloakedArea area, boolean isUncloaking) {
        this.coreX = area.blockPosCore.func_177958_n();
        this.coreY = area.blockPosCore.func_177956_o();
        this.coreZ = area.blockPosCore.func_177952_p();
        this.minX = area.minX;
        this.minY = area.minY;
        this.minZ = area.minZ;
        this.maxX = area.maxX;
        this.maxY = area.maxY;
        this.maxZ = area.maxZ;
        this.isFullyTransparent = area.isFullyTransparent;
        this.isUncloaking = isUncloaking;
    }

    public void fromBytes(ByteBuf buffer) {
        this.coreX = buffer.readInt();
        this.coreY = buffer.readInt();
        this.coreZ = buffer.readInt();
        this.minX = buffer.readInt();
        this.minY = buffer.readInt();
        this.minZ = buffer.readInt();
        this.maxX = buffer.readInt();
        this.maxY = buffer.readInt();
        this.maxZ = buffer.readInt();
        this.isFullyTransparent = buffer.readBoolean();
        this.isUncloaking = buffer.readBoolean();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.coreX);
        buffer.writeInt(this.coreY);
        buffer.writeInt(this.coreZ);
        buffer.writeInt(this.minX);
        buffer.writeInt(this.minY);
        buffer.writeInt(this.minZ);
        buffer.writeInt(this.maxX);
        buffer.writeInt(this.maxY);
        buffer.writeInt(this.maxZ);
        buffer.writeBoolean(this.isFullyTransparent);
        buffer.writeBoolean(this.isUncloaking);
    }

    @SideOnly(value=Side.CLIENT)
    private void handle(EntityPlayerSP player) {
        if (this.isUncloaking) {
            WarpDrive.cloaks.removeCloakedArea(player.field_70170_p.field_73011_w.getDimension(), new BlockPos(this.coreX, this.coreY, this.coreZ));
        } else {
            WarpDrive.cloaks.updateCloakedArea(player.field_70170_p, new BlockPos(this.coreX, this.coreY, this.coreZ), this.isFullyTransparent, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageCloak cloakMessage, MessageContext context) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            WarpDrive.logger.error("WorldObj is null, ignoring cloak packet");
            return null;
        }
        if (WarpDriveConfig.LOGGING_CLOAKING) {
            WarpDrive.logger.info(String.format("Received cloak packet: %s area (%d %d %d) -> (%d %d %d) tier %d", cloakMessage.isUncloaking ? "UNCLOAKING" : "cloaking", cloakMessage.minX, cloakMessage.minY, cloakMessage.minZ, cloakMessage.maxX, cloakMessage.maxY, cloakMessage.maxZ, cloakMessage.isFullyTransparent ? 2 : 1));
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        assert (player != null);
        if ((double)cloakMessage.minX <= player.field_70165_t && (double)(cloakMessage.maxX + 1) > player.field_70165_t && (double)cloakMessage.minY <= player.field_70163_u && (double)(cloakMessage.maxY + 1) > player.field_70163_u && (double)cloakMessage.minZ <= player.field_70161_v && (double)(cloakMessage.maxZ + 1) > player.field_70161_v) {
            return null;
        }
        cloakMessage.handle(player);
        return null;
    }
}

