/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleFirework;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSpawnParticle
implements IMessage,
IMessageHandler<MessageSpawnParticle, IMessage> {
    private String type;
    private byte quantity;
    private Vector3 origin;
    private Vector3 direction;
    private float baseRed;
    private float baseGreen;
    private float baseBlue;
    private float fadeRed;
    private float fadeGreen;
    private float fadeBlue;

    public MessageSpawnParticle() {
    }

    MessageSpawnParticle(String type, byte quantity, Vector3 origin, Vector3 direction, float baseRed, float baseGreen, float baseBlue, float fadeRed, float fadeGreen, float fadeBlue) {
        this.type = type;
        this.quantity = quantity;
        this.origin = origin;
        this.direction = direction;
        this.baseRed = baseRed;
        this.baseGreen = baseGreen;
        this.baseBlue = baseBlue;
        this.fadeRed = fadeRed;
        this.fadeGreen = fadeGreen;
        this.fadeBlue = fadeBlue;
    }

    public void fromBytes(ByteBuf buffer) {
        byte typeSize = buffer.readByte();
        this.type = buffer.toString(buffer.readerIndex(), (int)typeSize, StandardCharsets.US_ASCII);
        buffer.skipBytes((int)typeSize);
        this.quantity = buffer.readByte();
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        this.origin = new Vector3(x, y, z);
        x = buffer.readDouble();
        y = buffer.readDouble();
        z = buffer.readDouble();
        this.direction = new Vector3(x, y, z);
        this.baseRed = buffer.readFloat();
        this.baseGreen = buffer.readFloat();
        this.baseBlue = buffer.readFloat();
        this.fadeRed = buffer.readFloat();
        this.fadeGreen = buffer.readFloat();
        this.fadeBlue = buffer.readFloat();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte(this.type.length());
        buffer.writeBytes(this.type.getBytes(StandardCharsets.US_ASCII), 0, this.type.length());
        buffer.writeByte((int)this.quantity);
        buffer.writeDouble(this.origin.x);
        buffer.writeDouble(this.origin.y);
        buffer.writeDouble(this.origin.z);
        buffer.writeDouble(this.direction.x);
        buffer.writeDouble(this.direction.y);
        buffer.writeDouble(this.direction.z);
        buffer.writeFloat(this.baseRed);
        buffer.writeFloat(this.baseGreen);
        buffer.writeFloat(this.baseBlue);
        buffer.writeFloat(this.fadeRed);
        buffer.writeFloat(this.fadeGreen);
        buffer.writeFloat(this.fadeBlue);
    }

    private int integerFromRGB(float red, float green, float blue) {
        return (Math.round(red * 255.0f) << 16) + (Math.round(green * 255.0f) << 8) + Math.round(blue * 255.0f);
    }

    @SideOnly(value=Side.CLIENT)
    private void handle(World world) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        if (entity == null || mc.field_71452_i == null) {
            return;
        }
        if (mc.field_71474_y.field_74362_aa == 1 && world.field_73012_v.nextInt(3) != 0) {
            return;
        }
        double noiseLevel = this.direction.getMagnitude() * 0.35;
        for (int index = 0; index < this.quantity; ++index) {
            Particle particle;
            Vector3 directionRandomized = new Vector3(this.direction.x + noiseLevel * (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()), this.direction.y + noiseLevel * (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()), this.direction.z + noiseLevel * (double)(world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()));
            switch (this.type) {
                default: {
                    if (Commons.throttleMe("invalidParticleType " + this.type)) {
                        WarpDrive.logger.error(String.format("Invalid particle type '%s' at %s", this.type, this.origin.toString()));
                    }
                }
                case "explosionHuge": {
                    particle = mc.field_71452_i.func_178927_a(EnumParticleTypes.EXPLOSION_HUGE.func_179348_c(), this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z, new int[0]);
                    break;
                }
                case "explosionLarge": {
                    particle = mc.field_71452_i.func_178927_a(EnumParticleTypes.EXPLOSION_LARGE.func_179348_c(), this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z, new int[0]);
                    break;
                }
                case "explosionNormal": {
                    particle = mc.field_71452_i.func_178927_a(EnumParticleTypes.EXPLOSION_NORMAL.func_179348_c(), this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z, new int[0]);
                    break;
                }
                case "fireworksSpark": {
                    particle = mc.field_71452_i.func_178927_a(EnumParticleTypes.FIREWORKS_SPARK.func_179348_c(), this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z, new int[0]);
                    if (!(particle instanceof ParticleFirework.Spark)) break;
                    ((ParticleFirework.Spark)particle).func_187145_d(this.integerFromRGB(this.fadeRed, this.fadeGreen, this.fadeBlue));
                    break;
                }
                case "flame": {
                    particle = mc.field_71452_i.func_178927_a(EnumParticleTypes.FLAME.func_179348_c(), this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z, new int[0]);
                    break;
                }
                case "snowball": {
                    particle = mc.field_71452_i.func_178927_a(EnumParticleTypes.SNOWBALL.func_179348_c(), this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z, new int[0]);
                    break;
                }
                case "snowShovel": {
                    particle = mc.field_71452_i.func_178927_a(EnumParticleTypes.SNOW_SHOVEL.func_179348_c(), this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z, new int[0]);
                    break;
                }
                case "mobSpell": {
                    particle = mc.field_71452_i.func_178927_a(EnumParticleTypes.SPELL_MOB.func_179348_c(), this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z, new int[0]);
                    break;
                }
                case "cloud": {
                    particle = mc.field_71452_i.func_178927_a(EnumParticleTypes.CLOUD.func_179348_c(), this.origin.x, this.origin.y, this.origin.z, directionRandomized.x, directionRandomized.y, directionRandomized.z, new int[0]);
                    break;
                }
                case "jammed": {
                    EnumFacing directionFacing = Commons.getHorizontalDirectionFromEntity((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
                    particle = directionFacing.func_82601_c() != 0 ? mc.field_71452_i.func_178927_a(EnumParticleTypes.VILLAGER_ANGRY.func_179348_c(), this.origin.x + 0.51 * (double)directionFacing.func_82601_c(), this.origin.y - 0.5 + world.field_73012_v.nextDouble(), this.origin.z - 0.5 + world.field_73012_v.nextDouble(), directionRandomized.x, directionRandomized.y, directionRandomized.z, new int[0]) : mc.field_71452_i.func_178927_a(EnumParticleTypes.VILLAGER_ANGRY.func_179348_c(), this.origin.x - 0.5 + world.field_73012_v.nextDouble(), this.origin.y - 0.5 + world.field_73012_v.nextDouble(), this.origin.z + 0.51 * (double)directionFacing.func_82599_e(), directionRandomized.x, directionRandomized.y, directionRandomized.z, new int[0]);
                    assert (particle != null);
                    particle.func_70536_a(81);
                    particle.func_82338_g(0.5f);
                    particle.func_187114_a(100);
                }
            }
            if (particle == null || !(this.baseRed >= 0.0f) || !(this.baseGreen >= 0.0f) || !(this.baseBlue >= 0.0f)) continue;
            particle.func_70538_b(this.baseRed, this.baseGreen, this.baseBlue);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageSpawnParticle messageSpawnParticle, MessageContext context) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            WarpDrive.logger.error("WorldObj is null, ignoring particle packet");
            return null;
        }
        if (WarpDriveConfig.LOGGING_EFFECTS) {
            WarpDrive.logger.info(String.format("Received particle effect '%s' x %d from %s towards %s as RGB %.2f %.2f %.2f fading to %.2f %.2f %.2f", messageSpawnParticle.type, messageSpawnParticle.quantity, messageSpawnParticle.origin, messageSpawnParticle.direction, Float.valueOf(messageSpawnParticle.baseRed), Float.valueOf(messageSpawnParticle.baseGreen), Float.valueOf(messageSpawnParticle.baseBlue), Float.valueOf(messageSpawnParticle.fadeRed), Float.valueOf(messageSpawnParticle.fadeGreen), Float.valueOf(messageSpawnParticle.fadeBlue)));
        }
        messageSpawnParticle.handle((World)Minecraft.func_71410_x().field_71441_e);
        return null;
    }
}

