/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.network;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IVideoChannel;
import cr0s.warpdrive.config.WarpDriveConfig;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageVideoChannel
implements IMessage,
IMessageHandler<MessageVideoChannel, IMessage> {
    private BlockPos blockPos;
    private int videoChannel;

    public MessageVideoChannel() {
    }

    public MessageVideoChannel(BlockPos blockPos, int videoChannel) {
        this.blockPos = blockPos;
        this.videoChannel = videoChannel;
    }

    public void fromBytes(ByteBuf buffer) {
        this.blockPos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        this.videoChannel = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.blockPos.func_177958_n());
        buffer.writeInt(this.blockPos.func_177956_o());
        buffer.writeInt(this.blockPos.func_177952_p());
        buffer.writeInt(this.videoChannel);
    }

    @SideOnly(value=Side.CLIENT)
    private void handle(World world) {
        TileEntity tileEntity = world.func_175625_s(this.blockPos);
        if (tileEntity != null) {
            if (tileEntity instanceof IVideoChannel) {
                ((IVideoChannel)tileEntity).setVideoChannel(this.videoChannel);
            } else {
                WarpDrive.logger.error(String.format("Received video channel packet: invalid tile entity %s", Commons.format(world, this.blockPos)));
            }
        } else {
            WarpDrive.logger.error(String.format("Received video channel packet: no tile entity %s", Commons.format(world, this.blockPos)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageVideoChannel videoChannelMessage, MessageContext context) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            WarpDrive.logger.error("WorldObj is null, ignoring video channel packet");
            return null;
        }
        if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info(String.format("Received video channel packet %s videoChannel %d", Commons.format((World)world, videoChannelMessage.blockPos), videoChannelMessage.videoChannel));
        }
        videoChannelMessage.handle((World)world);
        return null;
    }
}

