/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumCameraType;
import cr0s.warpdrive.render.EntityCamera;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.lwjgl.input.Keyboard;

public class ClientCameraHandler {
    public static boolean isOverlayEnabled = false;
    public static EnumCameraType overlayType = null;
    public static int zoomIndex = 0;
    public static String overlayLoggingMessage = "";
    public static float originalFOV = 70.0f;
    public static float originalSensitivity = 100.0f;
    public static EntityPlayer entityPlayer;
    public static int dimensionId;
    public static BlockPos blockPosCheck1;
    public static BlockPos blockPosCheck2;
    public static IBlockState blockStateCheck1;
    public static IBlockState blockStateCheck2;

    public ClientCameraHandler() {
        Minecraft mc = Minecraft.func_71410_x();
        if (WarpDriveConfig.LOGGING_CAMERA) {
            WarpDrive.logger.info(String.format("FOV is %.3f Sensitivity is %.3f", Float.valueOf(mc.field_71474_y.field_74334_X), Float.valueOf(mc.field_71474_y.field_74341_c)));
        }
    }

    public static void setupViewpoint(EnumCameraType enumCameraType, EntityPlayer entityPlayer, float initialYaw, float initialPitch, BlockPos blockPosMonitor, IBlockState blockStateMonitor, BlockPos blockPosCamera, IBlockState blockStateCamera) {
        Minecraft mc = Minecraft.func_71410_x();
        if (entityPlayer == null) {
            WarpDrive.logger.error("setupViewpoint with null player => denied");
            return;
        }
        originalFOV = mc.field_71474_y.field_74334_X;
        originalSensitivity = mc.field_71474_y.field_74341_c;
        overlayType = enumCameraType;
        ClientCameraHandler.entityPlayer = entityPlayer;
        dimensionId = entityPlayer.field_70170_p.field_73011_w.getDimension();
        blockPosCheck1 = blockPosMonitor;
        blockStateCheck1 = blockStateMonitor;
        blockPosCheck2 = blockPosCamera;
        blockStateCheck2 = blockStateCamera;
        EntityCamera entityCamera = new EntityCamera(entityPlayer.field_70170_p, blockPosCamera.func_177958_n(), blockPosCamera.func_177956_o(), blockPosCamera.func_177952_p(), entityPlayer);
        entityPlayer.field_70170_p.func_72838_d((Entity)entityCamera);
        entityCamera.func_70012_b((double)blockPosCamera.func_177958_n() + 0.5, (double)blockPosCamera.func_177956_o() + 0.5, (double)blockPosCamera.func_177952_p() + 0.5, initialYaw, initialPitch);
        if (WarpDriveConfig.LOGGING_CAMERA) {
            WarpDrive.logger.info(String.format("Setting viewpoint to %s", new Object[]{entityCamera}));
        }
        mc.func_175607_a((Entity)entityCamera);
        mc.field_71474_y.field_74320_O = 0;
        ClientCameraHandler.refreshViewPoint();
        isOverlayEnabled = true;
        Keyboard.enableRepeatEvents((boolean)true);
    }

    private static void refreshViewPoint() {
        Minecraft mc = Minecraft.func_71410_x();
        switch (zoomIndex) {
            case 0: {
                mc.field_71474_y.field_74334_X = originalFOV;
                mc.field_71474_y.field_74341_c = originalSensitivity / 2.0f;
                break;
            }
            case 1: {
                mc.field_71474_y.field_74334_X = originalFOV / 1.5f;
                mc.field_71474_y.field_74341_c = originalSensitivity / 3.0f;
                break;
            }
            case 2: {
                mc.field_71474_y.field_74334_X = originalFOV / 3.0f;
                mc.field_71474_y.field_74341_c = originalSensitivity / 6.0f;
                break;
            }
            case 3: {
                mc.field_71474_y.field_74334_X = originalFOV / 4.5f;
                mc.field_71474_y.field_74341_c = originalSensitivity / 9.0f;
                break;
            }
            default: {
                mc.field_71474_y.field_74334_X = originalFOV;
                mc.field_71474_y.field_74341_c = originalSensitivity / 2.0f;
            }
        }
    }

    public static void zoom() {
        zoomIndex = (zoomIndex + 1) % 4;
        ClientCameraHandler.refreshViewPoint();
        if (WarpDriveConfig.LOGGING_CAMERA) {
            Minecraft mc = Minecraft.func_71410_x();
            assert (mc.field_71439_g != null);
            mc.field_71439_g.func_71165_d("changed to fovSetting " + mc.field_71474_y.field_74334_X + " mouseSensitivity " + mc.field_71474_y.field_74341_c);
        }
    }

    public static void resetViewpoint() {
        Minecraft mc = Minecraft.func_71410_x();
        if (entityPlayer != null) {
            mc.func_175607_a((Entity)entityPlayer);
            entityPlayer = null;
            if (WarpDriveConfig.LOGGING_CAMERA) {
                WarpDrive.logger.info("Resetting viewpoint");
            }
        } else {
            WarpDrive.logger.error("resetting viewpoint with invalid player entity?");
        }
        Keyboard.enableRepeatEvents((boolean)false);
        isOverlayEnabled = false;
        mc.field_71474_y.field_74320_O = 0;
        mc.field_71474_y.field_74334_X = originalFOV;
        mc.field_71474_y.field_74341_c = originalSensitivity;
        entityPlayer = null;
        dimensionId = -666;
    }

    public static boolean isValidContext(World world) {
        if (world == null || world.field_73011_w.getDimension() != dimensionId) {
            return false;
        }
        if (!world.func_180495_p(blockPosCheck1).func_177230_c().func_149667_c(blockStateCheck1.func_177230_c())) {
            WarpDrive.logger.error(String.format("Checking camera viewpoint, found invalid block1 %s", Commons.format(world, blockPosCheck1)));
            return false;
        }
        if (!world.func_180495_p(blockPosCheck2).func_177230_c().func_149667_c(blockStateCheck2.func_177230_c())) {
            WarpDrive.logger.error(String.format("Checking camera viewpoint, found invalid block2 %s", Commons.format(world, blockPosCheck2)));
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void onEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        if (isOverlayEnabled) {
            ClientCameraHandler.resetViewpoint();
        }
    }

    static {
        dimensionId = -666;
    }
}

