/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.render.AbstractEntityFX;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityFXDot
extends AbstractEntityFX {
    private Vector3 v3Acceleration;
    private double friction;
    private int layer = 0;

    public EntityFXDot(World world, Vector3 v3Position, Vector3 v3Motion, Vector3 v3Acceleration, double friction, int age) {
        super(world, v3Position.x, v3Position.y, v3Position.z, 0.0, 0.0, 0.0);
        this.func_187115_a(0.02f, 0.02f);
        this.field_190017_n = false;
        this.field_187129_i = v3Motion.x;
        this.field_187130_j = v3Motion.y;
        this.field_187131_k = v3Motion.z;
        this.v3Acceleration = v3Acceleration;
        this.friction = friction;
        this.field_70547_e = age;
        this.func_70536_a(113);
        this.func_187109_b(v3Position.x, v3Position.y, v3Position.z);
    }

    public void setParticleFromBlockIcon(TextureAtlasSprite texture) {
        this.layer = 1;
        this.func_187117_a(texture);
    }

    public void setParticleFromItemIcon(TextureAtlasSprite texture) {
        this.layer = 2;
        this.func_187117_a(texture);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i = (this.field_187129_i + this.v3Acceleration.x) * this.friction;
        this.field_187130_j = (this.field_187130_j + this.v3Acceleration.y) * this.friction;
        this.field_187131_k = (this.field_187131_k + this.v3Acceleration.z) * this.friction;
    }

    public int func_70537_b() {
        return this.layer;
    }

    public int func_189214_a(float p_70070_1_) {
        return 0xF00000;
    }

    public void func_180434_a(BufferBuilder vertexBuffer, Entity entityIn, float partialTick, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        double minU = (float)this.field_94054_b / 16.0f;
        double maxU = minU + (double)0.0624375f;
        double minV = (float)this.field_94055_c / 16.0f;
        double maxV = minV + (double)0.0624375f;
        float scale = 0.1f * this.field_70544_f;
        if (this.field_187119_C != null) {
            minU = this.field_187119_C.func_94209_e();
            maxU = this.field_187119_C.func_94212_f();
            minV = this.field_187119_C.func_94206_g();
            maxV = this.field_187119_C.func_94210_h();
        }
        double x = this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTick - field_70556_an;
        double y = this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTick - field_70554_ao;
        double z = this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTick - field_70555_ap;
        float alpha = this.field_82339_as;
        int ageLeft = this.field_70547_e - this.field_70546_d;
        if (this.field_70546_d < 1) {
            alpha = this.field_82339_as * partialTick;
        } else if (ageLeft < 2) {
            alpha = ageLeft < 1 ? this.field_82339_as * (0.5f - partialTick / 2.0f) : this.field_82339_as * (1.0f - partialTick / 2.0f);
        }
        int brightnessForRender = this.func_189214_a(partialTick);
        int brightnessHigh = brightnessForRender >> 16 & 0xFFFF;
        int brightnessLow = brightnessForRender & 0xFFFF;
        Vec3d[] vec3ds = new Vec3d[]{new Vec3d((double)(-rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(-rotationYZ * scale - rotationXZ * scale)), new Vec3d((double)(-rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(-rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale + rotationXY * scale), (double)(rotationZ * scale), (double)(rotationYZ * scale + rotationXZ * scale)), new Vec3d((double)(rotationX * scale - rotationXY * scale), (double)(-rotationZ * scale), (double)(rotationYZ * scale - rotationXZ * scale))};
        vertexBuffer.func_181662_b(x + vec3ds[0].field_72450_a, y + vec3ds[0].field_72448_b, z + vec3ds[0].field_72449_c).func_187315_a(maxU, maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
        vertexBuffer.func_181662_b(x + vec3ds[1].field_72450_a, y + vec3ds[1].field_72448_b, z + vec3ds[1].field_72449_c).func_187315_a(maxU, minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
        vertexBuffer.func_181662_b(x + vec3ds[2].field_72450_a, y + vec3ds[2].field_72448_b, z + vec3ds[2].field_72449_c).func_187315_a(minU, minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
        vertexBuffer.func_181662_b(x + vec3ds[3].field_72450_a, y + vec3ds[3].field_72448_b, z + vec3ds[3].field_72449_c).func_187315_a(minU, maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
    }
}

