/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.render.AbstractEntityFX;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class EntityFXEnergizing
extends AbstractEntityFX {
    private static final ResourceLocation TEXTURE = new ResourceLocation("warpdrive", "textures/particle/energy_grey.png");
    private double radius;
    private double length;
    private final int countSteps;
    private float rotYaw;
    private float rotPitch;
    private float prevYaw;
    private float prevPitch;

    public EntityFXEnergizing(World world, Vector3 position, Vector3 target, float red, float green, float blue, int age, float radius) {
        super(world, position.x, position.y, position.z, 0.0, 0.0, 0.0);
        this.func_70538_b(red, green, blue);
        this.func_187115_a(0.02f, 0.02f);
        this.field_190017_n = false;
        this.field_187129_i = 0.0;
        this.field_187130_j = 0.0;
        this.field_187131_k = 0.0;
        this.radius = radius;
        float xd = (float)(this.field_187126_f - target.x);
        float yd = (float)(this.field_187127_g - target.y);
        float zd = (float)(this.field_187128_h - target.z);
        this.length = new Vector3(this).distanceTo(target);
        double lengthXZ = MathHelper.func_76129_c((float)(xd * xd + zd * zd));
        this.rotYaw = (float)(Math.atan2(xd, zd) * 180.0 / Math.PI);
        this.rotPitch = (float)(Math.atan2(yd, lengthXZ) * 180.0 / Math.PI);
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        this.field_70547_e = age;
        Entity entityRender = Minecraft.func_71410_x().func_175606_aa();
        int visibleDistance = 300;
        if (!Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            visibleDistance = 100;
            this.countSteps = 1;
        } else {
            this.countSteps = 6;
        }
        if (entityRender.func_70011_f(this.field_187126_f, this.field_187127_g, this.field_187128_h) > (double)visibleDistance) {
            this.field_70547_e = 0;
        }
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.prevYaw = this.rotYaw;
        this.prevPitch = this.rotPitch;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
    }

    public void func_180434_a(BufferBuilder vertexBuffer, Entity entityIn, float partialTick, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        GlStateManager.func_179094_E();
        double factorFadeIn = Math.min(((float)this.field_70546_d + partialTick) / 20.0f, 1.0f);
        float alpha = 0.5f;
        if (this.field_70547_e - this.field_70546_d <= 4) {
            alpha = 0.5f - (float)(4 - (this.field_70547_e - this.field_70546_d)) * 0.1f;
        } else {
            double timeAlpha = (double)((float)(((this.getSeed() ^ 0x47C8) & 0xFFFF) + this.field_70546_d) + partialTick) + 0.0167;
            alpha = (float)((double)alpha + Math.pow(Math.sin(timeAlpha * 0.37) + Math.sin(0.178 + timeAlpha * 0.17), 2.0) * 0.05);
        }
        int brightnessForRender = this.func_189214_a(partialTick);
        int brightnessHigh = brightnessForRender >> 16 & 0xFFFF;
        int brightnessLow = Math.max(240, brightnessForRender & 0xFFFF);
        double timeTexture = (float)((this.getSeed() & 0xFFFF) + this.field_70546_d) + partialTick;
        double uOffset = (double)((int)Math.floor(timeTexture * 0.5) % 16) / 16.0;
        double vOffset = Math.pow(Math.sin(timeTexture * 0.2), 2.0) * 0.005;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_187403_b((int)3553, (int)10242, (float)10497.0f);
        GlStateManager.func_187403_b((int)3553, (int)10243, (float)10497.0f);
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179132_a((boolean)false);
        float xx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTick - field_70556_an);
        float yy = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTick - field_70554_ao);
        float zz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTick - field_70555_ap);
        GlStateManager.func_179109_b((float)xx, (float)yy, (float)zz);
        float rotYaw = this.prevYaw + (this.rotYaw - this.prevYaw) * partialTick;
        float rotPitch = this.prevPitch + (this.rotPitch - this.prevPitch) * partialTick;
        float rotSpin = 0.0f;
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(180.0f + rotYaw), (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        double radius = this.radius * factorFadeIn;
        double yMin = this.length * (0.5 - factorFadeIn / 2.0);
        double yMax = this.length * (0.5 + factorFadeIn / 2.0);
        double uMin = uOffset;
        double uMax = uMin + 0.03125;
        double vMin = -1.0 + vOffset;
        double vMax = vMin + this.length * factorFadeIn;
        Tessellator tessellator = Tessellator.func_178181_a();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
        double angleMax = 0.7853981633974483;
        double angleStep = 0.7853981633974483 / (double)this.countSteps;
        double angle = 0.0;
        double cosPrev = radius * Math.cos(angle);
        double sinPrev = radius * Math.sin(angle);
        for (int indexStep = 1; indexStep <= this.countSteps; ++indexStep) {
            double cosNext = radius * Math.cos(angle += angleStep);
            double sinNext = radius * Math.sin(angle);
            vertexBuffer.func_181662_b(cosPrev, yMax, sinPrev).func_187315_a(uMax, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(cosPrev, yMin, sinPrev).func_187315_a(uMax, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(cosNext, yMin, sinNext).func_187315_a(uMin, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(cosNext, yMax, sinNext).func_187315_a(uMin, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-cosPrev, yMax, sinPrev).func_187315_a(uMax, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-cosPrev, yMin, sinPrev).func_187315_a(uMax, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-cosNext, yMin, sinNext).func_187315_a(uMin, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-cosNext, yMax, sinNext).func_187315_a(uMin, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(cosPrev, yMax, -sinPrev).func_187315_a(uMax, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(cosPrev, yMin, -sinPrev).func_187315_a(uMax, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(cosNext, yMin, -sinNext).func_187315_a(uMin, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(cosNext, yMax, -sinNext).func_187315_a(uMin, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-cosPrev, yMax, -sinPrev).func_187315_a(uMax, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-cosPrev, yMin, -sinPrev).func_187315_a(uMax, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-cosNext, yMin, -sinNext).func_187315_a(uMin, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-cosNext, yMax, -sinNext).func_187315_a(uMin, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(sinPrev, yMax, cosPrev).func_187315_a(uMax, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(sinPrev, yMin, cosPrev).func_187315_a(uMax, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(sinNext, yMin, cosNext).func_187315_a(uMin, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(sinNext, yMax, cosNext).func_187315_a(uMin, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-sinPrev, yMax, cosPrev).func_187315_a(uMax, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-sinPrev, yMin, cosPrev).func_187315_a(uMax, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-sinNext, yMin, cosNext).func_187315_a(uMin, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-sinNext, yMax, cosNext).func_187315_a(uMin, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(sinPrev, yMax, -cosPrev).func_187315_a(uMax, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(sinPrev, yMin, -cosPrev).func_187315_a(uMax, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(sinNext, yMin, -cosNext).func_187315_a(uMin, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(sinNext, yMax, -cosNext).func_187315_a(uMin, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-sinPrev, yMax, -cosPrev).func_187315_a(uMax, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-sinPrev, yMin, -cosPrev).func_187315_a(uMax, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-sinNext, yMin, -cosNext).func_187315_a(uMin, vMin).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            vertexBuffer.func_181662_b(-sinNext, yMax, -cosNext).func_187315_a(uMin, vMax).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, alpha).func_187314_a(brightnessHigh, brightnessLow).func_181675_d();
            cosPrev = cosNext;
            sinPrev = sinNext;
        }
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    public int func_70537_b() {
        return 3;
    }
}

