/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.entity.EntityParticleBunch;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderEntity;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderEntityParticleBunch
extends RenderEntity {
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_SIZE_X = new double[]{0.0, 0.8, 1.0, 8.0, 10.0, 80.0, 100.0};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_SIZE_Y = new double[]{0.12, 0.08, 0.06, 0.05, 0.04, 0.03, 0.02};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_RED_INSIDE_Y = new double[]{0.4, 0.6, 0.7, 0.8, 0.6, 0.2, 0.2};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_GREEN_INSIDE_Y = new double[]{0.4, 0.5, 0.4, 0.2, 0.2, 0.3, 0.4};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_BLUE_INSIDE_Y = new double[]{0.2, 0.2, 0.5, 0.6, 0.6, 0.7, 0.8};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_RED_OUTSIDE_Y = new double[]{0.7, 0.9, 0.8, 0.9, 0.8, 0.65, 0.45};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_GREEN_OUTSIDE_Y = new double[]{0.8, 1.0, 0.9, 0.8, 0.6, 0.75, 1.0};
    public static final double[] PARTICLE_BUNCH_ENERGY_TO_BLUE_OUTSIDE_Y = new double[]{0.2, 0.3, 0.5, 0.6, 0.6, 0.8, 0.9};

    public RenderEntityParticleBunch(RenderManager renderManagerIn) {
        super(renderManagerIn);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float rotation, float partialTick) {
        if (entity instanceof EntityParticleBunch) {
            this.doRender((EntityParticleBunch)entity, x, y, z, rotation, partialTick);
        }
    }

    public void func_76979_b(@Nonnull Entity entity, double x, double y, double z, float rotation, float partialTick) {
    }

    public void doRender(EntityParticleBunch entityParticleBunch, double x, double y, double z, float rotation, float partialTick) {
        int maxRenderDistanceSquared = Minecraft.func_71410_x().field_71474_y.field_74347_j ? 16384 : 400;
        if (x * x + y * y + z * z > (double)maxRenderDistanceSquared) {
            return;
        }
        double energy = entityParticleBunch.getEnergy();
        float size = (float)Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_SIZE_Y, energy);
        int rayCount_base = 45;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
        RenderEntityParticleBunch.renderStar((float)entityParticleBunch.field_70173_aa + partialTick, entityParticleBunch.func_145782_y(), 45, (int)(255.0 * Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_RED_INSIDE_Y, energy)), (int)(255.0 * Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_GREEN_INSIDE_Y, energy)), (int)(255.0 * Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_BLUE_INSIDE_Y, energy)), (int)(255.0 * Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_RED_OUTSIDE_Y, energy)), (int)(255.0 * Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_GREEN_OUTSIDE_Y, energy)), (int)(255.0 * Commons.interpolate(PARTICLE_BUNCH_ENERGY_TO_SIZE_X, PARTICLE_BUNCH_ENERGY_TO_BLUE_OUTSIDE_Y, energy)));
        GlStateManager.func_179121_F();
    }

    private static void renderStar(float ticksExisted, long seed, int rayCount_base, int redIn, int greenIn, int blueIn, int redOut, int greenOut, int blueOut) {
        Random random = new Random(seed);
        int tickRotationPeriod = 220 + 2 * random.nextInt(30);
        int tickRotation = (int)(ticksExisted % (float)tickRotationPeriod);
        if (tickRotation >= tickRotationPeriod / 2) {
            tickRotation = tickRotationPeriod - tickRotation - 1;
        }
        float cycleRotation = (float)(2 * tickRotation) / (float)tickRotationPeriod;
        int rayCount = rayCount_base + random.nextInt(10);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        RenderHelper.func_74518_a();
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        GlStateManager.func_179132_a((boolean)false);
        for (int i = 0; i < rayCount; ++i) {
            int tickBoostPeriod = 15 + 2 * random.nextInt(10);
            int tickBoost = (int)(ticksExisted % (float)tickBoostPeriod);
            if (tickBoost >= tickBoostPeriod / 2) {
                tickBoost = tickBoostPeriod - tickBoost - 1;
            }
            float cycleBoost = (float)(2 * tickBoost) / (float)tickBoostPeriod;
            float boost = 0.0f;
            if (cycleBoost > 0.6f) {
                boost = (cycleBoost - 0.6f) / 0.4f;
            }
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(random.nextFloat() * 360.0f + cycleRotation * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            vertexBuffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            float rayLength = random.nextFloat() * 15.0f + 5.0f + boost * 5.0f;
            float rayWidth = random.nextFloat() * 2.0f + 1.0f + boost * 1.0f;
            vertexBuffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(redIn, greenIn, blueIn, (int)(190.0f + 64.0f * (1.0f - boost))).func_181675_d();
            vertexBuffer.func_181662_b(-0.866 * (double)rayWidth, (double)rayLength, -0.5 * (double)rayWidth).func_181669_b(redOut, greenOut, blueOut, 0).func_181675_d();
            vertexBuffer.func_181662_b(0.866 * (double)rayWidth, (double)rayLength, -0.5 * (double)rayWidth).func_181669_b(redOut, greenOut, blueOut, 0).func_181675_d();
            vertexBuffer.func_181662_b(0.0, (double)rayLength, 1.0 * (double)rayWidth).func_181669_b(redOut, greenOut, blueOut, 0).func_181675_d();
            vertexBuffer.func_181662_b(-0.866 * (double)rayWidth, (double)rayLength, -0.5 * (double)rayWidth).func_181669_b(redOut, greenOut, blueOut, 0).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
    }
}

