/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.render;

import cr0s.warpdrive.BreathingManager;
import cr0s.warpdrive.api.ExceptionChunkNotLoaded;
import cr0s.warpdrive.block.breathing.BlockAirShield;
import cr0s.warpdrive.compat.CompatMatterOverdrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.StateAir;
import cr0s.warpdrive.render.RenderCommons;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderOverlayAir {
    private static final int WARNING_ON_JOIN_TICKS = 400;
    private static final Minecraft minecraft = Minecraft.func_71410_x();
    private static float ratioPreviousAir = 1.0f;
    private static long timePreviousAir = 0L;
    private boolean wasRendered;
    private int cache_rangeToVoid = -1;
    private int cache_ticksVoidCheck = -1;

    private void renderAir(int width, int height) {
        float fAlpha;
        float fBlue;
        float fGreen;
        float fRed;
        long timeDelta;
        EntityPlayerSP entityPlayer = RenderOverlayAir.minecraft.field_71439_g;
        if (entityPlayer == null) {
            return;
        }
        if (entityPlayer.func_184812_l_() || entityPlayer.func_175149_v()) {
            return;
        }
        int x = MathHelper.func_76128_c((double)entityPlayer.field_70165_t);
        int y = MathHelper.func_76128_c((double)entityPlayer.field_70163_u);
        int z = MathHelper.func_76128_c((double)entityPlayer.field_70161_v);
        CelestialObject celestialObject = CelestialObjectManager.get(entityPlayer.field_70170_p, x, z);
        if (celestialObject == null || celestialObject.hasAtmosphere()) {
            return;
        }
        if (WarpDriveConfig.isMatterOverdriveLoaded && CompatMatterOverdrive.isAndroid((EntityPlayer)entityPlayer)) {
            return;
        }
        int rangeToVoid = this.getRangeToVoid((EntityLivingBase)entityPlayer, x, y, z);
        boolean hasValidSetup = BreathingManager.hasValidSetup((EntityLivingBase)entityPlayer);
        float ratioAirReserve = BreathingManager.getAirReserveRatio((EntityPlayer)entityPlayer);
        GlStateManager.func_179147_l();
        int alpha = 255;
        if (rangeToVoid >= 0 || entityPlayer.field_70173_aa < 400) {
            if (!hasValidSetup) {
                alpha = RenderCommons.drawSplashAlarm(width, height, "warpdrive.breathing.alarm", "warpdrive.breathing.invalid_setup");
            } else if (ratioAirReserve <= 0.0f) {
                alpha = RenderCommons.drawSplashAlarm(width, height, "warpdrive.breathing.alarm", "warpdrive.breathing.no_air");
            } else if (ratioAirReserve < 0.15f) {
                alpha = RenderCommons.drawSplashAlarm(width, height, "warpdrive.breathing.alarm", "warpdrive.breathing.low_reserve");
            }
        }
        minecraft.func_110434_K().func_110577_a(Gui.field_110324_m);
        int left = width / 2 + 91;
        int top = height - GuiIngameForge.right_height;
        long timeWorld = entityPlayer.field_70170_p.func_82737_E();
        if (ratioAirReserve != ratioPreviousAir) {
            timePreviousAir = timeWorld;
            ratioPreviousAir = ratioAirReserve;
        }
        if ((timeDelta = timeWorld - timePreviousAir) >= 0L && timeDelta <= 8L) {
            RenderCommons.drawTexturedModalRect(left - 9, top, 25, 18, 9, 9, 100);
        } else if (timeDelta < 0L || timeDelta > 16L) {
            RenderCommons.drawTexturedModalRect(left - 9, top, 16, 18, 9, 9, 100);
        }
        int full = MathHelper.func_76143_f((double)((double)ratioAirReserve * 71.0));
        RenderCommons.drawTexturedModalRect(left - 81, top + 2, 20, 84, 71, 5, 100);
        if (alpha == 255) {
            fRed = 1.0f;
            fGreen = 1.0f;
            fBlue = 1.0f;
            fAlpha = 1.0f;
        } else {
            float factor = 1.0f - (float)alpha / 255.0f;
            fRed = 1.0f;
            fGreen = 0.2f + 0.8f * factor;
            fBlue = 0.2f + 0.8f * factor;
            fAlpha = 1.0f;
        }
        RenderCommons.drawTexturedModalRect(left - 10 - full, top + 2, 91 - full, 89, full, 5, 100, fRed, fGreen, fBlue, fAlpha);
        GuiIngameForge.right_height += 10;
        GlStateManager.func_179084_k();
    }

    private int getRangeToVoid(@Nonnull EntityLivingBase entityLivingBase, int x, int y, int z) {
        if (entityLivingBase.field_70173_aa == this.cache_ticksVoidCheck) {
            return this.cache_rangeToVoid;
        }
        this.cache_rangeToVoid = this.getRangeToVoid_noCache(entityLivingBase.field_70170_p, x, y, z);
        this.cache_ticksVoidCheck = entityLivingBase.field_70173_aa;
        return this.cache_rangeToVoid;
    }

    private int getRangeToVoid_noCache(@Nonnull World world, int x, int y, int z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        IBlockState blockStateSelf = world.func_180495_p((BlockPos)mutableBlockPos);
        if (this.isVoid(blockStateSelf, (IBlockAccess)world, (BlockPos)mutableBlockPos)) {
            return 0;
        }
        for (EnumFacing enumFacing : EnumFacing.field_176754_o) {
            boolean isNonAirShieldSealer;
            mutableBlockPos.func_181079_c(x + enumFacing.func_82601_c(), y + enumFacing.func_96559_d(), z + enumFacing.func_82599_e());
            IBlockState blockStateClose = world.func_180495_p((BlockPos)mutableBlockPos);
            if (this.isVoid(blockStateClose, (IBlockAccess)world, (BlockPos)mutableBlockPos)) {
                return 1;
            }
            StateAir stateAirClose = new StateAir(null);
            try {
                stateAirClose.refresh(world, mutableBlockPos.func_177958_n(), mutableBlockPos.func_177956_o(), mutableBlockPos.func_177952_p());
            }
            catch (ExceptionChunkNotLoaded exceptionChunkNotLoaded) {
                return -1;
            }
            boolean bl = isNonAirShieldSealer = !stateAirClose.isAir() && !(blockStateClose.func_177230_c() instanceof BlockAirShield);
            if (isNonAirShieldSealer) continue;
            mutableBlockPos.func_181079_c(x + 2 * enumFacing.func_82601_c(), y + 2 * enumFacing.func_96559_d(), z + 2 * enumFacing.func_82599_e());
            IBlockState blockStateFar = world.func_180495_p((BlockPos)mutableBlockPos);
            if (!this.isVoid(blockStateFar, (IBlockAccess)world, (BlockPos)mutableBlockPos)) continue;
            return 2;
        }
        return -1;
    }

    private boolean isVoid(@Nonnull IBlockState blockState, @Nonnull IBlockAccess blockAccess, BlockPos blockPos) {
        return blockState.func_177230_c().isAir(blockState, blockAccess, blockPos) && !BreathingManager.isAirBlock(blockState.func_177230_c());
    }

    @SubscribeEvent
    public void onRender(@Nonnull RenderGameOverlayEvent.Pre event) {
        switch (event.getType()) {
            case ALL: {
                this.wasRendered = false;
                break;
            }
            case AIR: {
                this.renderAir(event.getResolution().func_78326_a(), event.getResolution().func_78328_b());
                this.wasRendered = true;
                break;
            }
            case CHAT: {
                if (this.wasRendered || !WarpDriveConfig.CLIENT_BREATHING_OVERLAY_FORCED) break;
                this.renderAir(event.getResolution().func_78326_a(), event.getResolution().func_78328_b());
                this.wasRendered = true;
            }
        }
    }

    @SubscribeEvent
    public void onRender(@Nonnull RenderGameOverlayEvent.Post event) {
        switch (event.getType()) {
            case ALL: {
                if (this.wasRendered || !WarpDriveConfig.CLIENT_BREATHING_OVERLAY_FORCED) break;
                this.renderAir(event.getResolution().func_78326_a(), event.getResolution().func_78328_b());
            }
        }
    }
}

