/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.render.RenderBlank;
import cr0s.warpdrive.render.RenderSpaceSky;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractWorldProvider
extends WorldProvider {
    protected CelestialObject celestialObjectDimension = null;
    protected boolean isRemote;
    protected static CelestialObject celestialObject = null;

    AbstractWorldProvider() {
    }

    protected void updateCelestialObject() throws RuntimeException {
        if (this.getDimension() == 0) {
            throw new RuntimeException("Critical error: you can't use a WorldProvider before settings its dimension id!");
        }
        if (this.celestialObjectDimension == null) {
            this.isRemote = FMLCommonHandler.instance().getEffectiveSide().isClient();
            this.celestialObjectDimension = CelestialObjectManager.get(this.isRemote, this.getDimension(), 0, 0);
        }
    }

    @Nonnull
    public String getSaveFolder() {
        this.updateCelestialObject();
        if (this.celestialObjectDimension == null) {
            throw new RuntimeException(String.format("Critical error: there's no celestial object defining %s dimension DIM%d, unable to proceed further", this.isRemote ? "client" : "server", this.getDimension()));
        }
        return this.celestialObjectDimension.id;
    }

    public boolean isDaytime() {
        return true;
    }

    @Nonnull
    public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, @Nonnull BlockPos blockPos) {
        return WorldProvider.WorldSleepResult.ALLOW;
    }

    public boolean func_76566_a(int x, int z) {
        BlockPos blockPos = this.field_76579_a.func_175672_r(new BlockPos(x, 0, z));
        return blockPos.func_177956_o() != 0;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Vec3d getSkyColor(@Nonnull Entity cameraEntity, float partialTicks) {
        if (this.getCloudRenderer() == null) {
            this.setCloudRenderer(RenderBlank.getInstance());
        }
        if (this.getSkyRenderer() == null) {
            this.setSkyRenderer(RenderSpaceSky.getInstance());
        }
        CelestialObject celestialObject = AbstractWorldProvider.celestialObject = cameraEntity.field_70170_p == null ? null : CelestialObjectManager.get(cameraEntity.field_70170_p, MathHelper.func_76128_c((double)cameraEntity.field_70165_t), MathHelper.func_76128_c((double)cameraEntity.field_70161_v));
        if (AbstractWorldProvider.celestialObject == null) {
            return new Vec3d(1.0, 0.0, 0.0);
        }
        return new Vec3d((double)AbstractWorldProvider.celestialObject.backgroundColor.red, (double)AbstractWorldProvider.celestialObject.backgroundColor.green, (double)AbstractWorldProvider.celestialObject.backgroundColor.blue);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public Vec3d func_76562_b(float celestialAngle, float par2) {
        float factor = Commons.clamp(0.0f, 1.0f, MathHelper.func_76134_b((float)(celestialAngle * (float)Math.PI * 2.0f)) * 2.0f + 0.5f);
        float red = celestialObject == null ? 0.0f : AbstractWorldProvider.celestialObject.colorFog.red;
        float green = celestialObject == null ? 0.0f : AbstractWorldProvider.celestialObject.colorFog.green;
        float blue = celestialObject == null ? 0.0f : AbstractWorldProvider.celestialObject.colorFog.blue;
        float factorRed = celestialObject == null ? 0.0f : AbstractWorldProvider.celestialObject.factorFog.red;
        float factorGreen = celestialObject == null ? 0.0f : AbstractWorldProvider.celestialObject.factorFog.green;
        float factorBlue = celestialObject == null ? 0.0f : AbstractWorldProvider.celestialObject.factorFog.blue;
        return new Vec3d((double)(red *= factor * factorRed + (1.0f - factorRed)), (double)(green *= factor * factorGreen + (1.0f - factorGreen)), (double)(blue *= factor * factorBlue + (1.0f - factorBlue)));
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float partialTicks) {
        if (celestialObject == null) {
            return 0.0f;
        }
        float starBrightnessVanilla = super.getStarBrightness(partialTicks);
        return AbstractWorldProvider.celestialObject.baseStarBrightness + AbstractWorldProvider.celestialObject.vanillaStarBrightness * starBrightnessVanilla;
    }
}

