/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cr0s.warpdrive.WarpDrive;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public final class EntityStarCore
extends Entity {
    public int xCoord;
    public int yCoord;
    public int zCoord;
    private int radius;
    private static final int KILL_RADIUS = 60;
    private static final int BURN_RADIUS = 200;
    private boolean isLogged = false;
    private static final int ENTITY_ACTION_INTERVAL = 10;
    private int ticks = 0;

    public EntityStarCore(World world) {
        super(world);
    }

    public EntityStarCore(World world, int x, int y, int z, int radius) {
        super(world);
        this.xCoord = x;
        this.field_70165_t = x;
        this.yCoord = y;
        this.field_70163_u = y;
        this.zCoord = z;
        this.field_70161_v = z;
        this.radius = radius;
    }

    private void actionToEntitiesNearStar() {
        int MAX_RANGE = this.radius + 60 + 200;
        int KILL_RANGESQ = (this.radius + 60) * (this.radius + 60);
        int BURN_RANGESQ = (this.radius + 60 + 200) * (this.radius + 60 + 200);
        int xMin = this.xCoord - MAX_RANGE;
        int xMax = this.xCoord + MAX_RANGE;
        int zMin = this.zCoord - MAX_RANGE;
        int zMax = this.zCoord + MAX_RANGE;
        int yMin = this.yCoord - MAX_RANGE;
        int yMax = this.yCoord + MAX_RANGE;
        AxisAlignedBB aabb = new AxisAlignedBB((double)xMin, (double)yMin, (double)zMin, (double)xMax, (double)yMax, (double)zMax);
        List list = this.field_70170_p.func_72839_b((Entity)this, aabb);
        if (!this.isLogged) {
            this.isLogged = true;
            WarpDrive.logger.info((Object)((Object)this) + " Capture range " + MAX_RANGE + " X " + xMin + " to " + xMax + " Y " + yMin + " to " + yMax + " Z " + zMin + " to " + zMax);
        }
        for (Object object : list) {
            double distanceSq;
            EntityLivingBase entityLivingBase;
            if (!(object instanceof Entity) || !(object instanceof EntityLivingBase) || (entityLivingBase = (EntityLivingBase)object).func_180431_b((DamageSource)WarpDrive.damageWarm)) continue;
            if (entityLivingBase instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
                if (entityPlayer.field_71075_bZ.field_75102_a) continue;
            }
            if ((distanceSq = entityLivingBase.func_70068_e((Entity)this)) <= (double)KILL_RANGESQ) {
                entityLivingBase.func_70097_a(DamageSource.field_76370_b, 9000.0f);
                entityLivingBase.func_70097_a(DamageSource.field_76377_j, 9000.0f);
                if (entityLivingBase.field_70128_L) continue;
                WarpDrive.logger.warn(String.format("Forcing entity death due to star proximity: %s", entityLivingBase));
                entityLivingBase.func_70106_y();
                continue;
            }
            if (!(distanceSq <= (double)BURN_RANGESQ)) continue;
            if (!entityLivingBase.func_70045_F()) {
                entityLivingBase.func_70015_d(3);
            }
            entityLivingBase.func_70097_a(DamageSource.field_76370_b, 1.0f);
        }
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (++this.ticks > 10) {
            this.ticks = 0;
            this.actionToEntitiesNearStar();
        }
    }

    protected void func_70037_a(@Nonnull NBTTagCompound tagCompound) {
        this.xCoord = tagCompound.func_74762_e("x");
        this.yCoord = tagCompound.func_74762_e("y");
        this.zCoord = tagCompound.func_74762_e("z");
        this.radius = tagCompound.func_74762_e("radius");
    }

    protected void func_70088_a() {
        this.field_70145_X = true;
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("x", this.xCoord);
        tagCompound.func_74768_a("y", this.yCoord);
        tagCompound.func_74768_a("z", this.zCoord);
        tagCompound.func_74768_a("radius", this.radius);
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }
}

