/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.world;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.world.AbstractWorldProvider;
import cr0s.warpdrive.world.SpaceChunkProvider;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProviderSingle;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SpaceWorldProvider
extends AbstractWorldProvider {
    public SpaceWorldProvider() {
        this.field_76578_c = new BiomeProviderSingle(WarpDrive.biomeSpace);
        this.field_76576_e = false;
    }

    protected void func_76572_b() {
        super.func_76572_b();
        this.field_76579_a.func_181544_b(0);
    }

    @Nonnull
    public DimensionType func_186058_p() {
        return WarpDrive.dimensionTypeSpace;
    }

    public boolean func_76567_e() {
        return true;
    }

    public boolean func_76569_d() {
        return true;
    }

    public int func_76557_i() {
        return 1;
    }

    public double getHorizon() {
        return -256.0;
    }

    public void updateWeather() {
        super.resetRainAndThunder();
    }

    @Nonnull
    public Biome getBiomeForCoords(@Nonnull BlockPos blockPos) {
        return WarpDrive.biomeSpace;
    }

    public void setAllowedSpawnTypes(boolean allowHostile, boolean allowPeaceful) {
        super.setAllowedSpawnTypes(true, true);
    }

    public float func_76563_a(long time, float partialTick) {
        return 0.0f;
    }

    protected void func_76556_a() {
        float ambient = 0.0f;
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * 1.0f + 0.0f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    public int getRespawnDimension(@Nonnull EntityPlayerMP entityPlayerMP) {
        if (entityPlayerMP.field_70170_p == null) {
            WarpDrive.logger.error(String.format("Invalid player passed to getRespawnDimension: %s", entityPlayerMP));
            return 0;
        }
        return CelestialObjectManager.getSpaceDimensionId(entityPlayerMP.field_70170_p, (int)entityPlayerMP.field_70165_t, (int)entityPlayerMP.field_70161_v);
    }

    @Nonnull
    public IChunkGenerator func_186060_c() {
        return new SpaceChunkProvider(this.field_76579_a, 45L);
    }

    public boolean canBlockFreeze(@Nonnull BlockPos blockPos, boolean byWater) {
        return true;
    }

    @Override
    public boolean isDaytime() {
        return true;
    }

    public boolean canDoLightning(@Nonnull Chunk chunk) {
        return false;
    }

    public boolean canDoRainSnowIce(@Nonnull Chunk chunk) {
        return false;
    }
}

