/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.DiscoveryRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipeAdapater;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.integrations.mods.crafttweaker.network.SerializeableRecipe;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public abstract class BaseAltarRecipe
implements SerializeableRecipe {
    protected String name;
    protected ItemHandle[] inputs;
    protected ItemStack output;
    protected int starlightRequired;
    protected int craftingTickTime;

    public BaseAltarRecipe(String name, ItemHandle[] inputs, ItemStack output, int starlightRequired, int craftingTickTime) {
        this.name = name;
        this.inputs = inputs;
        this.output = output;
        this.starlightRequired = starlightRequired;
        this.craftingTickTime = craftingTickTime;
    }

    @Override
    public void read(ByteBuf buf) {
        this.name = ByteBufUtils.readString(buf);
        this.starlightRequired = buf.readInt();
        this.craftingTickTime = buf.readInt();
        this.output = ByteBufUtils.readItemStack(buf);
        int size = buf.readInt();
        this.inputs = new ItemHandle[size];
        for (int i = 0; i < size; ++i) {
            boolean defined = buf.readBoolean();
            if (!defined) continue;
            this.inputs[i] = ItemHandle.deserialize(buf);
        }
    }

    @Override
    public void write(ByteBuf buf) {
        ByteBufUtils.writeString(buf, this.name);
        buf.writeInt(this.starlightRequired);
        buf.writeInt(this.craftingTickTime);
        ByteBufUtils.writeItemStack(buf, this.output);
        buf.writeInt(this.inputs.length);
        for (ItemHandle handle : this.inputs) {
            buf.writeBoolean(handle != null);
            if (handle == null) continue;
            handle.serialize(buf);
        }
    }

    public List<Integer> computeFluidConsumptionSlots(ItemHandle[] inputs) {
        LinkedList fluidInputs = Lists.newLinkedList();
        for (int i = 0; i < inputs.length; ++i) {
            ItemHandle handle = inputs[i];
            if (handle == null || handle.handleType != ItemHandle.Type.FLUID) continue;
            fluidInputs.add(i);
        }
        return fluidInputs;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractAltarRecipe buildRecipeUnsafe(TileAltar.AltarLevel altarLevel, int starlightConsumption, final int craftingTickTime, ItemStack out, ItemHandle[] inputs) {
        final int sConsumption = starlightConsumption = MathHelper.func_76125_a((int)starlightConsumption, (int)1, (int)altarLevel.getStarlightMaxStorage());
        final List<Integer> fluidStacks = this.computeFluidConsumptionSlots(inputs);
        switch (altarLevel) {
            case DISCOVERY: {
                return new DiscoveryRecipe(this.buildNativeRecipe(inputs, out)){

                    @Override
                    public int getPassiveStarlightRequired() {
                        return sConsumption;
                    }

                    @Override
                    public int craftingTickTime() {
                        return craftingTickTime;
                    }

                    @Override
                    public boolean mayDecrement(TileAltar ta, ShapedRecipeSlot slot) {
                        return !fluidStacks.contains(slot.getSlotID());
                    }
                };
            }
            case ATTUNEMENT: {
                AttunementRecipe rec = new AttunementRecipe(this.buildNativeRecipe(inputs, out)){

                    @Override
                    public int getPassiveStarlightRequired() {
                        return sConsumption;
                    }

                    @Override
                    public int craftingTickTime() {
                        return craftingTickTime;
                    }

                    @Override
                    public boolean mayDecrement(TileAltar ta, ShapedRecipeSlot slot) {
                        return !fluidStacks.contains(slot.getSlotID());
                    }

                    @Override
                    public boolean mayDecrement(TileAltar ta, AttunementRecipe.AttunementAltarSlot slot) {
                        return !fluidStacks.contains(slot.getSlotId());
                    }
                };
                for (AttunementRecipe.AttunementAltarSlot al : AttunementRecipe.AttunementAltarSlot.values()) {
                    if (inputs[al.getSlotId()] == null) continue;
                    rec.setAttItem(inputs[al.getSlotId()], al);
                }
                return rec;
            }
            case CONSTELLATION_CRAFT: {
                ConstellationRecipe cRec = new ConstellationRecipe(this.buildNativeRecipe(inputs, out)){

                    @Override
                    public int getPassiveStarlightRequired() {
                        return sConsumption;
                    }

                    @Override
                    public int craftingTickTime() {
                        return craftingTickTime;
                    }

                    @Override
                    public boolean mayDecrement(TileAltar ta, ShapedRecipeSlot slot) {
                        return !fluidStacks.contains(slot.getSlotID());
                    }

                    @Override
                    public boolean mayDecrement(TileAltar ta, AttunementRecipe.AttunementAltarSlot slot) {
                        return !fluidStacks.contains(slot.getSlotId());
                    }

                    @Override
                    public boolean mayDecrement(TileAltar ta, ConstellationRecipe.ConstellationAtlarSlot slot) {
                        return !fluidStacks.contains(slot.getSlotId());
                    }
                };
                for (AttunementRecipe.AttunementAltarSlot attunementAltarSlot : AttunementRecipe.AttunementAltarSlot.values()) {
                    if (inputs[attunementAltarSlot.getSlotId()] == null) continue;
                    cRec.setAttItem(inputs[attunementAltarSlot.getSlotId()], attunementAltarSlot);
                }
                for (Enum enum_ : ConstellationRecipe.ConstellationAtlarSlot.values()) {
                    if (inputs[((ConstellationRecipe.ConstellationAtlarSlot)enum_).getSlotId()] == null) continue;
                    cRec.setCstItem(inputs[((ConstellationRecipe.ConstellationAtlarSlot)enum_).getSlotId()], new ConstellationRecipe.ConstellationAtlarSlot[]{enum_});
                }
                return cRec;
            }
            case TRAIT_CRAFT: {
                void var13_29;
                void var13_27;
                void var13_25;
                TraitRecipe rRec = new TraitRecipe(this.buildNativeRecipe(inputs, out)){

                    @Override
                    public int getPassiveStarlightRequired() {
                        return sConsumption;
                    }

                    @Override
                    public int craftingTickTime() {
                        return craftingTickTime;
                    }

                    @Override
                    public boolean mayDecrement(TileAltar ta, ShapedRecipeSlot slot) {
                        return !fluidStacks.contains(slot.getSlotID());
                    }

                    @Override
                    public boolean mayDecrement(TileAltar ta, AttunementRecipe.AttunementAltarSlot slot) {
                        return !fluidStacks.contains(slot.getSlotId());
                    }

                    @Override
                    public boolean mayDecrement(TileAltar ta, ConstellationRecipe.ConstellationAtlarSlot slot) {
                        return !fluidStacks.contains(slot.getSlotId());
                    }

                    @Override
                    public boolean mayDecrement(TileAltar ta, TraitRecipe.TraitRecipeSlot slot) {
                        return !fluidStacks.contains(slot.getSlotId());
                    }
                };
                Enum[] enumArray = AttunementRecipe.AttunementAltarSlot.values();
                int n = enumArray.length;
                boolean bl = false;
                while (var13_25 < n) {
                    AttunementRecipe.AttunementAltarSlot attunementAltarSlot = enumArray[var13_25];
                    if (inputs[attunementAltarSlot.getSlotId()] != null) {
                        rRec.setAttItem(inputs[attunementAltarSlot.getSlotId()], attunementAltarSlot);
                    }
                    ++var13_25;
                }
                enumArray = ConstellationRecipe.ConstellationAtlarSlot.values();
                n = enumArray.length;
                boolean bl2 = false;
                while (var13_27 < n) {
                    Enum enum_ = enumArray[var13_27];
                    if (inputs[((ConstellationRecipe.ConstellationAtlarSlot)enum_).getSlotId()] != null) {
                        rRec.setCstItem(inputs[((ConstellationRecipe.ConstellationAtlarSlot)enum_).getSlotId()], new ConstellationRecipe.ConstellationAtlarSlot[]{enum_});
                    }
                    ++var13_27;
                }
                enumArray = TraitRecipe.TraitRecipeSlot.values();
                n = enumArray.length;
                boolean bl3 = false;
                while (var13_29 < n) {
                    Enum enum_ = enumArray[var13_29];
                    if (inputs[((TraitRecipe.TraitRecipeSlot)enum_).getSlotId()] != null) {
                        rRec.setInnerTraitItem(inputs[((TraitRecipe.TraitRecipeSlot)enum_).getSlotId()], new TraitRecipe.TraitRecipeSlot[]{enum_});
                    }
                    ++var13_29;
                }
                for (int i = 25; i < inputs.length; ++i) {
                    if (inputs[i] == null) continue;
                    rRec.addOuterTraitItem(inputs[i]);
                }
                return rRec;
            }
        }
        return null;
    }

    private AccessibleRecipeAdapater buildNativeRecipe(ItemHandle[] inputs, ItemStack out) {
        ShapedRecipe.Builder builder = ShapedRecipe.Builder.newShapedRecipe(this.name, out);
        for (int i = 0; i < 9; ++i) {
            ItemHandle itemHandle = inputs[i];
            if (itemHandle == null) continue;
            ShapedRecipeSlot srs = ShapedRecipeSlot.values()[i];
            builder.addPart(inputs[i], srs);
        }
        return builder.unregisteredAccessibleShapedRecipe();
    }
}

