/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.api.claim;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import dev.itsmeow.claimit.api.ClaimItAPI;
import dev.itsmeow.claimit.api.claim.ClaimManager;
import dev.itsmeow.claimit.api.claim.SubClaimArea;
import dev.itsmeow.claimit.api.config.ClaimItAPIConfig;
import dev.itsmeow.claimit.api.event.claim.ClaimCheckPermissionEvent;
import dev.itsmeow.claimit.api.group.Group;
import dev.itsmeow.claimit.api.group.GroupManager;
import dev.itsmeow.claimit.api.permission.ClaimPermissionMember;
import dev.itsmeow.claimit.api.permission.ClaimPermissionRegistry;
import dev.itsmeow.claimit.api.permission.ClaimPermissionToggle;
import dev.itsmeow.claimit.api.permission.ClaimPermissions;
import dev.itsmeow.claimit.api.util.nbt.ClaimNBTUtil;
import dev.itsmeow.claimit.api.util.objects.ClaimChunkUtil;
import dev.itsmeow.claimit.api.util.objects.MemberContainer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.Level;

public class ClaimArea
extends MemberContainer {
    protected int posX;
    protected int posZ;
    private final int dimID;
    protected int sideLengthX;
    protected int sideLengthZ;
    protected String viewName;
    protected Map<ClaimPermissionToggle, Boolean> toggles;
    private Set<SubClaimArea> subclaims;

    public ClaimArea(int dimID, int posX, int posZ, int sideLengthX, int sideLengthZ, EntityPlayer player) {
        this(dimID, posX, posZ, sideLengthX, sideLengthZ, player.func_146103_bH().getId());
    }

    public ClaimArea(int dimID, int posX, int posZ, int sideLengthX, int sideLengthZ, UUID ownerUUID) {
        super(ownerUUID);
        this.dimID = dimID;
        this.posX = posX;
        this.posZ = posZ;
        this.sideLengthX = sideLengthX;
        this.sideLengthZ = sideLengthZ;
        this.ownerUUID = ownerUUID;
        this.toggles = new HashMap<ClaimPermissionToggle, Boolean>();
        this.subclaims = new HashSet<SubClaimArea>();
        for (ClaimPermissionToggle perm : ClaimPermissionRegistry.getTogglePermissions()) {
            this.toggles.putIfAbsent(perm, perm.getDefault());
        }
        if (this.sideLengthX < 0 || this.sideLengthZ < 0) {
            if (this.sideLengthX < 0) {
                this.posX += this.sideLengthX;
                this.sideLengthX = Math.abs(this.sideLengthX);
            }
            if (this.sideLengthZ < 0) {
                this.posZ += this.sideLengthZ;
                this.sideLengthZ = Math.abs(this.sideLengthZ);
            }
        }
        this.viewName = ownerUUID.toString() + "_" + Math.abs(posX) + Math.abs(posZ) + dimID + Math.round(Math.random() * 100.0);
    }

    public ClaimArea(int dimID, int posX, int posZ, int sideLengthX, int sideLengthZ, UUID ownerUUID, String trueViewName) {
        this(dimID, posX, posZ, sideLengthX, sideLengthZ, ownerUUID);
        this.viewName = trueViewName;
    }

    public ClaimManager.ClaimAddResult addSubClaim(SubClaimArea subclaim) {
        if (this.subclaims.contains(subclaim)) {
            return ClaimManager.ClaimAddResult.ALREADY_EXISTS;
        }
        if (subclaim.getArea() == this.getArea()) {
            return ClaimManager.ClaimAddResult.TOO_LARGE;
        }
        if (subclaim.parent != this) {
            throw new RuntimeException("Invalid parent for subclaim");
        }
        for (BlockPos corner : subclaim.getFourCorners()) {
            if (this.isBlockPosInClaim(corner)) continue;
            return ClaimManager.ClaimAddResult.OUT_OF_BOUNDS;
        }
        for (SubClaimArea subclaimI : this.subclaims) {
            BlockPos toCheck;
            int i;
            for (i = 0; i <= subclaim.getSideLengthX(); ++i) {
                for (int j = 0; j <= subclaim.getSideLengthZ(); ++j) {
                    toCheck = new BlockPos(subclaim.getMainPosition().func_177958_n() + i, 0, subclaim.getMainPosition().func_177952_p() + j);
                    if (!subclaimI.isBlockPosInClaim(toCheck)) continue;
                    return ClaimManager.ClaimAddResult.OVERLAP;
                }
            }
            for (i = 0; i <= subclaimI.getSideLengthX(); ++i) {
                for (int j = 0; j <= subclaimI.getSideLengthZ(); ++j) {
                    toCheck = new BlockPos(subclaimI.getMainPosition().func_177958_n() + i, 0, subclaimI.getMainPosition().func_177952_p() + j);
                    if (!subclaim.isBlockPosInClaim(toCheck)) continue;
                    return ClaimManager.ClaimAddResult.OVERLAP;
                }
            }
        }
        this.subclaims.add(subclaim);
        return ClaimManager.ClaimAddResult.ADDED;
    }

    public boolean removeSubClaim(SubClaimArea subclaim) {
        return this.subclaims.remove(subclaim);
    }

    @Nonnull
    public ClaimArea getMostSpecificClaim(BlockPos pos) {
        for (SubClaimArea subclaim : this.subclaims) {
            if (!subclaim.isBlockPosInClaim(pos)) continue;
            return subclaim;
        }
        return this;
    }

    @Nullable
    public SubClaimArea getSubClaimAtLocation(BlockPos pos) {
        for (SubClaimArea subclaim : this.subclaims) {
            if (!subclaim.isBlockPosInClaim(pos)) continue;
            return subclaim;
        }
        return null;
    }

    @Nullable
    public SubClaimArea getSubClaimWithName(String viewName) {
        for (SubClaimArea subclaim : this.subclaims) {
            if (!subclaim.getDisplayedViewName().equals(viewName)) continue;
            return subclaim;
        }
        return null;
    }

    public ImmutableSet<SubClaimArea> getSubClaims() {
        return ImmutableSet.copyOf(this.subclaims);
    }

    @Override
    public boolean isOwner(UUID owner) {
        return this.getOwner().equals(owner);
    }

    public boolean canModify(EntityPlayer player) {
        return this.hasPermission(player, ClaimPermissions.MODIFY);
    }

    public boolean canUse(EntityPlayer player) {
        return this.hasPermission(player, ClaimPermissions.USE);
    }

    public boolean canEntity(EntityPlayer player) {
        return this.hasPermission(player, ClaimPermissions.ENTITY);
    }

    public boolean canPVP(EntityPlayer player) {
        return this.hasPermission(player, ClaimPermissions.PVP);
    }

    public boolean canManage(EntityPlayer player) {
        return this.hasPermission(player, ClaimPermissions.MANAGE_PERMS);
    }

    @Override
    public boolean hasPermission(EntityPlayer player, ClaimPermissionMember permission) {
        if (player instanceof FakePlayer && this.isPermissionToggled(ClaimPermissions.ALLOW_FAKE_PLAYER_BYPASS)) {
            return true;
        }
        return this.hasPermission(player.func_146103_bH().getId(), permission);
    }

    @Override
    public boolean hasPermission(UUID uuid, ClaimPermissionMember permission) {
        ClaimCheckPermissionEvent event = new ClaimCheckPermissionEvent(this, uuid, permission);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.ALLOW) {
            return true;
        }
        if (event.getResult() == Event.Result.DENY) {
            return false;
        }
        return this.isOwner(uuid) || this.isMemberPermissionToggled(permission) || this.memberLists.getValues(permission).contains(uuid) || this.hasPermissionFromGroup(permission, uuid);
    }

    protected boolean hasPermissionFromGroup(ClaimPermissionMember permission, UUID uuid) {
        for (Group group : GroupManager.getGroups()) {
            if (permission == ClaimPermissions.MANAGE_PERMS || !group.hasPermissionInClaim(uuid, permission, this)) continue;
            return true;
        }
        return false;
    }

    private boolean isMemberPermissionToggled(ClaimPermissionMember permission) {
        ClaimPermissionToggle toggle = ClaimPermissionRegistry.getToggleFor(permission);
        return toggle != null && this.isPermissionToggled(toggle);
    }

    public boolean isPermissionToggled(ClaimPermissionToggle perm) {
        if (perm.getForceEnabled()) {
            return perm.getForceValue();
        }
        if (!this.toggles.containsKey(perm)) {
            return perm.getDefault();
        }
        return this.toggles.get(perm);
    }

    public void flipPermissionToggle(ClaimPermissionToggle perm) {
        this.toggles.put(perm, this.toggles.get(perm) == false);
    }

    public void setPermissionToggle(ClaimPermissionToggle perm, boolean value) {
        this.toggles.put(perm, value);
    }

    public ImmutableMap<ClaimPermissionToggle, Boolean> getToggles() {
        return ImmutableMap.copyOf(this.toggles);
    }

    @Override
    public boolean inPermissionList(ClaimPermissionMember permission, UUID id) {
        Set members = this.memberLists.getValues(permission);
        return members != null && members.contains(id);
    }

    protected void setToggles(Map<ClaimPermissionToggle, Boolean> toggles) {
        toggles.forEach((p, b) -> this.toggles.put((ClaimPermissionToggle)p, (Boolean)b));
    }

    public boolean isBlockPosInClaim(BlockPos blockPos) {
        boolean isInXRange = blockPos.func_177958_n() < this.getHXZPosition().func_177958_n() + 1 && blockPos.func_177958_n() > this.posX - 1;
        boolean isInZRange = blockPos.func_177952_p() < this.getHXZPosition().func_177952_p() + 1 && blockPos.func_177952_p() > this.posZ - 1;
        return isInXRange && isInZRange;
    }

    public BlockPos getMainPosition() {
        return new BlockPos(this.posX, 0, this.posZ);
    }

    public BlockPos getHXZPosition() {
        return new BlockPos(this.posX + this.sideLengthX, 0, this.posZ + this.sideLengthZ);
    }

    public BlockPos getHXLZPosition() {
        return new BlockPos(this.posX + this.sideLengthX, 0, this.posZ);
    }

    public BlockPos getLXHZPosition() {
        return new BlockPos(this.posX, 0, this.posZ + this.sideLengthZ);
    }

    public BlockPos[] getTwoMainClaimCorners() {
        BlockPos[] corners = new BlockPos[]{this.getMainPosition(), this.getHXZPosition()};
        return corners;
    }

    public BlockPos[] getFourCorners() {
        BlockPos[] corners = new BlockPos[]{this.getMainPosition(), this.getHXLZPosition(), this.getLXHZPosition(), this.getHXZPosition()};
        return corners;
    }

    public int getSideLengthX() {
        return this.sideLengthX;
    }

    public int getSideLengthZ() {
        return this.sideLengthZ;
    }

    public int getDimensionID() {
        return this.dimID;
    }

    public World getWorld() {
        return DimensionManager.getWorld((int)this.dimID);
    }

    public int getArea() {
        return (this.sideLengthX + 1) * (this.sideLengthZ + 1);
    }

    public int[] getSelfAsInt() {
        int[] s = new int[]{0, this.dimID, this.posX, this.posZ, this.sideLengthX, this.sideLengthZ};
        return s;
    }

    public String getTrueViewName() {
        return this.viewName;
    }

    public String getDisplayedViewName() {
        if (!this.viewName.contains("_")) {
            this.viewName = this.ownerUUID.toString() + "_" + Math.abs(this.posX) + Math.abs(this.posZ) + this.dimID + Math.round(Math.random() * 100.0);
        }
        return this.viewName.substring(this.viewName.indexOf(95) + 1);
    }

    public boolean setViewName(String nameIn) {
        boolean pass = true;
        for (ClaimArea claim : ClaimManager.getManager().getClaimsOwnedByPlayer(this.getOwner())) {
            if (!claim.getTrueViewName().equals(this.ownerUUID + "_" + nameIn) || claim == this) continue;
            pass = false;
        }
        if (pass) {
            this.viewName = this.ownerUUID + "_" + nameIn;
        }
        return pass;
    }

    public Set<ClaimChunkUtil.ClaimChunk> getOverlappingChunks() {
        HashSet<ClaimChunkUtil.ClaimChunk> chunks = new HashSet<ClaimChunkUtil.ClaimChunk>();
        ClaimChunkUtil.ClaimChunk hChunk = ClaimChunkUtil.getChunk(this.getHXZPosition());
        ClaimChunkUtil.ClaimChunk lChunk = ClaimChunkUtil.getChunk(this.getMainPosition());
        for (int x = lChunk.x; x <= hChunk.x; ++x) {
            for (int z = lChunk.z; z <= hChunk.z; ++z) {
                chunks.add(new ClaimChunkUtil.ClaimChunk(x, z));
            }
        }
        return chunks;
    }

    public NBTTagCompound serialize() {
        int[] claimVals = this.getSelfAsInt();
        UUID owner = this.getOwner();
        NBTTagCompound data = new NBTTagCompound();
        data.func_74783_a("CLAIMINFO", claimVals);
        data.func_74778_a("OWNERUID", owner.toString());
        data.func_74778_a("TRUEVIEWNAME", this.getTrueViewName());
        data = super.writeMembers(data);
        data = ClaimNBTUtil.writeToggles(data, this.getToggles());
        if (ClaimItAPIConfig.enable_subclaims) {
            data = this.serializeSubClaims(data);
        }
        return data;
    }

    public static ClaimArea deserialize(NBTTagCompound tag, String keyName) {
        int[] claimVals = tag.func_74759_k("CLAIMINFO");
        UUID owner = UUID.fromString(tag.func_74779_i("OWNERUID"));
        String trueViewName = tag.func_74779_i("TRUEVIEWNAME");
        if (trueViewName == null || trueViewName.equals("")) {
            trueViewName = keyName;
        }
        if (claimVals.length > 0 && claimVals[0] == 0) {
            ClaimItAPI.logger.debug("Valid version.");
            ClaimArea claim = new ClaimArea(claimVals[1], claimVals[2], claimVals[3], claimVals[4], claimVals[5], owner, trueViewName);
            claim.addMembers(MemberContainer.readMembers(tag));
            claim.setToggles(ClaimNBTUtil.readToggles(tag));
            if (tag.func_74764_b("SUBCLAIMS") && ClaimItAPIConfig.enable_subclaims) {
                tag.func_150295_c("SUBCLAIMS", 10).forEach(base -> claim.addSubClaim(SubClaimArea.deserialize(claim, (NBTTagCompound)base)));
            }
            return claim;
        }
        ClaimItAPI.logger.log(Level.FATAL, "Detected version that doesn't exist yet! Mod was downgraded? Claim cannot be loaded.");
        throw new RuntimeException("Canceled loading to prevent loss of claim data. If you recently downgraded versions, please upgrade or contact author.");
    }

    protected NBTTagCompound serializeSubClaims(NBTTagCompound data) {
        NBTTagList subclaimData = new NBTTagList();
        for (SubClaimArea subclaim : this.subclaims) {
            subclaimData.func_74742_a((NBTBase)subclaim.serialize());
        }
        data.func_74782_a("SUBCLAIMS", (NBTBase)subclaimData);
        return data;
    }

    public int hashCode() {
        return Objects.hash(this.dimID, this.posX, this.posZ, this.ownerUUID, this.sideLengthX, this.sideLengthZ);
    }
}

