/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.api.group;

import com.google.common.collect.ImmutableSet;
import dev.itsmeow.claimit.api.ClaimItAPI;
import dev.itsmeow.claimit.api.claim.ClaimArea;
import dev.itsmeow.claimit.api.event.group.GroupClaimAddedEvent;
import dev.itsmeow.claimit.api.event.group.GroupClaimRemovedEvent;
import dev.itsmeow.claimit.api.group.Group;
import dev.itsmeow.claimit.api.serialization.GlobalDataSerializer;
import dev.itsmeow.claimit.api.util.objects.BiMultiMap;
import dev.itsmeow.claimit.util.text.ColorUtil;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GroupManager {
    private static HashMap<String, Group> groups = new HashMap();
    private static BiMultiMap<ClaimArea, Group> claimToGroup = new BiMultiMap();

    public static boolean addGroup(Group group) {
        if (groups.containsKey(group.getName())) {
            return false;
        }
        groups.put(group.getName(), group);
        return true;
    }

    public static void removeGroup(Group group) {
        group.removeAllClaims();
        group.removeAllMembers();
        groups.remove(group.getName());
    }

    @Nullable
    public static Group getGroup(String name) {
        return groups.get(name);
    }

    @Nullable
    public static ImmutableSet<Group> getGroupsForClaim(ClaimArea claim) {
        return ImmutableSet.copyOf(claimToGroup.getValues(claim));
    }

    public static boolean renameGroup(String name, String newName) {
        if (!groups.containsKey(name) || groups.containsKey(newName)) {
            return false;
        }
        Group group = groups.get(name);
        groups.remove(name);
        groups.put(newName, group);
        group.name = newName;
        return true;
    }

    public static boolean setGroupTag(Group group, String tag) {
        String cleanTag = ColorUtil.removeColorCodes((String)tag);
        boolean pass = true;
        for (Group group1 : groups.values()) {
            if (group1 == group || group1.getTag() == null || !ColorUtil.removeColorCodes((String)group1.getTag()).equalsIgnoreCase(cleanTag)) continue;
            pass = false;
        }
        if (pass) {
            group.setTag(tag);
        }
        return pass;
    }

    public static ImmutableSet<Group> getGroups() {
        return ImmutableSet.copyOf(groups.values());
    }

    public static void serialize() {
        GlobalDataSerializer store = GlobalDataSerializer.get();
        NBTTagCompound comp = store.data;
        NBTTagCompound groupsTag = new NBTTagCompound();
        for (String groupName : groups.keySet()) {
            NBTTagCompound groupCompound = groups.get(groupName).serialize();
            groupsTag.func_74782_a(groupName, (NBTBase)groupCompound);
            ClaimItAPI.logger.debug("Serializing group " + groupName);
        }
        comp.func_74782_a("GROUPS", (NBTBase)groupsTag);
        store.func_76185_a();
    }

    public static void deserialize() {
        groups.clear();
        GlobalDataSerializer store = GlobalDataSerializer.get();
        NBTTagCompound comp = store.data;
        if (comp != null) {
            NBTTagCompound groupsTag = comp.func_74775_l("GROUPS");
            for (String key : groupsTag.func_150296_c()) {
                ClaimItAPI.logger.debug("Loading group " + key);
                Group group = Group.deserialize(groupsTag.func_74775_l(key));
                if (GroupManager.addGroup(group)) continue;
                ClaimItAPI.logger.error("Duplicate group name of " + group.name + " failed to load! Was the data edited?");
            }
        } else {
            ClaimItAPI.logger.warn("Could not get group data tag.");
        }
    }

    @Mod.EventBusSubscriber(modid="claimitapi")
    private static class InternalGroupEventHandler {
        private InternalGroupEventHandler() {
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void onGroupClaimAdded(GroupClaimAddedEvent e) {
            claimToGroup.put(e.getClaim(), e.getGroup());
        }

        @SubscribeEvent(priority=EventPriority.LOW)
        public static void onGroupClaimRemoved(GroupClaimRemovedEvent e) {
            claimToGroup.remove(e.getClaim(), e.getGroup());
        }
    }
}

