/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.api.permission;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import dev.itsmeow.claimit.api.permission.ClaimPermissionMember;
import dev.itsmeow.claimit.api.permission.ClaimPermissionToggle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ClaimPermissionRegistry {
    private static BiMap<String, ClaimPermissionMember> memberPermissions = HashBiMap.create();
    private static BiMap<String, ClaimPermissionToggle> togglePermissions = HashBiMap.create();
    private static Map<ClaimPermissionMember, ClaimPermissionToggle> memberToggleMap = new HashMap<ClaimPermissionMember, ClaimPermissionToggle>();

    public static void addPermission(ClaimPermissionMember permission) {
        if (memberPermissions.containsKey((Object)permission.parsedName)) {
            throw new RuntimeException("Identical member permission ID registered: " + permission.parsedName);
        }
        if (memberPermissions.containsValue((Object)permission)) {
            throw new RuntimeException("Indentical member permissions registered under IDs: " + (String)memberPermissions.inverse().get((Object)permission) + " and " + permission.parsedName);
        }
        memberPermissions.put((Object)permission.parsedName, (Object)permission);
    }

    public static void addPermission(ClaimPermissionToggle permission) {
        if (togglePermissions.containsKey((Object)permission.parsedName)) {
            throw new RuntimeException("Identical toggle permission ID registered: " + permission.parsedName);
        }
        if (togglePermissions.containsValue((Object)permission)) {
            throw new RuntimeException("Indentical toggle permissions registered under IDs: " + (String)togglePermissions.inverse().get((Object)permission) + " and " + permission.parsedName);
        }
        togglePermissions.put((Object)permission.parsedName, (Object)permission);
    }

    public static void addPermission(ClaimPermissionToggle ... permissions) {
        for (ClaimPermissionToggle permission : permissions) {
            ClaimPermissionRegistry.addPermission(permission);
        }
    }

    public static void addPermission(ClaimPermissionMember ... permissions) {
        for (ClaimPermissionMember permission : permissions) {
            ClaimPermissionRegistry.addPermission(permission);
        }
    }

    public static void addPermission(ClaimPermissionMember permission, ClaimPermissionToggle toggle) {
        ClaimPermissionRegistry.addPermission(permission);
        ClaimPermissionRegistry.addPermission(toggle);
        memberToggleMap.put(permission, toggle);
    }

    public static final ImmutableSet<ClaimPermissionMember> getMemberPermissions() {
        return ImmutableSet.copyOf((Collection)memberPermissions.values());
    }

    public static final ImmutableSet<ClaimPermissionToggle> getTogglePermissions() {
        return ImmutableSet.copyOf((Collection)togglePermissions.values());
    }

    @Nullable
    public static final ClaimPermissionMember getPermissionMember(String name) {
        return (ClaimPermissionMember)memberPermissions.get((Object)name);
    }

    @Nullable
    public static final ClaimPermissionToggle getPermissionToggle(String name) {
        return (ClaimPermissionToggle)togglePermissions.get((Object)name);
    }

    @Nullable
    public static final ClaimPermissionToggle getToggleFor(ClaimPermissionMember permission) {
        return memberToggleMap.get(permission);
    }

    public static String getValidPermissionListMember() {
        String validPerms = "";
        for (ClaimPermissionMember perm : ClaimPermissionRegistry.getMemberPermissions()) {
            validPerms = validPerms + perm.parsedName + " ";
        }
        return validPerms;
    }

    public static String getValidPermissionListToggle() {
        String validPerms = "";
        for (ClaimPermissionToggle perm : ClaimPermissionRegistry.getTogglePermissions()) {
            validPerms = validPerms + perm.parsedName + " ";
        }
        return validPerms;
    }
}

