/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.api.userconfig;

import dev.itsmeow.claimit.api.serialization.GlobalDataSerializer;
import dev.itsmeow.claimit.api.userconfig.UserConfigType;
import dev.itsmeow.claimit.api.userconfig.UserConfigTypeRegistry;
import dev.itsmeow.claimit.api.userconfig.UserConfigValueStorage;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class UserConfigManager {
    @Nullable
    public static <T1, T extends UserConfigType<T1>> UserConfigValueStorage<T1> getStorage(Class<T> type) {
        return ((UserConfigType)UserConfigTypeRegistry.getRegistry(type)).storage;
    }

    public static void serialize() {
        NBTTagCompound data = GlobalDataSerializer.get().data;
        NBTTagCompound configsData = new NBTTagCompound();
        for (Class clazz : UserConfigTypeRegistry.getRegistries().keySet()) {
            UserConfigType type = (UserConfigType)UserConfigTypeRegistry.getRegistries().get((Object)clazz);
            for (UserConfigType.UserConfig config : type.getConfigs().values()) {
                try {
                    type.storage.storage.values.get((Object)config).uuids.forEach((uuid, value) -> {
                        if (!configsData.func_74764_b(uuid.toString())) {
                            configsData.func_74782_a(uuid.toString(), (NBTBase)new NBTTagCompound());
                        }
                        NBTTagCompound userTag = configsData.func_74775_l(uuid.toString());
                        type.getSerializer().serialize(userTag, config.parsedName, type.type.cast(value));
                        configsData.func_74782_a(uuid.toString(), (NBTBase)userTag);
                    });
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        data.func_74782_a("USERCONFIG", (NBTBase)configsData);
        GlobalDataSerializer wsd = GlobalDataSerializer.get();
        wsd.func_76185_a();
    }

    public static void deserialize() {
        NBTTagCompound data = GlobalDataSerializer.get().data;
        NBTTagCompound configsData = data.func_74775_l("USERCONFIG");
        for (String uuidStr : configsData.func_150296_c()) {
            if (!configsData.func_150297_b(uuidStr, 10)) continue;
            NBTTagCompound userTag = configsData.func_74775_l(uuidStr);
            UUID uuid = UUID.fromString(uuidStr);
            for (String parseName : userTag.func_150296_c()) {
                for (Class clazz : UserConfigTypeRegistry.getRegistries().keySet()) {
                    UserConfigType type = (UserConfigType)UserConfigTypeRegistry.getRegistries().get((Object)clazz);
                    UserConfigType.UserConfig config = type.getConfig(parseName);
                    if (config == null) continue;
                    Object val = type.getDeserializer().deserialize(userTag, config.parsedName);
                    type.setValue(config, uuid, val);
                }
            }
        }
    }
}

