/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.claimit.api.util.objects;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import dev.itsmeow.claimit.api.permission.ClaimPermissionMember;
import dev.itsmeow.claimit.api.permission.ClaimPermissionRegistry;
import dev.itsmeow.claimit.api.util.objects.BiMultiMap;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public abstract class MemberContainer {
    protected BiMultiMap<ClaimPermissionMember, UUID> memberLists;
    protected UUID ownerUUID;

    public MemberContainer(UUID owner) {
        this.ownerUUID = owner;
        this.memberLists = new BiMultiMap();
    }

    public boolean addMember(UUID uuid, ClaimPermissionMember permission) {
        if (uuid.equals(this.ownerUUID)) {
            return false;
        }
        return this.memberLists.put(permission, uuid);
    }

    public boolean addMember(EntityPlayer player, ClaimPermissionMember permission) {
        return this.addMember(player.func_146103_bH().getId(), permission);
    }

    public boolean removeMember(UUID uuid, ClaimPermissionMember permission) {
        if (uuid.equals(this.ownerUUID)) {
            return false;
        }
        return this.memberLists.remove(permission, uuid);
    }

    public boolean removeMember(EntityPlayer player, ClaimPermissionMember permission) {
        return this.removeMember(player.func_146103_bH().getId(), permission);
    }

    public abstract boolean hasPermission(UUID var1, ClaimPermissionMember var2);

    public boolean hasPermission(EntityPlayer player, ClaimPermissionMember permission) {
        return this.hasPermission(player.func_146103_bH().getId(), permission);
    }

    public boolean isOwner(EntityPlayer player) {
        return this.isOwner(player.func_146103_bH().getId());
    }

    public boolean isOwner(UUID uuid) {
        return this.ownerUUID.equals(uuid);
    }

    public UUID getOwner() {
        return this.ownerUUID;
    }

    protected void addMembers(SetMultimap<ClaimPermissionMember, UUID> memberLists) {
        for (ClaimPermissionMember key : memberLists.keySet()) {
            this.memberLists.putAll(key, memberLists.get((Object)key));
        }
    }

    public boolean inPermissionList(ClaimPermissionMember permission, UUID id) {
        Set<UUID> members = this.memberLists.getValues(permission);
        return members != null && members.contains(id);
    }

    public ImmutableSetMultimap<UUID, ClaimPermissionMember> getMembers() {
        return this.memberLists.getValuesToKeys();
    }

    public static SetMultimap<ClaimPermissionMember, UUID> readMembers(NBTTagCompound tag) {
        SetMultimap map = MultimapBuilder.hashKeys().hashSetValues().build();
        NBTTagCompound memberCompound = tag.func_74775_l("MEMBERS");
        for (String permString : memberCompound.func_150296_c()) {
            if (ClaimPermissionRegistry.getPermissionMember(permString) == null) continue;
            NBTTagList tagList = memberCompound.func_150295_c(permString, 8);
            ClaimPermissionMember perm = ClaimPermissionRegistry.getPermissionMember(permString);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                String uuidString = tagList.func_150307_f(i);
                UUID member = UUID.fromString(uuidString);
                map.put((Object)perm, (Object)member);
            }
        }
        return map;
    }

    public NBTTagCompound writeMembers(NBTTagCompound tag) {
        NBTTagCompound memberCompound = new NBTTagCompound();
        for (ClaimPermissionMember perm : this.memberLists.getKeysToValues().keySet()) {
            NBTTagList members = new NBTTagList();
            for (UUID member : this.memberLists.getKeysToValues().get((Object)perm)) {
                members.func_74742_a((NBTBase)new NBTTagString(member.toString()));
            }
            memberCompound.func_74782_a(perm.parsedName, (NBTBase)members);
        }
        tag.func_74782_a("MEMBERS", (NBTBase)memberCompound);
        return tag;
    }
}

