/*
 * Decompiled with CFR 0.152.
 */
package pl.pabilo8.immersiveintelligence.common.asm;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class IIClassTransformer
implements IClassTransformer {
    private static final Map<String, MethodTransformer[]> transformerMap = Maps.newHashMap();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass != null && transformerMap.containsKey(transformedName)) {
            MethodTransformer[] transformers = transformerMap.get(transformedName);
            ClassReader reader = new ClassReader(basicClass);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            for (MethodNode method : node.methods) {
                for (MethodTransformer methodTransformer : transformers) {
                    if (!methodTransformer.functionName.equals(method.name) && !methodTransformer.srgName.equals(method.name) || !methodTransformer.functionDesc.equals(method.desc)) continue;
                    methodTransformer.function.accept(method);
                }
            }
            ClassWriter writer = new ClassWriter(3);
            node.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    static {
        transformerMap.put("net.minecraft.client.model.ModelBiped", new MethodTransformer[]{new MethodTransformer("setRotationAngles", "func_78087_a", "(FFFFFFLnet/minecraft/entity/Entity;)V", methodNode -> {
            for (AbstractInsnNode anode : methodNode.instructions) {
                if (anode.getOpcode() != 177) continue;
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 7));
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, "pl/pabilo8/immersiveintelligence/client/ClientEventHandler", "handleBipedRotations", "(Lnet/minecraft/client/model/ModelBiped;Lnet/minecraft/entity/Entity;)V", false));
                methodNode.instructions.insertBefore(anode, newInstructions);
            }
        })});
    }

    private static class MethodTransformer {
        final String functionName;
        final String srgName;
        final String functionDesc;
        final Consumer<MethodNode> function;

        private MethodTransformer(String funcName, String srgName, String funcDesc, Consumer<MethodNode> function) {
            this.functionName = funcName;
            this.srgName = srgName;
            this.functionDesc = funcDesc;
            this.function = function;
        }
    }
}

