/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices;

import com.windanesz.arcaneapprentices.ArcaneApprentices;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@Config(modid="arcaneapprentices", name="arcaneapprentices")
public class Settings {
    public List<String> WIZARD_NAME_LIST;
    @Config.Name(value="General Settings")
    @Config.LangKey(value="settings.arcaneapprentices:general_settings")
    public static GeneralSettings generalSettings = new GeneralSettings();
    @Config.Name(value="Journey Settings")
    @Config.LangKey(value="settings.arcaneapprentices:journey_settings")
    public static JourneySettings journeySettings = new JourneySettings();

    public Settings() {
        this.WIZARD_NAME_LIST = Arrays.asList(Settings.generalSettings.WIZARD_NAMES);
    }

    public static boolean isArtefactEnabledForNPC(Item item) {
        return Arrays.stream(Settings.generalSettings.ARTEFACTS_USABLE_BY_NPCS).anyMatch(s -> s.equals(item.getRegistryName().toString()));
    }

    public static ItemStack getItemFromString(String string, World world) {
        String[] parts = string.split(":");
        if (parts.length >= 3) {
            String modId = parts[0];
            String itemName = parts[1];
            int metadata = Integer.parseInt(parts[2]);
            ResourceLocation itemLocation = new ResourceLocation(modId, itemName);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
            if (item != null) {
                ItemStack itemStack = new ItemStack(item, 1, metadata);
                if (parts.length >= 4) {
                    int countMin = Integer.parseInt(parts[3]);
                    itemStack.func_190920_e(countMin);
                    if (parts.length >= 5) {
                        int count = countMin;
                        int countMax = Integer.parseInt(parts[4]);
                        if (countMax > countMin) {
                            count = countMin + ArcaneApprentices.rand.nextInt(countMax - countMin);
                        }
                        itemStack.func_190920_e(count);
                        if (string.contains(":nbt:") && parts.length >= 6) {
                            String nbtString = string.substring(string.indexOf(":nbt:") + 5);
                            try {
                                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)nbtString);
                                itemStack.func_77982_d(nbt);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return ItemStack.field_190927_a;
                            }
                        }
                    }
                }
                return itemStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public static class GeneralSettings {
        @Config.Name(value="Apprentice Talents")
        @Config.Comment(value={"Enables or disables apprentice talents"})
        public String[] APPRENTICE_TALENTS = new String[]{"researcher:true", "conduit:true", "empowering_resonance:true", "spell_tinkerer:true", "phaser:true", "survivor:true", "apparel_expert:true", "swift_voyage:true", "healer:true", "alchemy_adept:true", "animal_whisperer:true", "treasure_hunter:true", "remnant_tamer:true", "artifice_master:true"};
        @Config.Name(value="PotionCore Compat Fix")
        @Config.Comment(value={"The PotionCore mod has a setting named 'Fix Effects When Changing Dimensions'. This is known to cause issues with modded entities, and if it is set to true, respawning apprentices will instantly die. When this 'PotionCore Compat Fix' setting is set to true, it will force the mentionedPotionCore config to be false."})
        public boolean POTIONCORE_COMPAT_FIX = true;
        @Config.Name(value="List of Possible Apprentice Names")
        @Config.Comment(value={"List of Possible Apprentice Names. Randomly chosen at first spawn of an NPC."})
        public String[] WIZARD_NAMES = new String[]{"Aidan", "Alaric", "Alarion", "Aldous", "Alistair", "Alphonse", "Amadeus", "Ambrose", "Anselm", "Apollo", "Archibald", "Argus", "Armand", "Asher", "Ashwood", "Astor", "Augustus", "Azriel", "Baldwin", "Balthazar", "Bardo", "Barnabas", "Bartholomew", "Basil", "Beaumont", "Beauregard", "Belvedere", "Benedict", "Bertrand", "Blaise", "Boulderheart", "Bramble", "Bramwell", "Brookstone", "Byron", "Calder", "Callahan", "Caradoc", "Casimir", "Caspian", "Cato", "Cedric", "Cillian", "Claudius", "Claymore", "Corristo", "Corwin", "Cronos", "Cyprian", "Cyril", "Dan", "Darius", "Demetrius", "Desmond", "Dimitri", "Donovan", "Dorian", "Draven", "Drystan", "Dustan", "Eamon", "Edgar", "Edmund", "Edwin", "Eldritch", "Electro", "Elek", "Elric", "Ember", "Emeric", "Emilio", "Emrys", "Enzo", "Ephraim", "Esmond", "Everard", "Ezekiel", "Fabian", "Faelan", "Ferdinand", "Finley", "Finnian", "Flint", "Florian", "Frost", "Fulgor", "Gabriel", "Gaian", "Gaius", "Galadriel", "Galen", "Gareth", "Garrick", "Gaspard", "Geoffrey", "Gideon", "Gilbert", "Giles", "Glacieron", "Godfrey", "Gregory", "Griffin", "Hadrian", "Hamish", "Harlan", "Hawthorn", "Hawthorne", "Hector", "Helios", "Hesperus", "Horace", "Horatio", "Icarius", "Ignatius", "Ikaros", "Indigo", "Isambard", "Isidore", "Jareth", "Jarvis", "Jasper", "Jericho", "Jovian", "Julius", "Kaelan", "Kai", "Kendrick", "Kieran", "Killian", "Lancelot", "Lazarus", "Leander", "Leopold", "Linus", "Lucian", "Lucius", "Luther", "Magnus", "Malachi", "Marcellus", "Marius", "Maurice", "Maximilian", "Meadowbrook", "Merlin", "Montgomery", "Morgan", "Mortimer", "Myxir", "Nathaniel", "Neville", "Nevin", "Nicodemus", "Oberon", "Octavius", "Octavos", "Odysseus", "Olaf", "Onyx", "Orin", "Orlando", "Orpheus", "Oswald", "Percival", "Philemon", "Phineas", "Prospero", "Ptolemy", "Quentin", "Quinlan", "Radcliffe", "Ragnar", "Rai", "Raiden", "Raphael", "Reginald", "Reuben", "Roderick", "Roland", "Roscoe", "Rowan", "Rufus", "Rupert", "Saturas", "Sebastian", "Silas", "Silvius", "Simeon", "Sinclair", "Solomon", "Solon", "Somerset", "Soren", "Sorin", "Sterling", "Stonebrook", "Sylvester", "Talus", "Tavian", "Terrin", "Thaddeus", "Theodoric", "Theon", "Theron", "Thistle", "Thistlewood", "Tiberius", "Titus", "Tobias", "Tristan", "Tristram", "Ulysses", "Uri", "Uriah", "Vajra", "Valentine", "Valerian", "Valerius", "Verdant", "Vesper", "Vincent", "Vincenzo", "Virgil", "Vulcan", "Waldemar", "Walden", "Waldo", "Warrick", "Wilbur", "Willard", "Winthrop", "Wolfgang", "Xander", "Xavier", "Yew", "Ymir", "Yorick", "Zachariah", "Zeno", "Zephyr", "Zephyrus", "Zigmund", "Zoltan"};
        @Config.RequiresMcRestart
        @Config.Name(value="List of Artefacts NPC Apprentices Can Use")
        @Config.Comment(value={"List of Artefacts NPC Apprentices Can Use. This list controls what artefacts can be used by NPCs.This list is more for disabling artefacts that have native support or dedicated support. New entries have a high chance of not working, but you can try."})
        public String[] ARTEFACTS_USABLE_BY_NPCS = new String[]{"ebwizardry:amulet_arcane_defence", "ebwizardry:amulet_banishing", "ebwizardry:amulet_channeling", "ebwizardry:amulet_fire_cloaking", "ebwizardry:amulet_fire_protection", "ebwizardry:amulet_frost_warding", "ebwizardry:amulet_ice_immunity", "ebwizardry:amulet_ice_protection", "ebwizardry:amulet_lich", "ebwizardry:amulet_potential", "ebwizardry:amulet_recovery", "ebwizardry:amulet_transience", "ebwizardry:amulet_warding", "ebwizardry:amulet_wisdom", "ebwizardry:amulet_wither_immunity", "ebwizardry:charm_experience_tome", "ebwizardry:charm_minion_health", "ebwizardry:charm_minion_variants", "ebwizardry:greater_telekinesis", "ebwizardry:ring_arcane_frost", "ebwizardry:ring_battlemage", "ebwizardry:ring_blockwrangler", "ebwizardry:ring_combustion", "ebwizardry:ring_condensing", "ebwizardry:ring_conjurer", "ebwizardry:ring_disintegration", "ebwizardry:ring_earth_biome", "ebwizardry:ring_earth_melee", "ebwizardry:ring_extraction", "ebwizardry:ring_fire_biome", "ebwizardry:ring_fire_melee", "ebwizardry:ring_full_moon", "ebwizardry:ring_ice_biome", "ebwizardry:ring_ice_melee", "ebwizardry:ring_leeching", "ebwizardry:ring_lightning_melee", "ebwizardry:ring_necromancy_melee", "ebwizardry:ring_paladin", "ebwizardry:ring_poison", "ebwizardry:ring_shattering", "ebwizardry:ring_soulbinding", "ebwizardry:ring_storm", "ebwizardry:charm_withering_atlas", "ebwizardry:charm_golden_lure", "ebwizardry:ring_siphoning", "ebwizardry:amulet_survival_chance", "apprenticearcana:head_knowledge"};
        @Config.Name(value="Minimum NPC Level for Identifying Spells")
        public int MINIMUM_NPC_LEVEL_FOR_IDENTIFYING_SPELLS = 10;
        @Config.Name(value="[UNUSED] Identify Spells in Inventory")
        public boolean IDENTIFY_SPELLS_IN_INVENTORY = true;
        @Config.Name(value="Wizards Can Identify Spells")
        public boolean WIZARDS_CAN_IDENTIFY_SPELLS = true;
        @Config.Name(value="Max Tier for Identifying Spells")
        @Config.Comment(value={"0 = novice, 1 = up to apprentice, 2 = up to advanced, 3 = up to master"})
        @Config.RangeInt(min=0, max=3)
        public int MAX_TIER_FOR_IDENTIFYING_SPELLS = 2;
        @Config.Name(value="Apprentice XP Gain on identified spells. Each tier multiplies it")
        public int XP_GAIN_ON_IDENTIFICATION = 100;
        @Config.Name(value="Apprentice XP Gain on observing player spell casts. Each tier multiplies it. This depends on the chance of SPELL_REMARK_MESSAGE_CHANCE setting.")
        public int XP_GAIN_ON_WATCHING_PLAYER_USING_MAGIC = 30;
        @Config.Name(value="Identifying Spell Duration Multiplier Compared to Learning")
        @Config.Comment(value={"Checked once every second. Set to 0 to disable this event."})
        public float IDENTIFYING_SPELL_DURATION_MULTIPLIER_COMPARED_TO_LEARNING = 2.5f;
        @Config.Name(value="Max Apprentice Level")
        public int MAX_WIZARD_LEVEL = 30;
        @Config.Name(value="Max Apprentice Spell Slots")
        @Config.RangeInt(min=1, max=8)
        public int MAX_WIZARD_SPELL_SLOTS = 8;
        @Config.Name(value="Max Apprentice Spell Tier")
        @Config.Comment(value={"0 = novice, 1 = up to apprentice, 2 = up to advanced, 3 = up to master"})
        @Config.RangeInt(min=0, max=3)
        public int MAX_WIZARD_SPELL_TIER = 2;
        @Config.Name(value="XP Gain Per Kill")
        @Config.RangeInt(min=1)
        public int XP_GAIN_PER_KILL = 20;
        @Config.Name(value="Maximum Apprentice Count")
        @Config.Comment(value={"The number of apprentice wizard NPCs a player can have at a time. Set to -1 to have no limit"})
        @Config.RangeInt(min=-1)
        public int MAXIMUM_APPRENTICE_COUNT = 2;
        @Config.Name(value="Maximum Party Size")
        @Config.Comment(value={"The number of apprentice wizard NPCs a player can have at a time following them. Can be used in conjunction with the MAXIMUM_APPRENTICE_COUNT setting,to allow having more apprentices at a time in total, but still keep the game more balanced. Set to -1 to allow unlimited parties."})
        @Config.RangeInt(min=-1)
        public int MAXIMUM_PARTY_SIZE = 2;
        @Config.Name(value="Apprentices Can Be Revived")
        @Config.Comment(value={"If true, died apprentices can be resurrected by using a Totem of Undying on an Imbuement Altar."})
        public boolean APPRENTICES_CAN_BE_RESURRECTED = true;
        @Config.Name(value="Apprentices Respawn At Player Spawnpoint")
        @Config.Comment(value={"If true, died apprentices will just respawn at the player's spawnpoint the next time the player sleeps. Mutually exclusive with the APPRENTICES_CAN_BE_RESURRECTED setting."})
        public boolean APPRENTICES_RESPAWN_AT_PLAYER_SPAWNPOINT = true;
        @Config.Name(value="Apprentices Spawn In Vanilla Villages")
        @Config.Comment(value={"If true, NPC apprentices will naturally spawn in vanilla villages. If set to false, you must provide your own method of spawning them."})
        public boolean APPRENTICES_SPAWN_IN_VANILLA_VILLAGES = true;
        @Config.Name(value="Show Partied Up Apprentice Hitpoints")
        @Config.Comment(value={"If true, NPCs currently following the player will have their health bar displayed on the screen."})
        public boolean SHOW_PARTIED_UP_APPRENTICE_HITPOINTS = true;
        @Config.Name(value="Party NPC Hitpoint X Position")
        @Config.Comment(value={"Sets the X position of the NPC health display of the NPCs apprentices currently following the player."})
        @Config.RangeInt(min=0)
        public int PARTY_NPC_HITPOINT_X_POSITION = 0;
        @Config.Name(value="Party NPC Hitpoint Y Position")
        @Config.Comment(value={"Sets the X position of the NPC health display of the NPCs apprentices currently following the player."})
        @Config.RangeInt(min=0)
        public int PARTY_NPC_HITPOINT_Y_POSITION = 0;
        @Config.Name(value="Apprentice Minimum HP")
        @Config.RangeInt(min=1)
        public int WIZARD_MINIMUM_HP = 8;
        @Config.Name(value="Apprentice HP Gain Per Level")
        @Config.RangeInt(min=0)
        public int WIZARD_HP_GAIN_PER_LEVEL = 1;
        @Config.Name(value="Apprentice MAX HEALTH CAP")
        @Config.RangeInt(min=1)
        public int WIZARD_MAX_HEALTH_CAP = 200;
        @Config.Name(value="XP Gain Per Spell Cast")
        public int XP_GAIN_PER_SPELL_CAST = 5;
        @Config.Name(value="Kill Message Chance")
        public float KILL_MESSAGE_CHANCE = 0.05f;
        @Config.Name(value="Spell Remark Message Chance")
        public float SPELL_REMARK_MESSAGE_CHANCE = 0.05f;
        @Config.Name(value="Items Found By Apprentices During Travelling Together")
        @Config.Comment(value={"List of items found by wizard apprentices that they give to the player on rare occasions during adventuring TOGETHER.The format should be like this: modid:itemname:metadata:count_min:count_max:nbt:nbt_stuff_goes_here. The nbt tag can be omitted. Example: ebwizardry:magic_crystal:0:2:5 - this didn't have an nbt tag with a random count between 2-5Example: bwizardry:magic_crystal:4:2:5:nbt:{ench:[{id:6,lvl:1}]} - this would be 2-5 magic crystals with an aqua affinity enchantment and metadata as 4"})
        public String[] APPRENTICE_ITEM_LIST_TRAVELLING_TOGETHER = new String[]{"ebwizardry:magic_crystal:1:2:5", "ebwizardry:crystal_flower:0:2:2:{ench:[{id:6,lvl:1}]}"};
        @Config.Name(value="Event Chance - Items Found By Apprentices")
        @Config.Comment(value={"Checked once every second. Set to 0 to disable this event."})
        public float EVENT_FREQUENCY_ITEMS_FOUND_BY_APPRENTICES = 1.0f;
        @Config.Name(value="Event Chance - Give Food To Starving Owner")
        @Config.Comment(value={"Checked once every second. Set to 0 to disable this event."})
        public float EVENT_FREQUENCY_GIVE_FOOD_TO_STARVING_OWNER = 1.0f;
        @Config.Name(value="Event Chance - Give Healing Potion To Dying Owner")
        @Config.Comment(value={"Checked once every second. Set to 0 to disable this event."})
        public float EVENT_FREQUENCY_GIVE_HEALING_POTION_TO_DYING_OWNER = 1.0f;
        @Config.Name(value="Max Adventure Duration In Ticks (short journeys)")
        @Config.Comment(value={"Determines the maximum duration an NPC can spend in an adventure before it returns."})
        public int MAX_ADVENTURE_DURATION_IN_TICKS_SHORT = 18000;
        @Config.Name(value="Min Adventure Duration In Ticks (short journeys)")
        @Config.Comment(value={"Determines the minimum duration an NPC must spend in an adventure before it returns."})
        public int MIN_ADVENTURE_DURATION_IN_TICKS_SHORT = 6000;
        @Config.Name(value="Max Adventure Duration In Ticks (medium journeys)")
        @Config.Comment(value={"Determines the maximum duration an NPC can spend in an adventure before it returns."})
        public int MAX_ADVENTURE_DURATION_IN_TICKS_MEDIUM = 18000;
        @Config.Name(value="Min Adventure Duration In Ticks (medium journeys)")
        @Config.Comment(value={"Determines the minimum duration an NPC must spend in an adventure before it returns."})
        public int MIN_ADVENTURE_DURATION_IN_TICKS_MEDIUM = 14000;
        @Config.Name(value="Max Adventure Duration In Ticks (long journeys)")
        @Config.Comment(value={"Determines the maximum duration an NPC can spend in an adventure before it returns."})
        public int MAX_ADVENTURE_DURATION_IN_TICKS_LONG = 81000;
        @Config.Name(value="Min Adventure Duration In Ticks (long journeys)")
        @Config.Comment(value={"Determines the minimum duration an NPC must spend in an adventure before it returns."})
        public int MIN_ADVENTURE_DURATION_IN_TICKS_LONG = 54000;
        @Config.Name(value="NPC Spell Study Time Modifier")
        @Config.Comment(value={"The higher the number, the longer it takes to learn a spell (as a math exponent)For reference, here is a table for each tier's learning time in MINUTES for a given whole number of this setting, format is:<time modifier> : <novice> | <apprentice> | <advanced> | <master>4: <1 | <1 | 1 | 25: 3 | 4 | 7 | 106: 13 | 23 | 39 | 637: 65 | 127 | 233 | 4088: 325 | 698 | 1400 | 2655"})
        @Config.RangeDouble(min=4.0, max=8.0)
        public double NPC_SPELL_STUDY_TIME_MODIFIER = 5.0;
    }

    public static class JourneySettings {
        @Config.Name(value="Journey Food Requirement Modifier")
        public float JOURNEY_FOOD_REQUIREMENT_MODIFIER = 1.0f;
        @Config.Name(value="Sets the modifier of the Explorer's Belt artefact. This is a multiplier, setting it to 1 makes it have no effect, lower valuesreduce the journey duration (default -25%")
        public float EXPLORERS_BELT_JOURNEY_TIME_MODIFIER = 0.75f;
        @Config.Name(value="Wizard Journey XP Gain Modifier")
        @Config.Comment(value={"Levels Required By Each Journey Type in a format of adventuretype:minimum_level"})
        public float WIZARD_JOURNEY_XP_GAIN_MODIFIER = 1.0f;
        @Config.Name(value="Journeys Require Food")
        public boolean JOURNEY_REQUIRE_FOOD = true;
        @Config.Name(value="Levels Required By Each Journey Type")
        @Config.Comment(value={"Levels Required By Each Journey Type in a format of journeytype:minimum_level"})
        public String[] LEVELS_REQUIRED_BY_EACH_JOURNEY_TYPE = new String[]{"gather:5", "slay_mobs:10", "adventure:15", "custom_journey:5"};
        @Config.Name(value="Custom Journey")
        @Config.Comment(value={"Enables a 4th, custom journey type. This could be used for pack makers or whatever other purpose you want. For the Level requirement, use the LEVELS_REQUIRED_BY_EACH_JOURNEY_TYPE settings' custom_journey:x type"})
        public boolean CUSTOM_JOURNEY_ENABLED = false;
        @Config.Name(value="Custom Journey Name")
        @Config.Comment(value={"Name of the custom journey type. Here you can simply provide a string, or a language key as well. If the string contains a colon (:), it will be treated as a language key and it will be localised. "})
        public String CUSTOM_JOURNEY_NAME = "Rename Me";
        @Config.Name(value="Custom Journey Loot Table")
        @Config.Comment(value={"Path of the Custom Journey's loot table. E.g. 'ebwizardry:chests/shrine'"})
        public String CUSTOM_JOURNEY_LOOT_TABLE = "";
    }

    @Mod.EventBusSubscriber(modid="arcaneapprentices")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("arcaneapprentices")) {
                ConfigManager.sync((String)"arcaneapprentices", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

