/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices;

import com.windanesz.arcaneapprentices.ArcaneApprentices;
import com.windanesz.arcaneapprentices.Settings;
import electroblob.wizardry.spell.Spell;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class Utils {
    private Utils() {
    }

    public static void sendMessage(Entity player, String translationKey, boolean actionBar, Object ... args) {
        if (player instanceof EntityPlayer && !player.field_70170_p.field_72995_K) {
            ((EntityPlayer)player).func_146105_b((ITextComponent)new TextComponentTranslation(translationKey, args), actionBar);
        }
    }

    public static String generateWizardName(World world) {
        return Arrays.asList(Settings.generalSettings.WIZARD_NAMES).get(world.field_73012_v.nextInt(Arrays.asList(Settings.generalSettings.WIZARD_NAMES).size()));
    }

    public static boolean giveStackToPlayer(EntityPlayer player, ItemStack stack) {
        if (player != null && stack != null && !stack.func_190926_b() && !player.field_70170_p.field_72995_K) {
            if (player.func_184614_ca().func_190926_b()) {
                player.func_184611_a(EnumHand.MAIN_HAND, stack);
            } else if (player.func_184592_cb().func_190926_b()) {
                player.func_184611_a(EnumHand.OFF_HAND, stack);
            } else if (!player.field_71071_by.func_70441_a(stack)) {
                player.func_71019_a(stack, false);
            }
            return true;
        }
        return false;
    }

    public static <T> T getRandomItem(List<T> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("List cannot be null or empty");
        }
        int randomIndex = ArcaneApprentices.rand.nextInt(list.size());
        return list.get(randomIndex);
    }

    public static <T extends Entity> List<T> getEntitiesWithinRadius(double radius, double x, double y, double z, World world, Class<T> entityType) {
        AxisAlignedBB aabb = new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
        List entityList = world.func_72872_a(entityType, aabb);
        for (int i = 0; i < entityList.size(); ++i) {
            if (!(((Entity)entityList.get(i)).func_70011_f(x, y, z) > radius)) continue;
            entityList.remove(i);
            break;
        }
        return entityList;
    }

    public static void overrideDefaultSpell(Spell newSpellInstance, int oldNetworkID) {
        ArcaneApprentices.logger.info("Overriding default Electroblobs's Wizardry spell " + newSpellInstance.getRegistryName() + " to apply changes by ApprenticeArcana.");
        newSpellInstance.setId(oldNetworkID);
        int nextSpellId = (Integer)ObfuscationReflectionHelper.getPrivateValue(Spell.class, (Object)newSpellInstance, (String)"nextSpellId");
        ObfuscationReflectionHelper.setPrivateValue(Spell.class, (Object)newSpellInstance, (Object)(--nextSpellId), (String)"nextSpellId");
    }
}

