/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.client.gui;

import com.windanesz.arcaneapprentices.Settings;
import com.windanesz.arcaneapprentices.data.JourneyType;
import com.windanesz.arcaneapprentices.entity.living.EntityWizardInitiate;
import com.windanesz.arcaneapprentices.handler.JourneySurvivalHandler;
import com.windanesz.arcaneapprentices.inventory.ContainerWizardInititateAdventure;
import com.windanesz.arcaneapprentices.packet.AAPacketHandler;
import com.windanesz.arcaneapprentices.packet.PacketControlInput;
import com.windanesz.arcaneapprentices.registry.AAItems;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiScreenWizardInitiateAdventure
extends GuiContainer {
    private static final ResourceLocation GUI_BACKGROUND = new ResourceLocation("arcaneapprentices", "textures/gui/wizard_adventuring.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private final EntityWizardInitiate wizard;
    private GuiTextField confirmField;
    private GuiButton infoButton;
    private GuiButton confirmButton;
    private GuiButton cancelButton;
    private GuiButtonWithDescription shortDuration;
    private GuiButtonWithDescription mediumDuration;
    private GuiButtonWithDescription longDuration;
    private GuiButtonWithDescription gatheringButton;
    private GuiButtonWithDescription mobSlayingButton;
    private GuiButtonWithDescription journeyButton;
    private GuiButtonWithDescription spellHuntButton;
    private GuiButtonWithDescription treasureHuntButton;
    private GuiButtonWithDescription netherAdventureButton;
    private GuiButtonWithDescription oceanAdventureButton;

    public GuiScreenWizardInitiateAdventure(EntityWizardInitiate wizard) {
        super((Container)new ContainerWizardInititateAdventure(wizard, (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        this.wizard = wizard;
        this.field_146291_p = true;
        this.field_146999_f = 176;
        this.field_147000_g = 196;
        this.field_147000_g = 230;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"gui.arcaneapprentices:distance_to_travel", (Object[])new Object[0]), 5, 108, 170, 0x404040);
        this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"gui.arcaneapprentices:what_to_do", (Object[])new Object[0]), 5, 145, 170, 0x404040);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int left = this.field_146294_l / 2 - this.field_146999_f / 2;
        int top = this.field_146295_m / 2 - this.field_147000_g / 2;
        this.infoButton = new GuiButtonInfo(0, this.field_146294_l / 2 - 8, top + 87, I18n.func_135052_a((String)"gui.arcaneapprentices:confirm_button", (Object[])new Object[0]), "confirm");
        this.field_146292_n.add(this.infoButton);
        this.confirmButton = new GuiButton(1, left + 100, top + 202, I18n.func_135052_a((String)"gui.arcaneapprentices:confirm_button", (Object[])new Object[0]));
        this.field_146292_n.add(this.confirmButton);
        this.cancelButton = new GuiButton(2, left + 20, top + 202, I18n.func_135052_a((String)"gui.arcaneapprentices:cancel_button", (Object[])new Object[0]));
        this.field_146292_n.add(this.cancelButton);
        int offset = 35;
        this.shortDuration = new GuiButtonWithDescription(3, left + 26, top + 155 - offset, 40, 20, I18n.func_135052_a((String)"gui.arcaneapprentices:short", (Object[])new Object[0]), "short_duration", 1);
        this.field_146292_n.add(this.shortDuration);
        this.mediumDuration = new GuiButtonWithDescription(4, left + 68, top + 155 - offset, 40, 20, I18n.func_135052_a((String)"gui.arcaneapprentices:medium", (Object[])new Object[0]), "medium_duration", 1);
        this.field_146292_n.add(this.mediumDuration);
        this.longDuration = new GuiButtonWithDescription(5, left + 110, top + 155 - offset, 40, 20, I18n.func_135052_a((String)"gui.arcaneapprentices:long", (Object[])new Object[0]), "long_duration", 1);
        this.field_146292_n.add(this.longDuration);
        this.gatheringButton = new GuiButtonWithDescription(6, left + 15, top + 190 - offset, 70, 20, I18n.func_135052_a((String)"gui.arcaneapprentices:gather", (Object[])new Object[0]), "gather", 2);
        this.field_146292_n.add(this.gatheringButton);
        this.mobSlayingButton = new GuiButtonWithDescription(7, left + 90, top + 190 - offset, 70, 20, I18n.func_135052_a((String)"gui.arcaneapprentices:slay_mobs", (Object[])new Object[0]), "slay_mobs", 2);
        this.field_146292_n.add(this.mobSlayingButton);
        this.journeyButton = new GuiButtonWithDescription(8, left + 15, top + 213 - offset, 70, 20, I18n.func_135052_a((String)"gui.arcaneapprentices:adventure", (Object[])new Object[0]), "adventure", 2);
        this.field_146292_n.add(this.journeyButton);
        if (this.wizard.isArtefactActive(AAItems.charm_spell_compass)) {
            this.spellHuntButton = new GuiButtonWithDescription(9, left + 90, top + 213 - offset, 70, 20, I18n.func_135052_a((String)"gui.arcaneapprentices:spell_hunt", (Object[])new Object[0]), "spell_hunt", 2);
            this.field_146292_n.add(this.spellHuntButton);
        } else if (this.wizard.isArtefactActive(AAItems.charm_withering_atlas)) {
            this.netherAdventureButton = new GuiButtonWithDescription(9, left + 90, top + 213 - offset, 70, 20, I18n.func_135052_a((String)"gui.arcaneapprentices:nether_adventure", (Object[])new Object[0]), "nether_adventure", 2);
            this.field_146292_n.add(this.netherAdventureButton);
        } else if (this.wizard.isArtefactActive(AAItems.charm_golden_lure)) {
            this.oceanAdventureButton = new GuiButtonWithDescription(9, left + 90, top + 213 - offset, 70, 20, I18n.func_135052_a((String)"gui.arcaneapprentices:ocean_adventure", (Object[])new Object[0]), "ocean_adventure", 2);
            this.field_146292_n.add(this.oceanAdventureButton);
        }
        this.confirmButton.field_146120_f = 50;
        this.cancelButton.field_146120_f = 50;
        this.updateButtonState();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        String suffix = "";
        int selectedCategories = 0;
        if (button instanceof GuiButtonWithDescription) {
            int currentCategory = ((GuiButtonWithDescription)button).category;
            for (GuiButton button1 : this.field_146292_n) {
                if (button1 == button || !(button1 instanceof GuiButtonWithDescription) || ((GuiButtonWithDescription)button1).category != currentCategory || !((GuiButtonWithDescription)button1).requirementsMet) continue;
                button1.field_146124_l = true;
                ((GuiButtonWithDescription)button1).selected = false;
            }
            button.field_146124_l = false;
            ((GuiButtonWithDescription)button).selected = true;
        }
        for (GuiButton button1 : this.field_146292_n) {
            if (!(button1 instanceof GuiButtonWithDescription) || !((GuiButtonWithDescription)button1).requirementsMet || !((GuiButtonWithDescription)button1).selected) continue;
            ++selectedCategories;
        }
        boolean bl = this.confirmButton.field_146124_l = selectedCategories == 2;
        if (button == this.cancelButton) {
            PacketControlInput.Message msg = new PacketControlInput.Message(PacketControlInput.ControlType.OPEN_WIZARD_INVENTORY_BUTTON);
            AAPacketHandler.net.sendToServer((IMessage)msg);
        } else if (button == this.confirmButton) {
            if (this.getJourneyType().toLowerCase().toString().contains("gather")) {
                if (this.wizard.func_184592_cb().func_77973_b() instanceof ItemAxe) {
                    suffix = "_AXE";
                } else if (this.wizard.func_184592_cb().func_77973_b() instanceof ItemPickaxe) {
                    suffix = "_PICKAXE";
                } else if (this.wizard.func_184592_cb().func_77973_b() instanceof ItemShears) {
                    suffix = "_SHEARS";
                }
            }
            JourneyType type = JourneyType.valueOf((this.getJourneyType() + "_" + this.getDuration()).toUpperCase() + suffix);
            PacketControlInput.Message msg = new PacketControlInput.Message(PacketControlInput.ControlType.JOURNEY_CONFIRM_BUTTON, type);
            AAPacketHandler.net.sendToServer((IMessage)msg);
            if (this.wizard.verifyWandManaRequirementForJourney(type)) {
                for (int i = 0; i < 20; ++i) {
                    float brightness = this.wizard.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.1f;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.CLOUD, (Random)this.wizard.field_70170_p.field_73012_v, (double)(this.wizard.field_70165_t + 1.0), (double)this.wizard.field_70163_u, (double)this.wizard.field_70161_v, (double)1.0, (boolean)false).clr(brightness, brightness, brightness).time(80 + this.wizard.field_70170_p.field_73012_v.nextInt(12)).shaded(true).spawn(this.wizard.field_70170_p);
                }
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_BACKGROUND);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiButtonWithDescription) || !button.func_146115_a()) continue;
            int tooltipX = mouseX + 12;
            int tooltipY = mouseY + 12;
            if (button != this.infoButton) {
                if (((GuiButtonWithDescription)button).category == 1 && !((GuiButtonWithDescription)button).requirementsMet) {
                    this.func_146279_a(I18n.func_135052_a((String)"gui.arcaneapprentices:not_enough_food", (Object[])new Object[0]), tooltipX, tooltipY);
                    continue;
                }
                if (((GuiButtonWithDescription)button).category == 2 && !((GuiButtonWithDescription)button).requirementsMet) {
                    this.func_146279_a(I18n.func_135052_a((String)"gui.arcaneapprentices:too_low_level", (Object[])new Object[0]), tooltipX, tooltipY);
                    continue;
                }
                this.func_146279_a(I18n.func_135052_a((String)((GuiButtonWithDescription)button).getDescriptionLanguageKey(), (Object[])new Object[0]), tooltipX, tooltipY);
                continue;
            }
            this.func_146279_a(I18n.func_135052_a((String)"gui.arcaneapprentices:wizard_journey_gui_info", (Object[])new Object[]{this.wizard.getDisplayNameWithoutOwner().func_150254_d()}), tooltipX, tooltipY);
        }
        if (this.confirmButton.field_146124_l) {
            int left = this.field_146294_l / 2 - this.field_146999_f / 2;
            int top = this.field_146295_m / 2 - this.field_147000_g / 2;
            String suffix = "";
            if (this.getJourneyType().toLowerCase().toString().contains("gather")) {
                if (this.wizard.func_184592_cb().func_77973_b() instanceof ItemAxe) {
                    suffix = "_AXE";
                } else if (this.wizard.func_184592_cb().func_77973_b() instanceof ItemPickaxe) {
                    suffix = "_PICKAXE";
                } else if (this.wizard.func_184592_cb().func_77973_b() instanceof ItemShears) {
                    suffix = "_SHEARS";
                }
            }
            JourneyType type = JourneyType.valueOf((this.getJourneyType() + "_" + this.getDuration()).toUpperCase() + suffix);
            float percent = JourneySurvivalHandler.calculateSurvivalChance(this.wizard, type);
            NumberFormat percentFormat = NumberFormat.getPercentInstance();
            percentFormat.setMinimumFractionDigits(1);
            String percentString = percentFormat.format(percent);
            this.field_146289_q.func_78279_b(percentString, left + 73, top + 207, 170, 0x404040);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
    }

    public boolean hasEnoughFood(JourneyType type) {
        if (!Settings.journeySettings.JOURNEY_REQUIRE_FOOD) {
            return true;
        }
        String duration = type.getDuration();
        float totalFoodValue = 0.0f;
        for (int i = 1; i < this.wizard.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.wizard.inventory.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof ItemFood) || stack.func_77973_b() == Items.field_151078_bh) continue;
            totalFoodValue += (float)(((ItemFood)stack.func_77973_b()).func_150905_g(stack) * stack.func_190916_E());
        }
        float cost = duration.equals("SHORT") ? 30.0f : (duration.equals("MEDIUM") ? 90.0f : 200.0f);
        return totalFoodValue >= (cost *= Settings.journeySettings.JOURNEY_FOOD_REQUIREMENT_MODIFIER);
    }

    private void updateButtonState() {
        this.confirmButton.field_146124_l = false;
        this.shortDuration.field_146124_l = this.shortDuration.requirementsMet = this.hasEnoughFood(JourneyType.GATHER_SHORT_DURATION);
        this.mediumDuration.field_146124_l = this.mediumDuration.requirementsMet = this.hasEnoughFood(JourneyType.GATHER_MEDIUM_DURATION);
        this.longDuration.field_146124_l = this.longDuration.requirementsMet = this.hasEnoughFood(JourneyType.GATHER_LONG_DURATION);
        this.gatheringButton.field_146124_l = this.gatheringButton.requirementsMet = this.requirementsMet(this.gatheringButton.buttonCodeName);
        this.mobSlayingButton.field_146124_l = this.mobSlayingButton.requirementsMet = this.requirementsMet(this.mobSlayingButton.buttonCodeName);
        this.journeyButton.field_146124_l = this.journeyButton.requirementsMet = this.requirementsMet(this.journeyButton.buttonCodeName);
    }

    private boolean requirementsMet(String adventureTypeString) {
        String[] levelsRequired;
        for (String levelRequired : levelsRequired = Settings.journeySettings.LEVELS_REQUIRED_BY_EACH_JOURNEY_TYPE) {
            String[] parts = levelRequired.split(":");
            String adventureType = parts[0];
            int requiredLevel = Integer.parseInt(parts[1]);
            if (!adventureType.equals(adventureTypeString)) continue;
            int wizardLevel = this.wizard.getLevel();
            return wizardLevel >= requiredLevel;
        }
        return true;
    }

    private String getDuration() {
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiButtonWithDescription) || ((GuiButtonWithDescription)button).category != 1 || !((GuiButtonWithDescription)button).selected) continue;
            return ((GuiButtonWithDescription)button).buttonCodeName;
        }
        return "none";
    }

    private String getJourneyType() {
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof GuiButtonWithDescription) || ((GuiButtonWithDescription)button).category != 2 || !((GuiButtonWithDescription)button).selected) continue;
            return ((GuiButtonWithDescription)button).buttonCodeName;
        }
        return "not_adventuring";
    }

    private static class GuiButtonInfo
    extends GuiButtonWithDescription {
        public GuiButtonInfo(int id, int x, int y, String buttonText, String buttonCodeName) {
            super(id, x, y, 16, 16, buttonText, buttonCodeName, 0);
        }

        public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int k = 176;
            int l = 0;
            if (this.field_146124_l && this.field_146123_n) {
                k += this.field_146120_f;
            }
            DrawingUtils.drawTexturedRect((int)this.field_146128_h, (int)this.field_146129_i, (int)k, (int)l, (int)this.field_146120_f, (int)this.field_146121_g, (int)256, (int)256);
        }
    }

    private static class GuiButtonWithDescription
    extends GuiButton {
        public boolean selected = false;
        public int category = 0;
        public boolean requirementsMet = true;
        String buttonCodeName;

        public GuiButtonWithDescription(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, String buttonCodeName, int category) {
            super(buttonId, x, y, widthIn, heightIn, buttonText);
            this.buttonCodeName = buttonCodeName;
            this.category = category;
        }

        public GuiButtonWithDescription(int buttonId, int x, int y, String buttonText, String buttonCodeName) {
            super(buttonId, x, y, buttonText);
            this.buttonCodeName = buttonCodeName;
        }

        public String getDescriptionLanguageKey() {
            return "gui.arcaneapprentices:" + this.buttonCodeName + ".description";
        }
    }
}

