/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.client.gui;

import com.windanesz.arcaneapprentices.entity.living.EntityWizardInitiate;
import com.windanesz.arcaneapprentices.handler.XpProgression;
import com.windanesz.arcaneapprentices.inventory.ContainerWizardInfo;
import com.windanesz.arcaneapprentices.packet.AAPacketHandler;
import com.windanesz.arcaneapprentices.packet.PacketControlInput;
import electroblob.wizardry.client.DrawingUtils;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiScreenWizardInitiateStats
extends GuiContainer {
    private static final ResourceLocation GUI_BACKGROUND = new ResourceLocation("arcaneapprentices", "textures/gui/wizard_stats.png");
    private final EntityWizardInitiate wizard;

    public GuiScreenWizardInitiateStats(EntityWizardInitiate wizard) {
        super((Container)new ContainerWizardInfo(wizard, (EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        this.wizard = wizard;
        this.field_146291_p = false;
        this.field_146999_f = 176;
        this.field_147000_g = 196;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.wizard.getDisplayNameWithoutOwner().func_150260_c(), 5, 13, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.arcaneapprentices:wizard_level", (Object[])new Object[]{this.wizard.getLevel(), this.wizard.getTotalXp(), (int)XpProgression.calculateTotalXpRequired(this.wizard.getLevel() + 1)}), 5, 25, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.arcaneapprentices:spell_slots", (Object[])new Object[0]), 5, 37, 0x404040);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        int ij = 0;
        int left = this.field_146294_l / 2 - this.field_146999_f / 2;
        int top = this.field_146295_m / 2 - this.field_147000_g / 2;
        for (int i = 0; i < this.wizard.getCurrentSpellSlotCap(); ++i) {
            int left1 = left + 4;
            this.field_146292_n.add(new GuiButtonSpellToggle(i, left1 + 6 + ij * 20, top + 50));
            ++ij;
        }
        this.field_146292_n.add(new NextPageButton(this.field_146292_n.size(), left + 140, top + 170));
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        PacketControlInput.Message msg;
        List<Spell> spells = this.wizard.getSpells();
        if (button.field_146127_k <= spells.size() - 1) {
            msg = new PacketControlInput.Message(PacketControlInput.ControlType.SPELL_TOGGLE_BUTTON, spells.get(button.field_146127_k));
            AAPacketHandler.net.sendToServer((IMessage)msg);
        }
        if (button instanceof NextPageButton) {
            msg = new PacketControlInput.Message(PacketControlInput.ControlType.OPEN_WIZARD_INVENTORY_BUTTON);
            AAPacketHandler.net.sendToServer((IMessage)msg);
        }
    }

    public void func_146279_a(String text, int x, int y) {
        super.func_146279_a(text, x, y);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_BACKGROUND);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        this.drawHealthBar();
        this.drawSpellSlots(partialTicks, mouseX, mouseY);
        int left = this.field_146294_l / 2 - this.field_146999_f / 2;
        int top = this.field_146295_m / 2 - this.field_147000_g / 2;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.arcaneapprentices:food_level", (Object[])new Object[]{Math.round(this.wizard.getFoodLevel() / 20.0f * 100.0f)}), left + 5, top + 82, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.arcaneapprentices:saturation", (Object[])new Object[]{Math.round(this.wizard.getSaturation() / 20.0f * 100.0f)}), left + 5, top + 92, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.apprenticearcana.talent", (Object[])new Object[0]), left + 5, top + 103, 0x404040);
        if (this.wizard.func_70631_g_()) {
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"gui.apprenticearcana.talent_locked", (Object[])new Object[]{this.wizard.func_70005_c_(), XpProgression.getMaxLevel() / 2}), left + 5, top + 113, 167, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(this.wizard.getTalent().getDisplayName(), left + 5, top + 113, 0x404040);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)("talent." + this.wizard.getTalent().name().toLowerCase() + ".desc"), (Object[])new Object[]{this.wizard.func_70005_c_()}), left + 5, top + 123, 167, 0x404040);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    public void drawHealthBar() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(field_110324_m);
        int effectX = 0;
        int lft = this.field_146294_l / 2 - this.field_146999_f / 2 + 5;
        int tp = this.field_146295_m / 2 - this.field_147000_g / 2 + 70;
        int maxHearts = (int)(this.wizard.func_110138_aP() / 2.0f);
        float currentHearts = this.wizard.func_110143_aJ() / 2.0f;
        boolean hasHalfHeart = currentHearts - (float)((int)currentHearts) >= 0.5f || this.wizard.func_110143_aJ() < 1.0f;
        int fullhearts = 0;
        for (int l = 0; l < maxHearts; ++l) {
            this.func_73729_b(lft + l * 9, tp, 16, 0, 9, 9);
            if (hasHalfHeart && fullhearts == (int)currentHearts || this.wizard.func_110143_aJ() < 1.0f && currentHearts == 0.0f) {
                this.func_73729_b(lft + l * 9, tp, 61 + effectX, 0, 9, 9);
            } else if ((float)l <= currentHearts - 1.0f && currentHearts > 1.0f) {
                this.func_73729_b(lft + l * 9, tp, 52 + effectX, 0, 9, 9);
            }
            ++fullhearts;
        }
    }

    public void drawSpellSlots(float partialTicks, int mouseX, int mouseY) {
        int left = this.field_146294_l / 2 - this.field_146999_f / 2;
        int top = this.field_146295_m / 2 - this.field_147000_g / 2;
        List<Spell> spells = this.wizard.getSpells();
        while (spells.size() < 8) {
            spells.add(Spells.none);
        }
        int ij = 0;
        int cap = this.wizard.getCurrentSpellSlotCap();
        int k = 1;
        for (Spell spell : spells) {
            if (k > cap) continue;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(spell.getIcon());
            int left1 = left + 4;
            DrawingUtils.drawTexturedRect((int)(left1 + 6 + ij * 20), (int)(top + 50), (int)0, (int)0, (int)16, (int)16, (int)16, (int)16);
            int iconX = left1 + 5 + ij * 20;
            int iconY = top + 50;
            if (mouseX >= iconX && mouseX < iconX + 16 && mouseY >= iconY && mouseY < iconY + 16) {
                String spellName = spell.getDisplayName();
                int textX = iconX + 3;
                int textY = iconY + 30 - this.field_146297_k.field_71466_p.field_78288_b;
                this.field_146289_q.func_175063_a(spellName, (float)textX, (float)textY, 0xFFFFFF);
            }
            if (this.wizard.isSpellDisabled(spell) && spell != Spells.none) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Gui.func_73734_a((int)(left1 + 6 + ij * 20), (int)(top + 50), (int)(left1 + 6 + ij * 20 + 16), (int)(top + 50 + 16), (int)1694433280);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
            }
            ++ij;
            ++k;
        }
    }

    @SideOnly(value=Side.CLIENT)
    static class NextPageButton
    extends GuiButton {
        public NextPageButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 23, 13, "");
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/book.png"));
                int i = 0;
                int j = 192;
                if (flag) {
                    i += 23;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, i, j += 13, 23, 13);
            }
        }
    }

    private static class GuiButtonSpellToggle
    extends GuiButton {
        public GuiButtonSpellToggle(int id, int x, int y) {
            super(id, x, y, 16, 16, I18n.func_135052_a((String)"gui.arcaneapprentices:spell_toggle_button", (Object[])new Object[0]));
        }

        public void func_191745_a(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        }
    }
}

