/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.client.render;

import com.windanesz.arcaneapprentices.entity.living.EntityWizardInitiate;
import electroblob.wizardry.client.model.ModelWizard;
import java.text.NumberFormat;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class RenderWizardInitiate
extends RenderBiped<EntityWizardInitiate> {
    static final ResourceLocation[] TEXTURES = new ResourceLocation[6];
    private boolean isSleeping;

    public RenderWizardInitiate(RenderManager renderManager) {
        super(renderManager, (ModelBiped)new ModelWizard(), 0.5f);
        for (int i = 0; i < 6; ++i) {
            RenderWizardInitiate.TEXTURES[i] = new ResourceLocation("arcaneapprentices", "textures/entity/wizard/wizard_" + i + ".png");
        }
        this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
    }

    protected ResourceLocation getEntityTexture(EntityWizardInitiate wizard) {
        return TEXTURES[wizard.textureIndex];
    }

    protected void applyRotations(EntityWizardInitiate wizard, float ageInTicks, float rotationYaw, float partialTicks) {
        float bedRotation;
        this.isSleeping = wizard.isLyingInBed();
        if (this.isSleeping && (bedRotation = wizard.getBedRotation()) != -1.0f) {
            GlStateManager.func_179114_b((float)bedRotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.func_77037_a((EntityLivingBase)wizard), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.isSleeping = false;
            return;
        }
        super.func_77043_a((EntityLivingBase)wizard, ageInTicks, rotationYaw, partialTicks);
    }

    public void doRender(EntityWizardInitiate entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((EntityLiving)entity, x, y, z, entityYaw, partialTicks);
        if (entity.getTask() == EntityWizardInitiate.Task.STUDY || entity.getTask() == EntityWizardInitiate.Task.IDENTIFY) {
            this.renderLecternProgress(entity, x, y, z, entityYaw, partialTicks);
        }
    }

    public void renderLecternProgress(EntityWizardInitiate entity, double x, double y, double z, float entityYaw, float partialTicks) {
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMinimumFractionDigits(1);
        String percentString = percentFormat.format(entity.getStudyProgress());
        this.func_147906_a((Entity)entity, percentString, x, y + 0.3, z, 20);
    }
}

