/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.data;

import com.windanesz.arcaneapprentices.Settings;
import com.windanesz.arcaneapprentices.data.StoredEntity;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.util.NBTExtras;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;

public class PlayerData {
    public static final IStoredVariable<List<UUID>> WIZARD_APPRENTICES = new IStoredVariable.StoredVariable("wizardApprentices", s -> NBTExtras.listToNBT((Collection)s, NBTUtil::func_186862_a), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, NBTUtil::func_186860_b)), Persistence.ALWAYS);
    public static final IStoredVariable<List<UUID>> CURRENT_PARTY = new IStoredVariable.StoredVariable("currentApprenticeParty", s -> NBTExtras.listToNBT((Collection)s, NBTUtil::func_186862_a), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, NBTUtil::func_186860_b)), Persistence.ALWAYS);
    public static final IStoredVariable<List<StoredEntity>> DEAD_APPRENTICES = new IStoredVariable.StoredVariable("deadApprentices", s -> NBTExtras.listToNBT((Collection)s, StoredEntity::toNBT), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, StoredEntity::fromNBT)), Persistence.ALWAYS).setSynced();
    public static final IStoredVariable<List<StoredEntity>> ADVENTURING_APPRENTICES = new IStoredVariable.StoredVariable("adventuringApprentices", s -> NBTExtras.listToNBT((Collection)s, StoredEntity::toNBT), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, StoredEntity::fromNBT)), Persistence.ALWAYS).setSynced();
    public static final IStoredVariable<List<StoredEntity>> PENDING_HOME_APPRENTICES = new IStoredVariable.StoredVariable("pendingHomeApprentices", s -> NBTExtras.listToNBT((Collection)s, StoredEntity::toNBT), t -> new ArrayList(NBTExtras.NBTToList((NBTTagList)t, StoredEntity::fromNBT)), Persistence.ALWAYS).setSynced();

    private PlayerData() {
    }

    public static void init() {
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{WIZARD_APPRENTICES});
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{CURRENT_PARTY});
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{DEAD_APPRENTICES});
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{PENDING_HOME_APPRENTICES});
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{ADVENTURING_APPRENTICES});
    }

    private static List<UUID> getUUIDList(EntityPlayer player, IStoredVariable<List<UUID>> variable) {
        WizardData data = WizardData.get((EntityPlayer)player);
        List uuids = (List)data.getVariable(variable);
        if (uuids == null) {
            return new ArrayList<UUID>();
        }
        return uuids;
    }

    private static boolean addToUUIDList(EntityPlayer player, IStoredVariable<List<UUID>> variable, UUID uuid, int limit) {
        WizardData data = WizardData.get((EntityPlayer)player);
        List<UUID> uuidList = PlayerData.getUUIDList(player, variable);
        if (limit == -1 || uuidList.size() < limit && !uuidList.contains(uuid)) {
            uuidList.add(uuid);
            data.setVariable(variable, uuidList);
            return true;
        }
        return false;
    }

    private static boolean removeFromUUIDList(EntityPlayer player, IStoredVariable<List<UUID>> variable, UUID uuid) {
        WizardData data = WizardData.get((EntityPlayer)player);
        List<UUID> uuidList = PlayerData.getUUIDList(player, variable);
        if (uuidList.contains(uuid)) {
            uuidList.remove(uuid);
            data.setVariable(variable, uuidList);
            return true;
        }
        return false;
    }

    private static boolean clearUUIDList(EntityPlayer player, IStoredVariable<List<UUID>> variable) {
        WizardData data = WizardData.get((EntityPlayer)player);
        data.setVariable(variable, new ArrayList());
        return true;
    }

    public static boolean addApprenticeForPlayer(EntityPlayer player, EntityLivingBase entity) {
        return PlayerData.addToUUIDList(player, WIZARD_APPRENTICES, entity.func_110124_au(), Settings.generalSettings.MAXIMUM_APPRENTICE_COUNT);
    }

    public static List<UUID> getApprentices(EntityPlayer player) {
        return PlayerData.getUUIDList(player, WIZARD_APPRENTICES);
    }

    public static boolean removeApprentice(EntityPlayer player, EntityLivingBase entity) {
        return PlayerData.removeFromUUIDList(player, WIZARD_APPRENTICES, entity.func_110124_au());
    }

    public static boolean clearApprentices(EntityPlayer player) {
        return PlayerData.clearUUIDList(player, WIZARD_APPRENTICES);
    }

    public static List<UUID> getParty(EntityPlayer player) {
        return PlayerData.getUUIDList(player, CURRENT_PARTY);
    }

    public static boolean addCurrentToParty(EntityPlayer player, EntityLivingBase entity) {
        return PlayerData.addToUUIDList(player, CURRENT_PARTY, entity.func_110124_au(), Settings.generalSettings.MAXIMUM_PARTY_SIZE);
    }

    public static boolean removeFromCurrentParty(EntityPlayer player, EntityLivingBase entity) {
        return PlayerData.removeFromUUIDList(player, CURRENT_PARTY, entity.func_110124_au());
    }

    public static List<StoredEntity> getDeadApprentices(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        List list = (List)data.getVariable(DEAD_APPRENTICES);
        if (list == null) {
            return new ArrayList<StoredEntity>();
        }
        return list;
    }

    public static List<StoredEntity> getAdventuringApprentices(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        List list = (List)data.getVariable(ADVENTURING_APPRENTICES);
        if (list == null) {
            return new ArrayList<StoredEntity>();
        }
        return list;
    }

    public static List<StoredEntity> getPendingHomeApprentices(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        List list = (List)data.getVariable(PENDING_HOME_APPRENTICES);
        if (list == null) {
            return new ArrayList<StoredEntity>();
        }
        return list;
    }

    public static boolean storeDeadApprentice(EntityPlayer player, EntityLivingBase entity) {
        StoredEntity entityToStore;
        WizardData data = WizardData.get((EntityPlayer)player);
        List<StoredEntity> list = PlayerData.getDeadApprentices(player);
        if (!list.contains(entityToStore = new StoredEntity(entity))) {
            list.add(entityToStore);
            data.setVariable(DEAD_APPRENTICES, list);
            return true;
        }
        return false;
    }

    public static boolean storeAdventuringApprentice(EntityPlayer player, EntityLivingBase entity) {
        StoredEntity entityToStore;
        WizardData data = WizardData.get((EntityPlayer)player);
        List<StoredEntity> list = PlayerData.getAdventuringApprentices(player);
        if (!list.contains(entityToStore = new StoredEntity(entity))) {
            list.add(entityToStore);
            data.setVariable(ADVENTURING_APPRENTICES, list);
            data.sync();
            return true;
        }
        return false;
    }

    public static boolean storeAdventuringApprentice(EntityPlayer player, StoredEntity entityToStore) {
        WizardData data = WizardData.get((EntityPlayer)player);
        List<StoredEntity> list = PlayerData.getAdventuringApprentices(player);
        if (!list.contains(entityToStore)) {
            list.add(entityToStore);
            data.setVariable(ADVENTURING_APPRENTICES, list);
            data.sync();
            return true;
        }
        return false;
    }

    public static boolean storePendingHomeApprentice(EntityPlayer player, EntityLivingBase entity) {
        StoredEntity entityToStore;
        WizardData data = WizardData.get((EntityPlayer)player);
        List<StoredEntity> list = PlayerData.getPendingHomeApprentices(player);
        if (!list.contains(entityToStore = new StoredEntity(entity))) {
            list.add(entityToStore);
            data.setVariable(PENDING_HOME_APPRENTICES, list);
            return true;
        }
        return false;
    }

    public static boolean removeDeadApprentice(EntityPlayer player, UUID uuid) {
        WizardData data = WizardData.get((EntityPlayer)player);
        List<StoredEntity> list = PlayerData.getDeadApprentices(player);
        int index = -1;
        for (int i = 0; i < list.size(); ++i) {
            StoredEntity entity = list.get(i);
            if (!entity.getNbtTagCompound().func_186857_a("UUID").equals(uuid)) continue;
            index = i;
        }
        if (index != -1) {
            list.remove(index);
            data.setVariable(DEAD_APPRENTICES, list);
            return true;
        }
        return false;
    }

    public static boolean removeAdventuringApprentice(EntityPlayer player, UUID uuid) {
        WizardData data = WizardData.get((EntityPlayer)player);
        List<StoredEntity> list = PlayerData.getAdventuringApprentices(player);
        int index = -1;
        for (int i = 0; i < list.size(); ++i) {
            StoredEntity entity = list.get(i);
            if (!entity.getNbtTagCompound().func_186857_a("UUID").equals(uuid)) continue;
            index = i;
        }
        if (index != -1) {
            list.remove(index);
            data.setVariable(ADVENTURING_APPRENTICES, list);
            data.sync();
            return true;
        }
        return false;
    }

    public static boolean removePendingHomeApprentice(EntityPlayer player, UUID uuid) {
        WizardData data = WizardData.get((EntityPlayer)player);
        List<StoredEntity> list = PlayerData.getPendingHomeApprentices(player);
        int index = -1;
        for (int i = 0; i < list.size(); ++i) {
            StoredEntity entity = list.get(i);
            if (!entity.getNbtTagCompound().func_186857_a("UUID").equals(uuid)) continue;
            index = i;
        }
        if (index != -1) {
            list.remove(index);
            data.setVariable(PENDING_HOME_APPRENTICES, list);
            data.sync();
            return true;
        }
        return false;
    }

    public static boolean clearDeadEntitiesList(EntityPlayer player) {
        WizardData data = WizardData.get((EntityPlayer)player);
        data.setVariable(DEAD_APPRENTICES, new ArrayList());
        return false;
    }
}

