/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.data;

import com.windanesz.arcaneapprentices.ArcaneApprentices;
import com.windanesz.arcaneapprentices.Settings;
import electroblob.wizardry.Wizardry;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;

public enum Talent {
    NONE(true, "none"),
    RESEARCHER(true, "researcher"),
    CONDUIT(true, "conduit"),
    EMPOWERING_RESONANCE(true, "empowering_resonance"),
    SPELL_TINKERER(true, "spell_tinkerer"),
    PHASER(true, "phaser"),
    SURVIVOR(true, "survivor"),
    APPAREL_EXPERT(true, "apparel_expert"),
    SWIFT_VOYAGE(true, "swift_voyage"),
    HEALER(true, "healer"),
    ALCHEMY_ADEPT(true, "alchemy_adept"),
    ARTIFICE_MASTER(true, "artifice_master"),
    ANIMAL_WHISPERER(true, "animal_whisperer"),
    REMNANT_TAMER(false, "remnant_tamer"),
    TREASURE_HUNTER(false, "treasure_hunter");

    private final boolean implemented;
    private final String unlocalisedName;

    private Talent(boolean implemented, String unlocalisedName) {
        this.implemented = implemented;
        this.unlocalisedName = unlocalisedName;
    }

    public static Talent fromName(String name) {
        for (Talent talent : Talent.values()) {
            if (!talent.unlocalisedName.equals(name)) continue;
            return talent;
        }
        throw new IllegalArgumentException("No such talent with unlocalised name: " + name);
    }

    @Nullable
    public static Talent fromName(String name, @Nullable Talent fallback) {
        for (Talent talent : Talent.values()) {
            if (!talent.unlocalisedName.equals(name)) continue;
            return talent;
        }
        return fallback;
    }

    public boolean isEnabled() {
        return this.implemented && TalentSettings.isEnabled(this);
    }

    public String getName() {
        return this.unlocalisedName;
    }

    public static Talent getRandom() {
        ArrayList<Talent> talents = new ArrayList<Talent>();
        for (Talent talent : Talent.values()) {
            if (talent == NONE || !talent.isEnabled()) continue;
            talents.add(talent);
        }
        return (Talent)((Object)talents.get(ArcaneApprentices.rand.nextInt(talents.size())));
    }

    public String getDisplayName() {
        return Wizardry.proxy.translate("talent." + this.getName(), new Object[0]);
    }

    public String getDescription() {
        return Wizardry.proxy.translate("talent." + this.getName() + ".desc", new Object[0]);
    }

    public static class TalentSettings {
        public static HashMap<Talent, Boolean> TALENT_SETTINGS = new HashMap();

        public static void init() {
            String[] talentList;
            for (String talent : talentList = Settings.generalSettings.APPRENTICE_TALENTS) {
                String[] parts = talent.split(":");
                String talentName = parts[0];
                boolean enabled = Boolean.parseBoolean(parts[1]);
                if (Talent.fromName(talentName) == NONE) continue;
                TALENT_SETTINGS.put(Talent.fromName(talentName), enabled);
            }
        }

        private static boolean isEnabled(Talent talent) {
            return TALENT_SETTINGS.getOrDefault((Object)talent, true);
        }
    }
}

