/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MessageEntry {
    private String message;
    private int delay;

    public MessageEntry(String message, int delay) {
        this.message = message;
        this.delay = delay;
    }

    public String getMessage() {
        return this.message;
    }

    public int getDelay() {
        return this.delay;
    }

    public void decrementDelay() {
        if (this.delay > 0) {
            --this.delay;
        }
    }

    public static NBTTagCompound serializeMessages(List<MessageEntry> entries) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList messageList = new NBTTagList();
        for (MessageEntry entry : entries) {
            NBTTagCompound messageCompound = new NBTTagCompound();
            String message = entry.getMessage();
            int delay = entry.getDelay();
            messageCompound.func_74778_a("message", message);
            messageCompound.func_74768_a("delay", delay);
            messageList.func_74742_a((NBTBase)messageCompound);
        }
        compound.func_74782_a("messages", (NBTBase)messageList);
        return compound;
    }

    public static List<MessageEntry> deserializeMessages(NBTTagCompound compound) {
        ArrayList<MessageEntry> entries = new ArrayList<MessageEntry>();
        if (compound.func_74764_b("messages")) {
            NBTTagList messageList = compound.func_150295_c("messages", (int)compound.func_74732_a());
            for (int i = 0; i < messageList.func_74745_c(); ++i) {
                NBTTagCompound messageCompound = messageList.func_150305_b(i);
                String message = messageCompound.func_74779_i("message");
                int value = messageCompound.func_74762_e("delay");
                MessageEntry entry = new MessageEntry(message, value);
                entries.add(entry);
            }
        }
        return entries;
    }

    public static MessageEntry removeNextMessage(List<MessageEntry> messageList) {
        if (!messageList.isEmpty()) {
            return messageList.remove(0);
        }
        return null;
    }

    public static MessageEntry peekNextMessage(List<MessageEntry> messageList) {
        if (!messageList.isEmpty()) {
            return messageList.get(0);
        }
        return null;
    }
}

