/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.entity.ai;

import com.windanesz.arcaneapprentices.Utils;
import com.windanesz.arcaneapprentices.data.Speech;
import com.windanesz.arcaneapprentices.entity.living.EntityWizardInitiate;
import com.windanesz.arcaneapprentices.handler.XpProgression;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.packet.PacketNPCCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WizardAIAttackSpellWithCost
extends EntityAIBase {
    private final EntityWizardInitiate npc;
    private EntityLivingBase target;
    private int cooldown = -1;
    private final int baseCooldown;
    private int continuousSpellTimer;
    private boolean proxyBuffs;
    private final int continuousSpellDuration;
    private final double speed;
    private int seeTime;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private int timeSinceDisengage = 0;
    private Spell currentSpell = Spells.none;

    public WizardAIAttackSpellWithCost(EntityWizardInitiate wizard, double speed, float maxDistance, int baseCooldown, int continuousSpellDuration, boolean proxyBuffs) {
        this.npc = wizard;
        this.baseCooldown = baseCooldown;
        this.continuousSpellDuration = continuousSpellDuration;
        this.speed = speed;
        this.maxAttackDistance = maxDistance * maxDistance;
        this.proxyBuffs = proxyBuffs;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!(this.npc.func_184614_ca().func_77973_b() instanceof ItemWand)) {
            return false;
        }
        EntityLivingBase entitylivingbase = this.npc.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        this.target = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.npc.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.target = null;
        this.seeTime = 0;
        this.cooldown = -1;
        this.setContinuousSpellAndNotify(Spells.none, new SpellModifiers());
        this.continuousSpellTimer = 0;
    }

    private void setContinuousSpellAndNotify(Spell spell, SpellModifiers modifiers) {
        this.npc.setContinuousSpell(spell);
        WizardryPacketHandler.net.sendToAllAround((IMessage)new PacketNPCCastSpell.Message(this.npc.func_145782_y(), this.target == null ? -1 : this.target.func_145782_y(), EnumHand.MAIN_HAND, spell, modifiers), new NetworkRegistry.TargetPoint(this.npc.field_71093_bK, this.npc.field_70165_t, this.npc.field_70163_u, this.npc.field_70161_v, 128.0));
    }

    public void func_75246_d() {
        Entity owner;
        double distanceSq = this.npc.func_70092_e(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
        boolean targetIsVisible = this.npc.func_70635_at().func_75522_a((Entity)this.target);
        this.seeTime = targetIsVisible ? ++this.seeTime : 0;
        if (this.npc.func_70638_az() != null && this.npc.field_70170_p.field_73012_v.nextInt(200) == 0) {
            this.npc.sayWithoutSpam(new TextComponentTranslation(Speech.WIZARD_COMBAT.getRandom(), new Object[]{this.npc.func_70638_az().func_145748_c_()}));
        }
        if (distanceSq <= (double)this.maxAttackDistance && this.seeTime >= 20) {
            this.npc.func_70661_as().func_75499_g();
        } else {
            this.npc.func_70661_as().func_75497_a((Entity)this.target, this.speed);
        }
        this.npc.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        if (this.continuousSpellTimer > 0) {
            if (this.target == null || this.target.field_70128_L) {
                this.func_75251_c();
            }
            --this.continuousSpellTimer;
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible || MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(SpellCastEvent.Source.NPC, this.npc.getContinuousSpell(), (EntityLivingBase)this.npc, this.npc.getModifiers(), this.continuousSpellDuration - this.continuousSpellTimer)) || !this.npc.getContinuousSpell().cast(this.npc.field_70170_p, (EntityLiving)this.npc, EnumHand.MAIN_HAND, this.continuousSpellDuration - this.continuousSpellTimer, this.target, this.npc.getModifiers()) || this.continuousSpellTimer == 0) {
                this.continuousSpellTimer = 0;
                this.cooldown = this.npc.getContinuousSpell().getCooldown() + this.baseCooldown;
                this.setContinuousSpellAndNotify(Spells.none, new SpellModifiers());
                return;
            }
            if (this.continuousSpellDuration - this.continuousSpellTimer == 1) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, this.npc.getContinuousSpell(), (EntityLivingBase)this.npc, this.npc.getModifiers()));
            }
        } else if (--this.cooldown == 0) {
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible) {
                return;
            }
            double dx = this.target.field_70165_t - this.npc.field_70165_t;
            double dz = this.target.field_70161_v - this.npc.field_70161_v;
            ArrayList<Spell> spells = new ArrayList<Spell>(this.npc.getSpells());
            spells.removeIf(spell -> spell == Spells.none);
            spells.removeIf(this.npc::isSpellDisabled);
            if (spells.size() > 0 && !this.npc.field_70170_p.field_72995_K) {
                while (!spells.isEmpty()) {
                    Spell spell2;
                    if (this.npc.func_184614_ca().func_77973_b() instanceof ItemWand) {
                        Tier wandTier = ((ItemWand)this.npc.func_184614_ca().func_77973_b()).tier;
                        if (this.npc.getCurrentTierCap() < wandTier.ordinal()) {
                            this.npc.sayWithoutSpam(new TextComponentTranslation(Speech.WAND_TIER_TOO_HIGH.getRandom(), new Object[0]));
                            spell2 = null;
                            break;
                        }
                        spell2 = Utils.getRandomItem(spells);
                        if (this.npc.func_110143_aJ() < this.npc.func_110138_aP() * 0.4f) {
                            List<Spell> healSpells = Arrays.asList(Spells.heal, Spells.greater_heal, Spells.healing_aura, Spells.group_heal);
                            List<Spell> matches = WizardAIAttackSpellWithCost.getMatches(spells, healSpells);
                            if (!matches.isEmpty()) {
                                spell2 = Utils.getRandomItem(matches);
                            }
                        } else if (this.npc.func_70027_ad()) {
                            List<Spell> matches;
                            Spell extinguish = (Spell)Spell.registry.getValue(new ResourceLocation("ancientspellcraft:extinguish"));
                            ArrayList<Spell> fireCounters = new ArrayList<Spell>(Arrays.asList(Spells.fire_resistance, Spells.blink));
                            if (extinguish != null) {
                                fireCounters.add(extinguish);
                            }
                            if (!(matches = WizardAIAttackSpellWithCost.getMatches(spells, fireCounters)).isEmpty()) {
                                spell2 = Utils.getRandomItem(matches);
                            }
                        }
                        ItemStack wandStack = this.npc.func_184614_ca();
                        int requiredMana = spell2.getCost();
                        int currentMana = ((ItemWand)wandStack.func_77973_b()).getMana(wandStack);
                        if (currentMana < requiredMana) {
                            this.npc.sayWithoutSpam(new TextComponentTranslation(Speech.WIZARD_LOW_MANA.getRandom(), new Object[0]));
                            spells.remove(spell2);
                            spell2 = null;
                        }
                    } else {
                        return;
                    }
                    SpellModifiers modifiers = this.npc.getModifiers();
                    if (spell2 != null && this.npc.setCurrentSpell(spell2) && this.attemptCastSpell(spell2, modifiers)) {
                        this.npc.field_70177_z = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        this.npc.addExperience(XpProgression.getXpGainPerSpellCast());
                        ItemStack stack = this.npc.func_184614_ca();
                        ItemWand wand = (ItemWand)stack.func_77973_b();
                        wand.consumeMana(this.npc.func_184614_ca(), spell2.getCost(), (EntityLivingBase)this.npc);
                        if (wand.tier.level < Tier.MASTER.level) {
                            int progression = (int)((float)spell2.getCost() * modifiers.get("progression"));
                            WandHelper.addProgression((ItemStack)stack, (int)progression);
                            if (!Wizardry.settings.legacyWandLevelling) {
                                Tier nextTier = wand.tier.next();
                                int excess = WandHelper.getProgression((ItemStack)stack) - nextTier.getProgression();
                                if (excess >= 0 && excess < progression) {
                                    this.npc.func_184185_a(WizardrySounds.ITEM_WAND_LEVELUP, 1.25f, 1.0f);
                                }
                            }
                        }
                        return;
                    }
                    spells.remove(spell2);
                }
            }
        } else if (this.cooldown < 0) {
            this.cooldown = this.baseCooldown;
        }
        EntityLivingBase target = this.npc.func_70638_az();
        boolean regrouping = false;
        if (this.npc.getTask() == EntityWizardInitiate.Task.FOLLOW && (owner = this.npc.func_70902_q()) instanceof EntityPlayer && owner.func_70032_d((Entity)this.npc) > 8.0f) {
            regrouping = true;
        }
        if (this.timeSinceDisengage == 0) {
            if (target != null) {
                boolean flag1;
                double d0 = this.npc.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
                boolean flag = this.npc.func_70635_at().func_75522_a((Entity)target);
                boolean bl = flag1 = this.seeTime > 0;
                if (flag != flag1) {
                    this.seeTime = 0;
                }
                this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                if (d0 <= (double)this.maxAttackDistance * (double)0.1f && this.seeTime >= 20) {
                    this.npc.func_70661_as().func_75499_g();
                    ++this.strafingTime;
                } else if (this.npc.func_70068_e((Entity)target) > 32.0) {
                    this.npc.func_70661_as().func_75497_a((Entity)target, this.speed);
                    this.strafingTime = -1;
                }
                if (this.strafingTime >= 20) {
                    if ((double)this.npc.func_70681_au().nextFloat() < 0.3) {
                        boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                    }
                    if ((double)this.npc.func_70681_au().nextFloat() < 0.3) {
                        this.strafingBackwards = !this.strafingBackwards;
                    }
                    this.strafingTime = 0;
                }
                if (this.strafingTime > -1) {
                    if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                    if (!regrouping) {
                        this.npc.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.45f : 0.45f, this.strafingClockwise ? 0.3f : -0.3f);
                        this.npc.func_70625_a((Entity)target, 30.0f, 30.0f);
                    } else {
                        this.npc.func_70661_as().func_75499_g();
                        this.npc.func_70661_as().func_75497_a(this.npc.func_70902_q(), this.speed);
                        this.npc.func_70671_ap().func_75651_a(this.npc.func_70902_q(), 30.0f, 30.0f);
                    }
                } else {
                    this.npc.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                }
            }
        } else {
            --this.timeSinceDisengage;
        }
    }

    public boolean attemptCastSpell(Spell spell, SpellModifiers modifiers) {
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.NPC, spell, (EntityLivingBase)this.npc, modifiers))) {
            return false;
        }
        if (spell.cast(this.npc.field_70170_p, (EntityLiving)this.npc, EnumHand.MAIN_HAND, 0, this.target, modifiers)) {
            if (spell.isContinuous) {
                this.continuousSpellTimer = this.continuousSpellDuration - 1;
                this.setContinuousSpellAndNotify(spell, modifiers);
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, spell, (EntityLivingBase)this.npc, modifiers));
                this.cooldown = this.baseCooldown + spell.getCooldown();
                if (spell.requiresPacket()) {
                    PacketNPCCastSpell.Message msg = new PacketNPCCastSpell.Message(this.npc.func_145782_y(), this.target.func_145782_y(), EnumHand.MAIN_HAND, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, this.npc.field_70170_p.field_73011_w.getDimension());
                }
                if (!this.npc.field_70170_p.field_72995_K && this.npc.func_184614_ca().func_77973_b() instanceof ItemScroll) {
                    this.npc.func_184614_ca().func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }

    private static List<Spell> getMatches(List<Spell> sourceList, List<Spell> compareList) {
        ArrayList<Spell> matches = new ArrayList<Spell>();
        for (Spell sourceObject : sourceList) {
            if (!compareList.contains(sourceObject)) continue;
            matches.add(sourceObject);
        }
        return matches;
    }
}

