/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.entity.living;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.windanesz.arcaneapprentices.ArcaneApprentices;
import com.windanesz.arcaneapprentices.Settings;
import com.windanesz.arcaneapprentices.Utils;
import com.windanesz.arcaneapprentices.client.gui.AAGuiHandler;
import com.windanesz.arcaneapprentices.data.JourneyType;
import com.windanesz.arcaneapprentices.data.PlayerData;
import com.windanesz.arcaneapprentices.data.Speech;
import com.windanesz.arcaneapprentices.data.Talent;
import com.windanesz.arcaneapprentices.entity.MessageEntry;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIAttackMelee;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIAttackRangedBow;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIAttackSpellWithCost;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIFollowOwner;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIGoHome;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIIdentify;
import com.windanesz.arcaneapprentices.entity.ai.WizardAILookAround;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIOwnerHurtByTarget;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIOwnerHurtTarget;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIPanicAtLowHP;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIStudy;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIWander;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIWatchClosest;
import com.windanesz.arcaneapprentices.entity.ai.WizardAIWatchClosest2;
import com.windanesz.arcaneapprentices.handler.EventHandler;
import com.windanesz.arcaneapprentices.handler.XpProgression;
import com.windanesz.arcaneapprentices.inventory.ContainerWizardInitiateInventory;
import com.windanesz.arcaneapprentices.inventory.WizardInventory;
import com.windanesz.arcaneapprentices.items.ItemArtefactWithSlots;
import com.windanesz.arcaneapprentices.registry.AAAdvancementTriggers;
import com.windanesz.arcaneapprentices.registry.AAItems;
import com.windanesz.arcaneapprentices.registry.LootRegistry;
import com.windanesz.wizardryutils.tools.WizardryUtilsTools;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.misc.WildcardTradeList;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Banish;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.block.BlockBed;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.INpc;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityWizardInitiate
extends EntityCreature
implements INpc,
ISpellCaster,
IEntityAdditionalSpawnData,
IInventoryChangedListener,
IEntityOwnable,
IRangedAttackMob {
    public static final float RARE_EVENT_CHANCE = 0.05f;
    public static final int OFF_HAND_SLOT = 1;
    public static final int ARTEFACT_SLOT = 21;
    private static final float ELEMENTAL_PROGRESSION_MODIFIER = 1.2f;
    private static final float DISCOVERY_PROGRESSION_MODIFIER = 5.0f;
    private static final float SECOND_TIME_PROGRESSION_MODIFIER = 1.5f;
    private static final float MAX_PROGRESSION_REDUCTION = 0.75f;
    private static final DataParameter<Integer> HEAL_COOLDOWN = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ELEMENT = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<String> CONTINUOUS_SPELL = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> CURRENT_SPELL = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Integer> SPELL_COUNTER = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LEVEL = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CURRENT_TASK = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PREVIOUS_TASK_BEFORE_SLEEPING = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> XP = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> TIME_TILL_NEXT_SCHEDULED_MESSAGE = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> FOOD_LEVEL = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> FOOD_SATURATION = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> STUDY_PROGRESS = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<NBTTagCompound> STUDIED_ITEM = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SLEEPING = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<NBTTagCompound> KNOWN_SPELLS = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<NBTTagCompound> DISABLED_SPELLS = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<NBTTagCompound> SCHEDULED_MESSAGES = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<BlockPos> BED_POSITION = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TALENT = EntityDataManager.func_187226_a(EntityWizardInitiate.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final int FEET_INDEX = 5;
    public static final int LEGS_INDEX = 4;
    public static final int CHEST_INDEX = 3;
    public static final int HEAD_INDEX = 2;
    public static final int OFFHAND_INDEX = 1;
    public static final int MAINHAND_INDEX = 0;
    public int textureIndex = 0;
    public int adventureRemainingDuration = -1;
    public WizardInventory inventory;
    public BlockPos currentStayPos = new BlockPos(0, 0, 0);
    protected Predicate<Entity> targetSelector;
    List<MessageEntry> scheduledMessages = new ArrayList<MessageEntry>();
    private JourneyType journeyType = JourneyType.NOT_ADVENTURING;
    private WizardAIAttackSpellWithCost spellCastingAI = new WizardAIAttackSpellWithCost(this, 0.5, 14.0f, 30, 50, false);
    private WizardAIAttackMelee meleeAI = new WizardAIAttackMelee(this, 0.5, false);
    private WizardAIAttackRangedBow<EntityWizardInitiate> bowAI = new WizardAIAttackRangedBow<EntityWizardInitiate>(this, 0.5, 25, 15.0f);
    private MerchantRecipeList trades;
    private BlockPos lectern;
    private boolean isEating = false;
    private int foodTickTimer = 0;
    private Location home = new Location(BlockPos.field_177992_a, 0);
    @Nullable
    private EntityPlayer customer;
    private int timeUntilReset;
    private boolean updateRecipes;
    private IItemHandler itemHandler = null;
    private Set<BlockPos> towerBlocks;
    private float wizardWidth = -1.0f;
    private float wizardHeight;
    private int chatCooldown = 0;
    private int rareEventCooldown = 0;
    private final int rareEventMaxCooldown = 6000;

    public EntityWizardInitiate(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.spellCastingAI);
        this.func_70105_a(0.6f, 1.95f);
        this.initInventory();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAL_COOLDOWN, (Object)-1);
        this.field_70180_af.func_187214_a(ELEMENT, (Object)0);
        this.field_70180_af.func_187214_a(CONTINUOUS_SPELL, (Object)"ebwizardry:none");
        this.field_70180_af.func_187214_a(CURRENT_SPELL, (Object)"ebwizardry:none");
        this.field_70180_af.func_187214_a(SPELL_COUNTER, (Object)0);
        this.field_70180_af.func_187214_a(LEVEL, (Object)1);
        this.field_70180_af.func_187214_a(CURRENT_TASK, (Object)0);
        this.field_70180_af.func_187214_a(PREVIOUS_TASK_BEFORE_SLEEPING, (Object)0);
        this.field_70180_af.func_187214_a(XP, (Object)0);
        this.field_70180_af.func_187214_a(TIME_TILL_NEXT_SCHEDULED_MESSAGE, (Object)0);
        this.field_70180_af.func_187214_a(FOOD_LEVEL, (Object)Float.valueOf(20.0f));
        this.field_70180_af.func_187214_a(FOOD_SATURATION, (Object)Float.valueOf(5.0f));
        this.field_70180_af.func_187214_a(IS_CHILD, (Object)false);
        this.field_70180_af.func_187214_a(BED_POSITION, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(IS_SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(STUDY_PROGRESS, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(KNOWN_SPELLS, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(DISABLED_SPELLS, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(SCHEDULED_MESSAGES, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(STUDIED_ITEM, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(TALENT, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new WizardAIPanicAtLowHP(this, 1.15));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new WizardAIFollowOwner(this, 0.7, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new WizardAIGoHome(this, 0.7, 20.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new WizardAIStudy(this, 10, 1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new WizardAIIdentify(this, 10, 1));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new WizardAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new WizardAIWander(this, 0.4, 10));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new WizardAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new WizardAILookAround(this, 8.0f, 0.1f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new WizardAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new WizardAIOwnerHurtTarget(this));
        this.targetSelector = entity -> entity != null && !entity.func_82150_aj() && entity != this.func_70902_q() && AllyDesignationSystem.isValidTarget((Entity)this, (Entity)entity) && (entity instanceof IMob || entity instanceof ISummonedCreature || Arrays.asList(Wizardry.settings.summonedCreatureTargetsWhitelist).contains(EntityList.func_191306_a(entity.getClass()))) && !Arrays.asList(Wizardry.settings.summonedCreatureTargetsBlacklist).contains(EntityList.func_191306_a(entity.getClass()));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, true, this.targetSelector));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    public static SpellModifiers calculateModifiers(ItemStack stack, EntityWizardInitiate npc, Spell spell) {
        SpellModifiers modifiers = new SpellModifiers();
        int level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.range_upgrade);
        if (level > 0) {
            modifiers.set(WizardryItems.range_upgrade, 1.0f + (float)level * Constants.RANGE_INCREASE_PER_LEVEL, true);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.duration_upgrade)) > 0) {
            modifiers.set(WizardryItems.duration_upgrade, 1.0f + (float)level * Constants.DURATION_INCREASE_PER_LEVEL, false);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.blast_upgrade)) > 0) {
            modifiers.set(WizardryItems.blast_upgrade, 1.0f + (float)level * Constants.BLAST_RADIUS_INCREASE_PER_LEVEL, true);
        }
        if ((level = WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.cooldown_upgrade)) > 0) {
            modifiers.set(WizardryItems.cooldown_upgrade, 1.0f - (float)level * Constants.COOLDOWN_REDUCTION_PER_LEVEL, true);
        }
        float progressionModifier = 0.25f;
        if (stack.func_77973_b() instanceof ItemWand && ((ItemWand)stack.func_77973_b()).element == spell.getElement()) {
            modifiers.set("potency", 1.0f + (float)(((ItemWand)stack.func_77973_b()).tier.level + 1) * Constants.POTENCY_INCREASE_PER_TIER, true);
            progressionModifier *= 1.2f;
        }
        modifiers.set("progression", progressionModifier, false);
        return modifiers;
    }

    public static void mergeItemStacks(IInventory inventory) {
        boolean merged;
        int slots = inventory.func_70302_i_();
        do {
            merged = false;
            block1: for (int i = 0; i < slots - 1; ++i) {
                ItemStack currentStack = inventory.func_70301_a(i);
                if (currentStack.func_190926_b() || currentStack.func_190916_E() >= currentStack.func_77976_d()) continue;
                for (int j = i + 1; j < slots; ++j) {
                    ItemStack targetStack = inventory.func_70301_a(j);
                    if (!EntityWizardInitiate.areStacksCompatible(currentStack, targetStack)) continue;
                    int spaceInStack = currentStack.func_77976_d() - currentStack.func_190916_E();
                    int transferAmount = Math.min(spaceInStack, targetStack.func_190916_E());
                    currentStack.func_190917_f(transferAmount);
                    targetStack.func_190918_g(transferAmount);
                    if (targetStack.func_190926_b()) {
                        inventory.func_70299_a(j, ItemStack.field_190927_a);
                    }
                    merged = true;
                    if (currentStack.func_190916_E() >= currentStack.func_77976_d()) continue block1;
                }
            }
        } while (merged);
    }

    private static boolean areStacksCompatible(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_179545_c((ItemStack)stack1, (ItemStack)stack2) && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public JourneyType getJourneyType() {
        return this.journeyType;
    }

    public void setJourneyType(JourneyType journeyType) {
        this.journeyType = journeyType;
    }

    public boolean verifyWandManaRequirementForJourney(JourneyType journeyType) {
        if (this.func_184614_ca().func_77973_b() instanceof ItemWand) {
            ItemWand wand = (ItemWand)this.func_184614_ca().func_77973_b();
            float manaPercent = (float)wand.getMana(this.func_184614_ca()) / (float)wand.getManaCapacity(this.func_184614_ca());
            return manaPercent > 0.5f;
        }
        return false;
    }

    public void goOnJourney() {
        if (!this.field_70170_p.field_72995_K && this.getJourneyType() != JourneyType.NOT_ADVENTURING && this.func_70902_q() instanceof EntityPlayer) {
            if (this.getHome().pos == BlockPos.field_177992_a) {
                this.setHome(new Location(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), this.field_71093_bK));
            }
            Speech.WIZARD_GOING_ON_JOURNEY.say(this);
            this.consumeFoodForJourney();
            this.consumeManaForJourney();
            this.adventureRemainingDuration = this.journeyType.getRandomAdventureDuration(this);
            if (PlayerData.storeAdventuringApprentice((EntityPlayer)this.func_70902_q(), (EntityLivingBase)this)) {
                this.field_70170_p.func_72900_e((Entity)this);
                AAAdvancementTriggers.apprentice_go_on_journey.triggerFor((EntityPlayer)this.func_70902_q());
            }
        }
    }

    public void consumeFoodForJourney() {
        if (!Settings.journeySettings.JOURNEY_REQUIRE_FOOD) {
            return;
        }
        String duration = this.getJourneyType().getDuration();
        float cost = duration.equals("SHORT") ? 30.0f : (duration.equals("MEDIUM") ? 90.0f : 200.0f);
        cost *= Settings.journeySettings.JOURNEY_FOOD_REQUIREMENT_MODIFIER;
        block0: for (int i = 1; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (!(cost > 0.0f) || !(stack.func_77973_b() instanceof ItemFood) || stack.func_77973_b() == Items.field_151078_bh) continue;
            float healAmount = ((ItemFood)stack.func_77973_b()).func_150905_g(stack);
            int count = stack.func_190916_E();
            for (int j = 0; j < count; ++j) {
                stack.func_190918_g(1);
                if ((cost -= healAmount) < 0.0f) continue block0;
            }
        }
    }

    public void consumeManaForJourney() {
        String duration = this.getJourneyType().getDuration();
        float cost = duration.equals("SHORT") ? 0.2f : (duration.equals("MEDIUM") ? 0.5f : 0.7f);
        cost += this.field_70146_Z.nextBoolean() ? -((float)this.field_70146_Z.nextInt(3)) / 10.0f : (float)this.field_70146_Z.nextInt(3) / 10.0f;
        if (this.func_184614_ca().func_77973_b() instanceof ItemWand) {
            ItemWand wand = (ItemWand)this.func_184614_ca().func_77973_b();
            float v = (float)(Math.sqrt(wand.getManaCapacity(this.func_184614_ca())) * 30.0 * (double)cost);
            wand.setMana(this.func_184614_ca(), (int)Math.max(0.0f, (float)wand.getMana(this.func_184614_ca()) - v));
        }
    }

    public Location getHome() {
        return this.home;
    }

    public void setHome(Location home) {
        this.home = home;
    }

    private void resetTimeTillNextScheduledMessage() {
        this.field_70180_af.func_187227_b(TIME_TILL_NEXT_SCHEDULED_MESSAGE, (Object)0);
    }

    private int getTimeTillNextScheduledMessage() {
        return (Integer)this.field_70180_af.func_187225_a(TIME_TILL_NEXT_SCHEDULED_MESSAGE);
    }

    private void setTimeTillNextScheduledMessage(int timer) {
        this.field_70180_af.func_187227_b(TIME_TILL_NEXT_SCHEDULED_MESSAGE, (Object)timer);
    }

    public boolean hasScheduledMessage() {
        return !this.scheduledMessages.isEmpty();
    }

    public int getChatCooldown() {
        return this.chatCooldown;
    }

    public void resetChatCooldown() {
        this.chatCooldown = 200 + this.field_70170_p.field_73012_v.nextInt(100);
    }

    public void decrementChatCooldown() {
        if (this.chatCooldown > 0) {
            --this.chatCooldown;
        }
    }

    public void decrementScheduledMessageTimer() {
        if (!this.scheduledMessages.isEmpty()) {
            MessageEntry nextMessage = this.scheduledMessages.get(0);
            nextMessage.decrementDelay();
        }
    }

    public void decrementRareEventCooldown() {
        if (this.rareEventCooldown > 0) {
            --this.rareEventCooldown;
        }
    }

    public void scheduleNextMessage() {
        MessageEntry entry = MessageEntry.peekNextMessage(MessageEntry.deserializeMessages(this.getScheduledMessagesCompound()));
        if (entry != null) {
            this.setTimeTillNextScheduledMessage(entry.getDelay());
        }
    }

    private void sayNextScheduledMessage() {
        MessageEntry entry;
        if (!this.scheduledMessages.isEmpty() && (entry = this.scheduledMessages.get(0)) != null) {
            if (entry.getDelay() > 0) {
                entry.decrementDelay();
            } else {
                this.sayImmediately(new TextComponentTranslation(entry.getMessage(), new Object[0]));
                this.scheduledMessages.remove(0);
            }
        }
    }

    public void sayWithoutSpam(String message) {
        if (this.chatCooldown == 0) {
            WizardryUtilsTools.sendMessage((Entity)this.func_70902_q(), (String)"message.arcaneapprentices:wizard_chat_message", (boolean)false, (Object[])new Object[]{this.getChatPrefix(), message});
            this.resetChatCooldown();
        }
    }

    public void sayWithoutSpam(TextComponentTranslation message) {
        if (this.func_70902_q() != null) {
            this.sayWithoutSpam((EntityPlayer)this.func_70902_q(), message);
        }
    }

    public void sayWithoutSpam(EntityPlayer player, TextComponentTranslation message) {
        if (this.chatCooldown == 0 && player != null && this.func_70032_d((Entity)player) < 20.0f) {
            WizardryUtilsTools.sendMessage((Entity)player, (String)"message.arcaneapprentices:wizard_chat_message", (boolean)false, (Object[])new Object[]{this.getChatPrefix(), message});
            this.func_70625_a((Entity)player, 30.0f, 30.0f);
            this.resetChatCooldown();
        }
    }

    public void sayImmediately(TextComponentTranslation message) {
        if (this.func_70902_q() != null) {
            this.sayImmediately((EntityPlayer)this.func_70902_q(), message);
        }
    }

    public void sayImmediately(EntityPlayer player, TextComponentTranslation message) {
        if (player != null && this.func_70032_d((Entity)player) < 20.0f) {
            this.func_70625_a((Entity)player, 30.0f, 30.0f);
            WizardryUtilsTools.sendMessage((Entity)player, (String)"message.arcaneapprentices:wizard_chat_message", (boolean)false, (Object[])new Object[]{this.getChatPrefix(), message});
            this.resetChatCooldown();
        }
    }

    public int getRareEventCooldown() {
        return this.rareEventCooldown;
    }

    public void setRareEventCooldown(int rareEventCooldown) {
        this.rareEventCooldown = rareEventCooldown;
    }

    public boolean rareEventReady() {
        return this.getRareEventCooldown() == 0;
    }

    public void resetRareEventCooldown() {
        this.rareEventCooldown = 6000;
    }

    public void resetRareEventCooldown(float totalPercent) {
        this.rareEventCooldown = (int)(6000.0f * totalPercent);
    }

    protected final void func_70105_a(float width, float height) {
        boolean flag = this.wizardWidth > 0.0f && this.wizardHeight > 0.0f;
        this.wizardWidth = width;
        this.wizardHeight = height;
        if (!flag) {
            this.multiplySize(1.0f);
        }
    }

    protected final void multiplySize(float size) {
        super.func_70105_a(this.wizardWidth * size, this.wizardHeight * size);
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    public boolean func_70631_g_() {
        return (float)this.getLevel() / (float)XpProgression.getMaxLevel() <= 0.5f;
    }

    public void setChild(boolean isChild) {
        this.func_184212_Q().func_187227_b(IS_CHILD, (Object)isChild);
        this.setChildSize(isChild);
    }

    public boolean isLyingInBed() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_SLEEPING);
    }

    public void setLyingInBed(boolean sleep) {
        this.func_184212_Q().func_187227_b(IS_SLEEPING, (Object)sleep);
    }

    public float getStudyProgress() {
        return ((Float)this.func_184212_Q().func_187225_a(STUDY_PROGRESS)).floatValue();
    }

    public ItemStack getStudiedItem() {
        return new ItemStack((NBTTagCompound)this.func_184212_Q().func_187225_a(STUDIED_ITEM));
    }

    public void setStudiedItem(ItemStack stack) {
        this.func_184212_Q().func_187227_b(STUDIED_ITEM, (Object)stack.func_77955_b(new NBTTagCompound()));
    }

    public float getFoodLevel() {
        return ((Float)this.func_184212_Q().func_187225_a(FOOD_LEVEL)).floatValue();
    }

    public void setFoodLevel(float foodLevel) {
        this.func_184212_Q().func_187227_b(FOOD_LEVEL, (Object)Float.valueOf(Math.min(20.0f, Math.max(0.0f, foodLevel))));
    }

    public void modifyFoodLevel(float amount) {
        float newAmount = this.getFoodLevel() + amount;
        this.setFoodLevel(newAmount);
    }

    public float getSaturation() {
        return ((Float)this.func_184212_Q().func_187225_a(FOOD_SATURATION)).floatValue();
    }

    public void setSaturation(float amount) {
        this.func_184212_Q().func_187227_b(FOOD_SATURATION, (Object)Float.valueOf(Math.min(this.getFoodLevel(), Math.max(0.0f, amount))));
    }

    public void modifySaturation(float amount) {
        float newAmount = this.getSaturation() + amount;
        this.setSaturation(newAmount);
    }

    public BlockPos getBedPos() {
        return (BlockPos)this.func_184212_Q().func_187225_a(BED_POSITION);
    }

    public void setBedPos(BlockPos pos) {
        this.func_184212_Q().func_187227_b(BED_POSITION, (Object)pos);
    }

    public void addStudyProgress(float amount, ItemStack stack) {
        float oldAmount = this.getStudyProgress();
        float newAmount = Math.min(1.0f, oldAmount + amount);
        this.func_184212_Q().func_187227_b(STUDY_PROGRESS, (Object)Float.valueOf(newAmount));
        this.setStudiedItem(stack);
    }

    public void resetStudyProgress() {
        this.func_184212_Q().func_187227_b(STUDY_PROGRESS, (Object)Float.valueOf(0.0f));
    }

    public boolean isStudyComplete() {
        return this.getStudyProgress() == 1.0f;
    }

    public NBTTagCompound getSpellCompound() {
        return (NBTTagCompound)this.field_70180_af.func_187225_a(KNOWN_SPELLS);
    }

    protected void setSpellCompound(NBTTagCompound tag) {
        this.field_70180_af.func_187227_b(KNOWN_SPELLS, (Object)tag);
    }

    public void removeAllKnownSpells() {
        this.field_70180_af.func_187227_b(KNOWN_SPELLS, (Object)new NBTTagCompound());
        this.field_70180_af.func_187227_b(DISABLED_SPELLS, (Object)new NBTTagCompound());
    }

    private NBTTagCompound getDisabledSpellCompound() {
        return (NBTTagCompound)this.field_70180_af.func_187225_a(DISABLED_SPELLS);
    }

    protected void setDisabledSpellCompound(NBTTagCompound tag) {
        this.field_70180_af.func_187227_b(DISABLED_SPELLS, (Object)tag);
    }

    public NBTTagCompound getScheduledMessagesCompound() {
        return (NBTTagCompound)this.field_70180_af.func_187225_a(SCHEDULED_MESSAGES);
    }

    private void setScheduledMessagesCompound(NBTTagCompound nbt) {
        this.field_70180_af.func_187227_b(SCHEDULED_MESSAGES, (Object)nbt);
    }

    public void scheduleMessage(MessageEntry messageEntry) {
        this.scheduledMessages.add(messageEntry);
    }

    public float func_70047_e() {
        float f = 1.74f;
        if (this.func_70631_g_()) {
            f = (float)((double)f - 0.81);
        }
        return f;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (IS_CHILD.equals(key)) {
            this.setChildSize(this.func_70631_g_());
        }
        super.func_184206_a(key);
    }

    public void setChildSize(boolean isChild) {
        this.multiplySize(isChild ? 0.5f : 1.0f);
    }

    private int getHealCooldown() {
        return (Integer)this.field_70180_af.func_187225_a(HEAL_COOLDOWN);
    }

    private void setHealCooldown(int cooldown) {
        this.field_70180_af.func_187227_b(HEAL_COOLDOWN, (Object)cooldown);
    }

    public Element getElement() {
        return Element.values()[(Integer)this.field_70180_af.func_187225_a(ELEMENT)];
    }

    public void setElement(Element element) {
        this.field_70180_af.func_187227_b(ELEMENT, (Object)element.ordinal());
    }

    public List<Spell> getSpells() {
        return (List)NBTExtras.NBTToList((NBTTagList)this.getSpellCompound().func_150295_c("spells", 3), tag -> Spell.byMetadata((int)tag.func_150287_d()));
    }

    public List<Spell> getDisabledSpells() {
        return (List)NBTExtras.NBTToList((NBTTagList)this.getDisabledSpellCompound().func_150295_c("spells", 3), tag -> Spell.byMetadata((int)tag.func_150287_d()));
    }

    public SpellModifiers getModifiers() {
        return EntityWizardInitiate.calculateModifiers(this.func_184614_ca(), this, this.getCurrentSpell());
    }

    public SpellModifiers getModifiers(Spell spell) {
        return EntityWizardInitiate.calculateModifiers(this.func_184614_ca(), this, spell);
    }

    public Spell getContinuousSpell() {
        return Spell.get((String)((String)this.field_70180_af.func_187225_a(CONTINUOUS_SPELL)));
    }

    public void setContinuousSpell(Spell spell) {
        this.field_70180_af.func_187227_b(CONTINUOUS_SPELL, (Object)spell.getRegistryName().toString());
    }

    public boolean setCurrentSpell(Spell spell) {
        this.field_70180_af.func_187227_b(CURRENT_SPELL, (Object)spell.getRegistryName().toString());
        return true;
    }

    public Spell getCurrentSpell() {
        return Spell.get((String)((String)this.field_70180_af.func_187225_a(CURRENT_SPELL)));
    }

    public int getSpellCounter() {
        return (Integer)this.field_70180_af.func_187225_a(SPELL_COUNTER);
    }

    public void setSpellCounter(int count) {
        this.field_70180_af.func_187227_b(SPELL_COUNTER, (Object)count);
    }

    public int getAimingError(EnumDifficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return 7;
            }
            case NORMAL: {
                return 4;
            }
            case HARD: {
                return 1;
            }
        }
        return 7;
    }

    public BlockPos getPos() {
        return new BlockPos((Entity)this);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return WizardrySounds.ENTITY_WIZARD_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return WizardrySounds.ENTITY_WIZARD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return WizardrySounds.ENTITY_WIZARD_DEATH;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.decrementChatCooldown();
        this.decrementRareEventCooldown();
        EventHandler.tickArtefacts(this);
        if (!this.field_70170_p.field_72995_K) {
            this.sayNextScheduledMessage();
        }
        ++this.foodTickTimer;
        if (this.func_70644_a(MobEffects.field_76438_s)) {
            this.modifySaturation(-0.005f * (float)(this.func_70660_b(MobEffects.field_76438_s).func_76458_c() + 1));
        } else if (this.func_70644_a(MobEffects.field_76443_y)) {
            this.modifyFoodLevel(0.005f * (float)(this.func_70660_b(MobEffects.field_76443_y).func_76458_c() + 1));
        }
        if (this.func_70902_q() != null && this.foodTickTimer >= 80) {
            if (this.shouldHeal()) {
                this.func_70691_i(0.5f);
                this.modifySaturation(-0.8f);
            } else if (this.getFoodLevel() == 0.0f && this.func_110143_aJ() > 0.5f) {
                this.func_70097_a(DamageSource.field_76366_f, 0.5f);
                Speech.WIZARD_STARVING.sayWithoutSpam(this);
            }
            this.foodTickTimer = 0;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 180 == 0 && !this.isEating && this.func_70902_q() != null) {
            this.modifySaturation(-0.1f);
            if (this.getSaturation() == 0.0f) {
                this.modifyFoodLevel(-0.1f);
            }
            if (this.func_70638_az() == null && this.getFoodLevel() / 20.0f < 0.85f) {
                for (int i = 1; i < this.inventory.func_70302_i_(); ++i) {
                    ItemStack stack = this.inventory.func_70301_a(i).func_77946_l();
                    if (!(stack.func_77973_b() instanceof ItemFood)) continue;
                    ItemStack oldHeldItem = this.func_184614_ca().func_77946_l();
                    ItemStack oldFirstItem = this.inventory.func_70301_a(7).func_77946_l();
                    this.inventory.func_70299_a(i, oldFirstItem);
                    this.inventory.func_70299_a(0, stack);
                    this.inventory.func_70299_a(7, oldHeldItem);
                    this.isEating = true;
                    break;
                }
            }
        }
        if (this.isEating) {
            if (this.func_184614_ca().func_77973_b() instanceof ItemFood) {
                this.func_184598_c(EnumHand.MAIN_HAND);
            } else if (!this.func_184587_cr()) {
                this.isEating = false;
            }
        }
        if (this.field_70146_Z.nextFloat() < 0.1f) {
            ArrayList<Potion> potionsToWishFor = new ArrayList<Potion>();
            if (this.func_70027_ad() && !this.func_70644_a(MobEffects.field_76426_n)) {
                potionsToWishFor.add(MobEffects.field_76426_n);
            } else if (this.func_110143_aJ() / this.func_110138_aP() < 0.5f) {
                potionsToWishFor.add(MobEffects.field_76432_h);
                if (!this.func_70644_a(MobEffects.field_76428_l)) {
                    potionsToWishFor.add(MobEffects.field_76428_l);
                }
                if (!this.func_70644_a(MobEffects.field_76441_p)) {
                    potionsToWishFor.add(MobEffects.field_76441_p);
                }
            }
            if (potionsToWishFor.isEmpty()) {
                return;
            }
            for (int i = 1; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack stack = this.inventory.func_70301_a(i).func_77946_l();
                if (!(stack.func_77973_b() instanceof ItemPotion)) continue;
                if (!PotionUtils.func_185189_a((ItemStack)stack).stream().map(PotionEffect::func_188419_a).anyMatch(potionsToWishFor::contains)) continue;
                if (stack.func_77973_b() == Items.field_185155_bH) {
                    EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, stack);
                    entitypotion.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187827_fP, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
                    this.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                    this.field_70170_p.func_72838_d((Entity)entitypotion);
                    this.inventory.func_70301_a(i).func_190918_g(1);
                    return;
                }
                ItemStack oldHeldItem = this.func_184614_ca().func_77946_l();
                ItemStack oldFirstItem = this.inventory.func_70301_a(7).func_77946_l();
                this.inventory.func_70299_a(i, oldFirstItem);
                this.inventory.func_70299_a(0, stack);
                this.inventory.func_70299_a(7, oldHeldItem);
                this.func_184598_c(EnumHand.MAIN_HAND);
                break;
            }
        }
        if (!(this.getTask() != Task.STAY && this.getTask() != Task.STUDY && this.getTask() != Task.IDENTIFY || this.field_70170_p.func_72935_r())) {
            BlockPos bedPos = this.findBed();
            if (bedPos != null) {
                this.func_70661_as().func_75492_a((double)((float)bedPos.func_177958_n() + 0.5f), (double)bedPos.func_177956_o(), (double)bedPos.func_177952_p() + 0.5, 0.5);
                this.setPreviousTaskBeforeSleeping(this.getTask());
                this.setTask(Task.TRY_TO_SLEEP);
                this.setBedPos(bedPos);
            }
        } else if (this.getTask() == Task.TRY_TO_SLEEP && this.field_70173_aa % 23 == 0) {
            if (this.field_70170_p.func_72935_r()) {
                this.setTask(this.getPreviousTaskBeforeSleeping());
                this.setLyingInBed(false);
            } else {
                BlockPos bedPos;
                if (!(this.field_70170_p.func_180495_p(this.getBedPos()).func_177230_c() instanceof BlockBed) && (bedPos = this.findBed()) != null) {
                    this.setBedPos(bedPos);
                }
                if (!this.getPos().equals((Object)this.getBedPos())) {
                    this.func_70661_as().func_75492_a((double)((float)this.getBedPos().func_177958_n() + 0.5f), (double)this.getBedPos().func_177956_o(), (double)this.getBedPos().func_177952_p() + 0.5, 0.5);
                    this.setLyingInBed(false);
                } else {
                    this.setLyingInBed(this.getPos().equals((Object)this.getBedPos()));
                }
            }
        }
        if (this.getTask() == Task.FOLLOW && this.field_70173_aa % 100 == 0) {
            this.addExperience(1);
        }
        if (!this.field_70170_p.field_72995_K && this.isLyingInBed() && this.field_70173_aa % 100 == 0 && this.func_110138_aP() > this.func_110143_aJ()) {
            this.func_70691_i(0.5f);
        }
        this.tickTalent();
    }

    private void tickTalent() {
        switch (this.getTalent()) {
            case HEALER: {
                if (this.field_70173_aa % 200 != 0) break;
                for (EntityLivingBase nearbyMob : EntityUtils.getEntitiesWithinRadius((double)10.0, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (World)this.field_70170_p, EntityLivingBase.class)) {
                    if (!AllyDesignationSystem.isAllied((EntityLivingBase)this, (EntityLivingBase)nearbyMob) || !(nearbyMob.func_110138_aP() > nearbyMob.func_110143_aJ())) continue;
                    if (this.field_70170_p.field_72995_K) {
                        Vec3d origin = nearbyMob.func_174824_e(1.0f);
                        for (int i = 0; i < 30; ++i) {
                            double x = origin.field_72450_a - 1.0 + this.field_70170_p.field_73012_v.nextDouble() * 2.0;
                            double y = origin.field_72448_b - 0.25 + this.field_70170_p.field_73012_v.nextDouble() * 0.5;
                            double z = origin.field_72449_c - 1.0 + this.field_70170_p.field_73012_v.nextDouble() * 2.0;
                            if (this.field_70170_p.field_73012_v.nextBoolean()) {
                                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).fade(0, 0, 0).spin((double)0.3f, (double)0.03f).clr(1.0f, 1.0f, 0.9f).spawn(this.field_70170_p);
                                continue;
                            }
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).fade(0, 0, 0).spin((double)0.3f, (double)0.03f).clr(1.0f, 1.0f, 0.3f).spawn(this.field_70170_p);
                        }
                    }
                    nearbyMob.func_70691_i(2.0f);
                }
                break;
            }
            case ALCHEMY_ADEPT: {
                List<Integer> emptySlots;
                if (this.field_70170_p.field_72995_K || !this.rareEventReady() || this.field_70146_Z.nextInt(600) != 0) break;
                PotionType potiontype = null;
                if (this.field_70146_Z.nextFloat() < 0.15f || this.func_70055_a(Material.field_151586_h)) {
                    potiontype = PotionTypes.field_185248_t;
                } else if (this.field_70146_Z.nextFloat() < 0.15f || this.func_70902_q() != null && this.func_70902_q().func_70027_ad() || this.func_70027_ad() || this.func_189748_bU() != null && this.func_189748_bU().func_76347_k()) {
                    potiontype = PotionTypes.field_185241_m;
                } else if (this.field_70146_Z.nextFloat() < 0.05f) {
                    potiontype = PotionTypes.field_185250_v;
                } else if (this.field_70146_Z.nextFloat() < 0.5f) {
                    potiontype = PotionTypes.field_185243_o;
                } else if (this.field_70146_Z.nextFloat() < 0.3f) {
                    potiontype = PotionTypes.field_185243_o;
                } else if (this.field_70146_Z.nextFloat() < 0.04f) {
                    potiontype = PotionTypes.field_185220_C;
                } else if (this.field_70146_Z.nextFloat() < 0.04f) {
                    potiontype = PotionTypes.field_185236_h;
                } else if (this.field_70146_Z.nextFloat() < 0.04f) {
                    potiontype = PotionTypes.field_185238_j;
                }
                if (potiontype == null || (emptySlots = this.getEmptySlotsRandomized()).isEmpty()) break;
                this.inventory.func_70299_a(emptySlots.get(0), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)potiontype));
                this.resetRareEventCooldown(1.5f);
                break;
            }
            case APPAREL_EXPERT: {
                if (this.field_70173_aa % 100 != 0) break;
                for (ItemStack stack : this.func_184193_aE()) {
                    if (!(stack.func_77973_b() instanceof IManaStoringItem)) continue;
                    ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, 1);
                }
                break;
            }
            case CONDUIT: {
                if (this.field_70173_aa % 260 != 0) break;
                if (this.func_184614_ca().func_77973_b() instanceof IManaStoringItem) {
                    ((IManaStoringItem)this.func_184614_ca().func_77973_b()).rechargeMana(this.func_184614_ca(), 4);
                }
                if (!(this.func_70902_q() instanceof EntityPlayer) || !(this.func_70902_q().func_70032_d((Entity)this) < 12.0f)) break;
                EntityPlayer player = (EntityPlayer)this.func_70902_q();
                if (player.func_184614_ca().func_77973_b() instanceof ISpellCastingItem && player.func_184614_ca().func_77973_b() instanceof IManaStoringItem && ((IManaStoringItem)player.func_184614_ca().func_77973_b()).getFullness(player.func_184614_ca()) < 0.15f) {
                    ((IManaStoringItem)player.func_184614_ca().func_77973_b()).rechargeMana(player.func_184614_ca(), 4);
                }
                if (!(player.func_184592_cb().func_77973_b() instanceof ISpellCastingItem) || !(player.func_184592_cb().func_77973_b() instanceof IManaStoringItem) || !(((IManaStoringItem)player.func_184592_cb().func_77973_b()).getFullness(player.func_184592_cb()) < 0.15f)) break;
                ((IManaStoringItem)player.func_184592_cb().func_77973_b()).rechargeMana(player.func_184592_cb(), 4);
                break;
            }
            case EMPOWERING_RESONANCE: {
                if (this.field_70170_p.field_72995_K || this.field_70173_aa % 100 != 0) break;
                this.func_70690_d(new PotionEffect(WizardryPotions.empowerment, 100));
                if (!(this.func_184614_ca().func_77973_b() instanceof ItemWand)) break;
                Element elm = ((ItemWand)this.func_184614_ca().func_77973_b()).element;
                for (EntityLivingBase nearbyMob : EntityUtils.getEntitiesWithinRadius((double)12.0, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (World)this.field_70170_p, EntityLivingBase.class)) {
                    if (!AllyDesignationSystem.isAllied((EntityLivingBase)this, (EntityLivingBase)nearbyMob) || !(nearbyMob.func_184614_ca().func_77973_b() instanceof ItemWand) || ((ItemWand)nearbyMob.func_184614_ca().func_77973_b()).element != elm) continue;
                    this.func_70690_d(new PotionEffect(WizardryPotions.empowerment, 100));
                }
                break;
            }
        }
    }

    public BlockPos findBed() {
        for (BlockPos pos : BlockUtils.getBlockSphere((BlockPos)this.func_180425_c(), (double)15.0)) {
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof BlockBed) || state.func_177229_b((IProperty)BlockBed.field_176472_a) != BlockBed.EnumPartType.FOOT || ((Boolean)state.func_177229_b((IProperty)BlockBed.field_176471_b)).booleanValue()) continue;
            return pos;
        }
        return null;
    }

    protected void func_71036_o() {
        boolean mainHand = ItemStack.func_77989_b((ItemStack)this.field_184627_bm, (ItemStack)this.func_184614_ca());
        if (!this.field_184627_bm.func_190926_b() && this.func_184587_cr() && this.field_184627_bm.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)this.func_184614_ca().func_77973_b();
            float foodHealAmount = food.func_150905_g(this.func_184614_ca());
            float saturation = food.func_150906_h(this.func_184614_ca());
            this.modifyFoodLevel(foodHealAmount);
            this.modifySaturation(saturation * 4.0f);
            this.isEating = false;
        }
        super.func_71036_o();
        if (mainHand && this.func_184614_ca().func_190926_b()) {
            this.inventory.func_70299_a(0, this.inventory.func_70301_a(7));
        } else if (mainHand) {
            ItemStack backup = this.func_184614_ca().func_77946_l();
            this.inventory.func_70299_a(0, this.inventory.func_70301_a(7));
            this.inventory.func_70299_a(7, backup);
        }
    }

    public boolean hasOwner() {
        return this.func_184753_b() != null;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player == this.func_70902_q()) {
            double x;
            int i;
            Vec3d origin;
            if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b().getRegistryName().toString().equals("ancientspellcraft:amnesia_scroll")) {
                if (this.field_70170_p.field_72995_K) {
                    origin = this.func_174824_e(1.0f);
                    for (i = 0; i < 30; ++i) {
                        x = origin.field_72450_a - 1.0 + this.field_70170_p.field_73012_v.nextDouble() * 2.0;
                        double y = origin.field_72448_b - 0.25 + this.field_70170_p.field_73012_v.nextDouble() * 0.5;
                        double z = origin.field_72449_c - 1.0 + this.field_70170_p.field_73012_v.nextDouble() * 2.0;
                        if (this.field_70170_p.field_73012_v.nextBoolean()) {
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).fade(0, 0, 0).spin((double)0.3f, (double)0.03f).clr(140, 140, 140).spawn(this.field_70170_p);
                            continue;
                        }
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).fade(0, 0, 0).spin((double)0.3f, (double)0.03f).clr(99, 1, 110).spawn(this.field_70170_p);
                    }
                } else {
                    this.removeAllKnownSpells();
                    player.func_184614_ca().func_190918_g(1);
                }
            } else if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == AAItems.charm_seal_of_fate) {
                if (this.field_70170_p.field_72995_K) {
                    origin = this.func_174824_e(1.0f);
                    for (i = 0; i < 60; ++i) {
                        x = origin.field_72450_a - 1.0 + this.field_70170_p.field_73012_v.nextDouble() * 2.0;
                        double y = origin.field_72448_b - 0.25 + this.field_70170_p.field_73012_v.nextDouble() * 0.5 - 1.5;
                        double z = origin.field_72449_c - 1.0 + this.field_70170_p.field_73012_v.nextDouble() * 2.0;
                        if (this.field_70170_p.field_73012_v.nextBoolean()) {
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).fade(0, 0, 0).spin((double)0.3f, (double)0.06f).clr(247, 189, 62).spawn(this.field_70170_p);
                            continue;
                        }
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).fade(0, 0, 0).spin((double)0.3f, (double)0.03f).clr(255, 239, 204).spawn(this.field_70170_p);
                    }
                } else {
                    for (int i2 = 0; i2 < 20; ++i2) {
                        Talent t = Talent.getRandom();
                        if (t == this.getTalent()) continue;
                        this.setTalent(t);
                        player.func_184614_ca().func_190918_g(1);
                        break;
                    }
                    return true;
                }
            }
        }
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == AAItems.charm_talent_detector) {
            WizardryUtilsTools.sendMessage((Entity)player, (String)"item.arcaneapprentices:charm_talent_detector.message", (boolean)false, (Object[])new Object[]{this.func_145748_c_(), this.getTalent().getDisplayName()});
            return true;
        }
        if (player.func_184812_l_() && player.func_70093_af() && !player.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND && player.func_184614_ca().func_77973_b() == Items.field_151156_bN) {
            this.addExperience(80);
            this.setOwner((EntityLivingBase)player);
            return false;
        }
        if (player.func_184812_l_() && player.func_70093_af() && !player.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND && player.func_184614_ca().func_77973_b() == WizardryItems.ring_condensing) {
            this.addExperience(80000);
            this.setOwner((EntityLivingBase)player);
            return false;
        }
        if (!player.field_70170_p.field_72995_K && !this.hasOwner() && player.func_184614_ca().func_77973_b() == WizardryItems.wizard_handbook) {
            Advancement requirement1 = ((WorldServer)this.field_70170_p).func_191952_z().func_192778_a(new ResourceLocation("ebwizardry:master"));
            Advancement requirement2 = ((WorldServer)this.field_70170_p).func_191952_z().func_192778_a(new ResourceLocation("ebwizardry:discover_master_spell"));
            PlayerAdvancements advancements = ((EntityPlayerMP)player).func_192039_O();
            if ((requirement1 == null || advancements.func_192747_a(requirement1).func_192105_a()) && (requirement2 == null || advancements.func_192747_a(requirement2).func_192105_a())) {
                if (PlayerData.addApprenticeForPlayer(player, (EntityLivingBase)this) || PlayerData.getApprentices(player).stream().anyMatch(a -> a.equals(this.func_110124_au()))) {
                    this.sayImmediately(player, new TextComponentTranslation(Speech.PLAYER_GIVES_HANDBOOK.getRandom(), new Object[]{player.func_145748_c_()}));
                    this.setOwner((EntityLivingBase)player);
                    this.setHome(new Location(this.getPos(), this.field_71093_bK));
                    WizardryUtilsTools.sendMessage((Entity)player, (String)"message.arcaneapprentices:apprentice_taken", (boolean)false, (Object[])new Object[]{this.func_70005_c_()});
                    this.setTask(Task.FOLLOW);
                    return true;
                }
                Utils.sendMessage((Entity)player, "info.arcaneapprentices:reached_apprentice_cap", false, this.func_70005_c_());
                return false;
            }
            this.sayImmediately(player, new TextComponentTranslation(Speech.PLAYER_GIVES_HANDBOOK_WITHOUT_REQUIREMENTS.getRandom(), new Object[]{player.func_145748_c_()}));
            AAAdvancementTriggers.no_requirements_met.triggerFor(player);
            player.func_184614_ca().func_190918_g(1);
        }
        if (player.func_70093_af() && !player.field_70170_p.field_72995_K && hand == EnumHand.MAIN_HAND && player == this.func_70902_q()) {
            if ((double)this.field_70170_p.field_73012_v.nextFloat() < 0.15) {
                this.sayImmediately(new TextComponentTranslation(Speech.GREET.getRandom(), new Object[]{player.func_145748_c_()}));
            }
            player.openGui((Object)"arcaneapprentices", AAGuiHandler.WIZARD_INVENTORY_GUI, this.field_70170_p, this.func_145782_y(), 0, 0);
        } else if (!this.hasOwner()) {
            this.sayWithoutSpam(player, new TextComponentTranslation(Speech.GREET_HANDBOOK_HINT.getRandom(), new Object[]{player.func_145748_c_()}));
        } else {
            this.sayWithoutSpam(player, new TextComponentTranslation(Speech.GREET.getRandom(), new Object[]{player.func_145748_c_()}));
        }
        return true;
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && (Settings.generalSettings.APPRENTICES_CAN_BE_RESURRECTED || Settings.generalSettings.APPRENTICES_RESPAWN_AT_PLAYER_SPAWNPOINT) && this.hasOwner()) {
            if (this.func_70902_q() instanceof EntityPlayer) {
                this.func_70691_i(10.0f);
                PlayerData.storeDeadApprentice((EntityPlayer)this.func_70902_q(), (EntityLivingBase)this);
            }
            if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82736_K().func_82766_b("showDeathMessages") && this.func_70902_q() instanceof EntityPlayerMP) {
                this.func_70902_q().func_145747_a(this.func_110142_aN().func_151521_b());
            }
        }
        super.func_70645_a(cause);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        Element element;
        super.func_70014_b(nbt);
        if (this.trades != null) {
            NBTExtras.storeTagSafely((NBTTagCompound)nbt, (String)"trades", (NBTBase)this.trades.func_77202_a());
        }
        if (this.func_184753_b() != null) {
            nbt.func_186854_a("OwnerUUID", this.func_184753_b());
        }
        nbt.func_74768_a("element", (element = this.getElement()) == null ? 0 : element.ordinal());
        nbt.func_74768_a("skin", this.textureIndex);
        if (this.towerBlocks != null && this.towerBlocks.size() > 0) {
            NBTExtras.storeTagSafely((NBTTagCompound)nbt, (String)"towerBlocks", (NBTBase)NBTExtras.listToNBT(this.towerBlocks, NBTUtil::func_186859_a));
        }
        nbt.func_74757_a("IsChild", this.func_70631_g_());
        nbt.func_74768_a("Task", this.getTask().ordinal());
        nbt.func_74768_a("PreviousTaskBeforeSleeping", this.getPreviousTaskBeforeSleeping().ordinal());
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        nbt.func_74782_a("Spells", (NBTBase)this.getSpellCompound());
        nbt.func_74782_a("DisabledSpells", (NBTBase)this.getDisabledSpellCompound());
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
        nbt.func_74768_a("Xp", this.getTotalXp());
        nbt.func_74768_a("Level", this.getLevel());
        nbt.func_74776_a("FoodLevel", this.getFoodLevel());
        nbt.func_74776_a("FoodSaturation", this.getSaturation());
        nbt.func_74782_a("CurrentStayPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.currentStayPos));
        nbt.func_74782_a("HomePos", (NBTBase)this.getHome().toNBT());
        nbt.func_74768_a("RareEventCooldown", this.getRareEventCooldown());
        nbt.func_74772_a("BedPos", this.getBedPos().func_177986_g());
        nbt.func_74768_a("AdventureRemainingDuration", this.adventureRemainingDuration);
        nbt.func_74778_a("JourneyType", this.journeyType.toString());
        Talent talent = this.getTalent();
        nbt.func_74768_a("Talent", talent == null ? 0 : talent.ordinal());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("trades")) {
            NBTTagCompound nbttagcompound1 = nbt.func_74775_l("trades");
            this.trades = new WildcardTradeList(nbttagcompound1);
        }
        if (nbt.func_186855_b("OwnerUUID")) {
            this.setOwnerId(nbt.func_186857_a("OwnerUUID"));
        }
        this.setElement(Element.values()[nbt.func_74762_e("element")]);
        this.currentStayPos = NBTUtil.func_186861_c((NBTTagCompound)nbt.func_74775_l("CurrentStayPos"));
        this.textureIndex = nbt.func_74762_e("skin");
        if (nbt.func_74764_b("Task")) {
            this.setTask(Task.values()[nbt.func_74762_e("Task")]);
        }
        if (nbt.func_74764_b("PreviousTaskBeforeSleeping")) {
            this.setTask(Task.values()[nbt.func_74762_e("PreviousTaskBeforeSleeping")]);
        }
        this.setSpellCompound(nbt.func_74775_l("Spells"));
        this.setDisabledSpellCompound(nbt.func_74775_l("DisabledSpells"));
        this.setChild(nbt.func_74767_n("IsChild"));
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.initInventory();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(j, new ItemStack(nbttagcompound));
        }
        this.setLevel(nbt.func_74762_e("Level"));
        this.setXp(nbt.func_74762_e("Xp"));
        this.setFoodLevel(nbt.func_74762_e("FoodLevel"));
        this.setSaturation(nbt.func_74760_g("FoodSaturation"));
        this.adventureRemainingDuration = nbt.func_74762_e("AdventureRemainingDuration");
        if (nbt.func_74764_b("JourneyType")) {
            this.journeyType = JourneyType.valueOf(nbt.func_74779_i("JourneyType"));
        }
        this.setRareEventCooldown(nbt.func_74762_e("RareEventCooldown"));
        if (nbt.func_74764_b("HomePos")) {
            this.setHome(Location.fromNBT((NBTTagCompound)((NBTTagCompound)nbt.func_74781_a("HomePos"))));
        }
        nbt.func_74782_a("CurrentStayPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.currentStayPos));
        if (nbt.func_74764_b("BedPos")) {
            this.setBedPos(BlockPos.func_177969_a((long)nbt.func_74763_f("BedPos")));
        }
        if (nbt.func_74764_b("Talent")) {
            this.setTalent(Talent.values()[nbt.func_74762_e("Talent")]);
            if (this.getTalent() == Talent.NONE) {
                this.setTalent(Talent.getRandom());
            }
        } else {
            this.setTalent(Talent.getRandom());
        }
    }

    public boolean hasTalentUnlocked() {
        return !this.func_70631_g_();
    }

    public Talent getTalent() {
        return Talent.values()[(Integer)this.field_70180_af.func_187225_a(TALENT)];
    }

    public void setTalent(Talent talent) {
        this.field_70180_af.func_187227_b(TALENT, (Object)talent.ordinal());
    }

    protected int getInventorySize() {
        return 23;
    }

    protected void initInventory() {
        WizardInventory wizardInventory = this.inventory;
        this.inventory = new WizardInventory("WizardInventory", false, this.getInventorySize());
        this.inventory.func_110133_a(this.func_70005_c_());
        if (wizardInventory != null) {
            wizardInventory.func_110132_b(this);
            int i = Math.min(wizardInventory.func_70302_i_(), this.inventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = wizardInventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.inventory.func_110134_a(this);
        this.itemHandler = new InvWrapper((IInventory)this.inventory);
    }

    public boolean consumeArcaneTome(Tier tier) {
        int ordinal = Math.max(1, tier.ordinal());
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_77973_b() != WizardryItems.arcane_tome || stack.func_77960_j() != ordinal) continue;
            this.inventory.func_70298_a(i, 1);
            return true;
        }
        return false;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_96094_a(Utils.generateWizardName(this.field_70170_p));
        this.textureIndex = this.field_70146_Z.nextInt(2);
        if (this.field_70146_Z.nextBoolean()) {
            this.setElement(Element.values()[this.field_70146_Z.nextInt(Element.values().length - 1) + 1]);
        } else {
            this.setElement(Element.MAGIC);
        }
        this.setSaturation(5.0f);
        this.setFoodLevel(20.0f);
        Element element = this.getElement();
        for (EntityEquipmentSlot slot : InventoryUtils.ARMOUR_SLOTS) {
        }
        EntityEquipmentSlot[] var4 = EntityEquipmentSlot.values();
        int var5 = var4.length;
        this.setHealCooldown(50);
        this.setHome(new Location(this.getPos(), this.field_71093_bK));
        return livingdata;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.textureIndex);
        data.writeInt(this.func_70902_q() != null ? this.func_70902_q().func_145782_y() : -1);
    }

    public void readSpawnData(ByteBuf data) {
        this.textureIndex = data.readInt();
        int id = data.readInt();
        if (id > -1) {
            Entity entity = Wizardry.proxy.getTheWorld().func_73045_a(id);
            if (entity instanceof EntityLivingBase) {
                this.setOwner((EntityLivingBase)entity);
            } else {
                Wizardry.logger.warn("Received a spawn packet for entity {}, but no living entity matched the supplied ID", (Object)this);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        boolean f = super.func_70097_a(source, damage);
        if (this.field_70146_Z.nextInt(5) == 0) {
            if (source.func_76346_g() instanceof EntityPlayer) {
                if (((EntityPlayer)source.func_76346_g()).func_184614_ca().func_77973_b().getRegistryName().toString().contains("sword")) {
                    Speech.WIZARD_TAKE_DAMAGE_BY_SWORD.say(this);
                } else {
                    this.sayImmediately(new TextComponentTranslation(Speech.WIZARD_TAKE_DAMAGE_FROM_PLAYER.getRandom(), new Object[]{source.func_76346_g().func_145748_c_()}));
                }
            } else if (f) {
                Speech.WIZARD_TAKE_DAMAGE.say(this);
            }
        }
        if (f && this.field_70146_Z.nextBoolean() && this.getTalent() == Talent.PHASER && this.hasTalentUnlocked() && (source.func_76346_g() != null || source == DamageSource.field_76371_c)) {
            ((Banish)Spells.banish).teleport((EntityLivingBase)this, this.field_70170_p, 6.0);
        }
        if (f && source.func_76346_g() != null && this.hasTalentUnlocked() && this.getTalent() == Talent.ANIMAL_WHISPERER && this.field_70146_Z.nextInt(5) == 0 && !this.field_70170_p.field_72995_K) {
            List<ResourceLocation> entities = Arrays.asList(new ResourceLocation("ancientspellcraft:fire_ant"), new ResourceLocation("ancientspellcraft:ordinary_spider_minion"), new ResourceLocation("ancientspellcraft:wolf_minion"), new ResourceLocation("ebwizardry:silverfish_minion"), new ResourceLocation("ebwizardry:spider_minion"));
            EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(entities.get(this.field_70170_p.field_73012_v.nextInt(entities.size())));
            BlockPos pos = BlockUtils.findNearbyFloorSpace((Entity)this, (int)2, (int)2);
            if (entry != null && pos != null) {
                Entity entity = entry.newInstance(this.field_70170_p);
                ((ISummonedCreature)entity).setOwnerId(this.func_110124_au());
                ((ISummonedCreature)entity).setLifetime(300);
                entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                this.field_70170_p.func_72838_d(entity);
            }
        }
        return f;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!(slotIn != EntityEquipmentSlot.OFFHAND || this.getTask() != Task.STUDY && this.getTask() != Task.IDENTIFY || this.getStudiedItem().func_77969_a(stack))) {
            this.resetStudyProgress();
        }
    }

    public void func_76316_a(IInventory inventory) {
        ItemStack newItem;
        ItemStack oldItem = this.func_184582_a(EntityEquipmentSlot.MAINHAND);
        if (ItemStack.func_77989_b((ItemStack)oldItem, (ItemStack)(newItem = this.inventory.func_70301_a(0)))) {
            // empty if block
        }
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, inventory.func_70301_a(0));
        this.func_184201_a(EntityEquipmentSlot.OFFHAND, inventory.func_70301_a(1));
        this.func_184201_a(EntityEquipmentSlot.HEAD, inventory.func_70301_a(2));
        this.func_184201_a(EntityEquipmentSlot.CHEST, inventory.func_70301_a(3));
        this.func_184201_a(EntityEquipmentSlot.LEGS, inventory.func_70301_a(4));
        this.func_184201_a(EntityEquipmentSlot.FEET, inventory.func_70301_a(5));
        if (inventory.func_70301_a(0).func_77973_b() instanceof ItemSword) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.spellCastingAI);
            this.field_70714_bg.func_85156_a(this.bowAI);
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.meleeAI);
        } else if (inventory.func_70301_a(0).func_77973_b() instanceof ItemBow) {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.meleeAI);
            this.field_70714_bg.func_85156_a((EntityAIBase)this.spellCastingAI);
            this.field_70714_bg.func_75776_a(3, this.bowAI);
        } else {
            this.field_70714_bg.func_85156_a((EntityAIBase)this.meleeAI);
            this.field_70714_bg.func_85156_a(this.bowAI);
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.spellCastingAI);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getBedRotation() {
        IBlockState state;
        BlockPos bedLocation = this.getBedPos();
        IBlockState iBlockState = state = bedLocation == null ? null : this.field_70170_p.func_180495_p(bedLocation);
        if (state != null && state.func_177230_c().isBed(state, (IBlockAccess)this.field_70170_p, bedLocation, null)) {
            EnumFacing direction = state.func_177230_c().getBedDirection(state, (IBlockAccess)this.field_70170_p, bedLocation);
            switch (direction) {
                case EAST: {
                    return 180.0f;
                }
                case WEST: {
                    return 0.0f;
                }
                case NORTH: {
                    return 270.0f;
                }
            }
            return 90.0f;
        }
        return -1.0f;
    }

    public void func_184611_a(EnumHand hand, ItemStack stack) {
        if (hand == EnumHand.MAIN_HAND) {
            this.inventory.func_70299_a(0, stack);
        } else {
            if (hand != EnumHand.OFF_HAND) {
                throw new IllegalArgumentException("Invalid hand " + hand);
            }
            this.inventory.func_70299_a(1, stack);
        }
    }

    public int getInventoryColumns() {
        return 5;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public UUID func_184753_b() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)uniqueId));
    }

    @Nullable
    public Entity func_70902_q() {
        Entity entity = EntityUtils.getEntityByUUID((World)this.field_70170_p, (UUID)this.func_184753_b());
        if (entity != null && !(entity instanceof EntityLivingBase)) {
            ArcaneApprentices.logger.warn("{} has a non-living owner!", (Object)this);
            return null;
        }
        return entity;
    }

    public void setOwner(@Nullable EntityLivingBase owner) {
        this.setOwnerId(owner == null ? null : owner.func_110124_au());
    }

    public boolean isStudying() {
        return this.func_184592_cb().func_77973_b() instanceof ItemSpellBook && !this.isSpellKnown(Spell.byMetadata((int)this.func_184592_cb().func_77952_i()));
    }

    public boolean isSpellKnown(Spell spell) {
        return this.getSpells().contains(spell);
    }

    public boolean isSpellDisabled(Spell spell) {
        return this.getDisabledSpells().contains(spell);
    }

    public int getCurrentSpellSlotCap() {
        return Math.max(1, Math.round((float)Settings.generalSettings.MAX_WIZARD_SPELL_SLOTS * ((float)this.getLevel() / (float)XpProgression.getMaxLevel())));
    }

    public int getCurrentTierCap() {
        float levellingProgress = (float)this.getLevel() / (float)XpProgression.getMaxLevel();
        if (levellingProgress <= 0.25f) {
            return 0;
        }
        if (levellingProgress <= 0.5f) {
            return Math.min(Settings.generalSettings.MAX_WIZARD_SPELL_TIER, 1);
        }
        if (levellingProgress <= 0.75f) {
            return Math.min(Settings.generalSettings.MAX_WIZARD_SPELL_TIER, 2);
        }
        return Math.min(Settings.generalSettings.MAX_WIZARD_SPELL_TIER, 3);
    }

    public boolean canLearnNewSpell() {
        return this.getSpells().size() < this.getCurrentSpellSlotCap();
    }

    public void learnSpell(Spell spell) {
        if (!this.isSpellKnown(spell)) {
            if (this.func_70902_q() instanceof EntityPlayer) {
                AAAdvancementTriggers.apprentice_learn_spell.triggerFor((EntityPlayer)this.func_70902_q());
            }
            List<Spell> spells = this.getSpells();
            spells.add(spell);
            NBTTagCompound newSpellNbt = new NBTTagCompound();
            NBTExtras.storeTagSafely((NBTTagCompound)newSpellNbt, (String)"spells", (NBTBase)NBTExtras.listToNBT(spells, s -> new NBTTagInt(s.metadata())));
            this.setSpellCompound(newSpellNbt);
            this.resetStudyProgress();
        }
        if (this.getSpells().size() == Settings.generalSettings.MAX_WIZARD_SPELL_SLOTS && this.func_70902_q() instanceof EntityPlayer) {
            AAAdvancementTriggers.apprentice_learn_max_spell.triggerFor((EntityPlayer)this.func_70902_q());
        }
    }

    public boolean toggleSpellDisablement(Spell spell) {
        boolean spellIsNowDisabled;
        List<Spell> alreadyDisabledSpells = this.getDisabledSpells();
        if (alreadyDisabledSpells.contains(spell)) {
            alreadyDisabledSpells.remove(spell);
            spellIsNowDisabled = false;
        } else {
            alreadyDisabledSpells.add(spell);
            spellIsNowDisabled = true;
        }
        NBTTagCompound newSpellNbt = new NBTTagCompound();
        NBTExtras.storeTagSafely((NBTTagCompound)newSpellNbt, (String)"spells", (NBTBase)NBTExtras.listToNBT(alreadyDisabledSpells, s -> new NBTTagInt(s.metadata())));
        this.setDisabledSpellCompound(newSpellNbt);
        return spellIsNowDisabled;
    }

    public BlockPos getLectern() {
        return this.lectern;
    }

    public void setLectern(BlockPos lectern) {
        this.lectern = lectern;
    }

    public float getStudyProgressForSpell(Spell spell, int tickFrequency) {
        double halfOrdinal = (double)spell.getTier().ordinal() / 2.0;
        double valuePlusFive = halfOrdinal + 5.0;
        return (float)tickFrequency / (float)Math.pow(valuePlusFive, Settings.generalSettings.NPC_SPELL_STUDY_TIME_MODIFIER) * (this.isArtefactActive(AAItems.head_knowledge) ? 1.33f : 1.0f);
    }

    public Task getTask() {
        return Task.values()[(Integer)this.field_70180_af.func_187225_a(CURRENT_TASK)];
    }

    public void setTask(Task task) {
        if (task == Task.STAY) {
            this.currentStayPos = this.getPos();
        }
        this.field_70180_af.func_187227_b(CURRENT_TASK, (Object)task.ordinal());
    }

    public Task getPreviousTaskBeforeSleeping() {
        return Task.values()[(Integer)this.field_70180_af.func_187225_a(PREVIOUS_TASK_BEFORE_SLEEPING)];
    }

    public void setPreviousTaskBeforeSleeping(Task task) {
        this.field_70180_af.func_187227_b(PREVIOUS_TASK_BEFORE_SLEEPING, (Object)task.ordinal());
    }

    public int getLevel() {
        return (Integer)this.field_70180_af.func_187225_a(LEVEL);
    }

    public void setLevel(int level) {
        this.field_70180_af.func_187227_b(LEVEL, (Object)level);
        double currentMaxHP = this.func_110138_aP();
        double newMaxHP = Math.min(Settings.generalSettings.WIZARD_MAX_HEALTH_CAP, Settings.generalSettings.WIZARD_HP_GAIN_PER_LEVEL * level + Settings.generalSettings.WIZARD_MINIMUM_HP);
        float healAmount = (float)(newMaxHP - currentMaxHP);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(newMaxHP);
        this.func_70691_i(healAmount);
    }

    public int getTotalXp() {
        return (Integer)this.field_70180_af.func_187225_a(XP);
    }

    public void setXp(int amount) {
        this.field_70180_af.func_187227_b(XP, (Object)amount);
    }

    public void addExperience(int amount) {
        int newAmount = this.getTotalXp() + amount;
        int xpForNewLevel = (int)XpProgression.calculateTotalXpRequired(this.getLevel() + 1);
        this.field_70180_af.func_187227_b(XP, (Object)newAmount);
        if (newAmount >= xpForNewLevel && this.getLevel() < XpProgression.getMaxLevel()) {
            if (this.func_70902_q() instanceof EntityPlayer) {
                AAAdvancementTriggers.apprentice_levels_up.triggerFor((EntityPlayer)this.func_70902_q());
            }
            if (this.getLevel() + 1 == XpProgression.getMaxLevel() && this.func_70902_q() instanceof EntityPlayer) {
                AAAdvancementTriggers.apprentice_max_level.triggerFor((EntityPlayer)this.func_70902_q());
            }
            this.setLevel(this.getLevel() + 1);
            this.sayImmediately(new TextComponentTranslation(Speech.LEVEL_UP.getRandom(), new Object[0]));
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187802_ec, this.func_184176_by(), 0.75f, 1.0f);
        }
    }

    public ITextComponent func_145748_c_() {
        if (this.func_184753_b() != null && this.func_70902_q() != null) {
            return new TextComponentTranslation("entity.arcaneapprentices:owned_wizard.nameplate", new Object[]{this.func_70902_q().func_70005_c_(), this.func_145818_k_() ? super.func_145748_c_() : this.getElement().getWizardName()});
        }
        return super.func_145748_c_();
    }

    public ITextComponent getDisplayNameWithoutOwner() {
        return super.func_145748_c_();
    }

    public ITextComponent getChatPrefix() {
        return new TextComponentTranslation("message.arcaneapprentices:wizard_chat_prefix", new Object[]{this.getCustomName()});
    }

    public String getCustomName() {
        return this.func_95999_t();
    }

    public List<ItemStack> getActiveArtefacts() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (this.inventory.func_70301_a(21).func_77973_b() instanceof ItemArtefact) {
            list.add(this.inventory.func_70301_a(21));
        }
        if (this.inventory.func_70301_a(1).func_77973_b() instanceof ItemArtefact) {
            list.add(this.inventory.func_70301_a(1));
        }
        if (this.hasTalentUnlocked() && this.getTalent() == Talent.ARTIFICE_MASTER) {
            if (this.inventory.func_70301_a(6).func_77973_b() instanceof ItemArtefact) {
                list.add(this.inventory.func_70301_a(6));
            }
            if (this.inventory.func_70301_a(7).func_77973_b() instanceof ItemArtefact) {
                list.add(this.inventory.func_70301_a(7));
            }
        }
        return list;
    }

    public List<ItemStack> getHeldItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.inventory.func_70301_a(0));
        list.add(this.inventory.func_70301_a(1));
        return list;
    }

    public boolean isArtefactActive(Item artefact) {
        return this.getActiveArtefacts().stream().anyMatch(s -> s.func_77973_b() == artefact);
    }

    public Iterable<ItemStack> func_184193_aE() {
        NonNullList inventoryArmor = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        inventoryArmor.set(0, (Object)this.inventory.func_70301_a(2));
        inventoryArmor.set(1, (Object)this.inventory.func_70301_a(3));
        inventoryArmor.set(2, (Object)this.inventory.func_70301_a(4));
        inventoryArmor.set(3, (Object)this.inventory.func_70301_a(5));
        return inventoryArmor;
    }

    public boolean shouldHeal() {
        return this.getFoodLevel() / 20.0f > 0.75f && this.func_110143_aJ() < this.func_110138_aP();
    }

    public void returnFromAdventuring() {
        if (this.journeyType != JourneyType.NOT_ADVENTURING) {
            this.fillWithLoot(LootRegistry.getLootTableFor(this.journeyType), this.journeyType.getBonusLootItemCount());
        }
        Speech.WIZARD_RETURNED_FROM_JOURNEY.say(this);
        if (this.func_70902_q() instanceof EntityPlayer) {
            AAAdvancementTriggers.apprentice_returns_from_journey.triggerFor((EntityPlayer)this.func_70902_q());
        }
        this.func_70661_as().func_75497_a(this.func_70902_q(), 0.7);
    }

    public void fillWithLoot(ResourceLocation lootTable, int extraItemCount) {
        if (this.func_70902_q() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.func_70902_q();
            if (lootTable != null) {
                int i;
                LootTable loottable = this.field_70170_p.func_184146_ak().func_186521_a(lootTable);
                Random random = new Random();
                LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_70170_p);
                lootcontext$builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
                WizardInventory temporaryInventory = new WizardInventory("WizardInventory", false, 64);
                loottable.func_186460_a((IInventory)temporaryInventory, random, lootcontext$builder.func_186471_a());
                EntityWizardInitiate.mergeItemStacks((IInventory)temporaryInventory);
                ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
                if (this.isArtefactActive(AAItems.ring_serendipity)) {
                    extraItemCount += Math.max(3, this.field_70146_Z.nextInt(6));
                }
                if (extraItemCount > 0) {
                    LootTable extraItems = this.field_70170_p.func_184146_ak().func_186521_a(LootRegistry.STRUCTURES);
                    LootContext.Builder lootcontext$builder2 = new LootContext.Builder((WorldServer)this.field_70170_p);
                    lootcontext$builder2.func_186469_a(player.func_184817_da()).func_186470_a(player);
                    WizardInventory fewItemContainer = new WizardInventory("WizardInventory", false, 64);
                    extraItems.func_186460_a((IInventory)fewItemContainer, random, lootcontext$builder2.func_186471_a());
                    EntityWizardInitiate.mergeItemStacks((IInventory)fewItemContainer);
                    ArrayList<ItemStack> itemStackList2 = new ArrayList<ItemStack>();
                    for (int t = 0; t < fewItemContainer.func_70302_i_(); ++t) {
                        if (fewItemContainer.func_70301_a(t).func_190926_b()) continue;
                        itemStackList2.add(fewItemContainer.func_70301_a(t).func_77946_l());
                    }
                    Collections.shuffle(itemStackList2);
                    for (i = 0; i < extraItemCount; ++i) {
                        if (i >= itemStackList2.size()) continue;
                        temporaryInventory.func_174894_a(((ItemStack)itemStackList2.get(i)).func_77946_l());
                    }
                }
                EntityWizardInitiate.mergeItemStacks((IInventory)temporaryInventory);
                for (int t = 0; t < temporaryInventory.func_70302_i_(); ++t) {
                    if (temporaryInventory.func_70301_a(t).func_190926_b()) continue;
                    itemStackList.add(temporaryInventory.func_70301_a(t).func_77946_l());
                }
                Iterator listIterator = itemStackList.iterator();
                while (listIterator.hasNext()) {
                    ItemStack stack = (ItemStack)listIterator.next();
                    boolean flag = true;
                    for (int i2 = 6; i2 < 23; ++i2) {
                        ItemStack newStack;
                        if (!ContainerWizardInitiateInventory.isSlotUnlocked(i2, this)) continue;
                        if (this.inventory.func_70301_a(i2).func_190926_b()) {
                            this.inventory.func_70299_a(i2, stack);
                            flag = false;
                            listIterator.remove();
                            break;
                        }
                        if (!EntityWizardInitiate.areStacksCompatible(this.inventory.func_70301_a(i2), stack)) continue;
                        int available = 64 - this.inventory.func_70301_a(i2).func_190916_E();
                        if (stack.func_190916_E() <= available) {
                            newStack = this.inventory.func_70301_a(i2).func_77946_l();
                            newStack.func_190920_e(this.inventory.func_70301_a(i2).func_190916_E() + stack.func_190916_E());
                            this.inventory.func_70299_a(i2, newStack);
                            flag = false;
                            listIterator.remove();
                            break;
                        }
                        newStack = this.inventory.func_70301_a(i2).func_77946_l();
                        int remainder = stack.func_190916_E() - available;
                        newStack.func_190920_e(64);
                        this.inventory.func_70299_a(i2, newStack);
                        stack.func_190920_e(remainder);
                    }
                    if (flag && this.isArtefactActive(AAItems.charm_bag_9)) {
                        ItemStack bag = this.inventory.func_70301_a(21).func_77946_l();
                        for (i = 0; i < 9; ++i) {
                            if (!ItemArtefactWithSlots.isSlotEmpty(bag, i)) continue;
                            ItemArtefactWithSlots.setItemForSlot(bag, stack, i);
                            flag = false;
                            listIterator.remove();
                            break;
                        }
                        if (this.inventory.func_70301_a(21).func_77973_b() == AAItems.charm_bag_9) {
                            this.inventory.func_70299_a(21, bag);
                        } else if (this.inventory.func_70301_a(1).func_77973_b() == AAItems.charm_bag_9) {
                            this.inventory.func_70299_a(1, bag);
                        }
                        this.inventory.func_70299_a(21, bag);
                    } else if (flag && this.isArtefactActive(AAItems.charm_bag_27)) {
                        ItemStack bag = this.inventory.func_70301_a(21).func_77946_l();
                        for (i = 0; i < 27; ++i) {
                            if (!ItemArtefactWithSlots.isSlotEmpty(bag, i)) continue;
                            ItemArtefactWithSlots.setItemForSlot(bag, stack, i);
                            flag = false;
                            listIterator.remove();
                            break;
                        }
                        if (this.inventory.func_70301_a(21).func_77973_b() == AAItems.charm_bag_27) {
                            this.inventory.func_70299_a(21, bag);
                        } else if (this.inventory.func_70301_a(1).func_77973_b() == AAItems.charm_bag_27) {
                            this.inventory.func_70299_a(1, bag);
                        }
                        this.inventory.func_70299_a(21, bag);
                    }
                    if (!flag) continue;
                    listIterator.remove();
                }
            }
        }
    }

    private List<Integer> getEmptySlotsRandomized() {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (i >= 2 && i <= 5 || !this.inventory.func_70301_a(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, this.field_70146_Z);
        return list;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b().canDisableShield(itemstack, itemstack1, (EntityLivingBase)entityplayer, (EntityLivingBase)this) && itemstack1.func_77973_b().isShield(itemstack1, (EntityLivingBase)entityplayer)) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(itemstack1.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityArrow entityarrow = this.getArrow(distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof ItemBow && entityarrow == null && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)this.func_184614_ca()) > 0) {
            ItemStack arrow = new ItemStack(Items.field_151032_g);
            entityarrow = ((ItemArrow)arrow.func_77973_b()).func_185052_a(this.field_70170_p, arrow, (EntityLivingBase)this);
        }
        if (entityarrow != null) {
            if (this.func_184614_ca().func_77973_b() instanceof ItemBow) {
                entityarrow = ((ItemBow)this.func_184614_ca().func_77973_b()).customizeArrow(entityarrow);
            }
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
            double d2 = target.field_70161_v - this.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
            this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)entityarrow);
        } else {
            this.sayWithoutSpam(new TextComponentTranslation(Speech.WIZARD_NO_ARROWS.getRandom(), new Object[0]));
        }
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    protected EntityArrow getArrow(float distanceFactor) {
        for (int i = 1; i < this.inventory.func_70302_i_(); ++i) {
            if (!(this.inventory.func_70301_a(i).func_77973_b() instanceof ItemArrow)) continue;
            EntityArrow arrow = ((ItemArrow)this.inventory.func_70301_a(i).func_77973_b()).func_185052_a(this.field_70170_p, this.inventory.func_70301_a(i).func_77946_l(), (EntityLivingBase)this);
            arrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
            arrow.func_190547_a((EntityLivingBase)this, distanceFactor);
            this.inventory.func_70301_a(i).func_190918_g(1);
            return arrow;
        }
        return null;
    }

    public boolean hasArrow() {
        for (int i = 1; i < this.inventory.func_70302_i_(); ++i) {
            if (!(this.inventory.func_70301_a(i).func_77973_b() instanceof ItemArrow)) continue;
            return true;
        }
        return this.func_184614_ca().func_77973_b() instanceof ItemBow && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)this.func_184614_ca()) > 0;
    }

    public static enum Task {
        FOLLOW,
        STAY,
        ADVENTURE,
        GO_HOME,
        STUDY,
        TRY_TO_SLEEP,
        IDENTIFY;

    }
}

