/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.handler;

import com.google.common.collect.Streams;
import com.windanesz.arcaneapprentices.Settings;
import com.windanesz.arcaneapprentices.Utils;
import com.windanesz.arcaneapprentices.data.PlayerData;
import com.windanesz.arcaneapprentices.data.Speech;
import com.windanesz.arcaneapprentices.data.StoredEntity;
import com.windanesz.arcaneapprentices.data.Talent;
import com.windanesz.arcaneapprentices.entity.living.EntityWizardInitiate;
import com.windanesz.arcaneapprentices.handler.XpProgression;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.construct.EntityFireRing;
import electroblob.wizardry.entity.construct.EntityIceBarrier;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.entity.projectile.EntityDart;
import electroblob.wizardry.entity.projectile.EntityForceOrb;
import electroblob.wizardry.entity.projectile.EntityIceShard;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.integration.DamageSafetyChecker;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Banish;
import electroblob.wizardry.spell.CurseOfSoulbinding;
import electroblob.wizardry.spell.Disintegration;
import electroblob.wizardry.spell.GreaterHeal;
import electroblob.wizardry.spell.Heal;
import electroblob.wizardry.spell.HealAlly;
import electroblob.wizardry.spell.ImbueWeapon;
import electroblob.wizardry.spell.SpellConjuration;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.IElementalDamage;
import electroblob.wizardry.util.Location;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public final class EventHandler {
    private EventHandler() {
    }

    public static void tickArtefacts(EntityWizardInitiate npc) {
        World world = npc.field_70170_p;
        for (ItemStack artefactStack : npc.getActiveArtefacts()) {
            List barriers;
            Item artefact = artefactStack.func_77973_b();
            if (!Settings.isArtefactEnabledForNPC(artefact)) continue;
            if (artefact == WizardryItems.ring_condensing) {
                if (npc.field_70173_aa % 150 != 0) continue;
                for (ItemStack stack : npc.getHeldItems()) {
                    if (!(stack.func_77973_b() instanceof ISpellCastingItem) || !(stack.func_77973_b() instanceof IManaStoringItem)) continue;
                    ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, 1);
                }
                continue;
            }
            if (artefact == WizardryItems.amulet_arcane_defence) {
                if (npc.field_70173_aa % 300 != 0) continue;
                for (ItemStack stack : npc.func_184193_aE()) {
                    if (!(stack.func_77973_b() instanceof IManaStoringItem)) continue;
                    ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, 1);
                }
                continue;
            }
            if (artefact == WizardryItems.amulet_recovery) {
                int totalArmourMana;
                if (!npc.shouldHeal() || !(npc.func_110143_aJ() < npc.func_110138_aP() / 2.0f) || npc.field_70173_aa % 50 != 0 || (totalArmourMana = Streams.stream(npc.func_184193_aE()).filter(s -> s.func_77973_b() instanceof IManaStoringItem).mapToInt(s -> ((IManaStoringItem)s.func_77973_b()).getMana(s)).sum()) < 2) continue;
                npc.func_70691_i(1.0f);
                List chargedArmour = Streams.stream(npc.func_184193_aE()).filter(s -> s.func_77973_b() instanceof IManaStoringItem).filter(s -> !((IManaStoringItem)s.func_77973_b()).isManaEmpty(s)).collect(Collectors.toList());
                if (chargedArmour.size() == 1) {
                    ((IManaStoringItem)((ItemStack)chargedArmour.get(0)).func_77973_b()).consumeMana((ItemStack)chargedArmour.get(0), 2, (EntityLivingBase)npc);
                    continue;
                }
                Collections.shuffle(chargedArmour);
                ((IManaStoringItem)((ItemStack)chargedArmour.get(0)).func_77973_b()).consumeMana((ItemStack)chargedArmour.get(0), 1, (EntityLivingBase)npc);
                ((IManaStoringItem)((ItemStack)chargedArmour.get(1)).func_77973_b()).consumeMana((ItemStack)chargedArmour.get(1), 1, (EntityLivingBase)npc);
                continue;
            }
            if (artefact != WizardryItems.amulet_frost_warding || world.field_72995_K || npc.field_70173_aa % 40 != 0 || (barriers = world.func_72872_a(EntityIceBarrier.class, npc.func_174813_aQ().func_186662_g(1.5))).isEmpty() || !barriers.stream().anyMatch(b -> b.func_70040_Z().func_72430_b(b.func_174791_d().func_178788_d(npc.func_174791_d())) > 0.0)) continue;
            npc.func_70690_d(new PotionEffect(WizardryPotions.ward, 50, 1));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (event.getCaster() instanceof EntityWizardInitiate) {
            EntityWizardInitiate npc = (EntityWizardInitiate)event.getCaster();
            SpellModifiers modifiers = event.getModifiers();
            if (npc.getTalent() == Talent.SPELL_TINKERER && npc.hasTalentUnlocked() && AllyDesignationSystem.isAllied((EntityLivingBase)event.getCaster(), (EntityLivingBase)npc)) {
                event.getModifiers().set(WizardryItems.duration_upgrade, event.getModifiers().get(WizardryItems.duration_upgrade) * 1.5f, false);
                event.getModifiers().set(WizardryItems.blast_upgrade, event.getModifiers().get(WizardryItems.duration_upgrade) * 1.5f, true);
                event.getModifiers().set(WizardryItems.range_upgrade, event.getModifiers().get(WizardryItems.duration_upgrade) * 1.5f, true);
            }
            for (ItemStack artefactStack : npc.getActiveArtefacts()) {
                Item artefact = artefactStack.func_77973_b();
                if (!Settings.isArtefactEnabledForNPC(artefact)) continue;
                float potency = modifiers.get("potency");
                float cooldown = modifiers.get(WizardryItems.cooldown_upgrade);
                Biome biome = npc.field_70170_p.func_180494_b(npc.func_180425_c());
                if (artefact == WizardryItems.ring_battlemage) {
                    if (!(npc.func_184592_cb().func_77973_b() instanceof ISpellCastingItem) || !ImbueWeapon.isSword((ItemStack)npc.func_184614_ca())) continue;
                    modifiers.set("potency", 1.1f * potency, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_fire_biome) {
                    if (event.getSpell().getElement() != Element.FIRE || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) continue;
                    modifiers.set("potency", 1.3f * potency, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_ice_biome) {
                    if (event.getSpell().getElement() != Element.ICE || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) continue;
                    modifiers.set("potency", 1.3f * potency, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_earth_biome) {
                    if (event.getSpell().getElement() != Element.EARTH || !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) continue;
                    modifiers.set("potency", 1.3f * potency, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_storm) {
                    if (event.getSpell().getElement() != Element.LIGHTNING || !npc.field_70170_p.func_72911_I()) continue;
                    modifiers.set(WizardryItems.cooldown_upgrade, cooldown * 0.3f, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_full_moon) {
                    if (event.getSpell().getElement() != Element.EARTH || npc.field_70170_p.func_72935_r() || npc.field_70170_p.field_73011_w.func_76559_b(npc.field_70170_p.func_72820_D()) != 0) continue;
                    modifiers.set(WizardryItems.cooldown_upgrade, cooldown * 0.3f, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_blockwrangler) {
                    if (event.getSpell() != Spells.greater_telekinesis) continue;
                    modifiers.set("potency", modifiers.get("potency") * 2.0f, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_conjurer) {
                    if (!(event.getSpell() instanceof SpellConjuration)) continue;
                    modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) * 2.0f, false);
                    continue;
                }
                if (artefact == WizardryItems.charm_minion_health) {
                    modifiers.set("minion_health", 1.25f * modifiers.get("minion_health"), true);
                    continue;
                }
                if (artefact != WizardryItems.charm_experience_tome) continue;
                modifiers.set("progression", modifiers.get("progression") * 1.5f, false);
            }
        }
        if (event.getCaster() != null) {
            for (EntityWizardInitiate initiate : EntityUtils.getEntitiesWithinRadius((double)16.0, (double)event.getCaster().field_70165_t, (double)event.getCaster().field_70163_u, (double)event.getCaster().field_70161_v, (World)event.getWorld(), EntityWizardInitiate.class)) {
                if (initiate.getTalent() != Talent.SPELL_TINKERER || !initiate.hasTalentUnlocked() || !AllyDesignationSystem.isAllied((EntityLivingBase)event.getCaster(), (EntityLivingBase)initiate) || !(initiate.func_184614_ca().func_77973_b() instanceof ItemWand)) continue;
                Element elm = ((ItemWand)initiate.func_184614_ca().func_77973_b()).element;
                if (!AllyDesignationSystem.isAllied((EntityLivingBase)initiate, (EntityLivingBase)event.getCaster()) || !(event.getCaster().func_184614_ca().func_77973_b() instanceof ItemWand) || ((ItemWand)event.getCaster().func_184614_ca().func_77973_b()).element != elm) continue;
                event.getModifiers().set(WizardryItems.duration_upgrade, event.getModifiers().get(WizardryItems.duration_upgrade) * 1.25f, false);
                event.getModifiers().set(WizardryItems.blast_upgrade, event.getModifiers().get(WizardryItems.blast_upgrade) * 1.25f, true);
                event.getModifiers().set(WizardryItems.range_upgrade, event.getModifiers().get(WizardryItems.range_upgrade) * 1.25f, true);
                if (!event.getWorld().field_72995_K) continue;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).clr(((int[])BlockReceptacle.PARTICLE_COLOURS.get(elm))[0]).time(20).pos(initiate.field_70165_t, initiate.field_70163_u + (double)(initiate.field_70131_O / 2.0f), initiate.field_70161_v).target((Entity)event.getCaster()).spawn(event.getWorld());
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BEAM).clr(((int[])BlockReceptacle.PARTICLE_COLOURS.get(elm))[0]).time(10).scale(2.0f).pos(initiate.field_70165_t, initiate.field_70163_u + (double)(initiate.field_70131_O / 2.0f), initiate.field_70161_v).target((Entity)event.getCaster()).spawn(event.getWorld());
            }
        }
    }

    @SubscribeEvent
    public static void onSpellCastPostEvent(SpellCastEvent.Post event) {
        if (event.getWorld().field_73012_v.nextFloat() < Settings.generalSettings.SPELL_REMARK_MESSAGE_CHANCE) {
            List<Object> wizards = new ArrayList();
            wizards = event.getCaster() != null ? Utils.getEntitiesWithinRadius(13.0, event.getCaster().field_70165_t, event.getCaster().field_70163_u, event.getCaster().field_70161_v, event.getWorld(), EntityWizardInitiate.class) : Utils.getEntitiesWithinRadius(13.0, event.getX(), event.getY(), event.getZ(), event.getWorld(), EntityWizardInitiate.class);
            if (!wizards.isEmpty()) {
                EntityWizardInitiate wizard = (EntityWizardInitiate)((Object)wizards.get(0));
                if (wizards.size() > 1) {
                    wizard = (EntityWizardInitiate)((Object)wizards.get(event.getWorld().field_73012_v.nextInt(wizards.size() - 1)));
                }
                if (event.getCaster() == wizard.func_70902_q()) {
                    wizard.addExperience(Settings.generalSettings.XP_GAIN_ON_WATCHING_PLAYER_USING_MAGIC * (event.getSpell().getTier().ordinal() + 1));
                    if (event.getSpell().getTier().ordinal() < 3) {
                        wizard.sayImmediately(new TextComponentTranslation(Speech.WIZARD_OWNER_SPELL_CAST_COMPLIMENT_LOW_TIER.getRandom(), new Object[]{event.getSpell().getDisplayName()}));
                    } else {
                        wizard.sayImmediately(new TextComponentTranslation(Speech.WIZARD_OWNER_SPELL_CAST_COMPLIMENT_HIGH_TIER.getRandom(), new Object[]{event.getSpell().getDisplayName()}));
                    }
                } else if (event.getSource() == SpellCastEvent.Source.DISPENSER) {
                    wizard.sayImmediately(new TextComponentTranslation(Speech.WIZARD_NEARBY_DISPENSER_SPELL_CAST.getRandom(), new Object[]{event.getSpell().getDisplayName()}));
                } else if (event.getCaster() instanceof EntityEvilWizard) {
                    wizard.sayImmediately(new TextComponentTranslation(Speech.WIZARD_NEARBY_HOSTILE_SPELL_CAST.getRandom(), new Object[]{event.getSpell().getDisplayName()}));
                }
            }
        }
        if (event.getCaster() instanceof EntityWizardInitiate) {
            EntityWizardInitiate caster = (EntityWizardInitiate)event.getCaster();
            if (Settings.isArtefactEnabledForNPC(WizardryItems.ring_paladin) && caster.isArtefactActive(WizardryItems.ring_paladin) && (event.getSpell() instanceof Heal || event.getSpell() instanceof HealAlly || event.getSpell() instanceof GreaterHeal)) {
                float healthGained = event.getSpell().getProperty("health").floatValue() * event.getModifiers().get("potency");
                List nearby = EntityUtils.getLivingWithinRadius((double)4.0, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)event.getWorld());
                for (EntityLivingBase entity : nearby) {
                    if (!AllyDesignationSystem.isAllied((EntityLivingBase)caster, (EntityLivingBase)entity) || !(entity.func_110143_aJ() > 0.0f) || !(entity.func_110143_aJ() < entity.func_110138_aP())) continue;
                    entity.func_70691_i(healthGained * 0.2f);
                    if (!event.getWorld().field_72995_K) continue;
                    ParticleBuilder.spawnHealParticles((World)event.getWorld(), (EntityLivingBase)entity);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        EntityWizardInitiate npc;
        if (event.getEntity() instanceof EntityWizardInitiate) {
            npc = (EntityWizardInitiate)event.getEntity();
            for (ItemStack artefactStack : npc.getActiveArtefacts()) {
                EntityLivingBase target2;
                Item artefact = artefactStack.func_77973_b();
                if (!Settings.isArtefactEnabledForNPC(artefact)) continue;
                if (artefact == WizardryItems.amulet_warding) {
                    if (event.getSource().func_76363_c() || !event.getSource().func_82725_o()) continue;
                    event.setAmount(event.getAmount() * 0.9f);
                    continue;
                }
                if (artefact == WizardryItems.amulet_fire_protection) {
                    if (!event.getSource().func_76347_k()) continue;
                    event.setAmount(event.getAmount() * 0.7f);
                    continue;
                }
                if (artefact == WizardryItems.amulet_ice_protection) {
                    if (!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.FROST) continue;
                    event.setAmount(event.getAmount() * 0.7f);
                    continue;
                }
                if (artefact == WizardryItems.amulet_channeling) {
                    if (!(npc.field_70170_p.field_73012_v.nextFloat() < 0.3f) || !(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.SHOCK) continue;
                    event.setCanceled(true);
                    return;
                }
                if (artefact == WizardryItems.amulet_fire_cloaking) {
                    if (event.getSource().func_76363_c()) continue;
                    List fireRings = npc.field_70170_p.func_72872_a(EntityFireRing.class, npc.func_174813_aQ());
                    for (EntityFireRing fireRing : fireRings) {
                        if (!(fireRing.getCaster() instanceof EntityWizardInitiate) || fireRing.getCaster() != npc && !AllyDesignationSystem.isAllied((EntityLivingBase)npc, (EntityLivingBase)fireRing.getCaster())) continue;
                        event.setAmount(event.getAmount() * 0.25f);
                    }
                    continue;
                }
                if (artefact == WizardryItems.amulet_potential) {
                    if (!(npc.field_70170_p.field_73012_v.nextFloat() < 0.2f) || !EntityUtils.isMeleeDamage((DamageSource)event.getSource()) || !(event.getSource().func_76346_g() instanceof EntityLivingBase)) continue;
                    target2 = (EntityLivingBase)event.getSource().func_76346_g();
                    if (npc.field_70170_p.field_72995_K) {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LIGHTNING).entity(event.getEntity()).pos(0.0, (double)(event.getEntity().field_70131_O / 2.0f), 0.0).target((Entity)target2).spawn(npc.field_70170_p);
                        ParticleBuilder.spawnShockParticles((World)npc.field_70170_p, (double)target2.field_70165_t, (double)(target2.field_70163_u + (double)(target2.field_70131_O / 2.0f)), (double)target2.field_70161_v);
                    }
                    DamageSafetyChecker.attackEntitySafely((Entity)target2, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)npc, (MagicDamage.DamageType)MagicDamage.DamageType.SHOCK, (boolean)true), (float)Spells.static_aura.getProperty("damage").floatValue(), (String)event.getSource().func_76355_l());
                    target2.func_184185_a(WizardrySounds.SPELL_STATIC_AURA_RETALIATE, 1.0f, npc.field_70170_p.field_73012_v.nextFloat() * 0.4f + 1.5f);
                    continue;
                }
                if (artefact == WizardryItems.amulet_lich) {
                    if (event.getSource().func_76363_c() || !(npc.field_70170_p.field_73012_v.nextFloat() < 0.15f)) continue;
                    List nearbyMobs = EntityUtils.getEntitiesWithinRadius((double)5.0, (double)npc.field_70165_t, (double)npc.field_70163_u, (double)npc.field_70161_v, (World)npc.field_70170_p, EntityLiving.class);
                    nearbyMobs.removeIf(e -> !(e instanceof ISummonedCreature) || ((ISummonedCreature)e).getCaster() != npc);
                    if (nearbyMobs.isEmpty()) continue;
                    Collections.shuffle(nearbyMobs);
                    DamageSafetyChecker.attackEntitySafely((Entity)((Entity)nearbyMobs.get(0)), (DamageSource)event.getSource(), (float)event.getAmount(), (String)event.getSource().func_76355_l());
                    event.setCanceled(true);
                    return;
                }
                if (artefact == WizardryItems.amulet_banishing) {
                    if (!(npc.field_70170_p.field_73012_v.nextFloat() < 0.2f) || !EntityUtils.isMeleeDamage((DamageSource)event.getSource()) || !(event.getSource().func_76346_g() instanceof EntityLivingBase)) continue;
                    target2 = (EntityLivingBase)event.getSource().func_76346_g();
                    ((Banish)Spells.banish).teleport(target2, target2.field_70170_p, 8.0 + target2.field_70170_p.field_73012_v.nextDouble() * 8.0);
                    continue;
                }
                if (artefact != WizardryItems.amulet_transience || !(npc.func_110143_aJ() <= 6.0f) || !(npc.field_70170_p.field_73012_v.nextFloat() < 0.25f)) continue;
                npc.func_70690_d(new PotionEffect(WizardryPotions.transience, 300));
                npc.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 300, 0, false, false));
            }
        }
        if (event.getSource().func_76346_g() instanceof EntityWizardInitiate) {
            npc = (EntityWizardInitiate)event.getSource().func_76346_g();
            ItemStack mainhandItem = npc.func_184614_ca();
            World world = npc.field_70170_p;
            for (ItemStack artefactStack : npc.getActiveArtefacts()) {
                Item artefact = artefactStack.func_77973_b();
                if (!Settings.isArtefactEnabledForNPC(artefact)) continue;
                if (artefact == WizardryItems.ring_fire_melee) {
                    if (!EntityUtils.isMeleeDamage((DamageSource)event.getSource()) || !(mainhandItem.func_77973_b() instanceof ItemWand) || ((ItemWand)mainhandItem.func_77973_b()).element != Element.FIRE) continue;
                    event.getEntity().func_70015_d(5);
                    continue;
                }
                if (artefact == WizardryItems.ring_ice_melee) {
                    if (!EntityUtils.isMeleeDamage((DamageSource)event.getSource()) || !(mainhandItem.func_77973_b() instanceof ItemWand) || ((ItemWand)mainhandItem.func_77973_b()).element != Element.ICE) continue;
                    event.getEntityLiving().func_70690_d(new PotionEffect(WizardryPotions.frost, 200, 0));
                    continue;
                }
                if (artefact == WizardryItems.ring_lightning_melee) {
                    if (!EntityUtils.isMeleeDamage((DamageSource)event.getSource()) || !(mainhandItem.func_77973_b() instanceof ItemWand) || ((ItemWand)mainhandItem.func_77973_b()).element != Element.LIGHTNING) continue;
                    EntityUtils.getLivingWithinRadius((double)3.0, (double)npc.field_70165_t, (double)npc.field_70163_u, (double)npc.field_70161_v, (World)world).stream().filter(EntityUtils::isLiving).filter(e -> e != npc).min(Comparator.comparingDouble(arg_0 -> ((EntityWizardInitiate)npc).func_70068_e(arg_0))).ifPresent(target -> {
                        if (world.field_72995_K) {
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LIGHTNING).entity(event.getEntity()).pos(0.0, (double)(event.getEntity().field_70131_O / 2.0f), 0.0).target((Entity)target).spawn(world);
                            ParticleBuilder.spawnShockParticles((World)world, (double)target.field_70165_t, (double)(target.field_70163_u + (double)(target.field_70131_O / 2.0f)), (double)target.field_70161_v);
                        }
                        DamageSafetyChecker.attackEntitySafely((Entity)target, (DamageSource)MagicDamage.causeDirectMagicDamage((Entity)npc, (MagicDamage.DamageType)MagicDamage.DamageType.SHOCK, (boolean)true), (float)Spells.static_aura.getProperty("damage").floatValue(), (String)event.getSource().func_76355_l());
                        target.func_184185_a(WizardrySounds.SPELL_STATIC_AURA_RETALIATE, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.5f);
                    });
                    continue;
                }
                if (artefact == WizardryItems.ring_necromancy_melee) {
                    if (!EntityUtils.isMeleeDamage((DamageSource)event.getSource()) || !(mainhandItem.func_77973_b() instanceof ItemWand) || ((ItemWand)mainhandItem.func_77973_b()).element != Element.NECROMANCY) continue;
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_82731_v, 200, 0));
                    continue;
                }
                if (artefact == WizardryItems.ring_earth_melee) {
                    if (!EntityUtils.isMeleeDamage((DamageSource)event.getSource()) || !(mainhandItem.func_77973_b() instanceof ItemWand) || ((ItemWand)mainhandItem.func_77973_b()).element != Element.EARTH) continue;
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 0));
                    continue;
                }
                if (artefact == WizardryItems.ring_shattering) {
                    if (npc.field_70170_p.field_72995_K || !(npc.field_70170_p.field_73012_v.nextFloat() < 0.15f) || !(event.getEntityLiving().func_110143_aJ() < 12.0f) || !event.getEntityLiving().func_70644_a(WizardryPotions.frost) || !EntityUtils.isMeleeDamage((DamageSource)event.getSource())) continue;
                    event.setAmount(12.0f);
                    for (int i = 0; i < 8; ++i) {
                        double dx = event.getEntity().field_70170_p.field_73012_v.nextDouble() - 0.5;
                        double dy = event.getEntity().field_70170_p.field_73012_v.nextDouble() - 0.5;
                        double dz = event.getEntity().field_70170_p.field_73012_v.nextDouble() - 0.5;
                        EntityIceShard iceshard = new EntityIceShard(event.getEntity().field_70170_p);
                        iceshard.func_70107_b(event.getEntity().field_70165_t + dx + Math.signum(dx) * (double)event.getEntity().field_70130_N, event.getEntity().field_70163_u + (double)(event.getEntity().field_70131_O / 2.0f) + dy, event.getEntity().field_70161_v + dz + Math.signum(dz) * (double)event.getEntity().field_70130_N);
                        iceshard.field_70159_w = dx * 1.5;
                        iceshard.field_70181_x = dy * 1.5;
                        iceshard.field_70179_y = dz * 1.5;
                        iceshard.setCaster((EntityLivingBase)npc);
                        event.getEntity().field_70170_p.func_72838_d((Entity)iceshard);
                    }
                    continue;
                }
                if (artefact == WizardryItems.ring_soulbinding) {
                    if ((!(event.getSource() instanceof IElementalDamage) || !(npc.func_70902_q() instanceof EntityPlayer) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.WITHER) && (event.getSource().func_76364_f() != npc || EntityUtils.isMeleeDamage((DamageSource)event.getSource()) || !Streams.stream((Iterable)npc.func_184214_aD()).anyMatch(s -> s.func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)s.func_77973_b()).getCurrentSpell(s).getElement() == Element.NECROMANCY))) continue;
                    event.getEntityLiving().func_70690_d(new PotionEffect(WizardryPotions.curse_of_soulbinding, 400));
                    CurseOfSoulbinding.getSoulboundCreatures((WizardData)WizardData.get((EntityPlayer)((EntityPlayer)npc.func_70902_q()))).add(event.getEntity().func_110124_au());
                    continue;
                }
                if (artefact == WizardryItems.ring_leeching) {
                    if (!(npc.field_70170_p.field_73012_v.nextFloat() < 0.3f) || (!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.WITHER) && (event.getSource().func_76364_f() != npc || EntityUtils.isMeleeDamage((DamageSource)event.getSource()) || !Streams.stream((Iterable)npc.func_184214_aD()).anyMatch(s -> s.func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)s.func_77973_b()).getCurrentSpell(s).getElement() == Element.NECROMANCY && ((ISpellCastingItem)s.func_77973_b()).getCurrentSpell(s) != Spells.life_drain)) || !npc.shouldHeal()) continue;
                    npc.func_70691_i(event.getAmount() * Spells.life_drain.getProperty("heal_factor").floatValue());
                    continue;
                }
                if (artefact == WizardryItems.ring_poison) {
                    if ((!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.POISON) && !(event.getSource().func_76364_f() instanceof EntityDart) && (event.getSource().func_76364_f() != npc || EntityUtils.isMeleeDamage((DamageSource)event.getSource()) || !Streams.stream((Iterable)npc.func_184214_aD()).anyMatch(s -> s.func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)s.func_77973_b()).getCurrentSpell(s).getElement() == Element.EARTH))) continue;
                    event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 0));
                    continue;
                }
                if (artefact != WizardryItems.ring_extraction || (!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.FORCE) && !(event.getSource().func_76364_f() instanceof EntityForceOrb) && (event.getSource().func_76364_f() != npc || EntityUtils.isMeleeDamage((DamageSource)event.getSource()) || !Streams.stream((Iterable)npc.func_184214_aD()).anyMatch(s -> s.func_77973_b() instanceof ISpellCastingItem && ((ISpellCastingItem)s.func_77973_b()).getCurrentSpell(s).getElement() == Element.SORCERY))) continue;
                npc.getHeldItems().stream().filter(s -> s.func_77973_b() instanceof ISpellCastingItem && s.func_77973_b() instanceof IManaStoringItem && !((IManaStoringItem)s.func_77973_b()).isManaFull(s)).findFirst().ifPresent(s -> ((IManaStoringItem)s.func_77973_b()).rechargeMana(s, 4 + world.field_73012_v.nextInt(3)));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityLivingBase && event.getSource().func_76346_g() instanceof EntityWizardInitiate) {
            EntityWizardInitiate wizard = (EntityWizardInitiate)event.getSource().func_76346_g();
            wizard.addExperience(XpProgression.getXpGainPerKill());
            if (wizard.field_70170_p.field_73012_v.nextFloat() < Settings.generalSettings.KILL_MESSAGE_CHANCE) {
                wizard.sayImmediately(new TextComponentTranslation(Speech.WIZARD_SLAY_ENEMY.getRandom(), new Object[]{event.getEntity().func_145748_c_()}));
            }
            wizard.resetChatCooldown();
        }
        if (event.getSource().func_76346_g() instanceof EntityWizardInitiate) {
            EntityWizardInitiate npc = (EntityWizardInitiate)event.getSource().func_76346_g();
            for (ItemStack artefactStack : npc.getActiveArtefacts()) {
                Item artefact = artefactStack.func_77973_b();
                if (artefact == WizardryItems.ring_combustion) {
                    if (!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.FIRE) continue;
                    event.getEntity().field_70170_p.func_72876_a(event.getEntity(), event.getEntity().field_70165_t, event.getEntity().field_70163_u, event.getEntity().field_70161_v, 1.5f, false);
                    continue;
                }
                if (artefact == WizardryItems.ring_disintegration) {
                    if (!(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.FIRE) continue;
                    Disintegration.spawnEmbers((World)event.getEntity().field_70170_p, (EntityLivingBase)npc, (Entity)event.getEntity(), (int)Spells.disintegration.getProperty("ember_count").intValue());
                    continue;
                }
                if (artefact != WizardryItems.ring_arcane_frost || npc.field_70170_p.field_72995_K || !(event.getSource() instanceof IElementalDamage) || ((IElementalDamage)event.getSource()).getType() != MagicDamage.DamageType.FROST) continue;
                for (int i = 0; i < 8; ++i) {
                    double dx = event.getEntity().field_70170_p.field_73012_v.nextDouble() - 0.5;
                    double dy = event.getEntity().field_70170_p.field_73012_v.nextDouble() - 0.5;
                    double dz = event.getEntity().field_70170_p.field_73012_v.nextDouble() - 0.5;
                    EntityIceShard iceshard = new EntityIceShard(event.getEntity().field_70170_p);
                    iceshard.func_70107_b(event.getEntity().field_70165_t + dx + Math.signum(dx) * (double)event.getEntity().field_70130_N, event.getEntity().field_70163_u + (double)(event.getEntity().field_70131_O / 2.0f) + dy, event.getEntity().field_70161_v + dz + Math.signum(dz) * (double)event.getEntity().field_70130_N);
                    iceshard.field_70159_w = dx * 1.5;
                    iceshard.field_70181_x = dy * 1.5;
                    iceshard.field_70179_y = dz * 1.5;
                    iceshard.setCaster((EntityLivingBase)npc);
                    event.getEntity().field_70170_p.func_72838_d((Entity)iceshard);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeathEventLowest(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityWizardInitiate) {
            EntityWizardInitiate wizard = (EntityWizardInitiate)event.getSource().func_76346_g();
            for (ItemStack stack : wizard.getHeldItems()) {
                if (!(stack.func_77973_b() instanceof IManaStoringItem) || ((IManaStoringItem)stack.func_77973_b()).isManaFull(stack) || WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.siphon_upgrade) <= 0) continue;
                int mana = 5 * WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.siphon_upgrade) + wizard.field_70170_p.field_73012_v.nextInt(5);
                if (wizard.isArtefactActive(WizardryItems.ring_siphoning)) {
                    mana = (int)((float)mana * 1.3f);
                }
                ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, mana);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPotionApplicableEvent(PotionEvent.PotionApplicableEvent event) {
        if (event.getEntity() instanceof EntityWizardInitiate) {
            EntityWizardInitiate npc = (EntityWizardInitiate)event.getEntity();
            for (ItemStack artefactStack : npc.getActiveArtefacts()) {
                Item artefact = artefactStack.func_77973_b();
                if (!Settings.isArtefactEnabledForNPC(artefact)) continue;
                if (artefact == WizardryItems.amulet_ice_immunity) {
                    if (event.getPotionEffect().func_188419_a() != WizardryPotions.frost) continue;
                    event.setResult(Event.Result.DENY);
                    continue;
                }
                if (artefact != WizardryItems.amulet_wither_immunity || event.getPotionEffect().func_188419_a() != MobEffects.field_82731_v) continue;
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerSleepInBedEvent(PlayerSleepInBedEvent event) {
        List<StoredEntity> list;
        if (Settings.generalSettings.APPRENTICES_RESPAWN_AT_PLAYER_SPAWNPOINT && !(list = PlayerData.getDeadApprentices(event.getEntityPlayer())).isEmpty()) {
            ArrayList<UUID> respawnedEntities = new ArrayList<UUID>();
            for (StoredEntity entity : list) {
                Entity mob;
                World world = event.getEntityPlayer().field_70170_p;
                BlockPos pos = BlockUtils.findNearbyFloorSpace((Entity)event.getEntityPlayer(), (int)5, (int)5);
                Arrays.asList("CurrentStayPos", "Motion", "Leashed", "ActiveEffects", "FallDistance", "HurtTime", "Fire", "FoodLevel", "FoodSaturation", "Health").forEach(tag -> entity.getNbtTagCompound().func_82580_o(tag));
                if (pos == null || !((mob = EntityList.func_75615_a((NBTTagCompound)entity.getNbtTagCompound(), (World)world)) instanceof EntityLivingBase)) continue;
                mob.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                ((EntityWizardInitiate)mob).setFoodLevel(20.0f);
                ((EntityWizardInitiate)mob).setSaturation(10.0f);
                ((EntityWizardInitiate)mob).resetChatCooldown();
                ((EntityWizardInitiate)mob).resetRareEventCooldown();
                if (!world.func_72838_d(mob)) continue;
                respawnedEntities.add(mob.func_110124_au());
                Utils.sendMessage((Entity)event.getEntityPlayer(), "message.arcaneapprentices:wizard_respawned", false, ((EntityWizardInitiate)mob).getDisplayNameWithoutOwner());
            }
            for (UUID uuid : respawnedEntities) {
                PlayerData.removeDeadApprentice(event.getEntityPlayer(), uuid);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        List<StoredEntity> list;
        List<StoredEntity> list2;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!event.player.field_70170_p.field_72995_K && event.player.field_70173_aa % 61 == 0 && !(list2 = PlayerData.getPendingHomeApprentices(event.player)).isEmpty()) {
            ArrayList<UUID> respawnedEntities = new ArrayList<UUID>();
            for (StoredEntity entity : list2) {
                Entity mob;
                World world = event.player.field_70170_p;
                if (!entity.getNbtTagCompound().func_74764_b("HomePos")) continue;
                Location homePos = Location.fromNBT((NBTTagCompound)entity.getNbtTagCompound().func_74775_l("HomePos"));
                if (event.player.field_71093_bK != homePos.dimension || !event.player.field_70170_p.func_175667_e(homePos.pos) || !(event.player.func_70011_f((double)homePos.pos.func_177958_n(), (double)homePos.pos.func_177956_o(), (double)homePos.pos.func_177952_p()) < 12.0)) continue;
                BlockPos pos = BlockUtils.findNearbyFloorSpace((World)event.player.field_70170_p, (BlockPos)homePos.pos, (int)3, (int)3);
                Arrays.asList("CurrentStayPos", "Motion", "Leashed", "ActiveEffects", "FallDistance", "HurtTime", "Fire").forEach(tag -> entity.getNbtTagCompound().func_82580_o(tag));
                if (pos == null || !((mob = EntityList.func_75615_a((NBTTagCompound)entity.getNbtTagCompound(), (World)world)) instanceof EntityLivingBase)) continue;
                mob.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                if (!world.func_72838_d(mob)) continue;
                respawnedEntities.add(mob.func_110124_au());
            }
            for (UUID uuid : respawnedEntities) {
                PlayerData.removePendingHomeApprentice(event.player, uuid);
            }
        }
        int tickRate = 55;
        if (!event.player.field_70170_p.field_72995_K && event.player.field_70173_aa % tickRate == 0 && !(list = PlayerData.getAdventuringApprentices(event.player)).isEmpty()) {
            ArrayList<UUID> respawnedEntities = new ArrayList<UUID>();
            ArrayList<UUID> updatedEntities = new ArrayList<UUID>();
            for (StoredEntity entity : list) {
                Entity mob;
                World world = event.player.field_70170_p;
                if (!entity.getNbtTagCompound().func_74764_b("HomePos") || !entity.getNbtTagCompound().func_74764_b("AdventureRemainingDuration")) continue;
                int remainingCountdown = entity.getNbtTagCompound().func_74762_e("AdventureRemainingDuration");
                if (remainingCountdown > tickRate) {
                    updatedEntities.add(entity.getNbtTagCompound().func_186857_a("UUID"));
                    continue;
                }
                Location homePos = Location.fromNBT((NBTTagCompound)entity.getNbtTagCompound().func_74775_l("HomePos"));
                if (event.player.field_71093_bK != homePos.dimension || !event.player.field_70170_p.func_175667_e(homePos.pos) || !(event.player.func_70011_f((double)homePos.pos.func_177958_n(), (double)homePos.pos.func_177956_o(), (double)homePos.pos.func_177952_p()) < 12.0)) continue;
                BlockPos pos = BlockUtils.findNearbyFloorSpace((World)event.player.field_70170_p, (BlockPos)homePos.pos, (int)3, (int)3);
                Arrays.asList("CurrentStayPos", "Motion", "Leashed", "ActiveEffects", "FallDistance", "HurtTime", "Fire").forEach(tag -> entity.getNbtTagCompound().func_82580_o(tag));
                if (pos == null || !((mob = EntityList.func_75615_a((NBTTagCompound)entity.getNbtTagCompound(), (World)world)) instanceof EntityLivingBase)) continue;
                mob.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                if (world.func_72838_d(mob)) {
                    respawnedEntities.add(mob.func_110124_au());
                    if (mob instanceof EntityWizardInitiate) {
                        EntityWizardInitiate wizard = (EntityWizardInitiate)mob;
                        wizard.returnFromAdventuring();
                    }
                }
                respawnedEntities.add(mob.func_110124_au());
            }
            for (UUID uuid : respawnedEntities) {
                PlayerData.removeAdventuringApprentice(event.player, uuid);
            }
            for (UUID uuid : updatedEntities) {
                List<StoredEntity> list22 = PlayerData.getAdventuringApprentices(event.player);
                boolean entityUpdated = false;
                for (int i = 0; i < list22.size(); ++i) {
                    StoredEntity entity = list22.get(i);
                    if (!Objects.equals(entity.getNbtTagCompound().func_186857_a("UUID"), uuid) || entityUpdated) continue;
                    int remainingCountdown = entity.getNbtTagCompound().func_74762_e("AdventureRemainingDuration");
                    entity.getNbtTagCompound().func_74768_a("AdventureRemainingDuration", remainingCountdown -= tickRate);
                    PlayerData.removeAdventuringApprentice(event.player, uuid);
                    PlayerData.storeAdventuringApprentice(event.player, entity);
                    entityUpdated = true;
                }
            }
        }
    }

    private static void handlePendingHomeApprentices(EntityPlayer player) {
    }

    private static void handleAdventuringApprentices(EntityPlayer player, int tickRate) {
    }
}

