/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.handler;

import com.windanesz.arcaneapprentices.Settings;
import com.windanesz.arcaneapprentices.data.JourneyType;
import com.windanesz.arcaneapprentices.data.Talent;
import com.windanesz.arcaneapprentices.entity.living.EntityWizardInitiate;
import com.windanesz.arcaneapprentices.registry.AAItems;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.math.MathHelper;

public class JourneySurvivalHandler {
    private int armour;
    private int armourToughness;
    private int level;
    private int numKnownSpells;
    private double currentHealthPercent;
    private double maxHealth;
    private JourneyType journey;
    private EntityWizardInitiate wizard;
    private static final float DEFAULT_SURVIVAL_CHANCE = 0.5f;

    public JourneySurvivalHandler(EntityWizardInitiate wizard, JourneyType journey) {
        this.armour = wizard.func_70658_aO();
        IAttributeInstance iattributeinstance = wizard.func_110148_a(SharedMonsterAttributes.field_189429_h);
        this.armourToughness = MathHelper.func_76128_c((double)iattributeinstance.func_111126_e());
        this.level = wizard.getLevel();
        this.numKnownSpells = wizard.getSpells().size();
        this.currentHealthPercent = wizard.func_110143_aJ() / wizard.func_110138_aP();
        this.maxHealth = wizard.func_110138_aP();
        this.journey = journey;
        this.wizard = wizard;
    }

    public float calculateSurvivalChance() {
        if (!this.wizard.func_70631_g_() && this.wizard.getTalent() == Talent.SURVIVOR && Talent.SURVIVOR.isEnabled()) {
            return 1.0f;
        }
        float survivalChance = 0.3f;
        survivalChance -= 1.0f - this.journey.getSurvivalModifier();
        survivalChance = (float)((double)survivalChance + (double)this.armour / 30.0 * 0.3);
        survivalChance = (float)((double)survivalChance + (double)((float)this.armourToughness / 20.0f) * 0.05);
        survivalChance = (float)((double)survivalChance + (double)((float)this.level / (float)Settings.generalSettings.MAX_WIZARD_LEVEL) * 0.3);
        survivalChance = (float)((double)survivalChance + (double)((float)this.numKnownSpells / (float)Settings.generalSettings.MAX_WIZARD_SPELL_SLOTS) * 0.08);
        survivalChance = (float)((double)survivalChance + this.currentHealthPercent * 0.8 * 0.15);
        survivalChance = (float)((double)survivalChance + this.maxHealth * 0.3 * 0.01);
        if (this.wizard.isArtefactActive(AAItems.amulet_survival_chance)) {
            survivalChance *= 1.15f;
        }
        survivalChance = (float)Math.max(0.0, Math.min(1.0, (double)survivalChance));
        return survivalChance;
    }

    public static float calculateSurvivalChance(EntityWizardInitiate wizardInitiate, JourneyType journey) {
        JourneySurvivalHandler j = new JourneySurvivalHandler(wizardInitiate, journey);
        return j.calculateSurvivalChance();
    }
}

