/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.handler;

import com.windanesz.arcaneapprentices.ArcaneApprentices;
import com.windanesz.arcaneapprentices.Settings;

public final class XpProgression {
    private static final int MAX_LEVEL = 30;
    private static final double BASE_XP = 100.0;
    private static final double XP_MULTIPLIER = 1.2;
    private static final double[] XP_TABLE = new double[30];

    public static int getMaxLevel() {
        return Settings.generalSettings.MAX_WIZARD_LEVEL;
    }

    public static int getXpGainPerKill() {
        return Settings.generalSettings.XP_GAIN_PER_KILL;
    }

    public static int getXpGainPerSpellCast() {
        return Settings.generalSettings.XP_GAIN_PER_SPELL_CAST;
    }

    private XpProgression() {
    }

    public static double calculateXpRequired(int level) {
        if (level < 1 || level > 30) {
            ArcaneApprentices.logger.warn("Invalid level: " + level);
            return 0.0;
        }
        return 100.0 * Math.pow(1.2, level - 1);
    }

    public static int calculateNextLevel(double currentXp) {
        for (int level = 1; level <= 30; ++level) {
            if (!(currentXp < XP_TABLE[level - 1])) continue;
            return level;
        }
        return 30;
    }

    public static double getXpForLevel(int targetLevel) {
        double totalXp = 0.0;
        for (int i = 0; i < targetLevel; ++i) {
            if (i >= XP_TABLE.length) {
                return Double.POSITIVE_INFINITY;
            }
            totalXp += XP_TABLE[i];
        }
        return totalXp;
    }

    public static double calculateTotalXpRequired(int level) {
        if (level < 1 || level > 30) {
            return 0.0;
        }
        double totalXp = 0.0;
        for (int i = 1; i <= level; ++i) {
            totalXp += XpProgression.calculateXpRequired(i);
        }
        return totalXp;
    }

    public static int getLevelForXp(double currentXp) {
        int level = 0;
        double totalXp = 0.0;
        for (double xp : XP_TABLE) {
            if (currentXp <= (totalXp += xp)) {
                return level;
            }
            ++level;
        }
        return level;
    }

    public static double calculateXpRequiredForNextLevel(double currentXp) {
        return 0.0;
    }

    static {
        for (int i = 0; i < 30; ++i) {
            XpProgression.XP_TABLE[i] = XpProgression.calculateXpRequired(i + 1);
        }
    }
}

