/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.items;

import com.windanesz.arcaneapprentices.client.gui.AAGuiHandler;
import com.windanesz.arcaneapprentices.inventory.IItemWithSlots;
import electroblob.wizardry.item.ItemArtefact;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemArtefactWithSlots
extends ItemArtefact
implements IItemWithSlots {
    private final int slotCount;
    private final int rows;
    private final int columns;
    private final boolean hasGUI;

    public ItemArtefactWithSlots(EnumRarity rarity, ItemArtefact.Type type, int rows, int columns, boolean hasGUI) {
        super(rarity, type);
        this.rows = rows;
        this.columns = columns;
        this.slotCount = rows * columns;
        this.hasGUI = hasGUI;
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public int getSlotCount() {
        return this.slotCount;
    }

    @Override
    public boolean hasGUI() {
        return this.hasGUI;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        player.openGui((Object)"arcaneapprentices", AAGuiHandler.ARTEFACT_BAG_GUI, world, hand.ordinal(), 0, 0);
        return new ActionResult(EnumActionResult.PASS, (Object)itemStack);
    }

    public static boolean isSlotEmpty(ItemStack stack, int slot) {
        int maxCount;
        if (stack.func_77973_b() instanceof ItemArtefactWithSlots && slot <= (maxCount = ((ItemArtefactWithSlots)stack.func_77973_b()).getSlotCount()) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Items")) {
            NBTTagList items = stack.func_77978_p().func_150295_c("Items", 10);
            NBTTagCompound nbttagcompound = items.func_150305_b(slot);
            return new ItemStack(nbttagcompound).func_190926_b();
        }
        return true;
    }

    public static ItemStack getItemForSlot(ItemStack stack, int slot) {
        int maxCount;
        if (stack.func_77973_b() instanceof ItemArtefactWithSlots && slot <= (maxCount = ((ItemArtefactWithSlots)stack.func_77973_b()).getSlotCount()) && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Items")) {
            NBTTagList items = stack.func_77978_p().func_150295_c("Items", 10);
            NBTTagCompound nbttagcompound = items.func_150305_b(slot);
            return new ItemStack(nbttagcompound);
        }
        return ItemStack.field_190927_a;
    }

    public static void setItemForSlot(ItemStack bag, ItemStack itemStack, int slot) {
        int maxCount;
        if (bag.func_77973_b() instanceof ItemArtefactWithSlots && slot <= (maxCount = ((ItemArtefactWithSlots)bag.func_77973_b()).getSlotCount())) {
            NBTTagCompound nbt = bag.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            NBTTagList items = new NBTTagList();
            if (nbt.func_74764_b("Items")) {
                items = bag.func_77978_p().func_150295_c("Items", 10);
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)slot);
            itemStack.func_77955_b(nbttagcompound);
            items.func_74742_a((NBTBase)nbttagcompound);
            nbt.func_74782_a("Items", (NBTBase)items);
            bag.func_77982_d(nbt);
        }
    }
}

