/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class BiomeLootCondition
implements LootCondition {
    private final JsonArray requiredBiomes;
    public static final String BIOME_NAME_LIST_TAG = "required_biomes";

    public BiomeLootCondition(JsonArray requiredBiomes) {
        if (requiredBiomes == null) {
            throw new IllegalArgumentException("Required biomes array cannot be null.");
        }
        this.requiredBiomes = requiredBiomes;
    }

    public boolean func_186618_a(Random rand, LootContext context) {
        EntityPlayer player = (EntityPlayer)context.func_186495_b();
        if (player != null) {
            ResourceLocation playerBiome = player.field_70170_p.func_180494_b(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v)).getRegistryName();
            for (int i = 0; i < this.requiredBiomes.size(); ++i) {
                ResourceLocation requiredBiome = new ResourceLocation(JsonUtils.func_151206_a((JsonElement)this.requiredBiomes.get(i), (String)""));
                if (!playerBiome.equals((Object)requiredBiome)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Serializer
    extends LootCondition.Serializer<BiomeLootCondition> {
        public Serializer() {
            super(new ResourceLocation("arcaneapprentices", "biome_condition"), BiomeLootCondition.class);
        }

        public void serialize(JsonObject json, BiomeLootCondition value, JsonSerializationContext context) {
            json.add(BiomeLootCondition.BIOME_NAME_LIST_TAG, (JsonElement)value.requiredBiomes);
        }

        public BiomeLootCondition deserialize(JsonObject object, JsonDeserializationContext context) {
            JsonArray requiredBiomes = JsonUtils.func_151214_t((JsonObject)object, (String)BiomeLootCondition.BIOME_NAME_LIST_TAG);
            return new BiomeLootCondition(requiredBiomes);
        }
    }
}

