/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.packet;

import com.windanesz.arcaneapprentices.Utils;
import com.windanesz.arcaneapprentices.client.gui.AAGuiHandler;
import com.windanesz.arcaneapprentices.data.JourneyType;
import com.windanesz.arcaneapprentices.data.PlayerData;
import com.windanesz.arcaneapprentices.data.Speech;
import com.windanesz.arcaneapprentices.entity.living.EntityWizardInitiate;
import com.windanesz.arcaneapprentices.inventory.ContainerWizardBase;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.Location;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketControlInput
implements IMessageHandler<Message, IMessage> {
    public IMessage onMessage(Message message, MessageContext ctx) {
        if (ctx.side.isServer()) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                switch (message.controlType) {
                    case FOLLOW_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        ((ContainerWizardBase)player.field_71070_bA).getWizard().setTask(EntityWizardInitiate.Task.FOLLOW);
                        ((ContainerWizardBase)player.field_71070_bA).getWizard().sayImmediately(new TextComponentTranslation(Speech.WIZARD_FOLLOWING_PLAYER.getRandom(), new Object[]{player.func_145748_c_()}));
                        player.func_71053_j();
                        break;
                    }
                    case STAY_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        ((ContainerWizardBase)player.field_71070_bA).getWizard().setTask(EntityWizardInitiate.Task.STAY);
                        ((ContainerWizardBase)player.field_71070_bA).getWizard().sayImmediately(new TextComponentTranslation(Speech.WIZARD_PLAYER_CLICK_HOLD_POSITION_BUTTON.getRandom(), new Object[0]));
                        player.func_71053_j();
                        break;
                    }
                    case STUDY_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        ((ContainerWizardBase)player.field_71070_bA).getWizard().setTask(EntityWizardInitiate.Task.STUDY);
                        ((ContainerWizardBase)player.field_71070_bA).getWizard().sayImmediately(new TextComponentTranslation(Speech.WIZARD_PLAYER_CLICK_STUDY_BUTTON.getRandom(), new Object[0]));
                        player.func_71053_j();
                        break;
                    }
                    case OPEN_STATS_GUI_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        player.openGui((Object)"arcaneapprentices", AAGuiHandler.WIZARD_STATS_GUI, player.field_70170_p, ((ContainerWizardBase)player.field_71070_bA).getWizard().func_145782_y(), 0, 0);
                        break;
                    }
                    case OPEN_DISMISS_WIZARD_GUI_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        player.openGui((Object)"arcaneapprentices", AAGuiHandler.WIZARD_DISMISS_CONFIRM_GUI, player.field_70170_p, ((ContainerWizardBase)player.field_71070_bA).getWizard().func_145782_y(), 0, 0);
                        break;
                    }
                    case SPELL_TOGGLE_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        ((ContainerWizardBase)player.field_71070_bA).getWizard().toggleSpellDisablement(message.spell);
                        break;
                    }
                    case SET_HOME_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        EntityWizardInitiate wizard = ((ContainerWizardBase)player.field_71070_bA).getWizard();
                        wizard.setHome(new Location(wizard.getPos(), wizard.field_71093_bK));
                        wizard.sayImmediately(new TextComponentTranslation(Speech.WIZARD_SET_HOME.getRandom(), new Object[0]));
                        player.func_71053_j();
                        break;
                    }
                    case GO_HOME_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        ((ContainerWizardBase)player.field_71070_bA).getWizard().setTask(EntityWizardInitiate.Task.GO_HOME);
                        ((ContainerWizardBase)player.field_71070_bA).getWizard().sayImmediately(new TextComponentTranslation(Speech.WIZARD_GO_HOME.getRandom(), new Object[0]));
                        player.func_71053_j();
                        break;
                    }
                    case IDENTIFY_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        ((ContainerWizardBase)player.field_71070_bA).getWizard().setTask(EntityWizardInitiate.Task.IDENTIFY);
                        ((ContainerWizardBase)player.field_71070_bA).getWizard().resetStudyProgress();
                        ((ContainerWizardBase)player.field_71070_bA).getWizard().sayImmediately(new TextComponentTranslation(Speech.WIZARD_TASKED_TO_IDENTIFY_SPELL.getRandom(), new Object[0]));
                        player.func_71053_j();
                        break;
                    }
                    case OPEN_JOURNEY_GUI_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        player.openGui((Object)"arcaneapprentices", AAGuiHandler.WIZARD_ADVENTURING_GUI, player.field_70170_p, ((ContainerWizardBase)player.field_71070_bA).getWizard().func_145782_y(), 0, 0);
                        break;
                    }
                    case OPEN_WIZARD_INVENTORY_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        player.openGui((Object)"arcaneapprentices", AAGuiHandler.WIZARD_INVENTORY_GUI, player.field_70170_p, ((ContainerWizardBase)player.field_71070_bA).getWizard().func_145782_y(), 0, 0);
                        break;
                    }
                    case JOURNEY_CONFIRM_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        EntityWizardInitiate wizard = ((ContainerWizardBase)player.field_71070_bA).getWizard();
                        if (!wizard.verifyWandManaRequirementForJourney(message.journeyType)) {
                            wizard.sayImmediately(new TextComponentTranslation("message.arcaneapprentices:no_wand_with_mana_for_journey", new Object[0]));
                        } else {
                            wizard.setJourneyType(message.journeyType);
                            wizard.goOnJourney();
                        }
                        player.func_71053_j();
                        break;
                    }
                    case DISMISS_WIZARD_BUTTON: {
                        if (!(player.field_71070_bA instanceof ContainerWizardBase)) break;
                        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
                        EntityWizardInitiate wizard = ((ContainerWizardBase)player.field_71070_bA).getWizard();
                        for (int i = 0; i < wizard.inventory.func_70302_i_(); ++i) {
                            stackList.add(wizard.inventory.func_70301_a(i).func_77946_l());
                        }
                        for (ItemStack stack : stackList) {
                            Utils.giveStackToPlayer((EntityPlayer)player, stack);
                        }
                        PlayerData.removeApprentice((EntityPlayer)player, (EntityLivingBase)wizard);
                        player.field_70170_p.func_72973_f((Entity)wizard);
                        player.func_71053_j();
                    }
                }
            });
        }
        return null;
    }

    public static class Message
    implements IMessage {
        private ControlType controlType;
        private Spell spell = Spells.none;
        private JourneyType journeyType = JourneyType.NOT_ADVENTURING;

        public Message() {
        }

        public Message(ControlType type) {
            this.controlType = type;
        }

        public Message(ControlType type, Spell spell) {
            this.controlType = type;
            this.spell = spell;
        }

        public Message(ControlType type, JourneyType journeyType) {
            this.controlType = type;
            this.journeyType = journeyType;
        }

        public void fromBytes(ByteBuf buf) {
            this.controlType = ControlType.values()[buf.readInt()];
            this.spell = Spell.byNetworkID((int)buf.readInt());
            this.journeyType = JourneyType.values()[buf.readInt()];
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.controlType.ordinal());
            buf.writeInt(this.spell.networkID());
            buf.writeInt(this.journeyType.ordinal());
        }
    }

    public static enum ControlType {
        FOLLOW_BUTTON,
        STAY_BUTTON,
        STUDY_BUTTON,
        OPEN_STATS_GUI_BUTTON,
        SPELL_TOGGLE_BUTTON,
        OPEN_DISMISS_WIZARD_GUI_BUTTON,
        DISMISS_WIZARD_BUTTON,
        CLOSE_WINDOW_BUTTON,
        SET_HOME_BUTTON,
        GO_HOME_BUTTON,
        IDENTIFY_BUTTON,
        OPEN_JOURNEY_GUI_BUTTON,
        OPEN_WIZARD_INVENTORY_BUTTON,
        JOURNEY_CONFIRM_BUTTON;

    }
}

