/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.arcaneapprentices.spell;

import com.windanesz.arcaneapprentices.data.PlayerData;
import com.windanesz.arcaneapprentices.data.StoredEntity;
import com.windanesz.arcaneapprentices.entity.living.EntityWizardInitiate;
import com.windanesz.wizardryutils.tools.WizardryUtilsTools;
import electroblob.wizardry.block.BlockTransportationStone;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class RecallApprentices
extends Spell {
    public static final String SUMMON_RADIUS = "summon_radius";

    public RecallApprentices() {
        super("arcaneapprentices", "recall_apprentices", SpellActions.SUMMON, false);
        this.addProperties(new String[]{SUMMON_RADIUS});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean flag = false;
        if (!BlockTransportationStone.testForCircle((World)world, (BlockPos)caster.func_180425_c())) {
            WizardryUtilsTools.sendMessage((Entity)caster, (String)"spell.arcaneapprentices:recall_apprentices.no_circle", (boolean)false, (Object[])new Object[0]);
            return false;
        }
        if (!world.field_72995_K) {
            flag = this.recallApprenticesFromJourneys(caster, world);
            List<UUID> nearby = PlayerData.getApprentices(caster);
            if (!nearby.isEmpty()) {
                int range = this.getProperty(SUMMON_RADIUS).intValue();
                for (UUID nearbyApprentice : nearby) {
                    BlockPos pos;
                    Entity mob = ((WorldServer)world).func_175733_a(nearbyApprentice);
                    if (!(mob instanceof EntityWizardInitiate) || (pos = BlockUtils.findNearbyFloorSpace((Entity)caster, (int)range, (int)(range * 2))) == null) continue;
                    mob.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
                    if (!world.func_72838_d(mob)) continue;
                    flag = true;
                }
            }
        } else {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).vel(0.0, 0.1, 0.0).fade(1.0f, 1.0f, 1.0f).spin((double)0.8f, (double)0.03f).time(40).entity((Entity)caster).scale(1.2f).spawn(world);
        }
        return flag;
    }

    private boolean recallApprenticesFromJourneys(EntityPlayer caster, World world) {
        boolean flag = false;
        List<StoredEntity> apprentices = PlayerData.getAdventuringApprentices(caster);
        if (apprentices.isEmpty()) {
            WizardryUtilsTools.sendMessage((Entity)caster, (String)"spell.arcaneapprentices:recall_apprentices.no_apprentices_on_journey", (boolean)false, (Object[])new Object[0]);
            return false;
        }
        ArrayList<UUID> respawnedEntities = new ArrayList<UUID>();
        for (StoredEntity storedEntity : apprentices) {
            int range;
            BlockPos pos;
            Entity mob = EntityList.func_75615_a((NBTTagCompound)storedEntity.getNbtTagCompound(), (World)world);
            if (!(mob instanceof EntityWizardInitiate) || (pos = BlockUtils.findNearbyFloorSpace((Entity)caster, (int)(range = this.getProperty(SUMMON_RADIUS).intValue()), (int)(range * 2))) == null) continue;
            mob.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
            if (!world.func_72838_d(mob)) continue;
            flag = true;
            respawnedEntities.add(mob.func_110124_au());
        }
        for (UUID uuid : respawnedEntities) {
            PlayerData.removeAdventuringApprentice(caster, uuid);
        }
        return flag;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }
}

