/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery;

import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teksturepako.greenery.client.GreeneryCreativeTab;
import teksturepako.greenery.common.block.plant.GreeneryPlant;
import teksturepako.greenery.common.command.CommandGreenery;
import teksturepako.greenery.common.config.json.Parser;
import teksturepako.greenery.common.config.json.Serializer;
import teksturepako.greenery.common.event.EventOldContentLoad;
import teksturepako.greenery.common.event.EventWorldGen;
import teksturepako.greenery.common.recipe.ModRecipes;
import teksturepako.greenery.common.registry.ModBlocks;
import teksturepako.greenery.common.registry.ModItems;
import teksturepako.greenery.common.registry.ModSoundEvents;
import teksturepako.greenery.common.util.ConfigUtil;
import teksturepako.greenery.common.util.FileUtils;
import teksturepako.greenery.common.world.WorldGenHook;
import teksturepako.greenery.common.world.gen.IPlantGenerator;
import teksturepako.greenery.common.world.gen.PlantGenerator;
import teksturepako.greenery.proxy.IProxy;

@Mod(modid="greenery", name="Greenery", version="1.12.2-4.7", dependencies="required-after:forgelin_continuous@[1.8.21.0,);required-after:fluidlogged_api@[2.0.0,);after:dynamictrees;after:biomesoplenty", acceptedMinecraftVersions="[1.12,1.12.2,)", modLanguageAdapter="io.github.chaosunity.forgelin.KotlinAdapter")
@Mod.EventBusSubscriber
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0007J\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010/\u001a\u000200J\u0016\u00101\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020302H\u0007J\u0016\u00104\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020502H\u0007J\u0016\u00106\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020702H\u0007J\u0012\u00108\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u000109H\u0007J\u0010\u0010:\u001a\u00020+2\u0006\u0010,\u001a\u00020;H\u0007J\u0010\u0010<\u001a\u00020+2\u0006\u0010,\u001a\u00020=H\u0007J\u0010\u0010>\u001a\u00020+2\u0006\u0010,\u001a\u00020?H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001aR\u001e\u0010$\u001a\u00020%8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u0006@"}, d2={"Lteksturepako/greenery/Greenery;", "", "()V", "ACCEPTED_MINECRAFT_VERSIONS", "", "ADAPTER", "CLIENT_PROXY", "DEPENDENCIES", "MODID", "NAME", "SERVER_PROXY", "VERSION", "configFolder", "Ljava/io/File;", "getConfigFolder", "()Ljava/io/File;", "setConfigFolder", "(Ljava/io/File;)V", "creativeTab", "Lteksturepako/greenery/client/GreeneryCreativeTab;", "getCreativeTab", "()Lteksturepako/greenery/client/GreeneryCreativeTab;", "generators", "", "Lteksturepako/greenery/common/world/gen/IPlantGenerator;", "getGenerators", "()Ljava/util/List;", "logger", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "setLogger", "(Lorg/apache/logging/log4j/Logger;)V", "plants", "Lteksturepako/greenery/common/block/plant/GreeneryPlant;", "getPlants", "proxy", "Lteksturepako/greenery/proxy/IProxy;", "getProxy", "()Lteksturepako/greenery/proxy/IProxy;", "setProxy", "(Lteksturepako/greenery/proxy/IProxy;)V", "init", "", "event", "Lnet/minecraftforge/fml/common/event/FMLInitializationEvent;", "loadGenerators", "printParsing", "", "onRegisterBlocks", "Lnet/minecraftforge/event/RegistryEvent$Register;", "Lnet/minecraft/block/Block;", "onRegisterItems", "Lnet/minecraft/item/Item;", "onRegisterSoundEvents", "Lnet/minecraft/util/SoundEvent;", "onServerStoppingEvent", "Lnet/minecraftforge/fml/common/event/FMLServerStoppingEvent;", "postInit", "Lnet/minecraftforge/fml/common/event/FMLPostInitializationEvent;", "preInit", "Lnet/minecraftforge/fml/common/event/FMLPreInitializationEvent;", "serverLoad", "Lnet/minecraftforge/fml/common/event/FMLServerStartingEvent;", "Greenery"})
public final class Greenery {
    @NotNull
    public static final Greenery INSTANCE = new Greenery();
    @NotNull
    public static final String MODID = "greenery";
    @NotNull
    public static final String NAME = "Greenery";
    @NotNull
    public static final String VERSION = "1.12.2-4.7";
    @NotNull
    public static final String DEPENDENCIES = "required-after:forgelin_continuous@[1.8.21.0,);required-after:fluidlogged_api@[2.0.0,);after:dynamictrees;after:biomesoplenty";
    @NotNull
    public static final String ACCEPTED_MINECRAFT_VERSIONS = "[1.12,1.12.2,)";
    @NotNull
    public static final String ADAPTER = "io.github.chaosunity.forgelin.KotlinAdapter";
    @NotNull
    public static final String SERVER_PROXY = "teksturepako.greenery.proxy.ServerProxy";
    @NotNull
    public static final String CLIENT_PROXY = "teksturepako.greenery.proxy.ClientProxy";
    @NotNull
    private static final GreeneryCreativeTab creativeTab = new GreeneryCreativeTab();
    @NotNull
    private static final List<IPlantGenerator> generators = new ArrayList();
    @NotNull
    private static final List<GreeneryPlant> plants = new ArrayList();
    @SidedProxy(clientSide="teksturepako.greenery.proxy.ClientProxy", serverSide="teksturepako.greenery.proxy.ServerProxy")
    public static IProxy proxy;
    public static Logger logger;
    public static File configFolder;

    private Greenery() {
    }

    @NotNull
    public final GreeneryCreativeTab getCreativeTab() {
        return creativeTab;
    }

    @NotNull
    public final List<IPlantGenerator> getGenerators() {
        return generators;
    }

    @NotNull
    public final List<GreeneryPlant> getPlants() {
        return plants;
    }

    @NotNull
    public final IProxy getProxy() {
        IProxy iProxy = proxy;
        if (iProxy != null) {
            return iProxy;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"proxy");
        return null;
    }

    public final void setProxy(@NotNull IProxy iProxy) {
        Intrinsics.checkNotNullParameter((Object)iProxy, (String)"<set-?>");
        proxy = iProxy;
    }

    @NotNull
    public final Logger getLogger() {
        Logger logger = Greenery.logger;
        if (logger != null) {
            return logger;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        return null;
    }

    public final void setLogger(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"<set-?>");
        Greenery.logger = logger;
    }

    @NotNull
    public final File getConfigFolder() {
        File file = configFolder;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configFolder");
        return null;
    }

    public final void setConfigFolder(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        configFolder = file;
    }

    @Mod.EventHandler
    public final void preInit(@NotNull FMLPreInitializationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Logger logger = event.getModLog();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getModLog(...)");
        this.setLogger(logger);
        this.getProxy().preInit(event);
        File file = event.getModConfigurationDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getModConfigurationDirectory(...)");
        this.setConfigFolder(FileUtils.INSTANCE.div(file, MODID));
        Serializer.INSTANCE.initDefaults();
        Parser.INSTANCE.initPlantData();
    }

    @Mod.EventHandler
    public final void init(@NotNull FMLInitializationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.getProxy().init(event);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenHook(), (int)0);
        ModRecipes.INSTANCE.register();
        MinecraftForge.EVENT_BUS.register(EventOldContentLoad.class);
        MinecraftForge.TERRAIN_GEN_BUS.register(EventWorldGen.class);
    }

    @Mod.EventHandler
    public final void postInit(@NotNull FMLPostInitializationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.getProxy().postInit(event);
        ModItems.INSTANCE.initOreDictionary();
    }

    @Mod.EventHandler
    public final void serverLoad(@NotNull FMLServerStartingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.loadGenerators(true);
        event.registerServerCommand((ICommand)new CommandGreenery());
    }

    @SubscribeEvent
    @JvmStatic
    public static final void onRegisterBlocks(@NotNull RegistryEvent.Register<Block> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        INSTANCE.getLogger().info("Registering blocks");
        IForgeRegistry iForgeRegistry = event.getRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)iForgeRegistry, (String)"getRegistry(...)");
        ModBlocks.INSTANCE.register((IForgeRegistry<Block>)iForgeRegistry);
        if (Loader.isModLoaded((String)"dynamictrees")) {
            DirtHelper.registerSoil((Block)ModBlocks.INSTANCE.getBlockGrass(), (String)"dirtlike");
        }
    }

    @SubscribeEvent
    @JvmStatic
    public static final void onRegisterItems(@NotNull RegistryEvent.Register<Item> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        INSTANCE.getLogger().info("Registering items");
        IForgeRegistry iForgeRegistry = event.getRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)iForgeRegistry, (String)"getRegistry(...)");
        ModBlocks.INSTANCE.registerItemBlocks((IForgeRegistry<Item>)iForgeRegistry);
        IForgeRegistry iForgeRegistry2 = event.getRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)iForgeRegistry2, (String)"getRegistry(...)");
        ModItems.INSTANCE.register((IForgeRegistry<Item>)iForgeRegistry2);
    }

    @SubscribeEvent
    @JvmStatic
    public static final void onRegisterSoundEvents(@NotNull RegistryEvent.Register<SoundEvent> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        INSTANCE.getLogger().info("Registering sounds");
        IForgeRegistry iForgeRegistry = event.getRegistry();
        Intrinsics.checkNotNullExpressionValue((Object)iForgeRegistry, (String)"getRegistry(...)");
        ModSoundEvents.INSTANCE.register((IForgeRegistry<SoundEvent>)iForgeRegistry);
    }

    @NotNull
    public final List<IPlantGenerator> loadGenerators(boolean printParsing) {
        if (generators.isEmpty()) {
            for (GreeneryPlant plant : plants) {
                generators.add(new PlantGenerator(plant));
            }
            ConfigUtil.INSTANCE.parseGenerators(generators, printParsing);
        }
        return generators;
    }

    @Mod.EventHandler
    public final void onServerStoppingEvent(@Nullable FMLServerStoppingEvent event) {
        this.getLogger().info("Unloading world generators");
        generators.clear();
    }
}

