/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.block.plant;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teksturepako.greenery.Greenery;
import teksturepako.greenery.common.block.plant.PlantDamageSource;
import teksturepako.greenery.common.config.Config;
import teksturepako.greenery.common.util.DropsUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H&J(\u0010\u000b\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\fH\u0016J\u0018\u00105\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J(\u00106\u001a\u00020\f2\u0006\u0010.\u001a\u00020/2\u0006\u00107\u001a\u0002082\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J \u00109\u001a\u00020:2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\b\u0010;\u001a\u00020<H\u0014J\b\u0010=\u001a\u00020#H\u0016J\b\u0010>\u001a\u00020<H&J\u0010\u0010?\u001a\u00020\u00052\u0006\u00102\u001a\u000203H\u0016J(\u0010@\u001a\u00020A2\u0006\u0010.\u001a\u00020B2\u0006\u00102\u001a\u0002032\u0006\u00100\u001a\u0002012\u0006\u0010C\u001a\u00020DH\u0016J\u000e\u0010E\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/J\"\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u0002032\u0006\u0010.\u001a\u00020B2\u0006\u00100\u001a\u000201H\u0016J6\u0010\u0014\u001a\u00020:2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020J0I2\u0006\u0010K\u001a\u00020B2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010L\u001a\u00020\u0005H\u0016J \u0010M\u001a\u00020\u00052\u0006\u0010K\u001a\u00020B2\u0006\u00100\u001a\u0002012\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010N\u001a\u00020\u00052\u0006\u00102\u001a\u000203H\u0016J\b\u0010O\u001a\u00020PH\u0017J\u0018\u0010Q\u001a\u0002032\u0006\u0010K\u001a\u00020B2\u0006\u00100\u001a\u000201H\u0016J\u0018\u0010R\u001a\u00020S2\u0006\u0010K\u001a\u00020B2\u0006\u00100\u001a\u000201H\u0016J\b\u0010T\u001a\u00020UH\u0017J\u0010\u0010V\u001a\u0002032\u0006\u0010W\u001a\u00020\u0005H\u0016J(\u0010X\u001a\u00020:2\u0006\u0010.\u001a\u00020/2\u0006\u00107\u001a\u0002082\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\b\u0010Y\u001a\u00020:H\u0004J \u0010Z\u001a\u00020\f2\u0006\u0010K\u001a\u00020B2\u0006\u00100\u001a\u0002012\u0006\u0010C\u001a\u00020DH\u0016J\u0010\u0010[\u001a\u00020\f2\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010\\\u001a\u00020\f2\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010]\u001a\u00020\f2\u0006\u00102\u001a\u000203H\u0016J\u0018\u0010^\u001a\u00020\f2\u0006\u0010.\u001a\u00020B2\u0006\u00100\u001a\u000201H\u0016J\u0018\u0010_\u001a\u00020\f2\u0006\u0010.\u001a\u00020B2\u0006\u00100\u001a\u000201H\u0016J0\u0010`\u001a\u00020:2\u0006\u00102\u001a\u0002032\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010a\u001a\u00020\u00012\u0006\u0010b\u001a\u000201H\u0016J(\u0010c\u001a\u00020:2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u0010d\u001a\u00020eH\u0016J(\u0010f\u001a\u00020:2\u0006\u0010K\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00107\u001a\u0002082\u0006\u0010g\u001a\u00020\u0005H&J\u0010\u0010h\u001a\u00020:2\u0006\u0010i\u001a\u00020jH\u0017J\u0010\u0010k\u001a\u00020:2\u0006\u0010i\u001a\u00020lH\u0017J\b\u0010m\u001a\u00020:H\u0017J\u0010\u0010n\u001a\u00020\u00012\u0006\u0010o\u001a\u00020\fH\u0016J(\u0010p\u001a\u00020:2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00107\u001a\u000208H\u0016J\u0010\u0010q\u001a\u0002032\u0006\u0010r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00020\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u0018\u0010\u001b\u001a\u00020\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u000e\"\u0004\b\u001d\u0010\u0010R\u0018\u0010\u001e\u001a\u00020\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u000e\"\u0004\b\u001f\u0010\u0010R\u0018\u0010 \u001a\u00020\fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u000e\"\u0004\b!\u0010\u0010R\u001a\u0010\"\u001a\u00020#X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010\u0015\"\u0004\b,\u0010\u0017\u00a8\u0006s"}, d2={"Lteksturepako/greenery/common/block/plant/GreeneryPlant;", "Lnet/minecraft/block/Block;", "Lnet/minecraft/block/IGrowable;", "Lnet/minecraftforge/common/IPlantable;", "maxAge", "", "(I)V", "ageProperty", "Lnet/minecraft/block/properties/PropertyInteger;", "getAgeProperty", "()Lnet/minecraft/block/properties/PropertyInteger;", "canGrow", "", "getCanGrow", "()Z", "setCanGrow", "(Z)V", "drops", "", "", "getDrops", "()Ljava/util/List;", "setDrops", "(Ljava/util/List;)V", "hasOffset", "getHasOffset", "setHasOffset", "hasTintIndex", "getHasTintIndex", "setHasTintIndex", "isHarmful", "setHarmful", "isSolid", "setSolid", "itemBlock", "Lnet/minecraft/item/Item;", "getItemBlock", "()Lnet/minecraft/item/Item;", "setItemBlock", "(Lnet/minecraft/item/Item;)V", "getMaxAge", "()I", "worldGen", "getWorldGen", "setWorldGen", "canBlockStay", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "isClient", "canPlaceBlockAt", "canUseBonemeal", "rand", "Ljava/util/Random;", "checkAndDropBlock", "", "createBlockState", "Lnet/minecraft/block/state/BlockStateContainer;", "createItemBlock", "createPlantContainer", "getAge", "getBlockFaceShape", "Lnet/minecraft/block/state/BlockFaceShape;", "Lnet/minecraft/world/IBlockAccess;", "face", "Lnet/minecraft/util/EnumFacing;", "getBonemealAgeIncrease", "getCollisionBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "blockState", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/ItemStack;", "world", "fortune", "getFlammability", "getMetaFromState", "getOffsetType", "Lnet/minecraft/block/Block$EnumOffsetType;", "getPlant", "getPlantType", "Lnet/minecraftforge/common/EnumPlantType;", "getRenderLayer", "Lnet/minecraft/util/BlockRenderLayer;", "getStateFromMeta", "meta", "grow", "initBlockState", "isFlammable", "isFullCube", "isMaxAge", "isOpaqueCube", "isPassable", "isReplaceable", "neighborChanged", "blockIn", "fromPos", "onEntityCollision", "entityIn", "Lnet/minecraft/entity/Entity;", "placePlant", "flags", "registerBlockColorHandler", "event", "Lnet/minecraftforge/client/event/ColorHandlerEvent$Block;", "registerItemColorHandler", "Lnet/minecraftforge/client/event/ColorHandlerEvent$Item;", "registerItemModel", "setTickRandomly", "shouldTick", "updateTick", "withAge", "age", "Greenery"})
public abstract class GreeneryPlant
extends Block
implements IGrowable,
IPlantable {
    private final int maxAge;
    @NotNull
    private final PropertyInteger ageProperty;
    public Item itemBlock;

    public GreeneryPlant(int maxAge) {
        super(Material.field_151585_k);
        this.maxAge = maxAge;
        PropertyInteger propertyInteger = PropertyInteger.func_177719_a((String)"age", (int)0, (int)this.maxAge);
        Intrinsics.checkNotNullExpressionValue((Object)propertyInteger, (String)"create(...)");
        this.ageProperty = propertyInteger;
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
        this.func_149713_g(0);
    }

    public final int getMaxAge() {
        return this.maxAge;
    }

    @NotNull
    public abstract List<String> getWorldGen();

    public abstract void setWorldGen(@NotNull List<String> var1);

    @NotNull
    public abstract List<String> getDrops();

    public abstract void setDrops(@NotNull List<String> var1);

    public abstract boolean getCanGrow();

    public abstract void setCanGrow(boolean var1);

    public abstract boolean getHasTintIndex();

    public abstract void setHasTintIndex(boolean var1);

    public abstract boolean getHasOffset();

    public abstract void setHasOffset(boolean var1);

    public abstract boolean isSolid();

    public abstract void setSolid(boolean var1);

    public abstract boolean isHarmful();

    public abstract void setHarmful(boolean var1);

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    @NotNull
    public final PropertyInteger getAgeProperty() {
        return this.ageProperty;
    }

    protected final void initBlockState() {
        BlockStateContainer stateContainer;
        this.field_176227_L = stateContainer = this.createPlantContainer();
        this.func_180632_j(stateContainer.func_177621_b());
    }

    @NotNull
    public abstract BlockStateContainer createPlantContainer();

    public boolean isMaxAge(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Comparable comparable = state.func_177229_b((IProperty)this.ageProperty);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Int");
        return (Integer)comparable >= this.maxAge;
    }

    public int getAge(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Comparable comparable = state.func_177229_b((IProperty)this.ageProperty);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type kotlin.Int");
        return (Integer)comparable;
    }

    @NotNull
    public IBlockState withAge(int age) {
        IBlockState iBlockState = this.func_176223_P().func_177226_a((IProperty)this.ageProperty, (Comparable)Integer.valueOf(age));
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"withProperty(...)");
        return iBlockState;
    }

    @NotNull
    public IBlockState func_176203_a(int meta) {
        return this.withAge(meta);
    }

    public int func_176201_c(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.getAge(state);
    }

    public abstract void placePlant(@NotNull World var1, @NotNull BlockPos var2, @NotNull Random var3, int var4);

    @NotNull
    public final Item getItemBlock() {
        Item item = this.itemBlock;
        if (item != null) {
            return item;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"itemBlock");
        return null;
    }

    public final void setItemBlock(@NotNull Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"<set-?>");
        this.itemBlock = item;
    }

    @NotNull
    public Item createItemBlock() {
        Item item = ((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName())).func_77655_b(this.func_149739_a());
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"setTranslationKey(...)");
        this.setItemBlock(item);
        return this.getItemBlock();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemModel() {
        Greenery.INSTANCE.getProxy().registerItemBlockRenderer(this.getItemBlock(), 0, String.valueOf(this.getRegistryName()));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemColorHandler(@NotNull ColorHandlerEvent.Item event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Greenery.INSTANCE.getProxy().registerItemColorHandler(this.getItemBlock(), event);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockColorHandler(@NotNull ColorHandlerEvent.Block event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Greenery.INSTANCE.getProxy().registerGrassColorHandler(this, event);
    }

    public abstract boolean canBlockStay(@NotNull World var1, @NotNull BlockPos var2, @NotNull IBlockState var3);

    public void checkAndDropBlock(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_189540_a(@NotNull IBlockState state, @NotNull World worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)blockIn, (String)"blockIn");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void getDrops(@NotNull NonNullList<ItemStack> drops, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull IBlockState state, int fortune) {
        Intrinsics.checkNotNullParameter(drops, (String)"drops");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        drops.addAll((Collection)DropsUtil.INSTANCE.getDrops(this.getDrops(), world, pos, state, this.getItemBlock(), 0));
    }

    public void func_180634_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Entity entityIn) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entityIn, (String)"entityIn");
        entityIn.field_70159_w /= Config.INSTANCE.getGlobal().slowdownModifier * 0.1 + 1.0;
        entityIn.field_70179_y /= Config.INSTANCE.getGlobal().slowdownModifier * 0.1 + 1.0;
        if (this.isHarmful() && entityIn instanceof EntityPlayer) {
            if (Intrinsics.areEqual((Object)((EntityPlayer)entityIn).field_71071_by.field_70460_b.get(0), (Object)ItemStack.field_190927_a)) {
                String string = this.func_149732_F();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedName(...)");
                entityIn.func_70097_a((DamageSource)new PlantDamageSource.Companion.Prickly(string), 0.5f);
            }
            if (Intrinsics.areEqual((Object)((EntityPlayer)entityIn).field_71071_by.field_70460_b.get(1), (Object)ItemStack.field_190927_a)) {
                String string = this.func_149732_F();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedName(...)");
                entityIn.func_70097_a((DamageSource)new PlantDamageSource.Companion.Prickly(string), 0.5f);
            }
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(@NotNull IBlockState blockState, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.isSolid() ? this.func_185496_a(blockState, worldIn, pos) : Block.field_185506_k;
    }

    public boolean func_149662_c(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return false;
    }

    public boolean func_149686_d(@NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @NotNull
    public BlockFaceShape func_193383_a(@NotNull IBlockAccess worldIn, @NotNull IBlockState state, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        return BlockFaceShape.UNDEFINED;
    }

    @NotNull
    public Block func_149675_a(boolean shouldTick) {
        Block block;
        if (this.getCanGrow()) {
            Block block2 = super.func_149675_a(true);
            block = block2;
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"setTickRandomly(...)");
        } else {
            Block block3 = super.func_149675_a(shouldTick);
            block = block3;
            Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"setTickRandomly(...)");
        }
        return block;
    }

    public void func_180650_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (this.getAge(state) <= this.maxAge && this.canBlockStay(worldIn, pos, state) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt(26) == 0 ? 1 : 0) != 0)) {
            this.func_176474_b(worldIn, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    public final int getBonemealAgeIncrease(@NotNull World worldIn) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5) / this.maxAge;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public Block.EnumOffsetType func_176218_Q() {
        return this.getHasOffset() ? Block.EnumOffsetType.XZ : Block.EnumOffsetType.NONE;
    }

    public boolean func_176196_c(@NotNull World worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        IBlockState iBlockState = this.func_176223_P();
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getDefaultState(...)");
        return this.canBlockStay(worldIn, pos, iBlockState);
    }

    public boolean func_176200_f(@NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return !this.isSolid();
    }

    public boolean func_176205_b(@NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return !this.isSolid();
    }

    public boolean isFlammable(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        return true;
    }

    public int getFlammability(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing face) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        return 300;
    }

    public boolean func_176473_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, boolean isClient) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return true;
    }

    public void func_176474_b(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int newAge = this.getAge(state) + this.getBonemealAgeIncrease(worldIn);
        if (newAge > this.maxAge) {
            newAge = this.maxAge;
            if (worldIn.func_175623_d(pos.func_177984_a())) {
                BlockPos blockPos = pos.func_177984_a();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"up(...)");
                if (this.canBlockStay(worldIn, blockPos, state)) {
                    worldIn.func_180501_a(pos.func_177984_a(), this.withAge(0), 2);
                }
            }
        }
        worldIn.func_180501_a(pos, this.withAge(newAge), 2);
    }

    @NotNull
    public EnumPlantType getPlantType(@NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return EnumPlantType.Plains;
    }

    @NotNull
    public IBlockState getPlant(@NotNull IBlockAccess world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        IBlockState iBlockState = this.func_176194_O().func_177621_b();
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getBaseState(...)");
        return iBlockState;
    }
}

