/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.block.plant.emergent;

import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import java.util.List;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;
import teksturepako.greenery.Greenery;
import teksturepako.greenery.client.GreenerySoundTypes;
import teksturepako.greenery.common.block.plant.GreeneryPlant;
import teksturepako.greenery.common.block.plant.PlantDamageSource;
import teksturepako.greenery.common.config.Config;
import teksturepako.greenery.common.util.FluidUtil;
import teksturepako.greenery.common.util.Utils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J(\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010)\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010*\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010,\u001a\u00020-H\u0016J \u0010.\u001a\u00020!2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001c\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010/\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u00100\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J(\u00101\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00102\u001a\u000203H\u0016J(\u00104\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u00105\u001a\u000206H\u0016J0\u00107\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016J(\u0010<\u001a\u00020+2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010=\u001a\u00020>H\u0016J(\u0010?\u001a\u00020@2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020!2\u0006\u0010A\u001a\u00020\u0006H\u0016J(\u0010B\u001a\u00020+2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020\u0006H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lteksturepako/greenery/common/block/plant/emergent/EmergentPlantBase;", "Lteksturepako/greenery/common/block/plant/GreeneryPlant;", "Lgit/jbredwards/fluidlogged_api/api/block/IFluidloggable;", "name", "", "maxAge", "", "(Ljava/lang/String;I)V", "ALLOWED_SOILS", "", "Lnet/minecraft/block/material/Material;", "WATER_CROP_BOTTOM_AABB", "", "Lnet/minecraft/util/math/AxisAlignedBB;", "[Lnet/minecraft/util/math/AxisAlignedBB;", "WATER_CROP_TOP_AABB", "compatibleFluids", "", "getCompatibleFluids", "()Ljava/util/List;", "setCompatibleFluids", "(Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "topProperty", "Lnet/minecraft/block/properties/PropertyBool;", "canBlockStay", "", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "canFluidFlow", "world", "Lnet/minecraft/world/IBlockAccess;", "here", "side", "Lnet/minecraft/util/EnumFacing;", "canGenerateBlockAt", "canPlaceBlockAt", "checkAndDropBlock", "", "createPlantContainer", "Lnet/minecraft/block/state/BlockStateContainer;", "getActualState", "getBoundingBox", "source", "isFluidValid", "fluid", "Lnet/minecraftforge/fluids/Fluid;", "onBlockHarvested", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "onBlockPlacedBy", "placer", "Lnet/minecraft/entity/EntityLivingBase;", "stack", "Lnet/minecraft/item/ItemStack;", "onEntityCollision", "entityIn", "Lnet/minecraft/entity/Entity;", "onFluidDrain", "Lnet/minecraft/util/EnumActionResult;", "blockFlags", "placePlant", "rand", "Ljava/util/Random;", "flags", "Greenery"})
public abstract class EmergentPlantBase
extends GreeneryPlant
implements IFluidloggable {
    @NotNull
    private final String name;
    @NotNull
    private final Set<Material> ALLOWED_SOILS;
    @NotNull
    private final AxisAlignedBB[] WATER_CROP_TOP_AABB;
    @NotNull
    private final AxisAlignedBB[] WATER_CROP_BOTTOM_AABB;
    @NotNull
    private final PropertyBool topProperty;

    public EmergentPlantBase(@NotNull String name, int maxAge) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(maxAge);
        this.name = name;
        Object[] objectArray = new Material[5];
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151578_c, (String)"GROUND");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151595_p, (String)"SAND");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151577_b, (String)"GRASS");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151571_B, (String)"CLAY");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151576_e, (String)"ROCK");
        this.ALLOWED_SOILS = SetsKt.setOf((Object[])objectArray);
        objectArray = new AxisAlignedBB[]{new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.5, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.625, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.75, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.875, 0.9)};
        this.WATER_CROP_TOP_AABB = objectArray;
        objectArray = new AxisAlignedBB[]{new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 1.0, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 1.0, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 1.0, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 1.0, 0.9)};
        this.WATER_CROP_BOTTOM_AABB = objectArray;
        PropertyBool propertyBool = PropertyBool.func_177716_a((String)"top");
        Intrinsics.checkNotNullExpressionValue((Object)propertyBool, (String)"create(...)");
        this.topProperty = propertyBool;
        this.initBlockState();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)this.topProperty, (Comparable)Boolean.valueOf(true)));
        this.setRegistryName("plant/emergent/" + this.name);
        this.func_149663_c("greenery." + this.name);
        this.func_149672_a(GreenerySoundTypes.INSTANCE.getSEAWEED());
        this.func_149647_a(Greenery.INSTANCE.getCreativeTab());
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public abstract List<String> getCompatibleFluids();

    public abstract void setCompatibleFluids(@NotNull List<String> var1);

    @Override
    @NotNull
    public BlockStateContainer createPlantContainer() {
        IProperty[] iPropertyArray = new IProperty[]{this.getAgeProperty(), this.topProperty};
        return new BlockStateContainer((Block)this, iPropertyArray);
    }

    @NotNull
    public IBlockState func_176221_a(@NotNull IBlockState state, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        IBlockState iBlockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (Intrinsics.areEqual((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c(), (Object)((Object)this))) {
            IBlockState iBlockState2 = state.func_177226_a((IProperty)this.topProperty, (Comparable)Boolean.valueOf(true));
            iBlockState = iBlockState2;
            Intrinsics.checkNotNullExpressionValue((Object)iBlockState2, (String)"withProperty(...)");
        } else if (Intrinsics.areEqual((Object)worldIn.func_180495_p(pos.func_177984_a()).func_177230_c(), (Object)((Object)this))) {
            IBlockState iBlockState3 = state.func_177226_a((IProperty)this.topProperty, (Comparable)Boolean.valueOf(false));
            iBlockState = iBlockState3;
            Intrinsics.checkNotNullExpressionValue((Object)iBlockState3, (String)"withProperty(...)");
        } else {
            iBlockState = state;
        }
        return iBlockState;
    }

    @NotNull
    public AxisAlignedBB func_185496_a(@NotNull IBlockState state, @NotNull IBlockAccess source, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        IBlockState actualState = this.func_176221_a(state, source, pos);
        return Intrinsics.areEqual((Object)actualState, (Object)actualState.func_177226_a((IProperty)this.topProperty, (Comparable)Boolean.valueOf(true))) ? Utils.INSTANCE.applyOffset(this.WATER_CROP_TOP_AABB[this.getAge(state)], this.getHasOffset(), state, source, pos) : (Intrinsics.areEqual((Object)actualState, (Object)actualState.func_177226_a((IProperty)this.topProperty, (Comparable)Boolean.valueOf(false))) ? Utils.INSTANCE.applyOffset(this.WATER_CROP_BOTTOM_AABB[this.getAge(state)], this.getHasOffset(), state, source, pos) : Utils.INSTANCE.applyOffset(this.WATER_CROP_TOP_AABB[this.getAge(state)], this.getHasOffset(), state, source, pos));
    }

    @Override
    public void func_180634_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Entity entityIn) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entityIn, (String)"entityIn");
        entityIn.field_70159_w /= Config.INSTANCE.getGlobal().slowdownModifier * 0.1 + 1.0;
        entityIn.field_70181_x /= Config.INSTANCE.getGlobal().slowdownModifier * 0.1 + 1.0;
        entityIn.field_70179_y /= Config.INSTANCE.getGlobal().slowdownModifier * 0.1 + 1.0;
        if (this.isHarmful() && entityIn instanceof EntityPlayer) {
            if (Intrinsics.areEqual((Object)((EntityPlayer)entityIn).field_71071_by.field_70460_b.get(0), (Object)ItemStack.field_190927_a)) {
                String string = this.func_149732_F();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedName(...)");
                entityIn.func_70097_a((DamageSource)new PlantDamageSource.Companion.Prickly(string), 0.5f);
            }
            if (Intrinsics.areEqual((Object)((EntityPlayer)entityIn).field_71071_by.field_70460_b.get(1), (Object)ItemStack.field_190927_a)) {
                String string = this.func_149732_F();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedName(...)");
                entityIn.func_70097_a((DamageSource)new PlantDamageSource.Companion.Prickly(string), 0.5f);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canGenerateBlockAt(World worldIn, BlockPos pos) {
        if (!FluidUtil.INSTANCE.canGenerateInFluids(this.getCompatibleFluids(), worldIn, pos)) return false;
        IBlockState iBlockState = this.func_176223_P();
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getDefaultState(...)");
        if (!this.canBlockStay(worldIn, pos, iBlockState)) return false;
        if (!worldIn.func_175623_d(pos.func_177984_a())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_176196_c(@NotNull World worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        FluidState fluidState = FluidloggedUtils.getFluidState((IBlockAccess)((IBlockAccess)worldIn), (BlockPos)pos);
        Intrinsics.checkNotNullExpressionValue((Object)fluidState, (String)"getFluidState(...)");
        FluidState fluidState2 = fluidState;
        if (!fluidState2.isEmpty()) {
            IBlockState iBlockState = this.func_176223_P();
            Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getDefaultState(...)");
            Fluid fluid = fluidState2.getFluid();
            Intrinsics.checkNotNullExpressionValue((Object)fluid, (String)"getFluid(...)");
            if (this.isFluidValid(iBlockState, worldIn, pos, fluid) && FluidloggedUtils.isFluidloggableFluid((IBlockState)fluidState2.getState(), (World)worldIn, (BlockPos)pos)) {
                IBlockState iBlockState2 = this.func_176223_P();
                Intrinsics.checkNotNullExpressionValue((Object)iBlockState2, (String)"getDefaultState(...)");
                if (!this.canBlockStay(worldIn, pos, iBlockState2)) return false;
                if (!worldIn.func_175623_d(pos.func_177984_a())) return false;
                return true;
            }
        }
        BlockPos blockPos = pos.func_177984_a();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"up(...)");
        IBlockState iBlockState = this.func_176223_P();
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getDefaultState(...)");
        boolean bl = this.canBlockStay(worldIn, blockPos, iBlockState);
        return bl;
    }

    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityLivingBase placer, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)placer, (String)"placer");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        if (!Intrinsics.areEqual((Object)down.func_177230_c(), (Object)((Object)this))) {
            worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(3)));
        }
        BlockPos blockPos = pos.func_177984_a();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"up(...)");
        if (this.canBlockStay(worldIn, blockPos, state)) {
            worldIn.func_180501_a(pos.func_177984_a(), this.func_176223_P(), 2);
        }
    }

    public void func_176208_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (Intrinsics.areEqual((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c(), (Object)((Object)this))) {
            this.func_176226_b(worldIn, pos.func_177977_b(), state, 0);
            worldIn.func_175698_g(pos.func_177977_b());
        }
    }

    @Override
    public void checkAndDropBlock(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!this.canBlockStay(worldIn, pos, state)) {
            worldIn.func_175698_g(pos);
        }
    }

    @Override
    public boolean canBlockStay(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        IBlockState down2 = worldIn.func_180495_p(pos.func_177979_c(2));
        return this.ALLOWED_SOILS.contains(down.func_185904_a()) ? true : Intrinsics.areEqual((Object)down.func_177230_c(), (Object)((Object)this)) && !Intrinsics.areEqual((Object)down2.func_177230_c(), (Object)((Object)this));
    }

    @Override
    public void placePlant(@NotNull World world, @NotNull BlockPos pos, @NotNull Random rand, int flags) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (this.canGenerateBlockAt(world, pos)) {
            IBlockState state = this.func_176223_P();
            world.func_180501_a(pos, state.func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getMaxAge())), flags);
            BlockPos blockPos = pos.func_177984_a();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"up(...)");
            Intrinsics.checkNotNull((Object)state);
            if (this.canBlockStay(world, blockPos, state)) {
                world.func_180501_a(pos.func_177984_a(), state, flags);
            }
        }
    }

    public boolean canFluidFlow(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull IBlockState here, @NotNull EnumFacing side) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)here, (String)"here");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return true;
    }

    public boolean isFluidValid(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull Fluid fluid) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        return FluidUtil.INSTANCE.areFluidsValid(this.getCompatibleFluids(), fluid);
    }

    @NotNull
    public EnumActionResult onFluidDrain(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState here, int blockFlags) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)here, (String)"here");
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)here));
        this.func_176226_b(world, pos, here, 0);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), blockFlags);
        return EnumActionResult.SUCCESS;
    }
}

