/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.block.plant.floating;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import teksturepako.greenery.Greenery;
import teksturepako.greenery.client.GreenerySoundTypes;
import teksturepako.greenery.common.block.plant.GreeneryPlant;
import teksturepako.greenery.common.block.plant.floating.FloatingItemBlock;
import teksturepako.greenery.common.util.Utils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001c"}, d2={"Lteksturepako/greenery/common/block/plant/floating/AbstractFloatingPlant;", "Lteksturepako/greenery/common/block/plant/GreeneryPlant;", "name", "", "maxAge", "", "(Ljava/lang/String;I)V", "getName", "()Ljava/lang/String;", "canBlockStay", "", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "createItemBlock", "Lnet/minecraft/item/Item;", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "source", "Lnet/minecraft/world/IBlockAccess;", "onEntityCollision", "", "entityIn", "Lnet/minecraft/entity/Entity;", "Companion", "Greenery"})
public abstract class AbstractFloatingPlant
extends GreeneryPlant {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final Set<Material> ALLOWED_SOILS;
    @NotNull
    private static final AxisAlignedBB[] WATER_CROP_AABB;

    public AbstractFloatingPlant(@NotNull String name, int maxAge) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(maxAge);
        this.name = name;
        this.setRegistryName("plant/floating/" + this.name);
        this.func_149663_c("greenery." + this.name);
        this.func_149672_a(GreenerySoundTypes.INSTANCE.getSEAWEED());
        this.func_149647_a(Greenery.INSTANCE.getCreativeTab());
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Item createItemBlock() {
        this.setItemBlock((Item)new FloatingItemBlock(this.name, this));
        return this.getItemBlock();
    }

    @Override
    public void func_180634_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Entity entityIn) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entityIn, (String)"entityIn");
        entityIn.field_70159_w /= 1.1;
        entityIn.field_70181_x /= 1.1;
        entityIn.field_70179_y /= 1.1;
    }

    @Override
    public boolean canBlockStay(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        IBlockState down2 = worldIn.func_180495_p(pos.func_177979_c(2));
        return (worldIn.func_175623_d(pos) || Intrinsics.areEqual((Object)worldIn.func_180495_p(pos).func_177230_c(), (Object)((Object)this))) && Intrinsics.areEqual((Object)down.func_185904_a(), (Object)Material.field_151586_h) ? ALLOWED_SOILS.contains(down2.func_185904_a()) : false;
    }

    @NotNull
    public AxisAlignedBB func_185496_a(@NotNull IBlockState state, @NotNull IBlockAccess source, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return Utils.INSTANCE.applyOffset(WATER_CROP_AABB[this.getAge(state)], this.getHasOffset(), state, source, pos);
    }

    static {
        Object[] objectArray = new Material[5];
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151578_c, (String)"GROUND");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151595_p, (String)"SAND");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151577_b, (String)"GRASS");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151571_B, (String)"CLAY");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151576_e, (String)"ROCK");
        ALLOWED_SOILS = SetsKt.setOf((Object[])objectArray);
        objectArray = new AxisAlignedBB[]{new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.5, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.625, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.75, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.875, 0.9)};
        WATER_CROP_AABB = objectArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lteksturepako/greenery/common/block/plant/floating/AbstractFloatingPlant$Companion;", "", "()V", "ALLOWED_SOILS", "", "Lnet/minecraft/block/material/Material;", "getALLOWED_SOILS", "()Ljava/util/Set;", "WATER_CROP_AABB", "", "Lnet/minecraft/util/math/AxisAlignedBB;", "getWATER_CROP_AABB", "()[Lnet/minecraft/util/math/AxisAlignedBB;", "[Lnet/minecraft/util/math/AxisAlignedBB;", "Greenery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Material> getALLOWED_SOILS() {
            return ALLOWED_SOILS;
        }

        @NotNull
        public final AxisAlignedBB[] getWATER_CROP_AABB() {
            return WATER_CROP_AABB;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

