/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.block.plant.floating;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import teksturepako.greenery.Greenery;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0015H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lteksturepako/greenery/common/block/plant/floating/FloatingItemBlock;", "Lnet/minecraft/item/ItemBlock;", "name", "", "blockToUse", "Lnet/minecraft/block/Block;", "(Ljava/lang/String;Lnet/minecraft/block/Block;)V", "canBlockStay", "", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "Lnet/minecraft/item/ItemStack;", "playerIn", "Lnet/minecraft/entity/player/EntityPlayer;", "handIn", "Lnet/minecraft/util/EnumHand;", "registerItemColorHandler", "", "event", "Lnet/minecraftforge/client/event/ColorHandlerEvent$Item;", "registerItemModel", "Companion", "Greenery"})
public final class FloatingItemBlock
extends ItemBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Block blockToUse;
    @NotNull
    private static final Set<Material> ALLOWED_SOILS;

    public FloatingItemBlock(@NotNull String name, @NotNull Block blockToUse) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)blockToUse, (String)"blockToUse");
        super(blockToUse);
        this.blockToUse = blockToUse;
        this.setRegistryName("plant/floating/" + name);
        this.func_77655_b("greenery." + name);
        this.func_77637_a(Greenery.INSTANCE.getCreativeTab());
    }

    private final boolean canBlockStay(World worldIn, BlockPos pos) {
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        IBlockState down2 = worldIn.func_180495_p(pos.func_177979_c(2));
        return worldIn.func_175623_d(pos) && Intrinsics.areEqual((Object)down.func_185904_a(), (Object)Material.field_151586_h) ? ALLOWED_SOILS.contains(down2.func_185904_a()) : false;
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerItemModel() {
        Greenery.INSTANCE.getProxy().registerItemRenderer((Item)this, 0, String.valueOf(this.getRegistryName()));
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerItemColorHandler(@NotNull ColorHandlerEvent.Item event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Greenery.INSTANCE.getProxy().registerItemColorHandler((Item)this, event);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, @NotNull EntityPlayer playerIn, @NotNull EnumHand handIn) {
        ActionResult actionResult;
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        Intrinsics.checkNotNullParameter((Object)handIn, (String)"handIn");
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult == null) {
            actionResult = new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        } else {
            if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos blockpos = raytraceresult.func_178782_a();
                if (!worldIn.func_175660_a(playerIn, blockpos) || !playerIn.func_175151_a(blockpos.func_177972_a(raytraceresult.field_178784_b), raytraceresult.field_178784_b, itemstack)) {
                    return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                }
                BlockPos blockpos1 = blockpos.func_177984_a();
                Intrinsics.checkNotNull((Object)blockpos1);
                if (this.canBlockStay(worldIn, blockpos1)) {
                    BlockSnapshot blocksnapshot = BlockSnapshot.getBlockSnapshot((World)worldIn, (BlockPos)blockpos1);
                    if (ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)playerIn, (BlockSnapshot)blocksnapshot, (EnumFacing)EnumFacing.UP, (EnumHand)handIn).isCanceled()) {
                        blocksnapshot.restore(true, false);
                        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
                    }
                    worldIn.func_180501_a(blockpos1, this.blockToUse.func_176223_P(), 3);
                    if (playerIn instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)playerIn, blockpos1, itemstack);
                    }
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    playerIn.func_71029_a(StatList.func_188057_b((Item)((Item)this)));
                    worldIn.func_184133_a(playerIn, blockpos, SoundEvents.field_187916_gp, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
                }
            }
            actionResult = new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        return actionResult;
    }

    static {
        Object[] objectArray = new Material[5];
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151578_c, (String)"GROUND");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151595_p, (String)"SAND");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151577_b, (String)"GRASS");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151571_B, (String)"CLAY");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151576_e, (String)"ROCK");
        ALLOWED_SOILS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lteksturepako/greenery/common/block/plant/floating/FloatingItemBlock$Companion;", "", "()V", "ALLOWED_SOILS", "", "Lnet/minecraft/block/material/Material;", "getALLOWED_SOILS", "()Ljava/util/Set;", "Greenery"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Material> getALLOWED_SOILS() {
            return ALLOWED_SOILS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

