/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.block.plant.submerged;

import git.jbredwards.fluidlogged_api.api.block.IFluidloggable;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import java.util.List;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;
import teksturepako.greenery.Greenery;
import teksturepako.greenery.client.GreenerySoundTypes;
import teksturepako.greenery.common.block.plant.GreeneryPlant;
import teksturepako.greenery.common.block.plant.PlantDamageSource;
import teksturepako.greenery.common.config.Config;
import teksturepako.greenery.common.util.FluidUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010(\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 H\u0016J(\u0010)\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010,\u001a\u00020\"H\u0016J(\u0010-\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J(\u00101\u001a\u0002022\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010,\u001a\u00020\"2\u0006\u00103\u001a\u000204H\u0016J(\u00105\u001a\u0002062\u0006\u0010\u001d\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u00107\u001a\u00020\u0006H\u0016J(\u00108\u001a\u0002022\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010,\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00069"}, d2={"Lteksturepako/greenery/common/block/plant/submerged/AbstractSubmergedPlant;", "Lteksturepako/greenery/common/block/plant/GreeneryPlant;", "Lgit/jbredwards/fluidlogged_api/api/block/IFluidloggable;", "name", "", "maxAge", "", "(Ljava/lang/String;I)V", "ALLOWED_SOILS", "", "Lnet/minecraft/block/material/Material;", "getALLOWED_SOILS", "()Ljava/util/Set;", "BOTTOM_AABB", "Lnet/minecraft/util/math/AxisAlignedBB;", "getBOTTOM_AABB", "()Lnet/minecraft/util/math/AxisAlignedBB;", "TOP_AABB", "getTOP_AABB", "compatibleFluids", "", "getCompatibleFluids", "()Ljava/util/List;", "setCompatibleFluids", "(Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "canFluidFlow", "", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "here", "Lnet/minecraft/block/state/IBlockState;", "side", "Lnet/minecraft/util/EnumFacing;", "canGenerateBlockAt", "worldIn", "Lnet/minecraft/world/World;", "canPlaceBlockAt", "canUseBonemeal", "rand", "Ljava/util/Random;", "state", "isFluidValid", "fluid", "Lnet/minecraftforge/fluids/Fluid;", "isReplaceable", "onEntityCollision", "", "entityIn", "Lnet/minecraft/entity/Entity;", "onFluidDrain", "Lnet/minecraft/util/EnumActionResult;", "blockFlags", "updateTick", "Greenery"})
public abstract class AbstractSubmergedPlant
extends GreeneryPlant
implements IFluidloggable {
    @NotNull
    private final String name;
    @NotNull
    private final Set<Material> ALLOWED_SOILS;
    @NotNull
    private final AxisAlignedBB TOP_AABB;
    @NotNull
    private final AxisAlignedBB BOTTOM_AABB;

    public AbstractSubmergedPlant(@NotNull String name, int maxAge) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(maxAge);
        this.name = name;
        Object[] objectArray = new Material[5];
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151578_c, (String)"GROUND");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151595_p, (String)"SAND");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151577_b, (String)"GRASS");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151571_B, (String)"CLAY");
        Intrinsics.checkNotNullExpressionValue((Object)Material.field_151576_e, (String)"ROCK");
        this.ALLOWED_SOILS = SetsKt.setOf((Object[])objectArray);
        this.TOP_AABB = new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.75, 0.9);
        this.BOTTOM_AABB = new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 1.0, 0.9);
        this.setRegistryName("plant/submerged/" + this.name);
        this.func_149663_c("greenery." + this.name);
        this.func_149672_a(GreenerySoundTypes.INSTANCE.getSEAWEED());
        this.func_149647_a(Greenery.INSTANCE.getCreativeTab());
        this.func_149713_g(0);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public abstract List<String> getCompatibleFluids();

    public abstract void setCompatibleFluids(@NotNull List<String> var1);

    @NotNull
    public final Set<Material> getALLOWED_SOILS() {
        return this.ALLOWED_SOILS;
    }

    @NotNull
    public final AxisAlignedBB getTOP_AABB() {
        return this.TOP_AABB;
    }

    @NotNull
    public final AxisAlignedBB getBOTTOM_AABB() {
        return this.BOTTOM_AABB;
    }

    @Override
    public void func_180634_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Entity entityIn) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)entityIn, (String)"entityIn");
        entityIn.field_70159_w /= Config.INSTANCE.getGlobal().slowdownModifier * 0.1 + 1.0;
        entityIn.field_70181_x /= Config.INSTANCE.getGlobal().slowdownModifier * 0.1 + 1.0;
        entityIn.field_70179_y /= Config.INSTANCE.getGlobal().slowdownModifier * 0.1 + 1.0;
        if (this.isHarmful() && entityIn instanceof EntityPlayer) {
            if (Intrinsics.areEqual((Object)((EntityPlayer)entityIn).field_71071_by.field_70460_b.get(0), (Object)ItemStack.field_190927_a)) {
                String string = this.func_149732_F();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedName(...)");
                entityIn.func_70097_a((DamageSource)new PlantDamageSource.Companion.Prickly(string), 0.5f);
            }
            if (Intrinsics.areEqual((Object)((EntityPlayer)entityIn).field_71071_by.field_70460_b.get(1), (Object)ItemStack.field_190927_a)) {
                String string = this.func_149732_F();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedName(...)");
                entityIn.func_70097_a((DamageSource)new PlantDamageSource.Companion.Prickly(string), 0.5f);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canGenerateBlockAt(@NotNull World worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!FluidUtil.INSTANCE.canGenerateInFluids(this.getCompatibleFluids(), worldIn, pos)) return false;
        IBlockState iBlockState = this.func_176223_P();
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getDefaultState(...)");
        if (!this.canBlockStay(worldIn, pos, iBlockState)) return false;
        return true;
    }

    @Override
    public void func_180650_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (this.getAge(state) <= this.getMaxAge() && this.canGenerateBlockAt(worldIn, pos) && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (rand.nextInt(26) == 0 ? 1 : 0) != 0)) {
            this.func_176474_b(worldIn, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state, (IBlockState)worldIn.func_180495_p(pos));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_176196_c(@NotNull World worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        FluidState fluidState = FluidloggedUtils.getFluidState((IBlockAccess)((IBlockAccess)worldIn), (BlockPos)pos);
        Intrinsics.checkNotNullExpressionValue((Object)fluidState, (String)"getFluidState(...)");
        FluidState fluidState2 = fluidState;
        if (fluidState2.isEmpty()) return false;
        IBlockState iBlockState = this.func_176223_P();
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getDefaultState(...)");
        Fluid fluid = fluidState2.getFluid();
        Intrinsics.checkNotNullExpressionValue((Object)fluid, (String)"getFluid(...)");
        if (!this.isFluidValid(iBlockState, worldIn, pos, fluid)) return false;
        if (!FluidloggedUtils.isFluidloggableFluid((IBlockState)fluidState2.getState(), (World)worldIn, (BlockPos)pos)) return false;
        IBlockState iBlockState2 = this.func_176223_P();
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState2, (String)"getDefaultState(...)");
        if (!this.canBlockStay(worldIn, pos, iBlockState2)) return false;
        return true;
    }

    @Override
    public boolean func_176200_f(@NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return false;
    }

    @Override
    public boolean func_180670_a(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return this.func_176473_a(worldIn, pos, state, false);
    }

    public boolean canFluidFlow(@NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull IBlockState here, @NotNull EnumFacing side) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)here, (String)"here");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return true;
    }

    public boolean isFluidValid(@NotNull IBlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull Fluid fluid) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        return FluidUtil.INSTANCE.areFluidsValid(this.getCompatibleFluids(), fluid);
    }

    @NotNull
    public EnumActionResult onFluidDrain(@NotNull World world, @NotNull BlockPos pos, @NotNull IBlockState here, int blockFlags) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)here, (String)"here");
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)here));
        this.func_176226_b(world, pos, here, 0);
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), blockFlags);
        return EnumActionResult.SUCCESS;
    }
}

